---
generated_at: 2026-01-14 22:15:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **バックアップ設計**：コード上に明示的な設定なし
  2. **本番環境スペック**：開発環境のみ確認可能
  3. **Azure Container Apps詳細構成**：azd連携のみ確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/eShop.AppHost/eShop.AppHost.csproj`
- E-02: `src/eShop.AppHost/Program.cs`
- E-03: `src/eShop.AppHost/Extensions.cs`
- E-04: `src/eShop.AppHost/appsettings.json`
- E-05: `src/eShop.ServiceDefaults/eShop.ServiceDefaults.csproj`
- E-06: `src/eShop.ServiceDefaults/Extensions.cs`
- E-07: `src/eShop.ServiceDefaults/AuthenticationExtensions.cs`
- E-08: `src/Basket.API/Basket.API.csproj`
- E-09: `src/Catalog.API/Catalog.API.csproj`
- E-10: `src/Ordering.API/Ordering.API.csproj`
- E-11: `src/Identity.API/Identity.API.csproj`
- E-12: `src/WebApp/WebApp.csproj`
- E-13: `src/OrderProcessor/OrderProcessor.csproj`
- E-14: `src/PaymentProcessor/PaymentProcessor.csproj`
- E-15: `src/Webhooks.API/Webhooks.API.csproj`
- E-16: `src/WebhookClient/WebhookClient.csproj`
- E-17: `src/EventBusRabbitMQ/EventBusRabbitMQ.csproj`
- E-18: `Directory.Packages.props`
- E-19: `README.md`
- E-20: `.github/workflows/pr-validation.yml`
- E-21: `ci.yml`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | .NET Aspire 13.1.0をオーケストレーターとして使用 | E-01, E-18 | ○ |
| C-02 | PostgreSQL (pgvector) をデータベースとして使用 | E-02 | ○ |
| C-03 | Redisを分散キャッシュとして使用 | E-02, E-08 | ○ |
| C-04 | RabbitMQをメッセージブローカーとして使用 | E-02, E-17 | ○ |
| C-05 | catalogdb, identitydb, orderingdb, webhooksdb の4データベース構成 | E-02 | ○ |
| C-06 | Basket APIはgRPC通信をサポート | E-08, E-12 | ○ |
| C-07 | YARPをMobile BFFとして使用 | E-02, E-03 | ○ |
| C-08 | Duende IdentityServer 7.3.2で認証実装 | E-11, E-18 | ○ |
| C-09 | OpenTelemetry 1.14.0で監視を実装 | E-05, E-06, E-18 | ○ |
| C-10 | ヘルスチェックエンドポイント /health, /alive を実装 | E-06 | ○ |
| C-11 | JWT Bearer認証を使用 | E-07 | ○ |
| C-12 | Service Discoveryを使用 | E-06 | ○ |
| C-13 | Standard Resilience Handlerを使用 | E-06 | ○ |
| C-14 | Entity Framework Core 10.0.1を使用 | E-09, E-10, E-18 | ○ |
| C-15 | FluentValidation 12.0.0を使用 | E-10, E-18 | ○ |
| C-16 | MediatR 13.0.0を使用 | E-18 | ○ |
| C-17 | Azure OpenAI連携オプションあり | E-02, E-03 | ○ |
| C-18 | Ollama連携オプションあり | E-02, E-03 | ○ |
| C-19 | .NET 10.0を使用 | E-01, E-08, E-09 等 | ○ |
| C-20 | RabbitMQは永続化設定（ContainerLifetime.Persistent） | E-02 | ○ |
| C-21 | PostgreSQLは永続化設定（ContainerLifetime.Persistent） | E-02 | ○ |
| C-22 | OTLP Exporterでテレメトリエクスポート | E-06 | ○ |
| C-23 | Forwarded Headers対応 | E-03 | ○ |
| C-24 | User Secretsで機密情報管理 | E-01, E-08 等 | ○ |
| C-25 | Azure Developer CLI (azd) でデプロイ可能 | E-19 | ○ |
| C-26 | Docker Desktop必須 | E-19 | ○ |
| C-27 | GitHub ActionsでCI実装 | E-20, E-21 | ○ |
| C-28 | Scalar.AspNetCoreでAPI文書化 | E-05, E-18 | ○ |
| C-29 | pgvectorでベクトル検索対応 | E-02, E-09 | ○ |
| C-30 | Order ProcessorはWorker Serviceとして実装 | E-13 | ○ |
| C-31 | WebAppはBlazor Server | E-12 | ○ |
| C-32 | 環境変数ESHOP_USE_HTTP_ENDPOINTSでHTTP強制可能 | E-02 | ○ |
| C-33 | バックアップ設計（日次推奨） | **根拠なし** | △ |
| C-34 | Azure Container Appsでホスティング | E-19 (README記載のみ) | △ |
| C-35 | サーバースペック詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **バックアップ設計**: コードベースにバックアップ設定の記述なし。本番環境では別途設計が必要。
  - 候補：Azureマネージドサービスのバックアップ機能 / カスタムバックアップスクリプト / サードパーティツール

- **本番環境サーバースペック**: 開発環境の設定のみ確認可能。本番環境ではリソース要件の検討が必要。
  - 候補：Azureリソースのサイジングガイド / 負荷テスト結果 / 過去実績

- **Azure Container Apps詳細構成**: README.mdにazd対応の記載があるが、具体的なContainer Apps構成は別リポジトリ（eShopOnAzure）に委譲。
  - 候補：eShopOnAzureリポジトリ / Azure公式ドキュメント

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: サービス構成、ミドルウェアバージョン、通信方式 - コードから直接確認可能
- **1（中リスク）**: Azure Container Apps構成 - README参照のみ、詳細は別リポジトリ
- **2（高リスク）**: バックアップ設計、本番環境スペック - コード上に根拠なし、本番運用前に要確認

## 6) レビュアーチェックリスト（最小）

- [ ] .NET Aspire 13.1.0の最新リリースノートを確認（セキュリティアップデートの有無）
- [ ] Duende IdentityServer 7.3.2のライセンス条件を確認（商用利用時）
- [ ] 本番環境へのデプロイ前にバックアップ設計を別途策定
- [ ] Azure Container Appsのスケーリング設定を環境要件に応じて調整
- [ ] OpenTelemetry Exporterの接続先（APM）を本番環境用に設定
- [ ] User Secretsから本番用シークレット管理（Azure Key Vault等）への移行計画を確認
- [ ] RabbitMQとPostgreSQLの永続化設定が本番要件を満たすか確認
