# インフラ構成図

## 全体アーキテクチャ

```mermaid
flowchart TB
    subgraph External["外部クライアント"]
        Browser["Webブラウザ"]
        MobileApp["モバイルアプリ"]
    end

    subgraph Gateway["エントリーポイント"]
        WebApp["WebApp<br/>(Blazor Server)"]
        MobileBFF["Mobile BFF<br/>(YARP)"]
        IdentityAPI["Identity API<br/>(Duende IdentityServer)"]
    end

    subgraph Services["マイクロサービス"]
        CatalogAPI["Catalog API"]
        BasketAPI["Basket API<br/>(gRPC)"]
        OrderingAPI["Ordering API"]
        WebhooksAPI["Webhooks API"]
        WebhookClient["Webhook Client"]
    end

    subgraph Workers["バックグラウンドワーカー"]
        OrderProcessor["Order Processor"]
        PaymentProcessor["Payment Processor"]
    end

    subgraph DataStores["データストア"]
        subgraph PostgreSQL["PostgreSQL (pgvector)"]
            CatalogDB[("catalogdb")]
            IdentityDB[("identitydb")]
            OrderingDB[("orderingdb")]
            WebhooksDB[("webhooksdb")]
        end
        Redis[("Redis<br/>Cache")]
    end

    subgraph Messaging["メッセージング"]
        RabbitMQ[("RabbitMQ<br/>Event Bus")]
    end

    subgraph AI["AI Services (Optional)"]
        OpenAI["Azure OpenAI /<br/>OpenAI"]
        Ollama["Ollama"]
    end

    %% External connections
    Browser --> WebApp
    MobileApp --> MobileBFF
    Browser --> IdentityAPI
    MobileApp --> IdentityAPI

    %% Gateway to Services
    WebApp --> CatalogAPI
    WebApp --> BasketAPI
    WebApp --> OrderingAPI
    MobileBFF --> CatalogAPI
    MobileBFF --> OrderingAPI
    MobileBFF --> IdentityAPI

    %% Service to Data
    CatalogAPI --> CatalogDB
    IdentityAPI --> IdentityDB
    OrderingAPI --> OrderingDB
    WebhooksAPI --> WebhooksDB
    BasketAPI --> Redis

    %% Event Bus connections
    CatalogAPI --> RabbitMQ
    BasketAPI --> RabbitMQ
    OrderingAPI --> RabbitMQ
    WebhooksAPI --> RabbitMQ
    OrderProcessor --> RabbitMQ
    PaymentProcessor --> RabbitMQ
    WebApp --> RabbitMQ

    %% Worker connections
    OrderProcessor --> OrderingDB

    %% AI connections
    CatalogAPI -.-> OpenAI
    CatalogAPI -.-> Ollama
    WebApp -.-> OpenAI
    WebApp -.-> Ollama

    %% Webhook
    WebhooksAPI --> WebhookClient
```

## サービス間通信フロー

```mermaid
flowchart LR
    subgraph Sync["同期通信"]
        REST["REST API"]
        gRPC["gRPC"]
    end

    subgraph Async["非同期通信"]
        Events["Integration Events"]
    end

    WebApp -->|REST| CatalogAPI["Catalog API"]
    WebApp -->|gRPC| BasketAPI["Basket API"]
    WebApp -->|REST| OrderingAPI["Ordering API"]

    CatalogAPI -->|Publish| RabbitMQ[("RabbitMQ")]
    BasketAPI -->|Publish| RabbitMQ
    OrderingAPI -->|Publish| RabbitMQ

    RabbitMQ -->|Subscribe| OrderProcessor["Order Processor"]
    RabbitMQ -->|Subscribe| PaymentProcessor["Payment Processor"]
    RabbitMQ -->|Subscribe| WebhooksAPI["Webhooks API"]
```

## データベース構成

```mermaid
erDiagram
    PostgreSQL {
        database catalogdb
        database identitydb
        database orderingdb
        database webhooksdb
    }

    catalogdb ||--o{ CatalogItems : contains
    catalogdb ||--o{ CatalogBrands : contains
    catalogdb ||--o{ CatalogTypes : contains
    catalogdb ||--o{ IntegrationEventLog : contains

    identitydb ||--o{ AspNetUsers : contains
    identitydb ||--o{ AspNetRoles : contains

    orderingdb ||--o{ Orders : contains
    orderingdb ||--o{ OrderItems : contains
    orderingdb ||--o{ Buyers : contains
    orderingdb ||--o{ IntegrationEventLog : contains

    webhooksdb ||--o{ WebhookSubscriptions : contains
    webhooksdb ||--o{ IntegrationEventLog : contains
```

## 認証フロー

```mermaid
sequenceDiagram
    participant User as ユーザー
    participant WebApp as WebApp
    participant Identity as Identity API
    participant API as Protected API

    User->>WebApp: アクセス
    WebApp->>Identity: 認証リクエスト
    Identity->>User: ログインページ
    User->>Identity: 認証情報入力
    Identity->>Identity: 認証処理
    Identity->>WebApp: Authorization Code
    WebApp->>Identity: Token Request
    Identity->>WebApp: Access Token + ID Token
    WebApp->>API: API呼び出し (Bearer Token)
    API->>API: Token検証
    API->>WebApp: レスポンス
```

## デプロイメント構成（ローカル開発）

```mermaid
flowchart TB
    subgraph Host["開発マシン"]
        subgraph Aspire["NET Aspire AppHost"]
            Orchestrator["Orchestrator"]
        end

        subgraph Docker["Docker Desktop"]
            PostgreSQLContainer["PostgreSQL<br/>(pgvector)"]
            RedisContainer["Redis"]
            RabbitMQContainer["RabbitMQ"]
        end

        subgraph DotNet[".NET Processes"]
            WebAppProc["WebApp"]
            IdentityProc["Identity API"]
            CatalogProc["Catalog API"]
            BasketProc["Basket API"]
            OrderingProc["Ordering API"]
            OrderProcProc["Order Processor"]
            PaymentProc["Payment Processor"]
            WebhooksProc["Webhooks API"]
            WebhookClientProc["Webhook Client"]
            MobileBFFProc["Mobile BFF"]
        end
    end

    Orchestrator --> Docker
    Orchestrator --> DotNet
```

## デプロイメント構成（Azure）

```mermaid
flowchart TB
    subgraph Azure["Azure Cloud"]
        subgraph ACA["Azure Container Apps"]
            WebAppACA["WebApp"]
            IdentityACA["Identity API"]
            CatalogACA["Catalog API"]
            BasketACA["Basket API"]
            OrderingACA["Ordering API"]
            OrderProcACA["Order Processor"]
            PaymentACA["Payment Processor"]
            WebhooksACA["Webhooks API"]
            WebhookClientACA["Webhook Client"]
            MobileBFFACA["Mobile BFF"]
        end

        subgraph Managed["マネージドサービス"]
            AzurePostgreSQL["Azure Database<br/>for PostgreSQL"]
            AzureCache["Azure Cache<br/>for Redis"]
            ServiceBus["Azure Service Bus /<br/>RabbitMQ on ACA"]
        end

        subgraph Optional["オプション"]
            AzureOpenAI["Azure OpenAI"]
            CognitiveServices["Cognitive Services"]
        end
    end

    Internet["インターネット"] --> WebAppACA
    Internet --> MobileBFFACA
    Internet --> IdentityACA

    ACA --> Managed
    ACA -.-> Optional
```

## ネットワーク構成

```mermaid
flowchart TB
    subgraph Public["パブリックネットワーク"]
        Internet["インターネット"]
    end

    subgraph Ingress["イングレス層"]
        WebApp["WebApp<br/>:443 (HTTPS)"]
        IdentityAPI["Identity API<br/>:443 (HTTPS)"]
        MobileBFF["Mobile BFF<br/>:443 (HTTPS)"]
    end

    subgraph Internal["内部ネットワーク"]
        CatalogAPI["Catalog API<br/>:80 (HTTP)"]
        BasketAPI["Basket API<br/>:80 (HTTP/gRPC)"]
        OrderingAPI["Ordering API<br/>:80 (HTTP)"]
        WebhooksAPI["Webhooks API<br/>:80 (HTTP)"]
        OrderProcessor["Order Processor"]
        PaymentProcessor["Payment Processor"]
    end

    subgraph Data["データ層"]
        PostgreSQL["PostgreSQL<br/>:5432"]
        Redis["Redis<br/>:6379"]
        RabbitMQ["RabbitMQ<br/>:5672"]
    end

    Internet --> Ingress
    Ingress --> Internal
    Internal --> Data
```

## 監視・オブザーバビリティ

```mermaid
flowchart LR
    subgraph Services["全サービス"]
        Service1["Service 1"]
        Service2["Service 2"]
        ServiceN["Service N"]
    end

    subgraph Telemetry["OpenTelemetry"]
        Traces["Traces"]
        Metrics["Metrics"]
        Logs["Logs"]
    end

    subgraph Backends["バックエンド"]
        AspireDashboard["Aspire Dashboard"]
        OTLP["OTLP Exporter"]
    end

    Services --> Telemetry
    Telemetry --> AspireDashboard
    Telemetry --> OTLP
```
