# インフラ設計書

## 概要

本ドキュメントは、eShopリファレンスアプリケーションのインフラストラクチャ構成を定義したものである。eShopは.NET Aspireフレームワークを使用したマイクロサービスアーキテクチャを採用したECサイトのリファレンス実装であり、ローカル開発環境からクラウド（Azure）へのデプロイまでをサポートする。

## システム構成

### 全体構成

eShopはサービスベースアーキテクチャを採用し、以下の主要コンポーネントで構成される：

- **WebApp**: フロントエンドWebアプリケーション（Blazor Server）
- **Identity API**: 認証・認可サービス（Duende IdentityServer）
- **Catalog API**: 商品カタログサービス
- **Basket API**: ショッピングカートサービス
- **Ordering API**: 注文管理サービス
- **Order Processor**: 注文処理バックグラウンドサービス
- **Payment Processor**: 決済処理サービス
- **Webhooks API**: Webhook管理サービス
- **Webhook Client**: Webhookクライアントアプリケーション
- **Mobile BFF**: モバイルアプリ向けリバースプロキシ（YARP）

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| AppHost | .NET Aspireオーケストレーター | .NET 10.0 | 1 |
| WebApp | フロントエンドWebサーバー（Blazor Server） | .NET 10.0 | 1 |
| Identity API | 認証サーバー（Duende IdentityServer 7.3） | .NET 10.0 | 1 |
| Catalog API | カタログAPIサーバー | .NET 10.0 | 1 |
| Basket API | カートAPIサーバー（gRPC） | .NET 10.0 | 1 |
| Ordering API | 注文APIサーバー | .NET 10.0 | 1 |
| Order Processor | バックグラウンドワーカー | .NET 10.0 | 1 |
| Payment Processor | 決済処理サーバー | .NET 10.0 | 1 |
| Webhooks API | Webhook APIサーバー | .NET 10.0 | 1 |
| Webhook Client | Webhookクライアント | .NET 10.0 | 1 |
| PostgreSQL (pgvector) | データベースサーバー | ankane/pgvector:latest | 1 |
| Redis | キャッシュサーバー | Redis | 1 |
| RabbitMQ | メッセージブローカー | RabbitMQ | 1 |
| Mobile BFF (YARP) | リバースプロキシ | YARP | 1 |

### ネットワーク構成

#### サービス間通信

- **同期通信**:
  - REST API: 主要なサービス間通信
  - gRPC: Basket APIとWebApp間の高性能通信
  - Service Discovery: .NET Aspireによるサービス検出

- **非同期通信**:
  - RabbitMQ: イベントドリブン通信用メッセージブローカー
  - Integration Events: サービス間のイベント連携

#### エンドポイント構成

| サービス | プロトコル | 外部公開 |
| --- | --- | --- |
| WebApp | HTTP/HTTPS | あり |
| Identity API | HTTP/HTTPS | あり |
| Catalog API | HTTP | なし |
| Basket API | gRPC/HTTP | なし |
| Ordering API | HTTP | なし |
| Webhooks API | HTTP | なし |
| Mobile BFF | HTTP/HTTPS | あり |

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| .NET Aspire | 13.1.0 | マイクロサービスオーケストレーション |
| PostgreSQL (pgvector) | latest | リレーショナルデータベース・ベクトル検索 |
| Redis | - | 分散キャッシュ（カートデータ保存） |
| RabbitMQ | - | メッセージブローカー（イベントバス） |
| YARP | 13.1.0 | リバースプロキシ（Mobile BFF） |
| Duende IdentityServer | 7.3.2 | OAuth2/OpenID Connect認証サーバー |
| Entity Framework Core | 10.0.1 | O/Rマッピング |
| OpenTelemetry | 1.14.0 | 分散トレーシング・メトリクス |
| FluentValidation | 12.0.0 | バリデーション |
| MediatR | 13.0.0 | CQRS/メディエーターパターン |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| Azure OpenAI | AIアシスタント・チャット機能 | REST API（オプション） |
| OpenAI | AIアシスタント・チャット機能 | REST API（オプション） |
| Ollama | ローカルLLM（オプション） | REST API |
| Azure Cognitive Services | AI機能 | REST API（オプション） |

## スケーリング設計

### ローカル開発環境

- .NET Aspireによるコンテナオーケストレーション
- 各サービスは単一インスタンスで起動
- Docker Desktopが必要

### Azure デプロイ

Azure Developer CLI（azd）によるデプロイをサポート：

- **Azure Container Apps**: マイクロサービスのホスティング
- **自動スケーリング**: Container Appsの組み込みスケーリング機能
- **サービス検出**: Aspire Service Discoveryによる自動解決

### スケーリング方式

| コンポーネント | スケーリング方式 |
| --- | --- |
| APIサービス群 | 水平スケーリング（複数インスタンス対応） |
| PostgreSQL | 垂直スケーリング / マネージドサービス利用 |
| Redis | クラスターモード対応 |
| RabbitMQ | クラスターモード対応 |

## 可用性設計

### ヘルスチェック

全サービスに共通のヘルスチェックエンドポイントを実装：

- `/health`: 全体ヘルスチェック
- `/alive`: ライブネスチェック

### 回復性（Resilience）

- **Standard Resilience Handler**: HTTPクライアントに組み込み
- **サーキットブレーカー**: サービス障害時の連鎖障害防止
- **リトライポリシー**: 一時的な障害からの自動回復
- **タイムアウト**: 適切なタイムアウト設定

### データベース

- PostgreSQLの永続化設定
- RabbitMQの永続化設定（ContainerLifetime.Persistent）

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| PostgreSQL (catalogdb) | 論理バックアップ（pg_dump） | 日次（推奨） | 環境依存 |
| PostgreSQL (identitydb) | 論理バックアップ（pg_dump） | 日次（推奨） | 環境依存 |
| PostgreSQL (orderingdb) | 論理バックアップ（pg_dump） | 日次（推奨） | 環境依存 |
| PostgreSQL (webhooksdb) | 論理バックアップ（pg_dump） | 日次（推奨） | 環境依存 |
| Redis | RDB/AOF | 環境依存 | 環境依存 |

**注記**: ローカル開発環境ではバックアップは設定されていない。本番環境ではマネージドサービスのバックアップ機能を利用することを推奨。

## 監視設計

### OpenTelemetry統合

全サービスに以下のテレメトリを実装：

- **メトリクス**:
  - ASP.NET Core Instrumentation
  - HTTP Client Instrumentation
  - Runtime Instrumentation

- **トレーシング**:
  - ASP.NET Core Instrumentation
  - gRPC Client Instrumentation
  - HTTP Client Instrumentation

- **ログ**:
  - OpenTelemetry Logger Provider
  - 構造化ログ出力

### Aspire Dashboard

.NET Aspireに組み込みのダッシュボードで以下を確認可能：

- サービス一覧と状態
- ログの集中管理
- 分散トレース
- メトリクス

### エクスポート

- **OTLP (OpenTelemetry Protocol)**: 外部監視システムへのエクスポート対応
- `OTEL_EXPORTER_OTLP_ENDPOINT`環境変数で設定可能

## セキュリティ設計

### 認証・認可

- **OAuth2 / OpenID Connect**: Duende IdentityServerによる実装
- **JWT Bearer認証**: APIサービス間認証
- **ASP.NET Core Identity**: ユーザー管理

### 通信セキュリティ

- **HTTPS**: 外部公開エンドポイント
- **HTTP**: 内部サービス間通信（コンテナネットワーク内）
- **Forwarded Headers**: リバースプロキシ対応

### 機密情報管理

- **User Secrets**: 開発環境での機密情報管理
- **環境変数**: コンテナ環境での設定

## 備考

### 前提条件

- Docker Desktop がインストール・起動されていること
- .NET 10.0 SDK がインストールされていること
- Windows環境ではVisual Studio 2022 17.10以降を推奨

### 開発環境での起動方法

```bash
dotnet run --project src/eShop.AppHost/eShop.AppHost.csproj
```

### Azure へのデプロイ

```bash
azd auth login
azd init
azd up
```

### 関連ドキュメント

- [.NET Aspire ドキュメント](https://learn.microsoft.com/dotnet/aspire/)
- [eShop on Azure](https://github.com/Azure-Samples/eShopOnAzure)
