---
generated_at: 2026-01-14 20:15:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **監査ログ保持期間**：具体的な保持期間設定がコードから確認できない
  2. **Rate Limiting推奨**：現状実装の有無が確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Program.cs` - IdentityServer設定、Cookie有効期限、イベント設定
- E-02: `src/Identity.API/Configuration/Config.cs` - クライアント定義、スコープ、Grant Type設定
- E-03: `src/eShop.ServiceDefaults/AuthenticationExtensions.cs` - JWT Bearer認証設定
- E-04: `src/Identity.API/Quickstart/SecurityHeadersAttribute.cs` - セキュリティヘッダー実装
- E-05: `src/Identity.API/Quickstart/Account/AccountController.cs` - CSRF対策、ログインロジック、イベント発行
- E-06: `src/Identity.API/Services/EFLoginService.cs` - ログインサービス実装
- E-07: `src/Identity.API/Models/ApplicationUser.cs` - ユーザーモデル、データ検証属性
- E-08: `src/Identity.API/UsersSeed.cs` - シードデータ、パスワード例、マスク済みカード番号
- E-09: `src/Ordering.API/Apis/OrdersApi.cs` - クレジットカードマスキング、ログ出力制御
- E-10: `src/Ordering.API/Application/Validations/CreateOrderCommandValidator.cs` - FluentValidation検証ルール
- E-11: `src/Ordering.API/Application/Behaviors/ValidatorBehavior.cs` - 検証パイプライン
- E-12: `src/Ordering.API/Application/Behaviors/LoggingBehavior.cs` - コマンドロギング
- E-13: `src/Ordering.API/Infrastructure/Services/IdentityService.cs` - ユーザーID取得
- E-14: `src/Ordering.API/Extensions/Extensions.cs` - 認証設定、FluentValidation登録
- E-15: `src/Basket.API/Extensions/Extensions.cs` - 認証設定
- E-16: `src/Basket.API/Extensions/ServerCallContextIdentityExtensions.cs` - gRPCユーザーID取得
- E-17: `src/Basket.API/Grpc/BasketService.cs` - 認証チェック、リソースアクセス制御
- E-18: `src/WebApp/Extensions/Extensions.cs` - OpenID Connect設定、Cookie認証
- E-19: `src/Webhooks.API/Apis/WebHooksApi.cs` - ユーザーIDベースアクセス制御
- E-20: `src/Webhooks.API/Extensions/Extensions.cs` - 認証設定
- E-21: `src/Webhooks.API/Extensions/RouteHandlerBuilderExtensions.cs` - リクエスト検証フィルター

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Duende IdentityServerを使用したOAuth2.0/OIDC認証 | E-01, E-02 | ○ |
| C-02 | ASP.NET Core Identity + PostgreSQLをユーザーストアとして使用 | E-01 | ○ |
| C-03 | JWT形式のトークンを使用 | E-03 | ○ |
| C-04 | Authorization CodeおよびImplicit Grant Typeをサポート | E-02 | ○ |
| C-05 | MAUIクライアントでPKCEが有効 | E-02 | ○ |
| C-06 | 6種類のクライアント（maui, webapp, webhooksclient, 3xswaggerui）を定義 | E-02 | ○ |
| C-07 | Cookie有効期限が2時間 | E-01 | ○ |
| C-08 | アクセストークン/IDトークン有効期限が2時間 | E-02 | ○ |
| C-09 | SessionCookieLifetimeMinutesで設定可能（デフォルト60分） | E-18 | ○ |
| C-10 | SameSite Cookie ポリシーがLax | E-01 | ○ |
| C-11 | アカウントロックアウトが有効（lockoutOnFailure: true） | E-05 | ○ |
| C-12 | openid, profile, offline_access, orders, basket, webhooksスコープを定義 | E-02 | ○ |
| C-13 | JWT Bearer認証でAudienceを検証 | E-03 | ○ |
| C-14 | Basket APIでユーザーIDベースのアクセス制御 | E-16, E-17 | ○ |
| C-15 | Ordering APIでユーザーIDベースのアクセス制御 | E-13 | ○ |
| C-16 | Webhooks APIでユーザーIDベースのアクセス制御 | E-19 | ○ |
| C-17 | RequireHttpsMetadata = false（開発環境向け） | E-03, E-18 | ○ |
| C-18 | パスワードがASP.NET Core Identityでハッシュ化 | E-01, E-06 | ○ |
| C-19 | クライアントシークレットがSHA256でハッシュ化 | E-02 | ○ |
| C-20 | 開発者署名キーを使用（本番環境では変更必要） | E-01 | ○ |
| C-21 | クレジットカード番号をマスキングして保存 | E-09 | ○ |
| C-22 | ログ出力時にクレジットカード情報を含むリクエストを出力しない | E-09 | ○ |
| C-23 | シードデータのカード番号がマスク済み形式 | E-08 | ○ |
| C-24 | Content-Security-Policyヘッダーを設定 | E-04 | ○ |
| C-25 | X-Frame-Options: SAMEORIGINを設定 | E-04 | ○ |
| C-26 | X-Content-Type-Options: nosniffを設定 | E-04 | ○ |
| C-27 | ValidateAntiForgeryToken属性でCSRF対策 | E-05 | ○ |
| C-28 | Referrer-Policy: no-referrerを設定 | E-04 | ○ |
| C-29 | FluentValidationで入力検証を実装 | E-10, E-11, E-14 | ○ |
| C-30 | Url.IsLocalUrl()でオープンリダイレクト対策 | E-05 | ○ |
| C-31 | UserLoginSuccessEvent/UserLoginFailureEventを発行 | E-05 | ○ |
| C-32 | UserLogoutSuccessEventを発行 | E-05 | ○ |
| C-33 | IdentityServerのイベント発行設定がすべて有効 | E-01 | ○ |
| C-34 | 監査ログの保持期間がIdentityServer設定による | **根拠なし** | △ |
| C-35 | Rate Limiting推奨（現状実装なし） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **監査ログ保持期間の設定**: IdentityServerの設定ファイルまたはロギングインフラストラクチャの設定から保持期間を確認する必要がある
  - 候補：appsettings.json / Serilog設定 / 外部ログ管理サービス設定
- **Rate Limitingの実装状況**: コードベースからRate Limitingミドルウェアの使用が確認できない
  - 候補：Microsoft.AspNetCore.RateLimiting / Aspireのポリシー / API Gatewayでの実装

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: クライアントシークレット（"secret"）が開発用の値のままであることの注記
- **1（中リスク）**: RequireHttpsMetadata = false の設定が本番環境で問題になる可能性
- **1（中リスク）**: ValidateAudience = false の設定がセキュリティ上のリスクになる可能性
- **1（中リスク）**: KeyManagement.Enabled = false による署名キー管理の問題
- **0（低リスク）**: Rate Limitingが未実装であることの指摘

## 6) レビュアーチェックリスト（最小）
- [ ] 認証方式（Duende IdentityServer + JWT）が実際のコードと一致しているか確認
- [ ] クライアント設定（6種類）が実際の設定ファイルと一致しているか確認
- [ ] セッション有効期限（2時間）が要件と合致しているか確認
- [ ] セキュリティヘッダー（CSP, X-Frame-Options等）の設定値が要件を満たしているか確認
- [ ] FluentValidationの検証ルールが業務要件と一致しているか確認
- [ ] クレジットカードマスキングの実装が適切か確認
- [ ] 開発環境向け設定（RequireHttpsMetadata = false等）の本番環境対応計画があるか確認
- [ ] 監査ログの保持期間要件を確認し、設定を追加する必要があるか判断
- [ ] Rate Limitingの実装必要性を検討
