---
generated_at: 2026-01-14 22:15:00
metrics:
  claims_total: 32
  claims_with_evidence: 29
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：29 / 32、根拠なし：3
- 優先レビュー（高）
  1. **カバレッジ目標値**：具体的な数値目標の根拠なし（推奨値として記載）
  2. **性能テスト・セキュリティテストの実施タイミング**：プロジェクトポリシーとして推定
  3. **不具合管理フロー**：プロジェクト標準として推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tests/Directory.Build.props` - MSTest/xUnit設定
- E-02: `tests/Ordering.UnitTests/Ordering.UnitTests.csproj` - MSTest SDK、NSubstitute参照
- E-03: `tests/Catalog.FunctionalTests/Catalog.FunctionalTests.csproj` - Aspire.AppHost.Sdk、xUnit v3参照
- E-04: `tests/Basket.UnitTests/Basket.UnitTests.csproj` - MSTest SDK、NSubstitute参照
- E-05: `tests/ClientApp.UnitTests/ClientApp.UnitTests.csproj` - MSTest SDK、MAUI参照
- E-06: `tests/Ordering.FunctionalTests/Ordering.FunctionalTests.csproj` - Aspire.AppHost.Sdk、xUnit v3参照
- E-07: `.github/workflows/pr-validation.yml` - CI/CD設定（Web）
- E-08: `.github/workflows/pr-validation-maui.yml` - CI/CD設定（MAUI）
- E-09: `.github/workflows/playwright.yml` - E2Eテスト設定
- E-10: `playwright.config.ts` - Playwright設定
- E-11: `package.json` - Playwright依存関係
- E-12: `global.json` - .NET SDK/テストランナー設定
- E-13: `tests/README.md` - テストディレクトリ説明
- E-14: `tests/Ordering.UnitTests/Domain/OrderAggregateTest.cs` - 単体テスト実装例
- E-15: `tests/Catalog.FunctionalTests/CatalogApiTests.cs` - 機能テスト実装例
- E-16: `tests/Catalog.FunctionalTests/CatalogApiFixture.cs` - Aspireフィクスチャ実装
- E-17: `tests/Ordering.FunctionalTests/OrderingApiFixture.cs` - Aspireフィクスチャ実装
- E-18: `tests/Basket.UnitTests/BasketServiceTests.cs` - gRPCテスト実装例
- E-19: `tests/Ordering.UnitTests/Builders.cs` - Builderパターン実装
- E-20: `e2e/AddItemTest.spec.ts` - E2Eテスト実装例
- E-21: `e2e/BrowseItemTest.spec.ts` - E2Eテスト実装例
- E-22: `e2e/login.setup.ts` - ログインセットアップ

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | .NET 10.0をベースに構築 | E-02, E-03, E-12 | ○ |
| C-02 | 単体テスト・結合テスト・E2Eテストの3層構成 | E-02, E-03, E-09, E-10 | ○ |
| C-03 | MSTest 4.0.2をテストフレームワークとして使用 | E-01, E-02, E-12 | ○ |
| C-04 | xUnit v3を機能テストに使用 | E-03, E-06 | ○ |
| C-05 | NSubstituteをモックライブラリとして使用 | E-02, E-04 | ○ |
| C-06 | Playwright 1.42.1をE2Eテストに使用 | E-11 | ○ |
| C-07 | Microsoft.AspNetCore.Mvc.Testingを使用 | E-03, E-04, E-06 | ○ |
| C-08 | Aspire.AppHost.Sdk 13.0.0を使用 | E-03, E-06 | ○ |
| C-09 | Dockerによるテストコンテナを使用 | E-13, E-16, E-17 | ○ |
| C-10 | CI環境はUbuntu Latest | E-07, E-09 | ○ |
| C-11 | MAUIテストはWindows Latest | E-08 | ○ |
| C-12 | Builderパターンでテストオブジェクト生成 | E-14, E-19 | ○ |
| C-13 | PostgreSQLコンテナを自動起動 | E-16, E-17 | ○ |
| C-14 | シードデータ101件（CatalogItem） | E-15（テスト内Assert） | ○ |
| C-15 | Playwright認証状態の保存 | E-10 | ○ |
| C-16 | pr-validation.ymlでdotnet build/test実行 | E-07 | ○ |
| C-17 | pr-validation-maui.ymlでMAUIワークロードインストール | E-08 | ○ |
| C-18 | playwright.ymlでChromiumを使用 | E-09 | ○ |
| C-19 | テストレポートを30日間保存 | E-09 | ○ |
| C-20 | PlaywrightテストはCI環境で2回リトライ | E-10 | ○ |
| C-21 | Microsoft.Testing.Platformをテストランナーに使用 | E-01, E-12 | ○ |
| C-22 | APIバージョン1.0/2.0の両方をテスト | E-15 | ○ |
| C-23 | Basket.UnitTestsの存在と構成 | E-04, E-18 | ○ |
| C-24 | Ordering.UnitTestsの存在と構成 | E-02, E-14 | ○ |
| C-25 | ClientApp.UnitTestsの存在と構成 | E-05 | ○ |
| C-26 | Catalog.FunctionalTestsの存在と構成 | E-03, E-15, E-16 | ○ |
| C-27 | Ordering.FunctionalTestsの存在と構成 | E-06, E-17 | ○ |
| C-28 | E2Eテストディレクトリの存在と構成 | E-10, E-20, E-21, E-22 | ○ |
| C-29 | タイムアウト60分（Playwrightワークフロー） | E-09 | ○ |
| C-30 | 行カバレッジ目標80% | **根拠なし** | △ |
| C-31 | 分岐カバレッジ目標70% | **根拠なし** | △ |
| C-32 | 不具合管理はGitHub Issuesで実施 | **根拠なし**（推定） | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標**：コードベースにカバレッジ閾値の設定ファイル（coverlet設定等）が見つからなかった
  - 候補：coverlet.runsettings / .codecov.yml / カバレッジ設定付きCI構成
- **不具合管理ポリシー**：明示的なドキュメントやIssueテンプレートが確認できなかった
  - 候補：.github/ISSUE_TEMPLATE / CONTRIBUTING.md / プロジェクトWiki
- **性能テスト・セキュリティテストの具体的設定**：実行スクリプトやツール設定が未確認
  - 候補：k6設定 / JMeter設定 / OWASP ZAP設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：テストフレームワーク・ツールの記載 - 全てコードベースから確認可能
- **0（低リスク）**：CI/CD構成 - GitHub Actionsワークフローから直接確認
- **1（中リスク）**：カバレッジ目標値 - 業界標準値を参考に記載したが、プロジェクト固有の要件確認が必要
- **1（中リスク）**：不具合管理フロー - 一般的なプラクティスを記載、チーム固有のフロー確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ目標値（80%/70%）がプロジェクトの実際の目標と一致しているか確認
- [ ] 不具合管理フローがチームの実際の運用と一致しているか確認
- [ ] 性能テスト・セキュリティテストの実施計画がある場合、具体的なツール・手順を追記
- [ ] テストプロジェクト構成が最新の状態を反映しているか確認
- [ ] E2Eテストの対象ブラウザ（現在Chromiumのみ）が要件を満たしているか確認
