# テスト方針書

## 概要

本ドキュメントは、eShopアプリケーションにおけるテスト戦略と方針を定義するものです。eShopはマイクロサービスアーキテクチャに基づくeコマースアプリケーションであり、.NET 10.0をベースに構築されています。本プロジェクトでは、単体テスト、結合テスト（機能テスト）、E2Eテストの3層構成でテストを実施し、品質を確保します。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のクラス・メソッドの動作検証、ドメインロジックの正確性確認 | 開発者 |
| 結合テスト（機能テスト） | API エンドポイントの動作検証、サービス間連携の確認、データベースとの統合確認 | 開発者/QAエンジニア |
| システムテスト（E2Eテスト） | ユーザーシナリオに基づくエンドツーエンドの動作検証、ブラウザ上での操作確認 | QAエンジニア |
| 受入テスト | ビジネス要件の充足確認、ステークホルダーによる承認 | プロダクトオーナー/QAエンジニア |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | 各APIエンドポイント、ドメインロジック、UIコンポーネントの機能検証 | 開発時・PR作成時 |
| 性能テスト | レスポンス時間、スループット、リソース使用率の検証 | リリース前 |
| セキュリティテスト | 認証・認可の動作確認、入力値検証、脆弱性検査 | リリース前 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発者による単体テスト・デバッグ | Windows/macOS/Linux、.NET 10.0 SDK、Docker |
| CI環境（GitHub Actions） | 自動テスト実行（PR検証、マージ時） | Ubuntu Latest、.NET 10.0、Docker（機能テスト用コンテナ） |
| E2Eテスト環境 | Playwrightによるブラウザテスト | Ubuntu Latest、Node.js LTS、Chromium |
| MAUIテスト環境 | クライアントアプリテスト | Windows Latest、.NET MAUI Workloads |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| MSTest | 単体テスト・結合テスト用フレームワーク | 4.0.2 (MSTest.Sdk) |
| xUnit v3 | 機能テスト用フレームワーク（Aspire統合） | xunit.v3.mtp-v2 |
| NSubstitute | モックライブラリ | 最新版 |
| Playwright | E2Eテスト（ブラウザ自動化） | 1.42.1 |
| Microsoft.AspNetCore.Mvc.Testing | WebApplicationFactory による統合テスト | .NET 10.0同梱 |
| Microsoft.AspNetCore.TestHost | テストサーバー | .NET 10.0同梱 |
| Aspire.Hosting | 分散アプリケーションテスト用ホスティング | 13.0.0 (Aspire.AppHost.Sdk) |
| Docker | テストコンテナ（PostgreSQL等）の実行 | 最新版 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 80% |
| 分岐カバレッジ | 70% |

**対象範囲：**
- ドメインロジック（Ordering.Domain等）：高カバレッジ優先
- APIエンドポイント：主要パスのカバレッジ確保
- UIコンポーネント：重要なユーザーフローのカバレッジ確保

## テストデータ

### テストデータの準備方針

1. **単体テスト**
   - Builderパターンを使用したテストオブジェクト生成（例：`OrderBuilder`、`AddressBuilder`）
   - 固定値による再現性のあるテストデータ

2. **機能テスト**
   - Aspireを活用したTestContainerによるPostgreSQLインスタンスの自動起動
   - シードデータによる初期データ投入（CatalogItem 101件等）
   - テスト間の独立性確保のためのトランザクション制御

3. **E2Eテスト**
   - `.env`ファイルによる認証情報の管理
   - ログイン状態の保存（`playwright/.auth/user.json`）による効率的なテスト実行

## 不具合管理

### 管理フロー

1. **不具合の検出**
   - 自動テストによる検出：CI/CDパイプラインで失敗したテストをGitHub Actionsのログで確認
   - 手動テストによる検出：QAチームによる探索的テストで発見

2. **不具合の記録**
   - GitHub Issuesにて管理
   - 必須項目：再現手順、期待動作、実際動作、環境情報

3. **優先度の分類**
   - Critical：サービス停止、データ損失
   - High：主要機能の障害
   - Medium：副次機能の障害
   - Low：軽微な問題、改善要望

4. **修正とリグレッションテスト**
   - 修正完了後、関連するテストケースの追加
   - 全テストスイートの実行によるリグレッション確認

## CI/CD連携

### GitHub Actions ワークフロー構成

#### 1. eShop Pull Request Validation (`pr-validation.yml`)
- **トリガー**：PRおよびmainブランチへのpush
- **除外**：Markdownファイル、ClientApp関連
- **実行内容**：
  - `dotnet build eShop.Web.slnf`
  - `dotnet test --solution eShop.Web.slnf --no-build`
- **環境**：Ubuntu Latest

#### 2. eShop Pull Request Validation - .NET MAUI (`pr-validation-maui.yml`)
- **トリガー**：ClientApp関連のPRおよびmainブランチへのpush
- **実行内容**：
  - MAUIワークロードのインストール（android, ios, maccatalyst, maui）
  - `dotnet build src/ClientApp/ClientApp.csproj`
  - `dotnet test --project tests/ClientApp.UnitTests/ClientApp.UnitTests.csproj`
- **環境**：Windows Latest

#### 3. Playwright Tests (`playwright.yml`)
- **トリガー**：PRおよびmainブランチへのpush
- **実行内容**：
  - Node.js依存関係のインストール
  - HTTPS開発証明書のセットアップ
  - Playwrightブラウザ（Chromium）のインストール
  - `npx playwright test`
  - テストレポートのアーティファクト保存（30日間）
- **環境**：Ubuntu Latest
- **タイムアウト**：60分

### テスト実行のベストプラクティス

1. **並列実行**：MSTestおよびxUnitの並列テスト機能を活用
2. **テスト分離**：機能テストはAspireによるコンテナ分離を使用
3. **フェイルファスト**：CIでは`test.only`が残っていた場合にビルド失敗
4. **リトライ戦略**：PlaywrightテストはCI環境で2回リトライ

## テストプロジェクト構成

```
tests/
├── Basket.UnitTests/           # Basket APIの単体テスト（MSTest）
│   ├── BasketServiceTests.cs   # BasketServiceのgRPC呼び出しテスト
│   └── Helpers/                # テストヘルパー
├── Ordering.UnitTests/         # Ordering APIの単体テスト（MSTest）
│   ├── Application/            # アプリケーション層のテスト
│   │   ├── NewOrderCommandHandlerTest.cs
│   │   ├── IdentifiedCommandHandlerTest.cs
│   │   └── OrdersWebApiTest.cs
│   └── Domain/                 # ドメイン層のテスト
│       ├── OrderAggregateTest.cs
│       └── BuyerAggregateTest.cs
├── ClientApp.UnitTests/        # MAUIクライアントアプリの単体テスト（MSTest）
│   ├── ViewModels/             # ViewModelのテスト
│   └── Services/               # サービス層のテスト
├── Catalog.FunctionalTests/    # Catalog APIの機能テスト（xUnit + Aspire）
│   ├── CatalogApiFixture.cs    # テストフィクスチャ（PostgreSQLコンテナ）
│   └── CatalogApiTests.cs      # APIエンドポイントテスト
└── Ordering.FunctionalTests/   # Ordering APIの機能テスト（xUnit + Aspire）
    ├── OrderingApiFixture.cs   # テストフィクスチャ（PostgreSQL + Identity）
    └── OrderingApiTests.cs     # APIエンドポイントテスト

e2e/
├── login.setup.ts              # ログインセットアップ
├── AddItemTest.spec.ts         # カート追加テスト（要ログイン）
├── RemoveItemTest.spec.ts      # カート削除テスト（要ログイン）
└── BrowseItemTest.spec.ts      # 商品閲覧テスト（ログイン不要）
```

## 備考

### 機能テスト実行の前提条件

機能テストはAspire AppHostとTestContainerを使用してPostgreSQLなどの依存サービスをコンテナとして起動します。実行前にDockerが起動していることを確認してください。

### テストランナー設定

本プロジェクトでは`global.json`にて`Microsoft.Testing.Platform`をテストランナーとして指定しています。これにより、`dotnet test`コマンドで統一的なテスト実行が可能です。

### APIバージョニングテスト

Catalog APIおよびOrdering APIのテストでは、APIバージョン1.0および2.0の両方に対するテストを実施しています。`[Theory]`と`[InlineData]`を使用したパラメータ化テストにより、両バージョンの互換性を確認しています。
