# ER図

本ドキュメントはeShopアプリケーションのエンティティ関係図をmermaid形式で表現する。

## 全体構成

eShopは4つの独立したデータベースコンテキストを持つマイクロサービスアーキテクチャを採用している。

---

## Ordering スキーマ ER図

注文管理サービスのデータモデル。DDDパターンに基づき設計されている。

```mermaid
erDiagram
    orders {
        int Id PK "HiLo: orderseq"
        timestamp_tz OrderDate
        varchar30 OrderStatus
        text Description
        int BuyerId FK
        int PaymentMethodId FK
        text Address_Street
        text Address_City
        text Address_State
        text Address_Country
        text Address_ZipCode
    }

    orderItems {
        int Id PK "HiLo: orderitemseq"
        int OrderId FK
        int ProductId
        text ProductName
        numeric UnitPrice
        numeric Discount
        int Units
        text PictureUrl
    }

    buyers {
        int Id PK "HiLo: buyerseq"
        varchar200 IdentityGuid UK
        text Name
    }

    paymentmethods {
        int Id PK "HiLo: paymentseq"
        int BuyerId FK
        varchar200 Alias
        varchar25 CardNumber
        varchar200 CardHolderName
        timestamp_tz Expiration
        int CardTypeId FK
    }

    cardtypes {
        int Id PK
        varchar200 Name
    }

    requests {
        uuid Id PK
        text Name
        timestamp_tz Time
    }

    IntegrationEventLog_Ordering {
        uuid EventId PK
        text EventTypeName
        text Content
        int State
        int TimesSent
        timestamp_tz CreationTime
        uuid TransactionId
    }

    buyers ||--o{ paymentmethods : "has"
    buyers ||--o{ orders : "places"
    paymentmethods ||--o{ orders : "used_in"
    cardtypes ||--o{ paymentmethods : "categorizes"
    orders ||--|{ orderItems : "contains"
```

---

## Catalog スキーマ ER図

商品カタログ管理サービスのデータモデル。

```mermaid
erDiagram
    Catalog {
        int Id PK "Identity"
        varchar50 Name
        text Description
        numeric Price
        text PictureFileName
        int CatalogTypeId FK
        int CatalogBrandId FK
        int AvailableStock
        int RestockThreshold
        int MaxStockThreshold
        boolean OnReorder
        vector384 Embedding "pgvector"
    }

    CatalogBrand {
        int Id PK "Identity"
        varchar100 Brand
    }

    CatalogType {
        int Id PK "Identity"
        varchar100 Type
    }

    IntegrationEventLog_Catalog {
        uuid EventId PK
        text EventTypeName
        text Content
        int State
        int TimesSent
        timestamp_tz CreationTime
        uuid TransactionId
    }

    CatalogBrand ||--o{ Catalog : "brands"
    CatalogType ||--o{ Catalog : "categorizes"
```

---

## Identity スキーマ ER図

ユーザー認証・認可サービスのデータモデル。ASP.NET Core Identityをベースに拡張。

```mermaid
erDiagram
    AspNetUsers {
        text Id PK
        varchar256 UserName
        varchar256 NormalizedUserName UK
        varchar256 Email
        varchar256 NormalizedEmail
        boolean EmailConfirmed
        text PasswordHash
        text SecurityStamp
        text ConcurrencyStamp
        text PhoneNumber
        boolean PhoneNumberConfirmed
        boolean TwoFactorEnabled
        timestamp_tz LockoutEnd
        boolean LockoutEnabled
        int AccessFailedCount
        text Name "Extended"
        text LastName "Extended"
        text CardNumber "Extended"
        text SecurityNumber "Extended"
        text Expiration "Extended"
        text CardHolderName "Extended"
        int CardType "Extended"
        text Street "Extended"
        text City "Extended"
        text State "Extended"
        text Country "Extended"
        text ZipCode "Extended"
    }

    AspNetRoles {
        text Id PK
        varchar256 Name
        varchar256 NormalizedName UK
        text ConcurrencyStamp
    }

    AspNetUserRoles {
        text UserId PK_FK
        text RoleId PK_FK
    }

    AspNetUserClaims {
        int Id PK "Identity"
        text UserId FK
        text ClaimType
        text ClaimValue
    }

    AspNetRoleClaims {
        int Id PK "Identity"
        text RoleId FK
        text ClaimType
        text ClaimValue
    }

    AspNetUserLogins {
        text LoginProvider PK
        text ProviderKey PK
        text ProviderDisplayName
        text UserId FK
    }

    AspNetUserTokens {
        text UserId PK_FK
        text LoginProvider PK
        text Name PK
        text Value
    }

    AspNetUsers ||--o{ AspNetUserRoles : "has"
    AspNetRoles ||--o{ AspNetUserRoles : "assigned_to"
    AspNetUsers ||--o{ AspNetUserClaims : "has"
    AspNetRoles ||--o{ AspNetRoleClaims : "has"
    AspNetUsers ||--o{ AspNetUserLogins : "has"
    AspNetUsers ||--o{ AspNetUserTokens : "has"
```

---

## Webhooks スキーマ ER図

Webhook購読管理サービスのデータモデル。

```mermaid
erDiagram
    Subscriptions {
        int Id PK "Identity"
        int Type "WebhookType enum"
        timestamp_tz Date
        text DestUrl
        text Token
        text UserId
    }
```

---

## サービス間の論理的関連

各マイクロサービスは独立したデータベースを持ち、直接的な外部キー制約はないが、以下の論理的な関連が存在する。

```mermaid
flowchart TB
    subgraph Identity["Identity Service"]
        Users[AspNetUsers]
    end

    subgraph Ordering["Ordering Service"]
        Buyers[buyers]
        Orders[orders]
        OrderItems[orderItems]
        PaymentMethods[paymentmethods]
    end

    subgraph Catalog["Catalog Service"]
        CatalogItems[Catalog]
        Brands[CatalogBrand]
        Types[CatalogType]
    end

    subgraph Webhooks["Webhooks Service"]
        Subs[Subscriptions]
    end

    Users -.->|IdentityGuid| Buyers
    Users -.->|UserId| Subs
    CatalogItems -.->|ProductId snapshot| OrderItems

    Orders -->|triggers| IntEvents[Integration Events]
    IntEvents -->|notifies| Subs
```

### 論理的関連の説明

1. **Identity -> Ordering**: AspNetUsers.Id は buyers.IdentityGuid として参照される
2. **Identity -> Webhooks**: AspNetUsers.Id は Subscriptions.UserId として参照される
3. **Catalog -> Ordering**: Catalog.Id は orderItems.ProductId として保存されるが、注文時点のスナップショットとして商品名・価格がコピーされる
4. **Ordering -> Webhooks**: 注文ステータス変更時にIntegration Eventが発行され、Webhook購読者に通知される

---

## 注記

- 各データベースコンテキストは独立しており、サービス間でトランザクションを共有しない
- Integration Eventを使用したイベント駆動アーキテクチャにより、サービス間の整合性を最終的整合性（Eventual Consistency）で保証
- 破線矢印（-.->）は論理的な関連を示し、物理的な外部キー制約は存在しない
