---
generated_at: 2026-01-14 00:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：40 / 42、根拠なし：2
- 優先レビュー（高）
  1. **セキュリティ考慮事項（暗号化推奨）**：設計意図の推測
  2. **シーケンス初期値**：マイグレーションスナップショットに明示的記載なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Ordering.Infrastructure/OrderingContext.cs`
- E-02: `src/Ordering.Infrastructure/Migrations/OrderingContextModelSnapshot.cs`
- E-03: `src/Ordering.Infrastructure/EntityConfigurations/OrderEntityTypeConfiguration.cs`
- E-04: `src/Ordering.Infrastructure/EntityConfigurations/OrderItemEntityTypeConfiguration.cs`
- E-05: `src/Ordering.Infrastructure/EntityConfigurations/BuyerEntityTypeConfiguration.cs`
- E-06: `src/Ordering.Infrastructure/EntityConfigurations/PaymentMethodEntityTypeConfiguration.cs`
- E-07: `src/Ordering.Infrastructure/EntityConfigurations/CardTypeEntityTypeConfiguration.cs`
- E-08: `src/Ordering.Infrastructure/EntityConfigurations/ClientRequestEntityTypeConfiguration.cs`
- E-09: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs`
- E-10: `src/Ordering.Domain/AggregatesModel/OrderAggregate/OrderItem.cs`
- E-11: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Address.cs`
- E-12: `src/Ordering.Domain/AggregatesModel/OrderAggregate/OrderStatus.cs`
- E-13: `src/Ordering.Domain/AggregatesModel/BuyerAggregate/Buyer.cs`
- E-14: `src/Ordering.Domain/AggregatesModel/BuyerAggregate/PaymentMethod.cs`
- E-15: `src/Ordering.Domain/AggregatesModel/BuyerAggregate/CardType.cs`
- E-16: `src/Ordering.Infrastructure/Idempotency/ClientRequest.cs`
- E-17: `src/Catalog.API/Infrastructure/CatalogContext.cs`
- E-18: `src/Catalog.API/Infrastructure/Migrations/CatalogContextModelSnapshot.cs`
- E-19: `src/Catalog.API/Infrastructure/EntityConfigurations/CatalogItemEntityTypeConfiguration.cs`
- E-20: `src/Catalog.API/Infrastructure/EntityConfigurations/CatalogBrandEntityTypeConfiguration.cs`
- E-21: `src/Catalog.API/Infrastructure/EntityConfigurations/CatalogTypeEntityTypeConfiguration.cs`
- E-22: `src/Catalog.API/Model/CatalogItem.cs`
- E-23: `src/Catalog.API/Model/CatalogBrand.cs`
- E-24: `src/Catalog.API/Model/CatalogType.cs`
- E-25: `src/Identity.API/Data/ApplicationDbContext.cs`
- E-26: `src/Identity.API/Data/Migrations/ApplicationDbContextModelSnapshot.cs`
- E-27: `src/Identity.API/Models/ApplicationUser.cs`
- E-28: `src/Webhooks.API/Infrastructure/WebhooksContext.cs`
- E-29: `src/Webhooks.API/Migrations/WebhooksContextModelSnapshot.cs`
- E-30: `src/Webhooks.API/Model/WebhookSubscription.cs`
- E-31: `src/IntegrationEventLogEF/IntegrationEventLogEntry.cs`
- E-32: `src/IntegrationEventLogEF/IntegrationLogExtensions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PostgreSQLをデータベースとして使用 | E-02, E-18, E-26, E-29 (Npgsql.EntityFrameworkCore.PostgreSQL) | ○ |
| C-02 | OrderingContextのスキーマ名は"ordering" | E-01 (HasDefaultSchema("ordering")) | ○ |
| C-03 | ordersテーブルはHiLoシーケンス(orderseq)を使用 | E-02, E-03 | ○ |
| C-04 | OrderStatusは文字列変換で最大30文字 | E-03 (HasConversion<string>(), HasMaxLength(30)) | ○ |
| C-05 | AddressはOwned Entityとしてordersテーブルに埋め込み | E-02, E-03 (OwnsOne(o => o.Address)) | ○ |
| C-06 | orderItemsテーブルのOrderIdは外部キー | E-02, E-04 | ○ |
| C-07 | buyersテーブルのIdentityGuidにユニークインデックス | E-02, E-05 (HasIndex("IdentityGuid").IsUnique(true)) | ○ |
| C-08 | paymentmethodsテーブルのカラム名マッピング | E-06 (HasColumnName設定) | ○ |
| C-09 | cardtypesテーブルのIdは手動設定 | E-07 (ValueGeneratedNever()) | ○ |
| C-10 | requestsテーブルのエンティティ構造 | E-08, E-16 | ○ |
| C-11 | IntegrationEventLogテーブルの構造 | E-31, E-32 | ○ |
| C-12 | CatalogテーブルでEmbeddingカラムはvector(384)型 | E-18, E-19, E-22 | ○ |
| C-13 | CatalogItemにNameインデックスが存在 | E-19 (HasIndex(ci => ci.Name)) | ○ |
| C-14 | CatalogBrandのBrandカラムは最大100文字 | E-20 (HasMaxLength(100)) | ○ |
| C-15 | CatalogTypeのTypeカラムは最大100文字 | E-21 (HasMaxLength(100)) | ○ |
| C-16 | ApplicationUserはIdentityUserを継承 | E-27 (: IdentityUser) | ○ |
| C-17 | ApplicationUserの拡張プロパティ（CardNumber等） | E-27, E-26 | ○ |
| C-18 | AspNetUsersにUserNameIndexとEmailIndexが存在 | E-26 | ○ |
| C-19 | SubscriptionsテーブルにTypeとUserIdのインデックス | E-28, E-29 | ○ |
| C-20 | Order.OrderDateの存在 | E-09 | ○ |
| C-21 | Order.BuyerId, PaymentIdの存在 | E-09 | ○ |
| C-22 | OrderItem.ProductName, UnitPrice, Discount, Unitsの存在 | E-10 | ○ |
| C-23 | OrderStatusの6つの値 | E-12 (enum定義) | ○ |
| C-24 | Buyerテーブル構造 | E-05, E-13 | ○ |
| C-25 | PaymentMethodの_alias, _cardNumber等のフィールド | E-14, E-06 | ○ |
| C-26 | CardTypeのIdとNameプロパティ | E-15, E-07 | ○ |
| C-27 | CatalogItemのAvailableStock, RestockThreshold, MaxStockThreshold | E-22 | ○ |
| C-28 | CatalogItemのOnReorderフラグ | E-22 | ○ |
| C-29 | WebhookSubscriptionのType, Date, DestUrl, Token, UserId | E-30 | ○ |
| C-30 | IntegrationEventLogEntryのState, TimesSent, TransactionId | E-31 | ○ |
| C-31 | orders -> buyersの外部キー関係 | E-02, E-03 | ○ |
| C-32 | orders -> paymentmethodsの外部キー関係(RESTRICT) | E-03 (OnDelete(DeleteBehavior.Restrict)) | ○ |
| C-33 | paymentmethods -> buyersの外部キー関係(CASCADE) | E-02 | ○ |
| C-34 | paymentmethods -> cardtypesの外部キー関係(CASCADE) | E-02, E-06 | ○ |
| C-35 | orderItems -> ordersの外部キー関係(CASCADE) | E-02 | ○ |
| C-36 | Catalog -> CatalogBrandの外部キー関係(CASCADE) | E-18, E-19 | ○ |
| C-37 | Catalog -> CatalogTypeの外部キー関係(CASCADE) | E-18, E-19 | ○ |
| C-38 | Identity関連テーブルの外部キー関係 | E-26 | ○ |
| C-39 | シーケンスの増分値は10 | E-02 (IncrementsBy(10)) | ○ |
| C-40 | pgvector拡張の使用 | E-17 (HasPostgresExtension("vector")), E-18 | ○ |
| C-41 | シーケンスの初期値は1 | **根拠なし** | △ |
| C-42 | セキュリティ考慮事項（カード情報の暗号化推奨） | **根拠なし**（設計意図の推測） | △ |

## 4) 不足情報（Unknown / Missing）
- **シーケンス初期値**: マイグレーションスナップショットにはIncrementsByのみ記載されており、StartsAtの明示的な記載がない。PostgreSQLのデフォルト動作から推測している。
  - 候補：実際のデータベースDDL / 初期マイグレーションファイル / PostgreSQLドキュメント
- **セキュリティ設計意図**: カード情報をプレーンテキストで保存することの妥当性について、設計ドキュメントやセキュリティ要件定義が見つからない。
  - 候補：セキュリティ設計書 / 要件定義書 / 運用ガイドライン

## 5) リスクフラグ（レビュー観点）
- **リスクレベル1（中リスク）**: シーケンス初期値の推測
  - マイグレーションスナップショットに明示的な記載がないため、実際のデータベース動作と異なる可能性がある
- **リスクレベル2（高リスク）**: セキュリティ考慮事項の記載
  - 設計書に「暗号化が必要」と記載したが、これは生成AIによる推奨であり、プロジェクトの実際のセキュリティ要件と合致しない可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] 各テーブル定義のカラム名・データ型がマイグレーションスナップショットと一致しているか確認
- [ ] 外部キー関係とON DELETE動作が正確か確認
- [ ] インデックス定義が漏れなく記載されているか確認
- [ ] シーケンスの初期値について、実際のデータベースで確認
- [ ] セキュリティ考慮事項について、プロジェクトのセキュリティ要件と照合
- [ ] ER図のmermaid記法が正しくレンダリングされるか確認
- [ ] サービス間の論理的関連の記述が実際のアプリケーションコードと一致しているか確認
