---
generated_at: 2026-01-14 20:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認できました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/OrderProcessor/Services/GracePeriodManagerService.cs`
- E-02: `src/OrderProcessor/BackgroundTaskOptions.cs`
- E-03: `src/OrderProcessor/appsettings.json`
- E-04: `src/OrderProcessor/Extensions/Extensions.cs`
- E-05: `src/OrderProcessor/Events/GracePeriodConfirmedIntegrationEvent.cs`
- E-06: `src/PaymentProcessor/Program.cs`
- E-07: `src/PaymentProcessor/IntegrationEvents/EventHandling/OrderStatusChangedToStockConfirmedIntegrationEventHandler.cs`
- E-08: `src/PaymentProcessor/IntegrationEvents/Events/OrderPaymentSucceededIntegrationEvent.cs`
- E-09: `src/PaymentProcessor/IntegrationEvents/Events/OrderPaymentFailedIntegrationEvent.cs`
- E-10: `src/PaymentProcessor/PaymentOptions.cs`
- E-11: `src/PaymentProcessor/appsettings.json`
- E-12: `src/Shared/MigrateDbContextExtensions.cs`
- E-13: `src/OrderProcessor/OrderProcessor.csproj`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GracePeriodManagerServiceはBackgroundServiceを継承したバックグラウンドサービスである | E-01（12行目：BackgroundService） | ○ |
| C-02 | CheckUpdateTime間隔で定期実行される | E-01（18行目、35行目）、E-02（7行目）、E-03（15行目） | ○ |
| C-03 | GracePeriodTimeを超えたSubmitted状態の注文を処理対象とする | E-01（69-73行目：SQLクエリ）、E-03（14行目） | ○ |
| C-04 | GracePeriodConfirmedIntegrationEventを発行する | E-01（55-59行目）、E-05 | ○ |
| C-05 | デフォルトのCheckUpdateTimeは30秒である | E-03（16行目：CheckUpdateTime: 30） | ○ |
| C-06 | デフォルトのGracePeriodTimeは1分である | E-03（15行目：GracePeriodTime: 1） | ○ |
| C-07 | OrderStatusChangedToStockConfirmedIntegrationEventHandlerはRabbitMQイベント駆動型である | E-06（5-6行目：AddSubscription）、E-07 | ○ |
| C-08 | 決済成功時にOrderPaymentSucceededIntegrationEventを発行する | E-07（23行目）、E-08 | ○ |
| C-09 | 決済失敗時にOrderPaymentFailedIntegrationEventを発行する | E-07（27行目）、E-09 | ○ |
| C-10 | PaymentOptionsの設定により決済成功/失敗をシミュレートする | E-07（21行目）、E-10、E-11 | ○ |
| C-11 | MigrationHostedServiceはBackgroundServiceを継承している | E-12（76-77行目） | ○ |
| C-12 | MigrationHostedServiceは起動時に一度だけマイグレーションを実行する | E-12（79-82行目：StartAsync）、E-12（84-87行目：ExecuteAsyncは空） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全ての主張についてソースコードから直接根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられています
- 注意事項：
  - PaymentProcessorの決済処理はシミュレーションであり、実際の決済ゲートウェイとの連携はありません（E-07のコメントに明記）
  - MigrationHostedServiceは共有コードとして複数のサービスで利用される汎用コンポーネントです

## 6) レビュアーチェックリスト（最小）
- [x] 全てのバックグラウンドサービス/ホステッドサービスが網羅されているか
- [x] 各バッチの実行タイミング・トリガーが正確に記載されているか
- [x] 設定値（デフォルト値）がappsettings.jsonと一致しているか
- [ ] 実運用環境での設定値が適切か確認（appsettings.Production.jsonなど）
- [ ] エラーハンドリング・リトライ戦略の妥当性を確認
