# バッチ設計書 1-GracePeriodManagerService

## 概要

本ドキュメントは、eShopシステムにおける注文猶予期間管理バックグラウンドサービス（GracePeriodManagerService）の設計を記載する。

### 本バッチの処理概要

このバッチは、eShopシステムにおいて注文の猶予期間（Grace Period）を監視し、猶予期間を超過した注文に対して後続処理を開始するための統合イベントを発行するバックグラウンドサービスである。

**業務上の目的・背景**：ECサイトにおいて、顧客が注文を確定した後、一定期間は注文のキャンセルや修正が可能な「猶予期間」を設けることが一般的である。この猶予期間が経過した注文を自動的に検出し、在庫確認や決済処理などの後続ワークフローへ進めるために本バッチが必要となる。これにより、手動での確認作業を排除し、注文処理の自動化と効率化を実現する。

**バッチの実行タイミング**：アプリケーション起動時から継続的に実行され、設定された間隔（デフォルト30秒）で定期的にデータベースをチェックする。

**主要な処理内容**：
1. 設定されたチェック間隔（CheckUpdateTime）でデータベースを定期的にポーリング
2. 注文テーブルから「Submitted」状態かつ猶予期間（GracePeriodTime）を超過した注文を抽出
3. 該当する各注文に対してGracePeriodConfirmedIntegrationEventを発行
4. イベント発行を通じて後続の注文処理ワークフロー（在庫確認等）をトリガー

**前後の処理との関連**：本バッチは注文作成後の最初の自動処理として位置づけられる。Webアプリケーションで注文が作成され「Submitted」状態になった後、本バッチが猶予期間超過を検知してGracePeriodConfirmedIntegrationEventを発行する。このイベントはOrdering.APIのGracePeriodConfirmedIntegrationEventHandlerで受信され、在庫検証プロセスが開始される。

**影響範囲**：ordering.ordersテーブルを読み取り、RabbitMQを通じてイベントを発行する。直接的なデータ更新は行わないが、発行されたイベントにより注文ステータスが変更される可能性がある。

## バッチ種別

イベント駆動型バックグラウンドサービス / データ監視・通知配信

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 継続実行（定期ポーリング） |
| 実行時刻 | アプリケーション起動時から継続 |
| 実行曜日 | 毎日（24時間稼働） |
| 実行日 | - |
| トリガー | アプリケーション起動 / 定期ポーリング（デフォルト30秒間隔） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| データベース接続 | PostgreSQL（orderingdb）への接続が可能であること |
| RabbitMQ接続 | EventBusへの接続が可能であること |
| 設定値の存在 | BackgroundTaskOptionsが正しく設定されていること |

### 実行可否判定

- アプリケーションが起動していること
- CancellationTokenがキャンセルされていないこと
- データベース接続が確立できること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GracePeriodTime | int | Yes | 1 | 猶予期間（分）。この時間を超過したSubmitted状態の注文を処理対象とする |
| CheckUpdateTime | int | Yes | 30 | チェック間隔（秒）。この間隔でデータベースをポーリングする |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ordering.orders | PostgreSQL DB | 注文テーブル。Id、OrderDate、OrderStatusカラムを参照 |
| appsettings.json | JSON | BackgroundTaskOptionsセクションから設定値を取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| RabbitMQ (EventBus) | Integration Event | GracePeriodConfirmedIntegrationEventを発行 |
| ログ | テキスト | 処理状況をILoggerで出力 |

### 出力ファイル仕様

ファイル出力なし（メッセージキューへのイベント発行のみ）

| 項目 | 内容 |
|-----|------|
| ファイル名 | - |
| 出力先 | - |
| 文字コード | - |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. サービス開始
   └─ ExecuteAsyncが呼び出され、ループ処理を開始
2. 遅延時間の計算
   └─ CheckUpdateTimeから待機時間（TimeSpan）を算出
3. データベースクエリ実行
   └─ GetConfirmedGracePeriodOrdersを呼び出し、該当注文IDリストを取得
4. イベント発行ループ
   └─ 取得した各OrderIdに対してGracePeriodConfirmedIntegrationEventを作成・発行
5. 待機
   └─ Task.Delayで指定時間待機
6. ステップ3に戻る（CancellationToken.IsCancellationRequestedがfalseの間）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[CheckUpdateTime から遅延時間を算出]
    B --> C[GetConfirmedGracePeriodOrders 実行]
    C --> D{該当注文あり?}
    D -->|あり| E[各注文IDをループ処理]
    E --> F[GracePeriodConfirmedIntegrationEvent 作成]
    F --> G[EventBus.PublishAsync でイベント発行]
    G --> H{次の注文あり?}
    H -->|あり| F
    H -->|なし| I[Task.Delay で待機]
    D -->|なし| I
    I --> J{CancellationRequested?}
    J -->|No| C
    J -->|Yes| K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 猶予期間超過注文の取得 | ordering.orders | SELECT | Submitted状態かつ猶予期間を超過した注文IDを取得 |

### テーブル別操作詳細

#### ordering.orders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | Id | CURRENT_TIMESTAMP - OrderDate >= GracePeriodTime AND OrderStatus = 'Submitted' | 猶予期間を超過したSubmitted状態の注文のみ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | NpgsqlException | データベース接続失敗 | エラーログを出力し、空のリストを返却。次回ポーリングで再試行 |
| - | TaskCanceledException | サービス停止要求 | 正常終了として処理。ループを抜けてサービス終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライ（次回ポーリングで再実行） |
| リトライ間隔 | CheckUpdateTime（デフォルト30秒） |
| リトライ対象エラー | NpgsqlException |

### 障害時対応

- データベース接続エラーの場合、エラーログを出力し空リストを返却する
- サービスは停止せず、次回ポーリングで再試行を行う
- 継続的なエラーが発生する場合は、アプリケーションの再起動または接続設定の確認が必要

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のポーリングで数十〜数百件 |
| 目標処理時間 | CheckUpdateTime（30秒）以内 |
| メモリ使用量上限 | 取得したOrderIdリストのサイズに依存 |

## 排他制御

- 同時実行制御なし
- 単一インスタンスとして動作することを前提とする
- 複数インスタンス稼働時は同一注文に対して重複イベント発行の可能性あり

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | サービス開始時 | "GracePeriodManagerService is starting." |
| 進捗ログ | ポーリング実行時 | "GracePeriodManagerService background task is doing background work." |
| 情報ログ | イベント発行時 | "Publishing integration event: {IntegrationEventId} - ({@IntegrationEvent})" |
| 停止ログ | サービス停止時 | "GracePeriodManagerService background task is stopping." |
| エラーログ | DB接続エラー時 | "Fatal error establishing database connection" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| データベース接続エラー | 連続発生時 | アプリケーションログ |
| イベント発行失敗 | 発生時 | アプリケーションログ |

## 備考

- BackgroundTaskOptionsは依存性注入を通じてappsettings.jsonから設定値を読み込む
- イベント発行にはeShop.EventBus.Abstractionsを使用
- デバッグログはLogLevel.Debugが有効な場合のみ出力される
