# バッチ設計書 2-OrderStatusChangedToStockConfirmedIntegrationEventHandler

## 概要

本ドキュメントは、eShopシステムにおける在庫確認完了後の決済処理を実行するイベントハンドラ（OrderStatusChangedToStockConfirmedIntegrationEventHandler）の設計を記載する。

### 本バッチの処理概要

このバッチは、RabbitMQメッセージキューを監視し、在庫確認が完了した注文に対して決済処理をシミュレーションし、決済結果に応じたイベントを発行するメッセージ駆動型のイベントハンドラである。

**業務上の目的・背景**：ECサイトの注文処理において、在庫の確保が完了した後に決済処理を実行する必要がある。本ハンドラは在庫確認完了イベント（OrderStatusChangedToStockConfirmedIntegrationEvent）を受信し、決済ゲートウェイとの連携をシミュレーションする。これにより、注文処理ワークフローの決済ステップを自動化し、在庫確認から決済への連携をシームレスに実現する。実際の運用では決済成功/失敗の設定値により挙動を制御できる。

**バッチの実行タイミング**：RabbitMQからOrderStatusChangedToStockConfirmedIntegrationEventメッセージを受信した際に実行される。イベント駆動型であり、定期実行ではない。

**主要な処理内容**：
1. RabbitMQキューからOrderStatusChangedToStockConfirmedIntegrationEventを受信
2. PaymentOptionsの設定値（PaymentSucceeded）を確認
3. 設定値に基づいて決済成功/失敗を判定
4. 決済成功時はOrderPaymentSucceededIntegrationEventを発行
5. 決済失敗時はOrderPaymentFailedIntegrationEventを発行

**前後の処理との関連**：本ハンドラは注文処理ワークフローの中間ステップに位置する。前段ではOrdering.APIのOrderStatusChangedToStockConfirmedDomainEventHandlerが在庫確認完了イベントを発行する。本ハンドラが発行する決済結果イベントは、Ordering.APIのOrderPaymentSucceededIntegrationEventHandlerまたはOrderPaymentFailedIntegrationEventHandlerで受信され、注文ステータスが更新される。

**影響範囲**：直接的なデータベース操作は行わない。RabbitMQを介してイベントを受信・発行し、後続のOrdering.APIハンドラを通じて注文ステータスに影響を与える。

## バッチ種別

メッセージ駆動型イベントハンドラ / 決済処理シミュレーション

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（随時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | OrderStatusChangedToStockConfirmedIntegrationEventの受信 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| RabbitMQ接続 | EventBusへの接続が可能であること |
| 設定値の存在 | PaymentOptionsが正しく設定されていること |
| イベント購読 | OrderStatusChangedToStockConfirmedIntegrationEventが購読登録されていること |

### 実行可否判定

- OrderStatusChangedToStockConfirmedIntegrationEventがキューに存在すること
- PaymentProcessorアプリケーションが稼働していること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PaymentSucceeded | bool | Yes | true | 決済成功/失敗をシミュレートするフラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| RabbitMQ (EventBus) | Integration Event | OrderStatusChangedToStockConfirmedIntegrationEventを受信 |
| appsettings.json | JSON | PaymentOptionsセクションから設定値を取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| RabbitMQ (EventBus) | Integration Event | OrderPaymentSucceededIntegrationEvent または OrderPaymentFailedIntegrationEvent を発行 |
| ログ | テキスト | 処理状況をILoggerで出力 |

### 出力ファイル仕様

ファイル出力なし（メッセージキューへのイベント発行のみ）

| 項目 | 内容 |
|-----|------|
| ファイル名 | - |
| 出力先 | - |
| 文字コード | - |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. イベント受信
   └─ OrderStatusChangedToStockConfirmedIntegrationEventをRabbitMQから受信
2. ログ出力（受信）
   └─ 受信したイベントの情報をログに記録
3. 設定値確認
   └─ IOptionsMonitor<PaymentOptions>からPaymentSucceededの値を取得
4. 決済結果判定
   └─ PaymentSucceededの値に基づいて出力イベントを決定
5. イベント作成
   └─ 成功時：OrderPaymentSucceededIntegrationEvent
   └─ 失敗時：OrderPaymentFailedIntegrationEvent
6. ログ出力（発行）
   └─ 発行するイベントの情報をログに記録
7. イベント発行
   └─ EventBus.PublishAsyncでイベントを発行
```

### フローチャート

```mermaid
flowchart TD
    A[イベント受信開始] --> B[OrderStatusChangedToStockConfirmedIntegrationEvent 受信]
    B --> C[受信ログ出力]
    C --> D{PaymentSucceeded?}
    D -->|true| E[OrderPaymentSucceededIntegrationEvent 作成]
    D -->|false| F[OrderPaymentFailedIntegrationEvent 作成]
    E --> G[発行ログ出力]
    F --> G
    G --> H[EventBus.PublishAsync でイベント発行]
    H --> I[処理完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | 本ハンドラではデータベース操作を行わない |

### テーブル別操作詳細

本ハンドラはデータベース操作を行わない。イベントの受信と発行のみを担当する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | EventBus接続エラー | RabbitMQ接続失敗 | イベント発行失敗。メッセージはキューに残り再処理される |
| - | 設定値取得エラー | PaymentOptions未設定 | アプリケーション起動時にエラー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | RabbitMQのメッセージ再配信に依存 |
| リトライ間隔 | RabbitMQの設定に依存 |
| リトライ対象エラー | イベント発行失敗時 |

### 障害時対応

- イベント発行失敗時は、RabbitMQのメッセージ再配信機能により再処理される
- 継続的なエラーが発生する場合は、RabbitMQおよびアプリケーションの接続状態を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（データベース操作なし） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1メッセージ/処理（イベント単位） |
| 目標処理時間 | ミリ秒単位（設定値参照とイベント発行のみ） |
| メモリ使用量上限 | 最小限（イベントオブジェクトのみ） |

## 排他制御

- 排他制御なし
- 各メッセージは独立して処理される
- 同一OrderIdのメッセージが複数回処理される可能性あり（冪等性は後続ハンドラで担保）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | イベント受信時 | "Handling integration event: {IntegrationEventId} - ({@IntegrationEvent})" |
| 情報ログ | イベント発行時 | "Publishing integration event: {IntegrationEventId} - ({@IntegrationEvent})" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| メッセージ処理遅延 | キュー長が閾値超過時 | RabbitMQ管理コンソール |
| エラー発生 | 発生時 | アプリケーションログ |

## 備考

- 本ハンドラは実際の決済ゲートウェイ連携をシミュレーションしている
- PaymentSucceeded設定により決済成功/失敗を制御可能（テスト・デモ用途）
- 本番環境では実際の決済APIとの連携実装に置き換える想定
- IOptionsMonitorを使用しているため、設定値の動的変更に対応
