---
generated_at: 2026-01-14 21:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-GracePeriodManagerService.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数**：具体的な数値の根拠がコード上に存在しない
  2. **同時実行時の重複イベント発行リスク**：実装上の想定であり、要確認
  3. **メモリ使用量上限**：明示的な制限がコードに存在しない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/OrderProcessor/Services/GracePeriodManagerService.cs`
- E-02: `src/OrderProcessor/BackgroundTaskOptions.cs`
- E-03: `src/OrderProcessor/appsettings.json`
- E-04: `src/OrderProcessor/Extensions/Extensions.cs`
- E-05: `src/OrderProcessor/Events/GracePeriodConfirmedIntegrationEvent.cs`
- E-06: `src/Ordering.API/Extensions/Extensions.cs`
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CheckUpdateTime間隔（デフォルト30秒）で定期実行 | E-01(L18,35), E-03(L16) | ○ |
| C-02 | GracePeriodTime（デフォルト1分）を超えたSubmitted状態の注文を処理対象 | E-01(L69-73), E-03(L15) | ○ |
| C-03 | GracePeriodConfirmedIntegrationEventを発行する | E-01(L55,59), E-05 | ○ |
| C-04 | BackgroundServiceを継承したバックグラウンドサービス | E-01(L12), E-04(L18) | ○ |
| C-05 | NpgsqlDataSourceを使用してPostgreSQLに接続 | E-01(L12,67), E-04(L13) | ○ |
| C-06 | IEventBusを使用してイベントを発行 | E-01(L11,59) | ○ |
| C-07 | ordering.ordersテーブルからSELECTでデータ取得 | E-01(L69-72) | ○ |
| C-08 | OrderStatus = 'Submitted'の条件で抽出 | E-01(L72) | ○ |
| C-09 | CURRENT_TIMESTAMP - OrderDateで経過時間を計算 | E-01(L72) | ○ |
| C-10 | エラー時は空リストを返却してサービス継続 | E-01(L87-92) | ○ |
| C-11 | NpgsqlExceptionをキャッチしてエラーログ出力 | E-01(L87-90) | ○ |
| C-12 | CancellationTokenでサービス停止を制御 | E-01(L16,23,26,35) | ○ |
| C-13 | LogLevel.Debugが有効な場合のみデバッグログ出力 | E-01(L20,28,38,46) | ○ |
| C-14 | IOptionsを通じてBackgroundTaskOptionsを注入 | E-01(L9,14), E-02, E-04(L15-16) | ○ |
| C-15 | RabbitMQをEventBusとして使用 | E-04(L10), E-03(L8-13) | ○ |
| C-16 | orderingdbという接続文字列名を使用 | E-04(L13) | ○ |
| C-17 | GracePeriodConfirmedIntegrationEventにOrderIdを含む | E-05(L7,9-10), E-01(L55) | ○ |
| C-18 | イベント発行時にIntegrationEventIdとイベント内容をログ出力 | E-01(L57) | ○ |
| C-19 | Ordering.APIでGracePeriodConfirmedIntegrationEventを購読 | E-06(L55) | ○ |
| C-20 | AddHostedServiceでサービスを登録 | E-04(L18) | ○ |
| C-21 | バッチ一覧.csvにNo.1として登録 | E-07(L2) | ○ |
| C-22 | ConfigureJsonOptionsでシリアライズ設定 | E-04(L11) | ○ |
| C-23 | データベース操作は読み取り専用（トランザクションなし） | E-01(L67-85) | ○ |
| C-24 | 取得したOrderIdをリストに格納 | E-01(L76,82-83) | ○ |
| C-25 | 想定処理件数は1回のポーリングで数十〜数百件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定処理件数の根拠がコード上に存在しない
  - 候補：運用実績データ / 負荷テスト結果 / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード実装に基づく仕様記述は高信頼度
- 1: 中リスク - 複数インスタンス稼働時の重複イベント発行に関する記述は要確認
- 0: 低リスク - データベーススキーマ情報は実際のSQLクエリから抽出

## 6) レビュアーチェックリスト（最小）
- [ ] GracePeriodTime/CheckUpdateTimeのデフォルト値が運用要件と合致しているか確認
- [ ] 複数インスタンス稼働時の挙動について運用方針を確認
- [ ] 想定処理件数について実運用データとの整合性を確認
- [ ] エラー発生時の継続実行動作が業務要件に合致しているか確認
