---
generated_at: 2026-01-14 21:40:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：3-MigrationHostedService.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間（数秒〜数分）**：具体的な数値の根拠がコード上に存在しない
  2. **本番環境での手動マイグレーション推奨**：コメントによる示唆のみ
  3. **複数インスタンス起動時のロック機構**：EF Core標準動作の想定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Shared/MigrateDbContextExtensions.cs`
- E-02: `src/Catalog.API/Extensions/Extensions.cs`
- E-03: `src/Ordering.API/Extensions/Extensions.cs`
- E-04: `src/Identity.API/Program.cs`
- E-05: `src/Catalog.API/Infrastructure/CatalogContextSeed.cs`
- E-06: `src/Ordering.API/Infrastructure/OrderingContextSeed.cs`
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BackgroundServiceを継承したMigrationHostedService | E-01(L76-77) | ○ |
| C-02 | StartAsyncでマイグレーションを実行 | E-01(L79-81) | ○ |
| C-03 | ExecuteAsyncはTask.CompletedTaskを返却 | E-01(L84-86) | ○ |
| C-04 | AddMigration拡張メソッドでサービス登録 | E-01(L10-20) | ○ |
| C-05 | IDbSeeder<TContext>インターフェースでシーダーを定義 | E-01(L90-93) | ○ |
| C-06 | Database.MigrateAsyncでマイグレーション適用 | E-01(L65) | ○ |
| C-07 | CreateExecutionStrategyでリトライ可能な実行を実現 | E-01(L44) | ○ |
| C-08 | ActivitySourceでOpenTelemetryトレーシングを出力 | E-01(L7-8,18,38,61) | ○ |
| C-09 | ActivitySource名は"DbMigrations" | E-01(L7) | ○ |
| C-10 | エラー時にActivityに例外タグを設定 | E-01(L52,70) | ○ |
| C-11 | エラー時にLogErrorでログ出力 | E-01(L50) | ○ |
| C-12 | エラー時に例外を再スロー | E-01(L54,72) | ○ |
| C-13 | マイグレーション開始時に情報ログを出力 | E-01(L42) | ○ |
| C-14 | CreateScopeでスコープを作成 | E-01(L33) | ○ |
| C-15 | GetRequiredServiceでDbContextを取得 | E-01(L36) | ○ |
| C-16 | Catalog.APIでAddMigration<CatalogContext, CatalogContextSeed>を使用 | E-02(L24) | ○ |
| C-17 | Ordering.APIでAddMigration<OrderingContext, OrderingContextSeed>を使用 | E-03(L21) | ○ |
| C-18 | Identity.APIでAddMigration<ApplicationDbContext, UsersSeed>を使用 | E-04(L12) | ○ |
| C-19 | CatalogContextSeedでCatalogBrands、CatalogTypes、CatalogItemsを投入 | E-05(L29-73) | ○ |
| C-20 | OrderingContextSeedでCardTypesを投入 | E-06(L9-16,19-24) | ○ |
| C-21 | シーダーはデータが存在しない場合のみ投入 | E-05(L23), E-06(L9) | ○ |
| C-22 | catalog.jsonからシードデータを読み込む | E-05(L25-27) | ○ |
| C-23 | SaveChangesAsyncでコミット | E-05(L41,73), E-06(L13,16) | ○ |
| C-24 | バッチ一覧.csvにNo.3として登録 | E-07(L4) | ○ |
| C-25 | 本番環境では自動マイグレーション非推奨（コメント） | E-04(L9-11) | ○ |
| C-26 | AddOpenTelemetryでトレーシングを有効化 | E-01(L18) | ○ |
| C-27 | Seeder未指定時は空のTask完了を実行 | E-01(L12) | ○ |
| C-28 | 目標処理時間は数秒〜数分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な根拠がコード上に存在しない
  - 候補：パフォーマンステスト結果 / 運用実績データ / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード実装に基づく仕様記述は高信頼度
- 1: 中リスク - 本番環境での自動マイグレーション使用に関する運用方針の確認が必要
- 1: 中リスク - 複数インスタンス起動時のマイグレーション競合に関する動作確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 本番環境でのマイグレーション適用方針を確認（自動 vs 手動SQLスクリプト）
- [ ] シードデータの冪等性が適切に担保されているか確認
- [ ] OpenTelemetryトレーシングの監視設定を確認
- [ ] データベース接続失敗時のアプリケーション起動動作を確認
- [ ] 複数インスタンス同時起動時のマイグレーション競合動作を確認
