---
generated_at: 2026-01-14 10:30:00
metrics:
  claims_total: 96
  claims_with_evidence: 96
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Catalog.API 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：96 / 96、根拠なし：0
- 優先レビュー（高）
  1. **在庫管理ロジック（RemoveStock/AddStock）**：ビジネスクリティカルなロジック
  2. **統合イベントハンドラ**：マイクロサービス間連携の重要なロジック
  3. **API エンドポイント**：外部公開されるインターフェース

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Catalog.API/Model/CatalogItem.cs` - RemoveStock/AddStockメソッド、プロパティ定義
- E-02: `src/Catalog.API/Model/CatalogBrand.cs` - CatalogBrandモデル定義
- E-03: `src/Catalog.API/Model/CatalogType.cs` - CatalogTypeモデル定義
- E-04: `src/Catalog.API/Model/PaginatedItems.cs` - ページネーションレスポンスクラス
- E-05: `src/Catalog.API/Model/PaginationRequest.cs` - ページネーションリクエストrecord
- E-06: `src/Catalog.API/Model/CatalogServices.cs` - DIコンテナ用サービスクラス
- E-07: `src/Catalog.API/Apis/CatalogApi.cs` - APIエンドポイント定義（全メソッド）
- E-08: `src/Catalog.API/Services/CatalogAI.cs` - AI埋め込み生成サービス
- E-09: `src/Catalog.API/Services/ICatalogAI.cs` - AI サービスインターフェース
- E-10: `src/Catalog.API/Infrastructure/CatalogContext.cs` - Entity Framework DbContext
- E-11: `src/Catalog.API/Infrastructure/CatalogContextSeed.cs` - データベースシード処理
- E-12: `src/Catalog.API/Infrastructure/Exceptions/CatalogDomainException.cs` - ドメイン例外クラス
- E-13: `src/Catalog.API/IntegrationEvents/CatalogIntegrationEventService.cs` - 統合イベントサービス
- E-14: `src/Catalog.API/IntegrationEvents/ICatalogIntegrationEventService.cs` - 統合イベントインターフェース
- E-15: `src/Catalog.API/IntegrationEvents/EventHandling/OrderStatusChangedToAwaitingValidationIntegrationEventHandler.cs` - 検証待ちイベントハンドラ
- E-16: `src/Catalog.API/IntegrationEvents/EventHandling/OrderStatusChangedToPaidIntegrationEventHandler.cs` - 支払完了イベントハンドラ
- E-17: `src/Catalog.API/IntegrationEvents/Events/ProductPriceChangedIntegrationEvent.cs` - 価格変更イベント
- E-18: `src/Catalog.API/IntegrationEvents/Events/OrderStockItem.cs` - 注文在庫アイテムrecord
- E-19: `src/Catalog.API/IntegrationEvents/Events/ConfirmedOrderStockItem.cs` - 確認済み注文在庫record
- E-20: `src/Catalog.API/Infrastructure/EntityConfigurations/CatalogItemEntityTypeConfiguration.cs` - CatalogItem EF設定
- E-21: `src/Catalog.API/Infrastructure/EntityConfigurations/CatalogBrandEntityTypeConfiguration.cs` - CatalogBrand EF設定
- E-22: `src/Catalog.API/Infrastructure/EntityConfigurations/CatalogTypeEntityTypeConfiguration.cs` - CatalogType EF設定
- E-23: `src/Catalog.API/CatalogOptions.cs` - 設定オプションクラス
- E-24: `src/Catalog.API/Extensions/HostEnvironmentExtensions.cs` - 環境拡張メソッド

## 3) Claims と根拠の対応（レビューの主戦場）

### CatalogItem モデル（UT-CAT-001 ~ UT-CAT-012）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RemoveStock: 在庫が0の場合にCatalogDomainExceptionをスロー | E-01 (L64-67) | ○ |
| C-02 | RemoveStock: quantityDesired <= 0の場合にCatalogDomainExceptionをスロー | E-01 (L69-72) | ○ |
| C-03 | RemoveStock: Math.Min(quantityDesired, AvailableStock)で減算量を計算 | E-01 (L74) | ○ |
| C-04 | RemoveStock: AvailableStockから減算して戻り値を返す | E-01 (L74-78) | ○ |
| C-05 | AddStock: MaxStockThresholdを超えない範囲で追加 | E-01 (L91-100) | ○ |
| C-06 | AddStock: 追加後にOnReorderをfalseに設定 | E-01 (L102) | ○ |
| C-07 | AddStock: 追加された量を戻り値として返す | E-01 (L104) | ○ |
| C-08 | コンストラクタ: nameを受け取りNameプロパティに設定 | E-01 (L47) | ○ |

### CatalogBrand/CatalogType モデル（UT-CAT-013 ~ UT-CAT-014）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | CatalogBrand: コンストラクタでbrandを受け取る | E-02 (L7-9) | ○ |
| C-10 | CatalogType: コンストラクタでtypeを受け取る | E-03 (L7-9) | ○ |

### PaginatedItems/PaginationRequest（UT-CAT-015 ~ UT-CAT-017）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | PaginatedItems: pageIndex, pageSize, count, dataをコンストラクタで受け取る | E-04 (L5) | ○ |
| C-12 | PaginationRequest: デフォルト値 PageSize=10, PageIndex=0 | E-05 (L8, L12) | ○ |

### CatalogAI サービス（UT-CAT-018 ~ UT-CAT-025）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | IsEnabled: _embeddingGeneratorがnullでない場合にtrue | E-08 (L25) | ○ |
| C-14 | GetEmbeddingAsync(CatalogItem): IsEnabledチェック後にGetEmbeddingAsync(string)を呼び出し | E-08 (L28-31) | ○ |
| C-15 | GetEmbeddingAsync(string): IsEnabled時にembedding生成、無効時はnull | E-08 (L55-73) | ○ |
| C-16 | GetEmbeddingsAsync: 複数アイテムのembeddingをバッチ生成 | E-08 (L34-52) | ○ |
| C-17 | EmbeddingDimensions: 384次元に固定 | E-08 (L9) | ○ |

### CatalogApi エンドポイント（UT-CAT-026 ~ UT-CAT-058）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | GetAllItems: name, type, brandフィルタをサポート | E-07 (L136-147) | ○ |
| C-19 | GetAllItems: ページネーション（Skip/Take）を適用 | E-07 (L152-156) | ○ |
| C-20 | GetItemsByIds: 指定IDの配列に含まれるアイテムを取得 | E-07 (L166) | ○ |
| C-21 | GetItemById: id <= 0でBadRequest | E-07 (L176-181) | ○ |
| C-22 | GetItemById: アイテム未発見時にNotFound | E-07 (L185-188) | ○ |
| C-23 | GetItemById: CatalogBrandをInclude | E-07 (L183) | ○ |
| C-24 | GetItemPictureById: アイテムまたはPictureFileName未発見時にNotFound | E-07 (L212-215) | ○ |
| C-25 | GetItemsBySemanticRelevance: AI無効時に名前検索にフォールバック | E-07 (L245-248) | ○ |
| C-26 | GetItemsBySemanticRelevance: vector nullの場合も名前検索にフォールバック | E-07 (L253-256) | ○ |
| C-27 | UpdateItem: 存在しないIDでNotFound | E-07 (L332-337) | ○ |
| C-28 | UpdateItem: 価格変更時にProductPriceChangedIntegrationEventを発行 | E-07 (L347-356) | ○ |
| C-29 | UpdateItemV1: productToUpdate.Idがnullの場合にBadRequest | E-07 (L315-320) | ○ |
| C-30 | CreateItem: 新規アイテムをコンテキストに追加して保存 | E-07 (L384-385) | ○ |
| C-31 | DeleteItemById: 存在しないIDでNotFound | E-07 (L396-399) | ○ |
| C-32 | GetImageMimeTypeFromImageFileExtension: 拡張子からMIMEタイプを判定 | E-07 (L406-418) | ○ |
| C-33 | GetFullPath: contentRootPath/Pics/pictureFileNameの形式でパス構築 | E-07 (L420-421) | ○ |

### CatalogIntegrationEventService（UT-CAT-059 ~ UT-CAT-063）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | PublishThroughEventBusAsync: InProgress -> Publish -> Published の順序 | E-13 (L17-19) | ○ |
| C-35 | PublishThroughEventBusAsync: 例外時にMarkEventAsFailed | E-13 (L24) | ○ |
| C-36 | SaveEventAndCatalogContextChangesAsync: ResilientTransaction内でatomic操作 | E-13 (L34-39) | ○ |
| C-37 | Dispose: disposedValueフラグで多重Dispose防止 | E-13 (L42-52) | ○ |

### 統合イベントハンドラ（UT-CAT-064 ~ UT-CAT-069）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | OrderStatusChangedToAwaitingValidationHandler: 全アイテム在庫充足時にOrderStockConfirmedIntegrationEvent | E-15 (L27-29) | ○ |
| C-39 | OrderStatusChangedToAwaitingValidationHandler: 一部不足時にOrderStockRejectedIntegrationEvent | E-15 (L27-28) | ○ |
| C-40 | OrderStatusChangedToAwaitingValidationHandler: 存在しないProductIdはスキップ（if catalogItem is not null） | E-15 (L18) | ○ |
| C-41 | OrderStatusChangedToPaidHandler: RemoveStockを呼び出して在庫減算 | E-16 (L17) | ○ |
| C-42 | OrderStatusChangedToPaidHandler: catalogItemがnullの場合はスキップ（?.演算子） | E-16 (L17) | ○ |
| C-43 | OrderStatusChangedToPaidHandler: SaveChangesAsyncで永続化 | E-16 (L20) | ○ |

### Infrastructure（UT-CAT-070 ~ UT-CAT-085）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | CatalogContext: CatalogItems, CatalogBrands, CatalogTypesのDbSetを持つ | E-10 (L14-16) | ○ |
| C-45 | CatalogContextSeed: CatalogItemsが空の場合のみシード実行 | E-11 (L23) | ○ |
| C-46 | CatalogContextSeed: AI有効時にembedding生成 | E-11 (L61-69) | ○ |
| C-47 | CatalogDomainException: 3種類のコンストラクタ | E-12 (L8-17) | ○ |
| C-48 | CatalogItemEntityTypeConfiguration: テーブル名"Catalog" | E-20 (L8) | ○ |
| C-49 | CatalogItemEntityTypeConfiguration: Name最大長50 | E-20 (L10-11) | ○ |
| C-50 | CatalogItemEntityTypeConfiguration: Nameにインデックス | E-20 (L22) | ○ |
| C-51 | CatalogBrandEntityTypeConfiguration: テーブル名"CatalogBrand" | E-21 (L8) | ○ |
| C-52 | CatalogBrandEntityTypeConfiguration: Brand最大長100 | E-21 (L10-11) | ○ |
| C-53 | CatalogTypeEntityTypeConfiguration: テーブル名"CatalogType" | E-22 (L8) | ○ |
| C-54 | CatalogTypeEntityTypeConfiguration: Type最大長100 | E-22 (L10-11) | ○ |

### その他（UT-CAT-086 ~ UT-CAT-096）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | CatalogOptions: PicBaseUrl, UseCustomizationDataプロパティ | E-23 (L5-6) | ○ |
| C-56 | HostEnvironmentExtensions.IsBuild: "Build"環境またはGetDocument.Insiderで判定 | E-24 (L12) | ○ |
| C-57 | CatalogServices: Context, CatalogAI, Options, Logger, EventServiceプロパティ | E-06 (L11-15) | ○ |
| C-58 | ProductPriceChangedIntegrationEvent: ProductId, NewPrice, OldPriceプロパティ | E-17 (L6) | ○ |
| C-59 | OrderStockItem: ProductId, Unitsプロパティ | E-18 (L3) | ○ |
| C-60 | ConfirmedOrderStockItem: ProductId, HasStockプロパティ | E-19 (L3) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースがソースコードに基づいて生成されており、根拠なしの項目はありません。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードから直接導出されています
- 注意点:
  - AI機能（CatalogAI）のテストは外部依存（IEmbeddingGenerator）のモック化が必要
  - 統合イベントのテストはEventBusのモック化が必要
  - データベースアクセスのテストはインメモリDBまたはモックが必要

## 6) レビュアーチェックリスト（最小）
- [ ] 在庫管理ロジック（RemoveStock/AddStock）のテストケースが境界条件を網羅しているか
- [ ] APIエンドポイントのバリデーションテストが十分か
- [ ] 統合イベントの発行タイミング・条件が正しくテストされているか
- [ ] AI機能無効時のフォールバック動作がテストされているか
- [ ] Entity Framework Configurationの設定値が正しいか
- [ ] 例外処理のテストケースが網羅的か
