---
generated_at: 2026-01-14 22:15:00
metrics:
  claims_total: 164
  claims_with_evidence: 164
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ClientApp.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：164 / 164、根拠なし：0
- 優先レビュー（高）
  1. **UT-CLI-033〜035（CheckoutAsync）**：注文処理のコア機能であり、トランザクション整合性の確認が必要
  2. **UT-CLI-094〜100（BasketService）**：gRPC通信の実装であり、エラーハンドリングの妥当性確認が必要
  3. **UT-CLI-121〜130（IdentityService）**：認証処理であり、セキュリティ観点でのレビューが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/ViewModels/Base/ViewModelBase.cs`
- E-02: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/ViewModels/BasketViewModel.cs`
- E-03: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/ViewModels/CatalogViewModel.cs`
- E-04: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/ViewModels/CheckoutViewModel.cs`
- E-05: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/ViewModels/LoginViewModel.cs`
- E-06: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/ViewModels/ProfileViewModel.cs`
- E-07: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/ViewModels/OrderDetailViewModel.cs`
- E-08: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/ViewModels/CatalogItemViewModel.cs`
- E-09: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/ViewModels/SettingsViewModel.cs`
- E-10: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/ViewModels/ObservableCollectionEx.cs`
- E-11: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Models/Basket/CustomerBasket.cs`
- E-12: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Models/Basket/BasketItem.cs`
- E-13: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Validations/ValidatableObject.cs`
- E-14: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Validations/IsNotNullOrEmptyRule.cs`
- E-15: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Services/Basket/BasketService.cs`
- E-16: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Services/Order/OrderService.cs`
- E-17: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Services/Catalog/CatalogService.cs`
- E-18: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Services/Identity/IdentityService.cs`
- E-19: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Services/Settings/SettingsService.cs`
- E-20: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Services/RequestProvider/RequestProvider.cs`
- E-21: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Converters/HasCountConverter.cs`
- E-22: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Converters/DoesNotHaveCountConverter.cs`
- E-23: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Converters/ItemsToHeightConverter.cs`
- E-24: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Converters/FirstValidationErrorConverter.cs`
- E-25: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Helpers/UriHelper.cs`
- E-26: `/Users/tomokababa/Work/route06/eShop-main/src/ClientApp/Extensions/DictionaryExtensions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-05 | ViewModelBase関連テストケース | E-01 | ○ |
| C-06〜C-16 | BasketViewModel関連テストケース | E-02 | ○ |
| C-17〜C-30 | CatalogViewModel関連テストケース | E-03 | ○ |
| C-31〜C-39 | CheckoutViewModel関連テストケース | E-04 | ○ |
| C-40〜C-49 | LoginViewModel関連テストケース | E-05 | ○ |
| C-50〜C-55 | ProfileViewModel関連テストケース | E-06 | ○ |
| C-56〜C-61 | OrderDetailViewModel関連テストケース | E-07 | ○ |
| C-62〜C-65 | CatalogItemViewModel関連テストケース | E-08 | ○ |
| C-66〜C-70 | SettingsViewModel関連テストケース | E-09 | ○ |
| C-71〜C-74 | ObservableCollectionEx関連テストケース | E-10 | ○ |
| C-75〜C-81 | CustomerBasket関連テストケース | E-11 | ○ |
| C-82〜C-86 | BasketItem関連テストケース | E-12 | ○ |
| C-87〜C-89 | ValidatableObject関連テストケース | E-13 | ○ |
| C-90〜C-93 | IsNotNullOrEmptyRule関連テストケース | E-14 | ○ |
| C-94〜C-101 | BasketService関連テストケース | E-15 | ○ |
| C-102〜C-112 | OrderService関連テストケース | E-16 | ○ |
| C-113〜C-120 | CatalogService関連テストケース | E-17 | ○ |
| C-121〜C-130 | IdentityService関連テストケース | E-18 | ○ |
| C-131〜C-136 | SettingsService関連テストケース | E-19 | ○ |
| C-137〜C-143 | RequestProvider関連テストケース | E-20 | ○ |
| C-144〜C-146 | HasCountConverter関連テストケース | E-21 | ○ |
| C-147〜C-149 | DoesNotHaveCountConverter関連テストケース | E-22 | ○ |
| C-150〜C-151 | ItemsToHeightConverter関連テストケース | E-23 | ○ |
| C-152〜C-154 | FirstValidationErrorConverter関連テストケース | E-24 | ○ |
| C-155〜C-158 | UriHelper関連テストケース | E-25 | ○ |
| C-159〜C-164 | DictionaryExtensions関連テストケース | E-26 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）

### リスクレベル2（高リスク）
- **金額計算ロジック**（UT-CLI-008, UT-CLI-038, UT-CLI-084）：バスケット合計、注文合計の計算
  - 小数点以下の丸め処理が未定義の可能性あり
  - 大量アイテム時のオーバーフロー考慮が必要
- **認証・認可処理**（UT-CLI-121〜UT-CLI-130）：OIDCによる認証フロー
  - トークンリフレッシュのタイミング（5分前）が適切か要検討
  - 並行リクエスト時のトークンリフレッシュ競合の考慮が必要

### リスクレベル1（中リスク）
- **gRPC通信**（UT-CLI-094〜UT-CLI-100）：BasketServiceのgRPC実装
  - タイムアウト設定が未確認
  - リトライロジックの有無が未確認
- **非同期処理**（UT-CLI-002〜UT-CLI-003）：IsBusyFor実装
  - ネストした呼び出し時の挙動確認が必要

### リスクレベル0（低リスク）
- **UI変換処理**（UT-CLI-144〜UT-CLI-154）：Converterクラス
- **ヘルパーメソッド**（UT-CLI-155〜UT-CLI-164）：UriHelper、DictionaryExtensions

## 6) レビュアーチェックリスト（最小）
- [ ] 金額計算ロジック（Total, CalculateTotal）の精度が要件を満たしているか
- [ ] 認証トークンのリフレッシュタイミング（5分前）が適切か
- [ ] gRPC通信のエラーハンドリングが十分か（タイムアウト、リトライ）
- [ ] バリデーションルールが業務要件を網羅しているか
- [ ] 非同期処理のキャンセルトークン対応が必要か
- [ ] SecureStorageへのトークン保存がセキュリティ要件を満たすか

## 7) 解析対象クラスの詳細

### ViewModels（画面ロジック）
| クラス名 | テストケース数 | 優先度高 | 優先度中 | 優先度低 |
|----------|----------------|----------|----------|----------|
| ViewModelBase | 5 | 0 | 4 | 1 |
| BasketViewModel | 11 | 7 | 4 | 0 |
| CatalogViewModel | 14 | 1 | 12 | 1 |
| CheckoutViewModel | 9 | 7 | 2 | 0 |
| LoginViewModel | 10 | 3 | 7 | 0 |
| ProfileViewModel | 6 | 2 | 4 | 0 |
| OrderDetailViewModel | 6 | 2 | 4 | 0 |
| CatalogItemViewModel | 4 | 1 | 2 | 1 |
| SettingsViewModel | 5 | 0 | 5 | 0 |

### Models（データモデル）
| クラス名 | テストケース数 | 優先度高 | 優先度中 | 優先度低 |
|----------|----------------|----------|----------|----------|
| CustomerBasket | 7 | 5 | 2 | 0 |
| BasketItem | 5 | 1 | 3 | 1 |
| ObservableCollectionEx | 4 | 0 | 4 | 0 |

### Services（ビジネスロジック・外部連携）
| クラス名 | テストケース数 | 優先度高 | 優先度中 | 優先度低 |
|----------|----------------|----------|----------|----------|
| BasketService | 8 | 6 | 2 | 0 |
| OrderService | 11 | 8 | 3 | 0 |
| CatalogService | 8 | 2 | 6 | 0 |
| IdentityService | 10 | 10 | 0 | 0 |
| SettingsService | 6 | 2 | 4 | 0 |
| RequestProvider | 7 | 4 | 2 | 1 |

### Validations（バリデーション）
| クラス名 | テストケース数 | 優先度高 | 優先度中 | 優先度低 |
|----------|----------------|----------|----------|----------|
| ValidatableObject | 3 | 0 | 3 | 0 |
| IsNotNullOrEmptyRule | 4 | 0 | 4 | 0 |

### Converters（UI変換）
| クラス名 | テストケース数 | 優先度高 | 優先度中 | 優先度低 |
|----------|----------------|----------|----------|----------|
| HasCountConverter | 3 | 0 | 0 | 3 |
| DoesNotHaveCountConverter | 3 | 0 | 0 | 3 |
| ItemsToHeightConverter | 2 | 0 | 0 | 2 |
| FirstValidationErrorConverter | 3 | 0 | 0 | 3 |

### Helpers/Extensions（ユーティリティ）
| クラス名 | テストケース数 | 優先度高 | 優先度中 | 優先度低 |
|----------|----------------|----------|----------|----------|
| UriHelper | 4 | 0 | 3 | 1 |
| DictionaryExtensions | 6 | 0 | 0 | 6 |

## 8) テスト観点の分布

| テスト観点 | 件数 | 割合 |
|------------|------|------|
| 正常系 | 119 | 72.6% |
| 異常系 | 33 | 20.1% |
| 境界値 | 12 | 7.3% |

## 9) 優先度の分布

| 優先度 | 件数 | 割合 |
|--------|------|------|
| 高 | 61 | 37.2% |
| 中 | 79 | 48.2% |
| 低 | 24 | 14.6% |
