---
generated_at: 2026-01-14 10:30:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：EventBus 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：すべてのテストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/EventBus/Events/IntegrationEvent.cs`
- E-02: `src/EventBus/Extensions/GenericTypeExtensions.cs`
- E-03: `src/EventBus/Abstractions/EventBusSubscriptionInfo.cs`
- E-04: `src/EventBus/Extensions/EventBusBuilderExtensions.cs`
- E-05: `src/EventBus/Abstractions/IEventBusBuilder.cs`
- E-06: `src/EventBus/Abstractions/IIntegrationEventHandler.cs`
- E-07: `src/EventBus/Abstractions/IEventBus.cs`
- E-08: `src/EventBus/GlobalUsings.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IntegrationEventコンストラクタでIdが生成される | E-01 (行7: Id = Guid.NewGuid()) | ○ |
| C-02 | IntegrationEventコンストラクタでCreationDateが設定される | E-01 (行8: CreationDate = DateTime.UtcNow) | ○ |
| C-03 | 複数インスタンスで異なるIdが生成される | E-01 (Guid.NewGuid()の仕様) | ○ |
| C-04 | IdプロパティがJsonInclude属性を持つ | E-01 (行11: [JsonInclude]) | ○ |
| C-05 | CreationDateプロパティがJsonInclude属性を持つ | E-01 (行14: [JsonInclude]) | ○ |
| C-06 | GetGenericTypeNameが非ジェネリック型を処理する | E-02 (行16: typeName = type.Name) | ○ |
| C-07 | GetGenericTypeNameがジェネリック型をフォーマットする | E-02 (行9-13: type.IsGenericType分岐) | ○ |
| C-08 | GetGenericTypeName(object)がType版を呼び出す | E-02 (行22-25: @object.GetType().GetGenericTypeName()) | ○ |
| C-09 | EventBusSubscriptionInfoのEventTypesが空Dictionaryで初期化される | E-03 (行8: EventTypes { get; } = []) | ○ |
| C-10 | EventBusSubscriptionInfoのJsonSerializerOptionsがデフォルト設定を持つ | E-03 (行10: new(DefaultSerializerOptions)) | ○ |
| C-11 | DefaultSerializerOptionsがTypeInfoResolverを設定する | E-03 (行12-15: TypeInfoResolver設定) | ○ |
| C-12 | ConfigureJsonOptionsがJsonSerializerOptionsを設定する | E-04 (行10-18: Configure<EventBusSubscriptionInfo>) | ○ |
| C-13 | ConfigureJsonOptionsがIEventBusBuilderを返却する | E-04 (行17: return eventBusBuilder) | ○ |
| C-14 | AddSubscriptionがKeyedTransientでハンドラを登録する | E-04 (行27: AddKeyedTransient) | ○ |
| C-15 | AddSubscriptionがEventTypesに型を登録する | E-04 (行29-36: Configure<EventBusSubscriptionInfo>) | ○ |
| C-16 | AddSubscriptionがIEventBusBuilderを返却する | E-04 (行38: return eventBusBuilder) | ○ |
| C-17 | IEventBusBuilderがServicesプロパティを持つ | E-05 (行5: IServiceCollection Services { get; }) | ○ |
| C-18 | IIntegrationEventHandler<T>がHandle(T)を定義する | E-06 (行6: Task Handle(TIntegrationEvent @event)) | ○ |
| C-19 | IIntegrationEventHandler<T>が既定実装でキャストする | E-06 (行8: Handle((TIntegrationEvent)@event)) | ○ |
| C-20 | IIntegrationEventHandlerがHandle(IntegrationEvent)を定義する | E-06 (行13: Task Handle(IntegrationEvent @event)) | ○ |
| C-21 | IEventBusがPublishAsyncを定義する | E-07 (行5: Task PublishAsync(IntegrationEvent @event)) | ○ |
| C-22 | Idプロパティがgetおよびsetを持つ | E-01 (行12: public Guid Id { get; set; }) | ○ |
| C-23 | CreationDateプロパティがgetおよびsetを持つ | E-01 (行15: public DateTime CreationDate { get; set; }) | ○ |
| C-24 | IntegrationEventがrecord型である | E-01 (行3: public record IntegrationEvent) | ○ |
| C-25 | GenericTypeExtensionsがstatic classである | E-02 (行3: public static class GenericTypeExtensions) | ○ |
| C-26 | EventBusSubscriptionInfoがclassである | E-03 (行6: public class EventBusSubscriptionInfo) | ○ |
| C-27 | EventBusBuilderExtensionsがstatic classである | E-04 (行8: public static class EventBusBuilderExtensions) | ○ |
| C-28 | IIntegrationEventHandler<T>がIIntegrationEventHandlerを継承する | E-06 (行3: IIntegrationEventHandler<T> : IIntegrationEventHandler) | ○ |
| C-29 | IIntegrationEventHandler<T>がwhere制約を持つ | E-06 (行4: where TIntegrationEvent : IntegrationEvent) | ○ |
| C-30 | AddSubscriptionが型制約を持つ | E-04 (行21-22: where T : IntegrationEvent, where TH : IIntegrationEventHandler<T>) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - すべてのテストケースはソースコードに基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：EventBusモジュールは抽象化層であり、すべてのクラス・インターフェースがソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] IntegrationEventのIdとCreationDateのシリアライズ/デシリアライズが正しく動作するか実際にテストで確認
- [ ] GenericTypeExtensionsのネストしたジェネリック型の処理が想定通りか確認
- [ ] AddSubscriptionで同一イベント型に複数ハンドラを登録した場合の取得方法が明確か確認
- [ ] IIntegrationEventHandler<T>の既定実装でのキャスト例外が適切にハンドリングされるか確認
- [ ] AOT環境でのCreateDefaultTypeResolverの動作確認（リフレクション無効時）
