---
generated_at: 2026-01-14 22:15:00
metrics:
  claims_total: 47
  claims_with_evidence: 47
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：EventBusRabbitMQ 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：47 / 47、根拠なし：0
- 優先レビュー（高）
  1. **リトライ処理のテスト**：BrokerUnreachableException/SocketException発生時のリトライ動作は統合テストでの検証が望ましい
  2. **非同期メッセージング**：StartAsync内のTask.Factory.StartNewによる非同期処理は実際のRabbitMQ環境でのテストが必要
  3. **OpenTelemetryトレーシング**：トレースコンテキストの伝播は分散環境での検証が推奨される

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/eShop-main/src/EventBusRabbitMQ/RabbitMQEventBus.cs`
- E-02: `/Users/tomokababa/Work/route06/eShop-main/src/EventBusRabbitMQ/RabbitMQTelemetry.cs`
- E-03: `/Users/tomokababa/Work/route06/eShop-main/src/EventBusRabbitMQ/RabbitMqDependencyInjectionExtensions.cs`
- E-04: `/Users/tomokababa/Work/route06/eShop-main/src/EventBusRabbitMQ/EventBusOptions.cs`
- E-05: `/Users/tomokababa/Work/route06/eShop-main/src/EventBusRabbitMQ/GlobalUsings.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### RabbitMQEventBus クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PublishAsync - IntegrationEventが正常にパブリッシュされる | E-01 (L31-111) | ○ |
| C-02 | PublishAsync - 接続閉じ時にInvalidOperationException | E-01 (L40) | ○ |
| C-03 | PublishAsync - イベント型名がルーティングキー | E-01 (L33) | ○ |
| C-04 | PublishAsync - トレースコンテキスト伝播 | E-01 (L59-86) | ○ |
| C-05 | PublishAsync - Persistent配信モード | E-01 (L75-78) | ○ |
| C-06 | PublishAsync - BrokerUnreachableExceptionリトライ | E-01 (L302-319) | ○ |
| C-07 | PublishAsync - SocketExceptionリトライ | E-01 (L307) | ○ |
| C-08 | StartAsync - 接続確立 | E-01 (L226-295) | ○ |
| C-09 | StartAsync - コンシューマチャネル作成 | E-01 (L246) | ○ |
| C-10 | StartAsync - Exchange宣言 | E-01 (L254-256) | ○ |
| C-11 | StartAsync - Queue宣言 | E-01 (L258-263) | ○ |
| C-12 | StartAsync - QueueBind実行 | E-01 (L279-285) | ○ |
| C-13 | StartAsync - 接続未オープン時の中断 | E-01 (L236-239) | ○ |
| C-14 | StartAsync - 例外時エラーログ | E-01 (L287-290) | ○ |
| C-15 | StopAsync - Task.CompletedTask返却 | E-01 (L297-300) | ○ |
| C-16 | Dispose - チャネルDispose | E-01 (L127-130) | ○ |
| C-17 | Dispose - null時の安全性 | E-01 (L129) | ○ |
| C-18 | OnMessageReceived - メッセージ処理 | E-01 (L132-181) | ○ |
| C-19 | OnMessageReceived - トレースコンテキスト抽出 | E-01 (L134-146) | ○ |
| C-20 | OnMessageReceived - BasicAck送信 | E-01 (L180) | ○ |
| C-21 | OnMessageReceived - 例外時もAck送信 | E-01 (L177-180) | ○ |
| C-22 | OnMessageReceived - throw-fake-exception | E-01 (L163-165) | ○ |
| C-23 | ProcessEvent - ハンドラ呼び出し | E-01 (L183-208) | ○ |
| C-24 | ProcessEvent - 未登録イベント警告 | E-01 (L192-196) | ○ |
| C-25 | ProcessEvent - 複数ハンドラ実行 | E-01 (L204-207) | ○ |
| C-26 | DeserializeMessage - JSONデシリアライズ | E-01 (L210-216) | ○ |
| C-27 | DeserializeMessage - 不正JSON例外 | E-01 (L215) | ○ |
| C-28 | SerializeMessage - UTF-8シリアライズ | E-01 (L218-224) | ○ |
| C-29 | SetActivityContext - タグ設定 | E-01 (L113-125) | ○ |
| C-30 | SetActivityContext - null安全性 | E-01 (L115) | ○ |
| C-31 | CreateResiliencePipeline - リトライ設定 | E-01 (L302-319) | ○ |
| C-32 | CreateResiliencePipeline - 指数バックオフ | E-01 (L316-318) | ○ |
| C-33 | CreateResiliencePipeline - retryCount=0 | E-01 (L308) | ○ |

### RabbitMQTelemetry クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | ActivitySource初期化 | E-02 (L8-10) | ○ |
| C-35 | DefaultTextMapPropagator設定 | E-02 (L11) | ○ |

### EventBusOptions クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | SubscriptionClientNameプロパティ | E-04 (L5) | ○ |
| C-37 | RetryCountデフォルト値10 | E-04 (L6) | ○ |
| C-38 | RetryCountプロパティ | E-04 (L6) | ○ |

### RabbitMqDependencyInjectionExtensions クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | AddRabbitMQClient呼び出し | E-03 (L21) | ○ |
| C-40 | OpenTelemetryトレーシング設定 | E-03 (L24-28) | ○ |
| C-41 | EventBusOptions Configurationバインド | E-03 (L31) | ○ |
| C-42 | RabbitMQTelemetryシングルトン登録 | E-03 (L34) | ○ |
| C-43 | IEventBus登録 | E-03 (L35) | ○ |
| C-44 | IHostedService登録 | E-03 (L37) | ○ |
| C-45 | IEventBusBuilder返却 | E-03 (L39) | ○ |
| C-46 | null引数検証 | E-03 (L19) | ○ |
| C-47 | EventBusBuilder.Servicesプロパティ | E-03 (L42-45) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。すべてのテストケースはソースコードに基づいています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースがソースコードから直接導出されている

### 注意事項
1. **統合テストが推奨される項目**:
   - RabbitMQ接続関連（UT-RMQ-008〜014）：実際のRabbitMQブローカーが必要
   - リトライ処理（UT-RMQ-006, 007）：ネットワーク障害のシミュレーションが必要
   - メッセージ送受信（UT-RMQ-018〜025）：エンドツーエンドのテストが望ましい

2. **モック化の検討**:
   - `IConnection`：RabbitMQ接続のモック
   - `IChannel`：チャネル操作のモック
   - `IServiceProvider`：依存性注入のモック
   - `ILogger<T>`：ログ出力の検証用モック

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度のテストケース（UT-RMQ-001〜008, 018〜028, 039, 043, 044, 046）がすべて実装されているか
- [ ] RabbitMQ接続のモック戦略が適切か
- [ ] 非同期処理のテスト方法が妥当か
- [ ] OpenTelemetryのトレース検証方法が適切か
- [ ] 例外ハンドリングのテストが網羅されているか
- [ ] リトライロジックのテストがPollyの仕様に沿っているか
