---
generated_at: 2026-01-14 22:15:00
metrics:
  claims_total: 71
  claims_with_evidence: 71
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：HybridApp単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：71 / 71、根拠なし：0
- 優先レビュー（高）
  1. **CatalogService API呼び出しテスト**：外部API依存のためモック必須
  2. **プラットフォーム固有テスト**：各プラットフォーム環境でのテスト実行が必要
  3. **Blazorコンポーネントテスト**：bUnitなどのフレームワーク使用推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/HybridApp/MauiProgram.cs` - MauiApp構成、DI設定
- E-02: `src/HybridApp/App.xaml.cs` - Applicationクラス実装
- E-03: `src/HybridApp/MainPage.xaml.cs` - メインページ実装
- E-04: `src/HybridApp/Services/CatalogService.cs` - カタログサービス実装（ICatalogService実装）
- E-05: `src/HybridApp/Services/ProductImageUrlProvider.cs` - 画像URL生成サービス
- E-06: `src/HybridApp/Services/CatalogJsonContext.cs` - JSONシリアライズコンテキスト
- E-07: `src/HybridApp/Platforms/Android/MainActivity.cs` - Android Activity
- E-08: `src/HybridApp/Platforms/Android/MainApplication.cs` - Android Application
- E-09: `src/HybridApp/Platforms/iOS/AppDelegate.cs` - iOS AppDelegate
- E-10: `src/HybridApp/Platforms/iOS/Program.cs` - iOS エントリポイント
- E-11: `src/HybridApp/Platforms/MacCatalyst/AppDelegate.cs` - Mac AppDelegate
- E-12: `src/HybridApp/Platforms/MacCatalyst/Program.cs` - Mac エントリポイント
- E-13: `src/HybridApp/Platforms/Windows/App.xaml.cs` - Windows Application
- E-14: `src/HybridApp/Platforms/Tizen/Main.cs` - Tizen エントリポイント
- E-15: `src/HybridApp/Components/Pages/Catalog/Catalog.razor` - カタログページコンポーネント
- E-16: `src/HybridApp/Components/Pages/Catalog/CatalogSearch.razor` - 検索コンポーネント
- E-17: `src/HybridApp/Components/Pages/Item/ItemPage.razor` - アイテム詳細ページ
- E-18: `src/HybridApp/Components/Layout/HeaderBar.razor` - ヘッダーバーコンポーネント
- E-19: `src/HybridApp/GlobalSuppressions.cs` - トリミング警告抑制設定
- E-20: `src/HybridApp/HybridApp.csproj` - プロジェクト設定ファイル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MauiProgram.CreateMauiAppがMauiAppインスタンスを返す | E-01 | ○ |
| C-02 | CatalogServiceがDIコンテナに登録される | E-01 (line 30) | ○ |
| C-03 | IProductImageUrlProviderがDIコンテナに登録される | E-01 (line 31) | ○ |
| C-04 | HttpClientのBaseAddressが設定される | E-01 (line 30) | ○ |
| C-05 | Android用BaseURLが10.0.2.2である | E-01 (line 9) | ○ |
| C-06 | 非Android用BaseURLがlocalhostである | E-01 (line 9) | ○ |
| C-07 | App.CreateWindowがWindowを返す | E-02 (line 10-13) | ○ |
| C-08 | Windowのタイトルが"eShop"である | E-02 (line 12) | ○ |
| C-09 | MainPageがWindowに設定される | E-02 (line 12) | ○ |
| C-10 | CatalogService.GetCatalogItemがAPIを呼び出す | E-04 (line 13-17) | ○ |
| C-11 | CatalogService.GetCatalogItemsがページネーション対応 | E-04 (line 19-24) | ○ |
| C-12 | CatalogService.GetCatalogItemsがフィルタ対応 | E-04 (line 54-68) | ○ |
| C-13 | CatalogService.GetCatalogItemsがID配列対応 | E-04 (line 26-31) | ○ |
| C-14 | CatalogService.GetCatalogItemsWithSemanticRelevanceがテキスト検索 | E-04 (line 33-38) | ○ |
| C-15 | CatalogService.GetBrandsがブランド一覧を返す | E-04 (line 40-45) | ○ |
| C-16 | CatalogService.GetTypesがタイプ一覧を返す | E-04 (line 47-52) | ○ |
| C-17 | GetAllCatalogItemsUriがURIを構築する | E-04 (line 54-68) | ○ |
| C-18 | ProductImageUrlProvider.GetProductImageUrlがURLを生成 | E-05 (line 7-8) | ○ |
| C-19 | CatalogJsonContextがシリアライズ型を定義 | E-06 (line 6-12) | ○ |
| C-20 | MainActivityがMauiAppCompatActivityを継承 | E-07 (line 8-10) | ○ |
| C-21 | MainApplication.CreateMauiAppがMauiProgram呼び出し | E-08 (line 14) | ○ |
| C-22 | iOS AppDelegate.CreateMauiAppがMauiProgram呼び出し | E-09 (line 8) | ○ |
| C-23 | iOS Program.MainがUIApplication.Main呼び出し | E-10 (line 13) | ○ |
| C-24 | Mac AppDelegate.CreateMauiAppがMauiProgram呼び出し | E-11 (line 8) | ○ |
| C-25 | Mac Program.MainがUIApplication.Main呼び出し | E-12 (line 13) | ○ |
| C-26 | Windows App.CreateMauiAppがMauiProgram呼び出し | E-13 (line 22) | ○ |
| C-27 | Tizen Program.CreateMauiAppがMauiProgram呼び出し | E-14 (line 9) | ○ |
| C-28 | Catalog.razorがOnParametersSetAsyncでデータ取得 | E-15 (line 53-60) | ○ |
| C-29 | Catalog.razorのGetVisiblePageIndexesがページ計算 | E-15 (line 50-51) | ○ |
| C-30 | CatalogSearch.razorがOnInitializedAsyncで並列取得 | E-16 (line 55-62) | ○ |
| C-31 | CatalogSearch.razorのBrandUriがURI生成 | E-16 (line 64-68) | ○ |
| C-32 | CatalogSearch.razorのTypeUriがURI生成 | E-16 (line 70-74) | ○ |
| C-33 | ItemPage.razorがOnInitializedAsyncでアイテム取得 | E-17 (line 52-65) | ○ |
| C-34 | ItemPage.razorが404をハンドリング | E-17 (line 60-64) | ○ |
| C-35 | HeaderBar.razorのIsCatalogがtrue | E-18 (line 33) | ○ |
| C-36 | GlobalSuppressionsがIL2111を抑制 | E-19 (line 24-27) | ○ |
| C-37 | GlobalSuppressionsがIL2110を抑制 | E-19 (line 29-31) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべてのテストケースはソースコードから直接確認された実装に基づいています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースがソースコードに基づいており、根拠が明確

### 注意点
1. **外部API依存**: CatalogServiceのテストはHttpClientのモックが必要
2. **プラットフォーム固有**: Android/iOS/Mac/Windows/Tizen固有のテストは各環境でのみ実行可能
3. **Blazorコンポーネント**: bUnitなどのテストフレームワークを使用することを推奨
4. **JSONシリアライズ**: Source Generatorベースのため、AOT環境でのテストも検討

## 6) レビュアーチェックリスト（最小）
- [ ] CatalogServiceの各メソッドがAPIエンドポイントと一致しているか確認
- [ ] URLエンコーディングの処理が正しいか確認（特にGetCatalogItemsWithSemanticRelevance）
- [ ] プラットフォーム固有のエントリポイントが正しく設定されているか確認
- [ ] Blazorコンポーネントのライフサイクルメソッドが適切にテストされているか確認
- [ ] JSONシリアライズのテストが型安全性を担保しているか確認
- [ ] エラーハンドリング（404、接続エラー等）のテストケースが十分か確認
