---
generated_at: 2026-01-14 12:00:00
metrics:
  claims_total: 146
  claims_with_evidence: 142
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：Identity.API 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：142 / 146、根拠なし：4
- 優先レビュー（高）
  1. **UT-IDA-048**：不正returnURL例外スローのテストケースは実装依存の挙動確認が必要
  2. **UT-IDA-059**：Challenge時の不正URL例外処理の確認が必要
  3. **UT-IDA-101**：本番環境でのエラー詳細非表示はセキュリティポリシー依存
  4. **UT-IDA-097**：DiagnosticsControllerのIP制限テストは環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Identity.API/Models/ApplicationUser.cs` - ユーザーモデル定義
- E-02: `src/Identity.API/Services/ProfileService.cs` - プロファイルサービス実装
- E-03: `src/Identity.API/Services/EFLoginService.cs` - ログインサービス実装
- E-04: `src/Identity.API/Services/ILoginService.cs` - ログインサービスインターフェース
- E-05: `src/Identity.API/Services/RedirectService.cs` - リダイレクトサービス実装
- E-06: `src/Identity.API/Services/IRedirectService.cs` - リダイレクトサービスインターフェース
- E-07: `src/Identity.API/Quickstart/Account/AccountController.cs` - アカウントコントローラー
- E-08: `src/Identity.API/Quickstart/Account/ExternalController.cs` - 外部認証コントローラー
- E-09: `src/Identity.API/Quickstart/Consent/ConsentController.cs` - 同意コントローラー
- E-10: `src/Identity.API/Quickstart/Device/DeviceController.cs` - デバイス認証コントローラー
- E-11: `src/Identity.API/Quickstart/Grants/GrantsController.cs` - 権限管理コントローラー
- E-12: `src/Identity.API/Quickstart/Diagnostics/DiagnosticsController.cs` - 診断コントローラー
- E-13: `src/Identity.API/Quickstart/Home/HomeController.cs` - ホームコントローラー
- E-14: `src/Identity.API/Quickstart/Extensions.cs` - 拡張メソッド
- E-15: `src/Identity.API/Quickstart/SecurityHeadersAttribute.cs` - セキュリティヘッダー属性
- E-16: `src/Identity.API/Quickstart/Account/AccountOptions.cs` - アカウントオプション
- E-17: `src/Identity.API/Quickstart/Consent/ConsentOptions.cs` - 同意オプション
- E-18: `src/Identity.API/Quickstart/Account/LoginViewModel.cs` - ログインビューモデル
- E-19: `src/Identity.API/Quickstart/Account/LoginInputModel.cs` - ログイン入力モデル
- E-20: `src/Identity.API/Quickstart/Consent/ProcessConsentResult.cs` - 同意処理結果
- E-21: `src/Identity.API/Quickstart/Grants/GrantsViewModel.cs` - 権限ビューモデル
- E-22: `src/Identity.API/Quickstart/Diagnostics/DiagnosticsViewModel.cs` - 診断ビューモデル
- E-23: `src/Identity.API/Quickstart/Home/ErrorViewModel.cs` - エラービューモデル
- E-24: `src/Identity.API/Quickstart/Device/DeviceAuthorizationViewModel.cs` - デバイス認証ビューモデル
- E-25: `src/Identity.API/Data/ApplicationDbContext.cs` - データベースコンテキスト
- E-26: `src/Identity.API/UsersSeed.cs` - シードデータ
- E-27: `src/Identity.API/Configuration/Config.cs` - 設定クラス

## 3) Claims と根拠の対応（レビューの主戦場）

### Models - ApplicationUser (UT-IDA-001 ~ UT-IDA-014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CardNumberプロパティは[Required]属性で必須 | E-01 (L7) | ○ |
| C-02 | SecurityNumberプロパティは[Required]属性で必須 | E-01 (L9) | ○ |
| C-03 | Expirationプロパティは正規表現バリデーション付き | E-01 (L11) `[RegularExpression(@"(0[1-9]|1[0-2])\/[0-9]{2}")]` | ○ |
| C-04 | CardHolderNameプロパティは[Required]属性で必須 | E-01 (L14) | ○ |
| C-05 | CardTypeプロパティはint型 | E-01 (L15) | ○ |
| C-06 | Street/City/State/Country/ZipCodeは[Required]属性で必須 | E-01 (L16-25) | ○ |
| C-07 | Name/LastNameプロパティは[Required]属性で必須 | E-01 (L26-28) | ○ |

### Services - ProfileService (UT-IDA-015 ~ UT-IDA-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | GetProfileDataAsyncでSubjectがnullの場合例外スロー | E-02 (L14) `throw new ArgumentNullException` | ○ |
| C-09 | ユーザーが見つからない場合ArgumentExceptionスロー | E-02 (L20) `throw new ArgumentException` | ○ |
| C-10 | IsActiveAsyncでロックアウト状態を確認 | E-02 (L48-51) | ○ |
| C-11 | セキュリティスタンプの検証が行われる | E-02 (L37-44) | ○ |
| C-12 | GetClaimsFromUserで各プロパティからClaimsを生成 | E-02 (L55-116) | ○ |
| C-13 | 空文字・nullの場合Claimが追加されない | E-02 (L64-95) `!string.IsNullOrWhiteSpace` | ○ |

### Services - EFLoginService (UT-IDA-029 ~ UT-IDA-035)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | FindByUsernameはFindByEmailAsyncを呼び出す | E-03 (L16) | ○ |
| C-15 | ValidateCredentialsはCheckPasswordAsyncを呼び出す | E-03 (L21) | ○ |
| C-16 | SignInはSignInAsyncを呼び出す | E-03 (L26) | ○ |
| C-17 | SignInAsyncは認証メソッドを受け取る | E-03 (L29-31) | ○ |

### Services - RedirectService (UT-IDA-036 ~ UT-IDA-042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | redirect_uriがない場合空文字を返す | E-05 (L9-10) | ○ |
| C-19 | signin-oidcまたはscopeをデリミタとして使用 | E-05 (L14-18) | ○ |
| C-20 | URLエンコードされた文字をデコード | E-05 (L26) `Replace("%3A", ":")` | ○ |
| C-21 | HTMLデコードを実行 | E-05 (L7) `WebUtility.HtmlDecode` | ○ |

### Controllers - AccountController (UT-IDA-043 ~ UT-IDA-056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | Login GETでLoginViewModelを構築して返す | E-07 (L40-53) | ○ |
| C-23 | 外部ログインのみの場合Challengeへリダイレクト | E-07 (L47-50) | ○ |
| C-24 | Login POSTでPasswordSignInAsyncを呼び出す | E-07 (L95) | ○ |
| C-25 | キャンセル時にDenyAuthorizationAsyncを呼び出す | E-07 (L74) | ○ |
| C-26 | 不正returnURLで例外スロー | E-07 (L126) `throw new Exception("invalid return URL")` | ○ |
| C-27 | Logout時にSignOutAsyncを呼び出す | E-07 (L175) | ○ |
| C-28 | 外部IdP利用時にTriggerExternalSignoutを設定 | E-07 (L182-190) | ○ |

### Controllers - ExternalController (UT-IDA-057 ~ UT-IDA-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | Challengeで不正URL時に例外スロー | E-08 (L42) `throw new Exception("invalid return URL")` | ○ |
| C-30 | Callback失敗時に例外スロー | E-08 (L70) `throw new Exception("External authentication error")` | ○ |
| C-31 | 新規ユーザーの自動プロビジョニング | E-08 (L86) `AutoProvisionUserAsync` | ○ |
| C-32 | userIdClaimがない場合例外スロー | E-08 (L143-145) | ○ |
| C-33 | session_idのコピー処理 | E-08 (L225-228) | ○ |
| C-34 | id_tokenの保存処理 | E-08 (L232-235) | ○ |

### Controllers - ConsentController (UT-IDA-071 ~ UT-IDA-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | 無効returnURLでエラービュー返却 | E-09 (L41) | ○ |
| C-36 | button="no"でアクセス拒否 | E-09 (L93-98) | ○ |
| C-37 | スコープ未選択でエラーメッセージ | E-09 (L124) `MustChooseOneErrorMessage` | ○ |
| C-38 | 不正ボタン値でエラーメッセージ | E-09 (L129) `InvalidSelectionErrorMessage` | ○ |
| C-39 | offline_accessのフィルタリング | E-09 (L107-109) | ○ |

### Controllers - DeviceController (UT-IDA-084 ~ UT-IDA-091)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | userCode空でUserCodeCaptureビュー | E-10 (L32) | ○ |
| C-41 | nullモデルでArgumentNullException | E-10 (L55) `throw new ArgumentNullException` | ○ |

### Controllers - GrantsController (UT-IDA-092 ~ UT-IDA-095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | RevokeでRevokeUserConsentAsyncを呼び出す | E-11 (L45) | ○ |
| C-43 | GrantsRevokedEventを発行 | E-11 (L46) | ○ |

### Controllers - DiagnosticsController (UT-IDA-096 ~ UT-IDA-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | ローカルIPチェックで非ローカルはNotFound | E-12 (L13-17) | ○ |

### Controllers - HomeController (UT-IDA-098 ~ UT-IDA-101)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | Development環境でのみViewを表示 | E-13 (L26-33) | ○ |
| C-46 | 本番環境でErrorDescriptionをnullに設定 | E-13 (L52) | ○ |

### Extensions (UT-IDA-102 ~ UT-IDA-105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | IsNativeClientでhttp/https以外でtrue | E-14 (L9-12) | ○ |
| C-48 | LoadingPageでStatusCode=200設定 | E-14 (L17) | ○ |

### SecurityHeadersAttribute (UT-IDA-106 ~ UT-IDA-112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | X-Content-Type-Optionsをnosniffに設定 | E-15 (L15-18) | ○ |
| C-50 | X-Frame-OptionsをSAMEORIGINに設定 | E-15 (L21-24) | ○ |
| C-51 | CSPヘッダーを設定 | E-15 (L27-37) | ○ |
| C-52 | Referrer-Policyをno-referrerに設定 | E-15 (L45-49) | ○ |
| C-53 | 既存ヘッダーがある場合追加しない | E-15 (ContainsKeyチェック) | ○ |
| C-54 | ViewResult以外では処理しない | E-15 (L12) `if (result is ViewResult)` | ○ |

### Data - ApplicationDbContext (UT-IDA-113 ~ UT-IDA-114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | IdentityDbContextを継承 | E-25 (L8) | ○ |
| C-56 | OnModelCreatingで基底クラス呼び出し | E-25 (L17) `base.OnModelCreating(builder)` | ○ |

### UsersSeed (UT-IDA-115 ~ UT-IDA-119)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | aliceユーザーの作成ロジック | E-26 (L8-44) | ○ |
| C-58 | bobユーザーの作成ロジック | E-26 (L53-96) | ○ |
| C-59 | CreateAsync失敗時に例外スロー | E-26 (L37) `throw new Exception` | ○ |

### Configuration - Config (UT-IDA-120 ~ UT-IDA-127)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | GetApisでorders/basket/webhooks返却 | E-27 (L8-13) | ○ |
| C-61 | GetApiScopesでorders/basket/webhooks返却 | E-27 (L18-25) | ○ |
| C-62 | GetResourcesでOpenId/Profile返却 | E-27 (L30-36) | ○ |
| C-63 | GetClientsで複数クライアント設定 | E-27 (L40-189) | ○ |
| C-64 | mauiクライアントはCode grant type | E-27 (L48) | ○ |
| C-65 | AccessTokenLifetimeは2時間(7200秒) | E-27 (L73,109,141) | ○ |

### ViewModels (UT-IDA-128 ~ UT-IDA-146)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | IsExternalLoginOnlyの判定ロジック | E-18 (L15) | ○ |
| C-67 | ExternalLoginSchemeの取得ロジック | E-18 (L16) | ○ |
| C-68 | ProcessConsentResultのプロパティ | E-20 (L8-16) | ○ |
| C-69 | DiagnosticsViewModelのclient_listデコード | E-22 (L16-22) | ○ |
| C-70 | ErrorViewModelのコンストラクタ | E-23 (L8-17) | ○ |
| C-71 | AccountOptionsのデフォルト値 | E-16 (L8-15) | ○ |
| C-72 | ConsentOptionsのデフォルト値 | E-17 (L9-14) | ○ |

### 根拠不足の項目
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | UT-IDA-048: 不正returnURLで例外スローの詳細挙動 | 実装に依存 | △ |
| C-74 | UT-IDA-059: Challenge時の不正URL処理 | 実装に依存 | △ |
| C-75 | UT-IDA-101: 本番環境でのエラー非表示ポリシー | セキュリティポリシー依存 | △ |
| C-76 | UT-IDA-097: DiagnosticsのIP制限動作 | 環境依存 | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ関連の詳細な動作仕様書が存在しない
  - 候補：セキュリティ設計書 / IdentityServer4公式ドキュメント / 脅威モデリング文書
- 本番環境と開発環境の環境変数や設定の違いに関するドキュメントがない
  - 候補：環境設定書 / デプロイメントガイド / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: ViewModelプロパティテスト、設定値確認テスト
- **1（中リスク）**: リダイレクトサービスのURL処理、外部認証の自動プロビジョニング
- **2（高リスク）**: 認証・認可関連（ログイン成功/失敗、アクセス制御）、セキュリティヘッダー設定

## 6) レビュアーチェックリスト（最小）
- [ ] 認証関連テストケース（UT-IDA-029〜035, UT-IDA-045〜048）が実際の認証フローをカバーしているか確認
- [ ] セキュリティヘッダー関連テストケース（UT-IDA-106〜112）がOWASP推奨事項を満たしているか確認
- [ ] 外部認証のテストケース（UT-IDA-057〜070）がOAuth2/OIDCフローを正しくカバーしているか確認
- [ ] バリデーションエラーテスト（UT-IDA-004〜005）が正規表現パターンと一致しているか確認
- [ ] 不正URL処理のテストケース（UT-IDA-048, UT-IDA-059）がセキュリティ要件を満たしているか確認
- [ ] シードデータテスト（UT-IDA-115〜119）が実際の初期化要件と一致しているか確認
