---
generated_at: 2026-01-14 10:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 50
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：IntegrationEventLogEF 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：50 / 50、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全てのテストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/eShop-main/src/IntegrationEventLogEF/IntegrationEventLogEntry.cs`
- E-02: `/Users/tomokababa/Work/route06/eShop-main/src/IntegrationEventLogEF/Services/IntegrationEventLogService.cs`
- E-03: `/Users/tomokababa/Work/route06/eShop-main/src/IntegrationEventLogEF/Services/IIntegrationEventLogService.cs`
- E-04: `/Users/tomokababa/Work/route06/eShop-main/src/IntegrationEventLogEF/Utilities/ResilientTransaction.cs`
- E-05: `/Users/tomokababa/Work/route06/eShop-main/src/IntegrationEventLogEF/IntegrationLogExtensions.cs`
- E-06: `/Users/tomokababa/Work/route06/eShop-main/src/IntegrationEventLogEF/EventStateEnum.cs`
- E-07: `/Users/tomokababa/Work/route06/eShop-main/src/IntegrationEventLogEF/GlobalUsings.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### IntegrationEventLogEntry クラス（UT-IEL-001〜012, 050）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでEventId, State, TimesSentが正しく初期化される | E-01 (行11-20) | ○ |
| C-02 | ContentがJSON形式でシリアライズされる | E-01 (行16: JsonSerializer.Serialize) | ○ |
| C-03 | EventTypeNameがFullNameで設定される | E-01 (行15: @event.GetType().FullName) | ○ |
| C-04 | CreationTimeがイベントのCreationDateと一致する | E-01 (行14: CreationTime = @event.CreationDate) | ○ |
| C-05 | EventTypeShortNameがSplit('.')?.Last()で取得される | E-01 (行25) | ○ |
| C-06 | EventTypeNameがドットを含まない場合も動作する | E-01 (行25: Split演算子の挙動) | ○ |
| C-07 | DeserializeJsonContentでJSONがデシリアライズされる | E-01 (行35-39) | ○ |
| C-08 | DeserializeJsonContentがthisを返却する | E-01 (行38: return this) | ○ |
| C-09 | 不正なJSONの場合の異常系 | E-01 (行37: JsonSerializer.Deserializeの挙動) | ○ |
| C-10 | 型が一致しない場合の異常系 | E-01 (行37: as IntegrationEventの挙動) | ○ |
| C-11 | Stateプロパティがget/setを持つ | E-01 (行28: public set) | ○ |
| C-12 | TimesSentプロパティがget/setを持つ | E-01 (行29: public set) | ○ |
| C-50 | EventTypeNameがnullの場合の挙動 | E-01 (行25: Null参照の可能性) | ○ |

### IntegrationEventLogService クラス（UT-IEL-013〜036）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | コンストラクタでDbContextが設定される | E-02 (行10-17) | ○ |
| C-14 | エントリーアセンブリからIntegrationEvent型が収集される | E-02 (行13-16: Assembly.Load, Where, ToArray) | ○ |
| C-15 | RetrieveEventLogsPendingToPublishAsyncで未発行イベントが取得される | E-02 (行19-32) | ○ |
| C-16 | CreationTime順にソートされる | E-02 (行27: OrderBy(o => o.CreationTime)) | ○ |
| C-17 | 各イベントがDeserializeされる | E-02 (行28: DeserializeJsonContent呼び出し) | ○ |
| C-18 | 該当イベントがない場合に空コレクションが返却される | E-02 (行31: return []) | ○ |
| C-19 | InProgress状態のイベントは取得されない | E-02 (行22: State == EventStateEnum.NotPublished) | ○ |
| C-20 | Published状態のイベントは取得されない | E-02 (行22: State == EventStateEnum.NotPublished) | ○ |
| C-21 | SaveEventAsyncでイベントが保存される | E-02 (行34-44) | ○ |
| C-22 | トランザクションが正しく使用される | E-02 (行40: UseTransaction) | ○ |
| C-23 | transactionがnullの場合にArgumentNullExceptionがスローされる | E-02 (行36: throw new ArgumentNullException) | ○ |
| C-24 | MarkEventAsPublishedAsyncでStateがPublishedに更新される | E-02 (行46-49, 61-70) | ○ |
| C-25 | MarkEventAsPublishedAsyncでTimesSentがインクリメントされない | E-02 (行66-67: if条件による制御) | ○ |
| C-26 | 存在しないEventIdの場合に例外がスローされる | E-02 (行63: Single演算子の挙動) | ○ |
| C-27 | MarkEventAsInProgressAsyncでStateがInProgressに更新される | E-02 (行51-54, 61-70) | ○ |
| C-28 | MarkEventAsInProgressAsyncでTimesSentがインクリメントされる | E-02 (行66-67: if (status == InProgress) TimesSent++) | ○ |
| C-29 | 複数回呼び出し時にTimesSentが累積する | E-02 (行67: TimesSent++) | ○ |
| C-30 | MarkEventAsInProgressAsyncで存在しないEventIdの場合に例外がスローされる | E-02 (行63: Single演算子の挙動) | ○ |
| C-31 | MarkEventAsFailedAsyncでStateがPublishedFailedに更新される | E-02 (行56-59, 61-70) | ○ |
| C-32 | MarkEventAsFailedAsyncでTimesSentがインクリメントされない | E-02 (行66-67: if条件による制御) | ○ |
| C-33 | MarkEventAsFailedAsyncで存在しないEventIdの場合に例外がスローされる | E-02 (行63: Single演算子の挙動) | ○ |
| C-34 | DisposeでDbContextが破棄される | E-02 (行72-84) | ○ |
| C-35 | 複数回Disposeしても例外が発生しない | E-02 (行74: if (!_disposedValue)) | ○ |
| C-36 | GC.SuppressFinalizeが呼び出される | E-02 (行89: GC.SuppressFinalize(this)) | ○ |

### ResilientTransaction クラス（UT-IEL-037〜043）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | NewでDbContextから新しいインスタンスが作成される | E-04 (行9: public static ResilientTransaction New) | ○ |
| C-38 | contextがnullの場合にArgumentNullExceptionがスローされる | E-04 (行7: throw new ArgumentNullException) | ○ |
| C-39 | ExecuteAsyncでactionが実行される | E-04 (行11-22) | ○ |
| C-40 | トランザクションがコミットされる | E-04 (行20: await transaction.CommitAsync()) | ○ |
| C-41 | ExecutionStrategyが使用される | E-04 (行15: CreateExecutionStrategy) | ○ |
| C-42 | 例外発生時にトランザクションがロールバックされる | E-04 (行18-21: usingブロック内でのトランザクション管理) | ○ |
| C-43 | 一時的なエラー時にリトライされる | E-04 (行16: strategy.ExecuteAsync) | ○ |

### IntegrationLogExtensions クラス（UT-IEL-044〜045）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | IntegrationEventLogテーブルが設定される | E-05 (行9: ToTable("IntegrationEventLog")) | ○ |
| C-45 | EventIdが主キーとして設定される | E-05 (行11: HasKey(e => e.EventId)) | ○ |

### EventStateEnum（UT-IEL-046〜049）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | NotPublishedが0である | E-06 (行5: NotPublished = 0) | ○ |
| C-47 | InProgressが1である | E-06 (行6: InProgress = 1) | ○ |
| C-48 | Publishedが2である | E-06 (行7: Published = 2) | ○ |
| C-49 | PublishedFailedが3である | E-06 (行8: PublishedFailed = 3) | ○ |

## 4) 不足情報（Unknown / Missing）
- **該当なし**：全てのテストケースはソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：IntegrationEventLogEFモジュールは比較的小規模で、全クラスとメソッドが明確に実装されています
- 主要なリスク観点：
  - トランザクション処理（ResilientTransaction）の正確性
  - 状態遷移ロジック（IntegrationEventLogService）の整合性
  - JSON シリアライズ/デシリアライズの堅牢性

## 6) レビュアーチェックリスト（最小）
- [ ] UT-IEL-021〜023: SaveEventAsyncのトランザクション処理が正しく検証されているか
- [ ] UT-IEL-027〜030: MarkEventAsInProgressAsyncのTimesSentインクリメント検証が十分か
- [ ] UT-IEL-039〜043: ResilientTransactionのリトライ・ロールバック検証が適切か
- [ ] UT-IEL-007〜010: DeserializeJsonContentの異常系テストが網羅的か
- [ ] テストID（UT-IEL-xxx）の連番が正しいか
- [ ] 優先度の設定が適切か（金額計算やデータ整合性に関わる部分が「高」になっているか）

## 7) モジュール解析サマリー

### 解析対象ファイル
| ファイル | 説明 | テストケース数 |
|----------|------|---------------|
| IntegrationEventLogEntry.cs | イベントログエントリのエンティティクラス | 13 |
| IntegrationEventLogService.cs | イベントログの永続化サービス | 24 |
| ResilientTransaction.cs | リトライ対応トランザクションユーティリティ | 7 |
| IntegrationLogExtensions.cs | EF Core ModelBuilder拡張 | 2 |
| EventStateEnum.cs | イベント状態の列挙型 | 4 |

### テスト観点別分布
| テスト観点 | 件数 |
|-----------|------|
| 正常系 | 36 |
| 異常系 | 10 |
| 境界値 | 4 |

### 優先度別分布
| 優先度 | 件数 |
|--------|------|
| 高 | 23 |
| 中 | 22 |
| 低 | 5 |
