---
generated_at: 2026-01-14 21:30:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：OrderProcessor単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  1. **GracePeriodManagerService.GetConfirmedGracePeriodOrders**：SQL条件の検証が重要
  2. **GracePeriodManagerService.CheckConfirmedGracePeriodOrders**：イベント発行ロジックの検証
  3. **Extensions.AddApplicationServices**：DI設定の検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/eShop-main/src/OrderProcessor/BackgroundTaskOptions.cs`
- E-02: `/Users/tomokababa/Work/route06/eShop-main/src/OrderProcessor/Events/GracePeriodConfirmedIntegrationEvent.cs`
- E-03: `/Users/tomokababa/Work/route06/eShop-main/src/OrderProcessor/Services/GracePeriodManagerService.cs`
- E-04: `/Users/tomokababa/Work/route06/eShop-main/src/OrderProcessor/Extensions/Extensions.cs`
- E-05: `/Users/tomokababa/Work/route06/eShop-main/src/OrderProcessor/Program.cs`
- E-06: `/Users/tomokababa/Work/route06/eShop-main/src/OrderProcessor/GlobalUsings.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BackgroundTaskOptions.GracePeriodTimeプロパティが存在する | E-01（5行目） | ○ |
| C-02 | BackgroundTaskOptions.CheckUpdateTimeプロパティが存在する | E-01（7行目） | ○ |
| C-03 | GracePeriodConfirmedIntegrationEventがIntegrationEventを継承している | E-02（5行目） | ○ |
| C-04 | GracePeriodConfirmedIntegrationEventがOrderIdプロパティを持つ | E-02（7行目） | ○ |
| C-05 | GracePeriodManagerServiceがBackgroundServiceを継承している | E-03（12行目） | ○ |
| C-06 | GracePeriodManagerServiceコンストラクタでoptionsがnullの場合ArgumentNullExceptionをスローする | E-03（14行目） | ○ |
| C-07 | ExecuteAsyncでCheckUpdateTime間隔で処理を実行する | E-03（18行目、35行目） | ○ |
| C-08 | ExecuteAsyncでstoppingTokenがキャンセルされるまでループする | E-03（26行目） | ○ |
| C-09 | CheckConfirmedGracePeriodOrdersでGracePeriodConfirmedIntegrationEventを発行する | E-03（55行目、59行目） | ○ |
| C-10 | GetConfirmedGracePeriodOrdersでGracePeriod経過かつSubmittedの注文を取得するSQL | E-03（69-73行目） | ○ |
| C-11 | GetConfirmedGracePeriodOrdersでNpgsqlExceptionをキャッチして空リストを返す | E-03（87-92行目） | ○ |
| C-12 | Extensions.AddApplicationServicesでRabbitMqEventBusを設定する | E-04（10-11行目） | ○ |
| C-13 | Extensions.AddApplicationServicesでNpgsqlDataSourceをorderingdbで設定する | E-04（13行目） | ○ |
| C-14 | Extensions.AddApplicationServicesでBackgroundTaskOptionsを設定バインドする | E-04（15-16行目） | ○ |
| C-15 | Extensions.AddApplicationServicesでGracePeriodManagerServiceをHostedServiceとして登録する | E-04（18行目） | ○ |
| C-16 | IntegrationEventContextでGracePeriodConfirmedIntegrationEventがJsonSerializable指定されている | E-04（22-26行目） | ○ |
| C-17 | GracePeriodManagerServiceがIEventBus依存を持つ | E-03（10行目） | ○ |
| C-18 | GracePeriodManagerServiceがILogger依存を持つ | E-03（11行目） | ○ |
| C-19 | GracePeriodManagerServiceがNpgsqlDataSource依存を持つ | E-03（12行目） | ○ |
| C-20 | サービス開始時にDebugログを出力する | E-03（20-24行目） | ○ |
| C-21 | イベント発行時にInformationログを出力する | E-03（57行目） | ○ |
| C-22 | DB接続エラー時にErrorログを出力する | E-03（89行目） | ○ |
| C-23 | Program.csでAddBasicServiceDefaultsを呼び出す | E-05（3行目） | ○ |
| C-24 | Program.csでAddApplicationServicesを呼び出す | E-05（4行目） | ○ |
| C-25 | Program.csでMapDefaultEndpointsを呼び出す | E-05（8行目） | ○ |
| C-26 | GlobalUsingsでServiceDefaultsを参照している | E-06（7行目） | ○ |
| C-27 | GracePeriodTimeをTimeSpan.FromMinutesで変換している | E-03（74行目） | ○ |
| C-28 | CheckUpdateTimeをTimeSpan.FromSecondsで変換している | E-03（18行目） | ○ |
| C-29 | SQLでordering.ordersテーブルを参照している | E-03（71行目） | ○ |
| C-30 | SQLでOrderStatus='Submitted'を条件としている | E-03（72行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのテストケースについてソースコードから直接根拠を確認できた

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて生成されており、推測による記載はない
- 補足事項：
  - SQL文字列のテスト（C-10, C-29, C-30）は統合テストでの検証が望ましい
  - イベントバス連携（C-09, C-12）はモックを使用した単体テストで検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] GracePeriodManagerService.GetConfirmedGracePeriodOrdersのSQL条件が実際のDB構造と一致しているか確認
- [ ] BackgroundTaskOptionsの設定値（GracePeriodTime, CheckUpdateTime）の単位（分/秒）が適切か確認
- [ ] 例外処理テスト（UT-OPR-023, UT-OPR-024）でNpgsqlException以外の例外が発生した場合の挙動を検討
- [ ] 境界値テスト（負の値、0値）で実際にアプリケーションが正常動作するか確認
- [ ] イベント発行テスト（UT-OPR-017）でIEventBusのモック設定が適切か確認
