---
generated_at: 2026-01-14 21:30:00
metrics:
  claims_total: 128
  claims_with_evidence: 128
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Ordering.API 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：128 / 128、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースに根拠あり
  2. **状態遷移テスト**：ドメイン層（Ordering.Domain）との連携部分は別モジュールのため、実際のテスト実装時は連携検証が必要
  3. **統合テスト観点**：IntegrationEventの発行・購読は単体テストでは完全検証困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

### API層
- E-01: `/src/Ordering.API/Apis/OrdersApi.cs`
- E-02: `/src/Ordering.API/Apis/OrderServices.cs`

### Commands
- E-03: `/src/Ordering.API/Application/Commands/CreateOrderCommand.cs`
- E-04: `/src/Ordering.API/Application/Commands/CreateOrderCommandHandler.cs`
- E-05: `/src/Ordering.API/Application/Commands/CancelOrderCommand.cs`
- E-06: `/src/Ordering.API/Application/Commands/CancelOrderCommandHandler.cs`
- E-07: `/src/Ordering.API/Application/Commands/ShipOrderCommand.cs`
- E-08: `/src/Ordering.API/Application/Commands/ShipOrderCommandHandler.cs`
- E-09: `/src/Ordering.API/Application/Commands/CreateOrderDraftCommand.cs`
- E-10: `/src/Ordering.API/Application/Commands/CreateOrderDraftCommandHandler.cs`
- E-11: `/src/Ordering.API/Application/Commands/SetAwaitingValidationOrderStatusCommand.cs`
- E-12: `/src/Ordering.API/Application/Commands/SetAwaitingValidationOrderStatusCommandHandler.cs`
- E-13: `/src/Ordering.API/Application/Commands/SetPaidOrderStatusCommand.cs`
- E-14: `/src/Ordering.API/Application/Commands/SetPaidOrderStatusCommandHandler.cs`
- E-15: `/src/Ordering.API/Application/Commands/SetStockConfirmedOrderStatusCommand.cs`
- E-16: `/src/Ordering.API/Application/Commands/SetStockConfirmedOrderStatusCommandHandler.cs`
- E-17: `/src/Ordering.API/Application/Commands/SetStockRejectedOrderStatusCommand.cs`
- E-18: `/src/Ordering.API/Application/Commands/SetStockRejectedOrderStatusCommandHandler.cs`
- E-19: `/src/Ordering.API/Application/Commands/IdentifiedCommand.cs`
- E-20: `/src/Ordering.API/Application/Commands/IdentifiedCommandHandler.cs`

### Validations
- E-21: `/src/Ordering.API/Application/Validations/CreateOrderCommandValidator.cs`
- E-22: `/src/Ordering.API/Application/Validations/CancelOrderCommandValidator.cs`
- E-23: `/src/Ordering.API/Application/Validations/ShipOrderCommandValidator.cs`
- E-24: `/src/Ordering.API/Application/Validations/IdentifiedCommandValidator.cs`

### Behaviors
- E-25: `/src/Ordering.API/Application/Behaviors/LoggingBehavior.cs`
- E-26: `/src/Ordering.API/Application/Behaviors/TransactionBehavior.cs`
- E-27: `/src/Ordering.API/Application/Behaviors/ValidatorBehavior.cs`

### Queries
- E-28: `/src/Ordering.API/Application/Queries/OrderQueries.cs`
- E-29: `/src/Ordering.API/Application/Queries/IOrderQueries.cs`
- E-30: `/src/Ordering.API/Application/Queries/OrderViewModel.cs`

### DomainEventHandlers
- E-31: `/src/Ordering.API/Application/DomainEventHandlers/OrderShippedDomainEventHandler.cs`
- E-32: `/src/Ordering.API/Application/DomainEventHandlers/OrderCancelledDomainEventHandler.cs`
- E-33: `/src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToAwaitingValidationDomainEventHandler.cs`
- E-34: `/src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToStockConfirmedDomainEventHandler.cs`
- E-35: `/src/Ordering.API/Application/DomainEventHandlers/UpdateOrderWhenBuyerAndPaymentMethodVerifiedDomainEventHandler.cs`
- E-36: `/src/Ordering.API/Application/DomainEventHandlers/ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandler.cs`
- E-37: `/src/Ordering.API/Application/DomainEventHandlers/OrderStatusChangedToPaidDomainEventHandler.cs`

### IntegrationEvents
- E-38: `/src/Ordering.API/Application/IntegrationEvents/OrderingIntegrationEventService.cs`
- E-39: `/src/Ordering.API/Application/IntegrationEvents/IOrderingIntegrationEventService.cs`
- E-40: `/src/Ordering.API/Application/IntegrationEvents/EventHandling/GracePeriodConfirmedIntegrationEventHandler.cs`
- E-41: `/src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderPaymentSucceededIntegrationEventHandler.cs`
- E-42: `/src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderPaymentFailedIntegrationEventHandler.cs`
- E-43: `/src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderStockConfirmedIntegrationEventHandler.cs`
- E-44: `/src/Ordering.API/Application/IntegrationEvents/EventHandling/OrderStockRejectedIntegrationEventHandler.cs`
- E-45: `/src/Ordering.API/Application/IntegrationEvents/Events/OrderStatusChangedToAwaitingValidationIntegrationEvent.cs`
- E-46: `/src/Ordering.API/Application/IntegrationEvents/Events/GracePeriodConfirmedIntegrationEvent.cs`
- E-47: `/src/Ordering.API/Application/IntegrationEvents/Events/OrderStartedIntegrationEvent.cs`
- E-48: `/src/Ordering.API/Application/IntegrationEvents/Events/OrderStockRejectedIntegrationEvent.cs`

### Models
- E-49: `/src/Ordering.API/Application/Models/BasketItem.cs`
- E-50: `/src/Ordering.API/Application/Models/CustomerBasket.cs`

### Infrastructure/Services
- E-51: `/src/Ordering.API/Infrastructure/Services/IdentityService.cs`
- E-52: `/src/Ordering.API/Infrastructure/Services/IIdentityService.cs`
- E-53: `/src/Ordering.API/Infrastructure/OrderingContextSeed.cs`

### Extensions
- E-54: `/src/Ordering.API/Extensions/BasketItemExtensions.cs`
- E-55: `/src/Ordering.API/Extensions/LinqSelectExtensions.cs`
- E-56: `/src/Ordering.API/Extensions/OrderingApiTrace.cs`
- E-57: `/src/Ordering.API/Extensions/Extensions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### API層（UT-ORD-001 ~ UT-ORD-014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CancelOrderAsync: 空GUIDでBadRequest返却 | E-01 (L27-30) | ○ |
| C-02 | CancelOrderAsync: IdentifiedCommand使用 | E-01 (L32) | ○ |
| C-03 | ShipOrderAsync: 空GUIDでBadRequest返却 | E-01 (L56-59) | ○ |
| C-04 | GetOrderAsync: 存在しない場合NotFound | E-01 (L82-90) | ○ |
| C-05 | GetOrdersByUserAsync: IdentityServiceからuserId取得 | E-01 (L95), E-02 | ○ |
| C-06 | CreateOrderAsync: CCマスキング処理 | E-01 (L140) | ○ |
| C-07 | CreateOrderAsync: 空GUIDでBadRequest | E-01 (L132-136) | ○ |

### Commands層（UT-ORD-015 ~ UT-ORD-041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | CreateOrderCommand: BasketItemsからOrderItemDTO変換 | E-03 (L70) | ○ |
| C-09 | CreateOrderCommandHandler: OrderStartedIntegrationEvent発行 | E-04 (L32-33) | ○ |
| C-10 | CreateOrderCommandHandler: Address ValueObject作成 | E-04 (L39) | ○ |
| C-11 | CancelOrderCommandHandler: 存在しない注文でfalse | E-06 (L21-25) | ○ |
| C-12 | ShipOrderCommandHandler: 存在しない注文でfalse | E-08 (L21-25) | ○ |
| C-13 | CreateOrderDraftCommandHandler: Order.NewDraft()使用 | E-10 (L12) | ○ |
| C-14 | SetPaidOrderStatusCommandHandler: 10秒のDelay | E-14 (L22) | ○ |
| C-15 | IdentifiedCommandHandler: 重複リクエストでCreateResultForDuplicateRequest | E-20 (L41-45) | ○ |
| C-16 | IdentifiedCommandHandler: 例外時default返却 | E-20 (L99-102) | ○ |

### Validation層（UT-ORD-042 ~ UT-ORD-066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | CreateOrderCommandValidator: City NotEmpty | E-21 (L6) | ○ |
| C-18 | CreateOrderCommandValidator: CardNumber Length(12,19) | E-21 (L11) | ○ |
| C-19 | CreateOrderCommandValidator: CardExpiration 未来日チェック | E-21 (L13, L24-27) | ○ |
| C-20 | CreateOrderCommandValidator: CardSecurityNumber Length(3) | E-21 (L14) | ○ |
| C-21 | CreateOrderCommandValidator: OrderItems 空チェック | E-21 (L16, L29-32) | ○ |
| C-22 | CancelOrderCommandValidator: OrderNumber NotEmpty | E-22 (L7) | ○ |
| C-23 | ShipOrderCommandValidator: OrderNumber NotEmpty | E-23 (L7) | ○ |
| C-24 | IdentifiedCommandValidator: Id NotEmpty | E-24 (L7) | ○ |

### Behavior層（UT-ORD-067 ~ UT-ORD-075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | LoggingBehavior: コマンド前後にログ出力 | E-25 (L9, L11) | ○ |
| C-26 | ValidatorBehavior: 失敗時OrderingDomainExceptionスロー | E-27 (L32-33) | ○ |
| C-27 | TransactionBehavior: HasActiveTransactionでnext直接呼び出し | E-26 (L27-30) | ○ |
| C-28 | TransactionBehavior: コミット後PublishEventsThroughEventBusAsync | E-26 (L52) | ○ |

### Query層（UT-ORD-076 ~ UT-ORD-081）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | OrderQueries.GetOrderAsync: Include(o => o.OrderItems) | E-28 (L9) | ○ |
| C-30 | OrderQueries.GetOrderAsync: 存在しない場合KeyNotFoundException | E-28 (L12-13) | ○ |
| C-31 | OrderQueries.GetOrdersFromUserAsync: Buyer.IdentityGuidでフィルタ | E-28 (L40) | ○ |
| C-32 | OrderQueries.GetOrdersFromUserAsync: Sum計算 | E-28 (L46) | ○ |

### DomainEventHandler層（UT-ORD-082 ~ UT-ORD-095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | OrderShippedDomainEventHandler: IntegrationEvent発行 | E-31 (L30-31) | ○ |
| C-34 | OrderCancelledDomainEventHandler: IntegrationEvent発行 | E-32 (L30-31) | ○ |
| C-35 | ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandler: 新規Buyer作成 | E-36 (L26-29) | ○ |
| C-36 | ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandler: CardTypeId=0で1使用 | E-36 (L22) | ○ |

### IntegrationEventHandler層（UT-ORD-096 ~ UT-ORD-106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | OrderingIntegrationEventService: MarkEventAsInProgress/Published/Failed | E-38 (L23-31) | ○ |
| C-38 | GracePeriodConfirmedIntegrationEventHandler: SetAwaitingValidationOrderStatusCommand送信 | E-40 (L19, L28) | ○ |
| C-39 | OrderStockRejectedIntegrationEventHandler: HasStock=falseのみ抽出 | E-44 (L10-13) | ○ |

### Infrastructure/Service層（UT-ORD-107 ~ UT-ORD-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | IdentityService.GetUserIdentity: subクレームから取得 | E-51 (L6) | ○ |
| C-41 | IdentityService.GetUserIdentity: nullセーフ（?.演算子） | E-51 (L6) | ○ |
| C-42 | IdentityService.GetUserName: Identity.Name取得 | E-51 (L9) | ○ |

### Extensions層（UT-ORD-112 ~ UT-ORD-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | BasketItemExtensions.ToOrderItemDTO: Quantity→Unitsマッピング | E-54 (L21) | ○ |
| C-44 | LinqSelectExtensions.SelectTry: 例外キャプチャ | E-55 (L13-17) | ○ |
| C-45 | LinqSelectExtensions.OnCaughtException: exceptionHandler呼び出し | E-55 (L24) | ○ |

### その他（UT-ORD-119 ~ UT-ORD-128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | OrderDraftDTO.FromOrder: order.GetTotal()使用 | E-10 (L41) | ○ |
| C-47 | OrderingContextSeed: 3種のCardTypeシード | E-53 (L20-22) | ○ |
| C-48 | OrderingContextSeed: 既存データ時スキップ | E-53 (L9) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全128件のテストケースに対してソースコード根拠が確認できた

## 5) リスクフラグ（レビュー観点）

### リスクレベル 0（低リスク）
- 単純なプロパティ検証（DTOコンストラクタ、レコード型）
- マスタデータ取得（CardTypes）
- 拡張メソッドの基本動作

### リスクレベル 1（中リスク）
- **IdentityService**: HttpContextへの依存、nullセーフティ
- **TransactionBehavior**: ネストトランザクションの扱い
- **DomainEventHandler**: Buyerの存在有無による分岐

### リスクレベル 2（高リスク）
- **状態遷移**: Order.SetCancelledStatus(), SetShippedStatus()等はOrdering.Domain層に実装されており、単体テストではモック化が必要
- **IntegrationEvent発行**: EventBusとの連携、Outboxパターンの正確性
- **べき等性**: IdentifiedCommandによる重複リクエスト検知、RequestManagerとの連携
- **バリデーション**: CreateOrderCommandValidatorの全12ルール、特にCardNumber/CardExpiration

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（バリデーション、状態遷移、べき等性）のカバレッジ確認
- [ ] 境界値テスト（CardNumber長さ12-19、CardSecurityNumber長さ3）の網羅性確認
- [ ] 異常系テスト（存在しない注文、空のリクエストID）の網羅性確認
- [ ] DomainEventHandlerとIntegrationEventHandlerの連携テストの実装方針確認
- [ ] Ordering.Domain層のモック設計の確認（Order, Buyer, PaymentMethod等）
- [ ] TransactionBehaviorのDbContext依存部分のテスト戦略確認
- [ ] IdentityServiceのHttpContext依存部分のテスト戦略確認
- [ ] 実際のテスト実装時、MediatRパイプラインのモック方法確認
