---
generated_at: 2026-01-14 12:00:00
metrics:
  claims_total: 77
  claims_with_evidence: 77
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Ordering.Domain 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：77 / 77、根拠なし：0
- 優先レビュー（高）
  1. **状態遷移テスト（UT-ORD-008〜020）**：複雑な状態遷移ロジックの網羅性確認推奨
  2. **金額計算テスト（UT-ORD-021〜022）**：GetTotalメソッドの割引適用有無の確認
  3. **バリデーションテスト（UT-ORD-025〜027, 044〜048）**：境界値の追加検討推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs`
- E-02: `src/Ordering.Domain/AggregatesModel/OrderAggregate/OrderItem.cs`
- E-03: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Address.cs`
- E-04: `src/Ordering.Domain/AggregatesModel/OrderAggregate/OrderStatus.cs`
- E-05: `src/Ordering.Domain/AggregatesModel/OrderAggregate/IOrderRepository.cs`
- E-06: `src/Ordering.Domain/AggregatesModel/BuyerAggregate/Buyer.cs`
- E-07: `src/Ordering.Domain/AggregatesModel/BuyerAggregate/PaymentMethod.cs`
- E-08: `src/Ordering.Domain/AggregatesModel/BuyerAggregate/CardType.cs`
- E-09: `src/Ordering.Domain/AggregatesModel/BuyerAggregate/IBuyerRepository.cs`
- E-10: `src/Ordering.Domain/SeedWork/Entity.cs`
- E-11: `src/Ordering.Domain/SeedWork/ValueObject.cs`
- E-12: `src/Ordering.Domain/SeedWork/IAggregateRoot.cs`
- E-13: `src/Ordering.Domain/SeedWork/IRepository.cs`
- E-14: `src/Ordering.Domain/SeedWork/IUnitOfWork.cs`
- E-15: `src/Ordering.Domain/Exceptions/OrderingDomainException.cs`
- E-16: `src/Ordering.Domain/Events/OrderStartedDomainEvent.cs`
- E-17: `src/Ordering.Domain/Events/OrderShippedDomainEvent.cs`
- E-18: `src/Ordering.Domain/Events/OrderCancelledDomainEvent.cs`
- E-19: `src/Ordering.Domain/Events/OrderStatusChangedToAwaitingValidationDomainEvent.cs`
- E-20: `src/Ordering.Domain/Events/OrderStatusChangedToPaidDomainEvent.cs`
- E-21: `src/Ordering.Domain/Events/OrderStatusChangedToStockConfirmedDomainEvent.cs`
- E-22: `src/Ordering.Domain/Events/BuyerPaymentMethodVerifiedDomainEvent.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Order クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規注文がコンストラクタで正常に作成される | E-01 L52-65 | ○ |
| C-02 | OrderStartedDomainEventがコンストラクタで発行される | E-01 L63-64, L170-178 | ○ |
| C-03 | NewDraftでドラフト注文が作成される | E-01 L37-44 | ○ |
| C-04 | AddOrderItemで新規商品が追加される | E-01 L71-91 | ○ |
| C-05 | AddOrderItemで同一商品の数量が加算される | E-01 L73-83 | ○ |
| C-06 | AddOrderItemでより高い割引率が適用される | E-01 L78-81 | ○ |
| C-07 | SetPaymentMethodVerifiedで支払方法が設定される | E-01 L93-97 | ○ |
| C-08 | SetAwaitingValidationStatusでステータス変更される | E-01 L99-106 | ○ |
| C-09 | SetAwaitingValidationStatusでSubmitted以外は変更されない | E-01 L101 | ○ |
| C-10 | SetStockConfirmedStatusでステータス変更される | E-01 L108-117 | ○ |
| C-11 | SetStockConfirmedStatusでAwaitingValidation以外は変更されない | E-01 L110 | ○ |
| C-12 | SetPaidStatusでステータス変更される | E-01 L119-128 | ○ |
| C-13 | SetPaidStatusでStockConfirmed以外は変更されない | E-01 L121 | ○ |
| C-14 | SetShippedStatusでステータス変更される | E-01 L130-140 | ○ |
| C-15 | SetShippedStatusでPaid以外は例外がスローされる | E-01 L132-135 | ○ |
| C-16 | SetCancelledStatusでキャンセル可能ステータスから変更される | E-01 L142-153 | ○ |
| C-17 | SetCancelledStatusでPaidは例外 | E-01 L144-148 | ○ |
| C-18 | SetCancelledStatusでShippedは例外 | E-01 L144-148 | ○ |
| C-19 | SetCancelledStatusWhenStockIsRejectedで在庫不足時キャンセル | E-01 L155-168 | ○ |
| C-20 | SetCancelledStatusWhenStockIsRejectedでAwaitingValidation以外は変更されない | E-01 L157 | ○ |
| C-21 | GetTotalで合計金額が計算される | E-01 L185 | ○ |
| C-22 | GetTotalで空の場合0が返される | E-01 L185 | ○ |
| C-23 | OrderItemsが読み取り専用コレクション | E-01 L33 | ○ |

### OrderItem クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | コンストラクタで正常に作成される | E-02 L23-42 | ○ |
| C-25 | units<=0で例外 | E-02 L25-28 | ○ |
| C-26 | units=-1で例外 | E-02 L25-28 | ○ |
| C-27 | 割引が合計より大きい場合例外 | E-02 L30-33 | ○ |
| C-28 | SetNewDiscountで割引が設定される | E-02 L44-52 | ○ |
| C-29 | SetNewDiscountで0が設定できる | E-02 L46-49 | ○ |
| C-30 | SetNewDiscountで負の値は例外 | E-02 L46-49 | ○ |
| C-31 | AddUnitsで数量が加算される | E-02 L54-62 | ○ |
| C-32 | AddUnitsで0を加算しても変更なし | E-02 L56-59 | ○ |
| C-33 | AddUnitsで負の値は例外 | E-02 L56-59 | ○ |

### Address クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | コンストラクタで正常に作成される | E-03 L15-22 | ○ |
| C-35 | 同一値で等価判定される | E-03 L24-32 | ○ |
| C-36 | 異なる値で非等価判定される | E-03 L24-32 | ○ |

### Buyer クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | コンストラクタで正常に作成される | E-06 L23-27 | ○ |
| C-38 | 空のidentityで例外 | E-06 L25 | ○ |
| C-39 | 空のnameで例外 | E-06 L26 | ○ |
| C-40 | nullのidentityで例外 | E-06 L25 | ○ |
| C-41 | VerifyOrAddPaymentMethodで新規追加 | E-06 L29-50 | ○ |
| C-42 | VerifyOrAddPaymentMethodで既存返却 | E-06 L33-40 | ○ |
| C-43 | PaymentMethodsが読み取り専用 | E-06 L15 | ○ |

### PaymentMethod クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | コンストラクタで正常に作成される | E-07 L21-35 | ○ |
| C-45 | 空のcardNumberで例外 | E-07 L23 | ○ |
| C-46 | 空のsecurityNumberで例外 | E-07 L24 | ○ |
| C-47 | 空のcardHolderNameで例外 | E-07 L25 | ○ |
| C-48 | 過去の有効期限で例外 | E-07 L27-30 | ○ |
| C-49 | IsEqualToで同一カードでtrue | E-07 L37-42 | ○ |
| C-50 | IsEqualToで異なるカードでfalse | E-07 L37-42 | ○ |

### Entity クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | AddDomainEventでイベント追加 | E-10 L22-26 | ○ |
| C-52 | RemoveDomainEventでイベント削除 | E-10 L28-31 | ○ |
| C-53 | ClearDomainEventsでクリア | E-10 L33-36 | ○ |
| C-54 | IsTransientでId=0はtrue | E-10 L38-41 | ○ |
| C-55 | IsTransientでId>0はfalse | E-10 L38-41 | ○ |
| C-56 | Equalsで同一Idはtrue | E-10 L43-60 | ○ |
| C-57 | Equalsで異なるIdはfalse | E-10 L43-60 | ○ |
| C-58 | Equalsでnullはfalse | E-10 L45-46 | ○ |
| C-59 | Equalsで両方Transientはfalse | E-10 L56-57 | ○ |
| C-60 | GetHashCodeで一貫した値 | E-10 L62-74 | ○ |
| C-61 | ==演算子で同一Idはtrue | E-10 L75-81 | ○ |
| C-62 | !=演算子で異なるIdはtrue | E-10 L82-86 | ○ |

### ValueObject クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | Equalsで同一コンポーネントは等価 | E-11 L21-31 | ○ |
| C-64 | Equalsで異なるコンポーネントは非等価 | E-11 L21-31 | ○ |
| C-65 | GetHashCodeで同一値は同一ハッシュ | E-11 L33-38 | ○ |
| C-66 | GetCopyでシャローコピー作成 | E-11 L40-43 | ○ |

### OrderingDomainException クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | デフォルトコンストラクタで作成 | E-15 L8-9 | ○ |
| C-68 | メッセージ付きで作成 | E-15 L11-13 | ○ |
| C-69 | 内部例外付きで作成 | E-15 L15-17 | ○ |

### Domain Events
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | OrderStartedDomainEventが正常作成 | E-16 L7-15 | ○ |
| C-71 | OrderShippedDomainEventが正常作成 | E-17 L3-11 | ○ |
| C-72 | OrderCancelledDomainEventが正常作成 | E-18 L3-11 | ○ |
| C-73 | OrderStatusChangedToAwaitingValidationDomainEventが正常作成 | E-19 L6-18 | ○ |
| C-74 | OrderStatusChangedToPaidDomainEventが正常作成 | E-20 L6-18 | ○ |
| C-75 | OrderStatusChangedToStockConfirmedDomainEventが正常作成 | E-21 L6-13 | ○ |
| C-76 | BuyerAndPaymentMethodVerifiedDomainEventが正常作成 | E-22 L3-16 | ○ |

### CardType クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | IdとNameが設定できる | E-08 L3-7 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全てのテストケースはソースコードから直接抽出されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて生成されています
- 以下の点は追加検討を推奨：
  - GetTotalメソッドが割引（Discount）を計算に含めていない点（コード上はUnitPrice * Unitsのみ）
  - OrderStatusの状態遷移の網羅性（全遷移パターンの確認）
  - PaymentMethodの有効期限チェックが `DateTime.UtcNow` との比較で境界値の扱い

## 6) レビュアーチェックリスト（最小）
- [ ] 状態遷移テスト（UT-ORD-008〜020）の網羅性を確認
- [ ] GetTotalメソッドの割引計算仕様を確認（現在は割引を含めずに計算）
- [ ] PaymentMethodの有効期限境界値（当日の扱い）を確認
- [ ] 同一商品追加時の割引更新ロジック（より高い場合のみ）の仕様確認
- [ ] Buyerコンストラクタの空白文字列（スペースのみ）の扱いを確認
