---
generated_at: 2026-01-14 22:30:00
metrics:
  claims_total: 91
  claims_with_evidence: 91
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Ordering.Infrastructure 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：91 / 91、根拠なし：0
- 優先レビュー（高）
  1. **トランザクション管理のテストケース（UT-ORD-INF-012〜022）**：実際のDBを使用した統合テストが必要かもしれない
  2. **Entity Framework Core設定のテストケース（UT-ORD-INF-061〜091）**：Model構成の検証方法についてレビュー推奨
  3. **MediatorExtensionのテストケース（UT-ORD-INF-023〜027）**：モック戦略の妥当性を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Ordering.Infrastructure/OrderingContext.cs`
- E-02: `src/Ordering.Infrastructure/MediatorExtension.cs`
- E-03: `src/Ordering.Infrastructure/GlobalUsings.cs`
- E-04: `src/Ordering.Infrastructure/Idempotency/ClientRequest.cs`
- E-05: `src/Ordering.Infrastructure/Idempotency/IRequestManager.cs`
- E-06: `src/Ordering.Infrastructure/Idempotency/RequestManager.cs`
- E-07: `src/Ordering.Infrastructure/Repositories/BuyerRepository.cs`
- E-08: `src/Ordering.Infrastructure/Repositories/OrderRepository.cs`
- E-09: `src/Ordering.Infrastructure/EntityConfigurations/OrderEntityTypeConfiguration.cs`
- E-10: `src/Ordering.Infrastructure/EntityConfigurations/OrderItemEntityTypeConfiguration.cs`
- E-11: `src/Ordering.Infrastructure/EntityConfigurations/BuyerEntityTypeConfiguration.cs`
- E-12: `src/Ordering.Infrastructure/EntityConfigurations/PaymentMethodEntityTypeConfiguration.cs`
- E-13: `src/Ordering.Infrastructure/EntityConfigurations/CardTypeEntityTypeConfiguration.cs`
- E-14: `src/Ordering.Infrastructure/EntityConfigurations/ClientRequestEntityTypeConfiguration.cs`
- E-15: `src/Ordering.Domain/AggregatesModel/BuyerAggregate/IBuyerRepository.cs`
- E-16: `src/Ordering.Domain/AggregatesModel/OrderAggregate/IOrderRepository.cs`
- E-17: `src/Ordering.Domain/SeedWork/IUnitOfWork.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### OrderingContext（UT-ORD-INF-001〜022）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DbContextOptionsのみでインスタンス生成できること | E-01 (行21) | ○ |
| C-02 | DbContextOptionsとMediatorでインスタンス生成できること | E-01 (行27-33) | ○ |
| C-03 | Mediatorがnullの場合ArgumentNullExceptionがスローされること | E-01 (行29: `_mediator = mediator ?? throw new ArgumentNullException`) | ○ |
| C-04 | 現在のトランザクションを取得できること | E-01 (行23: `GetCurrentTransaction()`) | ○ |
| C-05 | トランザクション未開始時にnullが返されること | E-01 (行19, 23: `_currentTransaction`初期値はnull) | ○ |
| C-06 | アクティブトランザクション存在時にtrueが返されること | E-01 (行25: `HasActiveTransaction => _currentTransaction != null`) | ○ |
| C-07 | アクティブトランザクション未存在時にfalseが返されること | E-01 (行25) | ○ |
| C-08 | デフォルトスキーマがorderingに設定されること | E-01 (行37: `modelBuilder.HasDefaultSchema("ordering")`) | ○ |
| C-09 | すべてのEntityTypeConfigurationが適用されること | E-01 (行38-44: 6つのApplyConfiguration呼び出し) | ○ |
| C-10 | ドメインイベントがディスパッチされエンティティが保存されること | E-01 (行47-62: `SaveEntitiesAsync`) | ○ |
| C-11 | ドメインイベントがない場合も正常に保存されること | E-01 (行55, 59) | ○ |
| C-12 | 新規トランザクションを開始できること | E-01 (行64-71: `BeginTransactionAsync`) | ○ |
| C-13 | 既存トランザクション存在時にnullが返されること | E-01 (行66: `if (_currentTransaction != null) return null`) | ○ |
| C-14 | ReadCommitted分離レベルでトランザクションが開始されること | E-01 (行68: `IsolationLevel.ReadCommitted`) | ○ |
| C-15 | トランザクションが正常にコミットされること | E-01 (行73-96: `CommitTransactionAsync`) | ○ |
| C-16 | nullトランザクションでArgumentNullExceptionがスローされること | E-01 (行75: `throw new ArgumentNullException`) | ○ |
| C-17 | 異なるトランザクションでInvalidOperationExceptionがスローされること | E-01 (行76: `throw new InvalidOperationException`) | ○ |
| C-18 | SaveChanges失敗時にロールバックされ例外が再スローされること | E-01 (行83-87: catch内でRollbackTransaction呼び出し) | ○ |
| C-19 | コミット成功後にトランザクションがクリアされること | E-01 (行88-95: finally内でDispose) | ○ |
| C-20 | トランザクションがロールバックされること | E-01 (行98-111: `RollbackTransaction`) | ○ |
| C-21 | ロールバック後にトランザクションがクリアされること | E-01 (行104-110: finally内でDispose) | ○ |
| C-22 | トランザクション未開始時でも例外なく処理されること | E-01 (行102: `_currentTransaction?.Rollback()` null条件演算子使用) | ○ |

### MediatorExtension（UT-ORD-INF-023〜027）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | ドメインイベントを持つエンティティのイベントがパブリッシュされること | E-02 (行5-20) | ○ |
| C-24 | パブリッシュ後にドメインイベントがクリアされること | E-02 (行15-16: `ClearDomainEvents()`) | ○ |
| C-25 | ドメインイベントがないエンティティでは何もパブリッシュされないこと | E-02 (行9: Whereフィルター) | ○ |
| C-26 | DomainEventsがnullのエンティティでは何もパブリッシュされないこと | E-02 (行9: `x.Entity.DomainEvents != null`) | ○ |
| C-27 | 複数エンティティのイベントがすべてパブリッシュされること | E-02 (行18-19: foreachループ) | ○ |

### ClientRequest/RequestManager（UT-ORD-INF-028〜038）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | Id/Name/Timeプロパティが正しく設定・取得できること | E-04 (行7-10) | ○ |
| C-29 | Nameが必須属性であること | E-04 (行8: `[Required]`) | ○ |
| C-30 | 有効なOrderingContextでインスタンス生成できること | E-06 (行7-10) | ○ |
| C-31 | nullコンテキストでArgumentNullExceptionがスローされること | E-06 (行9: `?? throw new ArgumentNullException`) | ○ |
| C-32 | 存在するリクエストIDでtrueが返されること | E-06 (行13-18: `ExistAsync`) | ○ |
| C-33 | 存在しないリクエストIDでfalseが返されること | E-06 (行18: `return request != null`) | ○ |
| C-34 | Guid.EmptyでもClientRequestを検索できること | E-06 (行15-16: `FindAsync<ClientRequest>(id)`) | ○ |
| C-35 | 新規リクエストが正しく作成されること | E-06 (行21-37: `CreateRequestForCommandAsync`) | ○ |
| C-36 | 作成されたリクエストのNameがコマンド型名になること | E-06 (行30: `Name = typeof(T).Name`) | ○ |
| C-37 | 作成されたリクエストのTimeがUTC現在時刻になること | E-06 (行31: `Time = DateTime.UtcNow`) | ○ |
| C-38 | 既存IDでOrderingDomainExceptionがスローされること | E-06 (行26: `throw new OrderingDomainException`) | ○ |

### BuyerRepository（UT-ORD-INF-039〜052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | 有効なOrderingContextでインスタンス生成できること | E-07 (行9-12) | ○ |
| C-40 | nullコンテキストでArgumentNullExceptionがスローされること | E-07 (行11: `?? throw new ArgumentNullException`) | ○ |
| C-41 | OrderingContextがUnitOfWorkとして返されること | E-07 (行7: `UnitOfWork => _context`) | ○ |
| C-42 | IsTransient()がtrueのBuyerが追加されること | E-07 (行14-24: `if (buyer.IsTransient())`) | ○ |
| C-43 | IsTransient()がfalseのBuyerはそのまま返されること | E-07 (行23: `return buyer`) | ○ |
| C-44 | Buyerが更新されEntityが返されること | E-07 (行26-31: `Update`) | ○ |
| C-45 | 存在するIdentityGuidでBuyerが取得できること | E-07 (行33-41: `FindAsync`) | ○ |
| C-46 | 存在しないIdentityGuidでnullが返されること | E-07 (行38: `SingleOrDefaultAsync`) | ○ |
| C-47 | PaymentMethodsがIncludeされて取得されること | E-07 (行36: `Include(b => b.PaymentMethods)`) | ○ |
| C-48 | 存在するIdでBuyerが取得できること | E-07 (行43-51: `FindByIdAsync`) | ○ |
| C-49 | 存在しないIdでnullが返されること | E-07 (行48: `SingleOrDefaultAsync`) | ○ |
| C-50 | PaymentMethodsがIncludeされて取得されること（FindByIdAsync） | E-07 (行46: `Include(b => b.PaymentMethods)`) | ○ |
| C-51 | Id=0で検索した場合の挙動 | E-07 (行47: `Where(b => b.Id == id)`) | ○ |
| C-52 | Id=負数で検索した場合の挙動 | E-07 (行47) | ○ |

### OrderRepository（UT-ORD-INF-053〜060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | 有効なOrderingContextでインスタンス生成できること | E-08 (行10-13) | ○ |
| C-54 | nullコンテキストでArgumentNullExceptionがスローされること | E-08 (行12: `?? throw new ArgumentNullException`) | ○ |
| C-55 | OrderingContextがUnitOfWorkとして返されること | E-08 (行8: `UnitOfWork => _context`) | ○ |
| C-56 | Orderが追加されEntityが返されること | E-08 (行15-18: `Add`) | ○ |
| C-57 | 存在するOrderIdでOrderが取得できること | E-08 (行20-32: `GetAsync`) | ○ |
| C-58 | 存在しないOrderIdでnullが返されること | E-08 (行23, 31: `FindAsync`でnullの場合) | ○ |
| C-59 | OrderItemsがロードされて取得されること | E-08 (行27-28: `Collection(i => i.OrderItems).LoadAsync()`) | ○ |
| C-60 | OrderのEntityStateがModifiedに設定されること | E-08 (行34-37: `State = EntityState.Modified`) | ○ |

### EntityConfigurations（UT-ORD-INF-061〜091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | Orderテーブル名がordersに設定されること | E-09 (行7: `ToTable("orders")`) | ○ |
| C-62 | DomainEventsがIgnoreされること（Order） | E-09 (行9: `Ignore(b => b.DomainEvents)`) | ○ |
| C-63 | IdがHiLoシーケンスorderseqを使用すること | E-09 (行11-12: `UseHiLo("orderseq")`) | ○ |
| C-64 | AddressがOwned Entityとして構成されること | E-09 (行15-16: `OwnsOne(o => o.Address)`) | ○ |
| C-65 | OrderStatusが文字列変換され最大長30で設定されること | E-09 (行18-21: `HasConversion<string>()`, `HasMaxLength(30)`) | ○ |
| C-66 | PaymentIdがPaymentMethodIdカラムにマップされること | E-09 (行23-25: `HasColumnName("PaymentMethodId")`) | ○ |
| C-67 | PaymentMethodへの外部キーがRestrict削除で設定されること | E-09 (行27-30: `OnDelete(DeleteBehavior.Restrict)`) | ○ |
| C-68 | Buyerへの外部キーが設定されること | E-09 (行32-34: `HasForeignKey(o => o.BuyerId)`) | ○ |
| C-69 | OrderItemテーブル名がorderItemsに設定されること | E-10 (行8: `ToTable("orderItems")`) | ○ |
| C-70 | DomainEventsがIgnoreされること（OrderItem） | E-10 (行10: `Ignore(b => b.DomainEvents)`) | ○ |
| C-71 | IdがHiLoシーケンスorderitemseqを使用すること | E-10 (行12-13: `UseHiLo("orderitemseq")`) | ○ |
| C-72 | OrderIdシャドウプロパティが設定されること | E-10 (行15: `Property<int>("OrderId")`) | ○ |
| C-73 | Buyerテーブル名がbuyersに設定されること | E-11 (行8: `ToTable("buyers")`) | ○ |
| C-74 | DomainEventsがIgnoreされること（Buyer） | E-11 (行10: `Ignore(b => b.DomainEvents)`) | ○ |
| C-75 | IdがHiLoシーケンスbuyerseqを使用すること | E-11 (行12-13: `UseHiLo("buyerseq")`) | ○ |
| C-76 | IdentityGuidが最大長200で設定されること | E-11 (行15-16: `HasMaxLength(200)`) | ○ |
| C-77 | IdentityGuidにユニークインデックスが設定されること | E-11 (行18-19: `HasIndex("IdentityGuid").IsUnique(true)`) | ○ |
| C-78 | PaymentMethodsへのHasManyリレーションが設定されること | E-11 (行21-22: `HasMany(b => b.PaymentMethods).WithOne()`) | ○ |
| C-79 | PaymentMethodテーブル名がpaymentmethodsに設定されること | E-12 (行8: `ToTable("paymentmethods")`) | ○ |
| C-80 | DomainEventsがIgnoreされること（PaymentMethod） | E-12 (行10: `Ignore(b => b.DomainEvents)`) | ○ |
| C-81 | IdがHiLoシーケンスpaymentseqを使用すること | E-12 (行12-13: `UseHiLo("paymentseq")`) | ○ |
| C-82 | BuyerIdシャドウプロパティが設定されること | E-12 (行15: `Property<int>("BuyerId")`) | ○ |
| C-83 | CardHolderNameが正しくマップされること | E-12 (行17-20) | ○ |
| C-84 | Aliasが正しくマップされること | E-12 (行22-25) | ○ |
| C-85 | CardNumberが必須で最大長25にマップされること | E-12 (行27-31) | ○ |
| C-86 | Expirationが正しくマップされること | E-12 (行33-36) | ○ |
| C-87 | CardTypeへの外部キーが設定されること | E-12 (行42-44) | ○ |
| C-88 | CardTypeテーブル名がcardtypesに設定されること | E-13 (行8: `ToTable("cardtypes")`) | ○ |
| C-89 | IdがValueGeneratedNeverで設定されること | E-13 (行10-11: `ValueGeneratedNever()`) | ○ |
| C-90 | Nameが必須で最大長200に設定されること | E-13 (行13-15: `HasMaxLength(200)`, `IsRequired()`) | ○ |
| C-91 | ClientRequestテーブル名がrequestsに設定されること | E-14 (行8: `ToTable("requests")`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべてのテストケースはソースコードに基づいて生成されており、根拠が存在します。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：すべてのテストケースはソースコードから直接導出されており、高い信頼性があります。
- 注意点：
  - Entity Framework Coreの設定テスト（EntityConfigurations）は、実際のDBスキーマ生成との整合性を別途確認することを推奨
  - トランザクション関連のテストは、モックでの単体テストと実DBでの統合テストの両方が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがIBuyerRepository/IOrderRepositoryインターフェースの全メソッドをカバーしていることを確認
- [ ] IUnitOfWork実装（SaveEntitiesAsync）のテスト戦略が適切か確認
- [ ] トランザクション管理のテストで使用するモック戦略が妥当か確認
- [ ] Entity Framework Core設定のテスト方法（ModelBuilderのモック vs 実DB検証）を検討
- [ ] RequestManager.CreateRequestForCommandAsyncの並行実行時の挙動についてテストケース追加を検討
