---
generated_at: 2026-01-14 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：PaymentProcessor 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. **UT-PAY-001〜003, UT-PAY-008**：支払い処理の核心ロジックであり、テストの正確性を重点確認
  2. **全テストケース**：すべてソースコードから直接導出されており、根拠不足のケースはなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/PaymentProcessor/IntegrationEvents/EventHandling/OrderStatusChangedToStockConfirmedIntegrationEventHandler.cs`
- E-02: `src/PaymentProcessor/PaymentOptions.cs`
- E-03: `src/PaymentProcessor/IntegrationEvents/Events/OrderPaymentSucceededIntegrationEvent.cs`
- E-04: `src/PaymentProcessor/IntegrationEvents/Events/OrderPaymentFailedIntegrationEvent.cs`
- E-05: `src/PaymentProcessor/IntegrationEvents/Events/OrderStatusChangedToStockConfirmedIntegrationEvent.cs`
- E-06: `src/PaymentProcessor/Program.cs`
- E-07: `src/PaymentProcessor/GlobalUsings.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PaymentSucceeded=trueで成功イベント発行 | E-01 (21-23行目: if文でPaymentSucceededを判定しOrderPaymentSucceededIntegrationEventを生成) | ○ |
| C-02 | PaymentSucceeded=falseで失敗イベント発行 | E-01 (24-28行目: else句でOrderPaymentFailedIntegrationEventを生成) | ○ |
| C-03 | OrderIdがイベント間で引き継がれる | E-01 (23,27行目: @event.OrderIdを新イベントのコンストラクタに渡している) | ○ |
| C-04 | ログ出力（受信時） | E-01 (11行目: logger.LogInformation呼び出し) | ○ |
| C-05 | ログ出力（発行時） | E-01 (30行目: logger.LogInformation呼び出し) | ○ |
| C-06 | EventBusがnullの場合の挙動 | E-01 (32行目: eventBus.PublishAsync呼び出し - null checkなし) | ○ |
| C-07 | OptionsMonitorがnullの場合の挙動 | E-01 (21行目: options.CurrentValue参照 - null checkなし) | ○ |
| C-08 | PublishAsync例外の伝播 | E-01 (32行目: try-catchなしでawait呼び出し) | ○ |
| C-09 | OrderId=0の境界値 | E-01, E-05 (intパラメータ、バリデーションなし) | ○ |
| C-10 | OrderId負値の境界値 | E-01, E-05 (intパラメータ、バリデーションなし) | ○ |
| C-11 | OrderId最大値の境界値 | E-01, E-05 (int型のため2147483647まで対応) | ○ |
| C-12 | PaymentOptionsのデフォルト値 | E-02 (bool型のデフォルトはfalse) | ○ |
| C-13 | PaymentSucceeded setter (true) | E-02 (5行目: publicプロパティとして定義) | ○ |
| C-14 | PaymentSucceeded setter (false) | E-02 (5行目: publicプロパティとして定義) | ○ |
| C-15 | OrderPaymentSucceededIntegrationEvent.OrderId | E-03 (record定義でOrderIdパラメータ) | ○ |
| C-16 | OrderPaymentSucceededIntegrationEvent継承 | E-03 (IntegrationEventを継承) | ○ |
| C-17 | OrderPaymentSucceededIntegrationEvent.Id | E-03 (IntegrationEvent継承によりIdプロパティ存在) | ○ |
| C-18 | OrderPaymentFailedIntegrationEvent.OrderId | E-04 (record定義でOrderIdパラメータ) | ○ |
| C-19 | OrderPaymentFailedIntegrationEvent継承 | E-04 (IntegrationEventを継承) | ○ |
| C-20 | OrderPaymentFailedIntegrationEvent.Id | E-04 (IntegrationEvent継承によりIdプロパティ存在) | ○ |
| C-21 | OrderStatusChangedToStockConfirmedIntegrationEvent.OrderId | E-05 (record定義でOrderIdパラメータ) | ○ |
| C-22 | OrderStatusChangedToStockConfirmedIntegrationEvent継承 | E-05 (IntegrationEventを継承) | ○ |
| C-23 | OrderStatusChangedToStockConfirmedIntegrationEvent.Id | E-05 (IntegrationEvent継承によりIdプロパティ存在) | ○ |
| C-24 | record型の等価性（同一OrderId） | E-03 (record型の標準動作) | ○ |
| C-25 | record型の等価性（異なるOrderId） | E-03 (record型の標準動作) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - すべてのテストケースはソースコードから直接導出されており、根拠不足のケースは存在しない
  - IntegrationEventの基底クラスの実装はEventBusモジュールにあるが、本モジュールのテスト範囲としては継承関係の確認で十分

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - PaymentProcessorはシンプルな構造で、主要ロジックはPaymentOptionsの値に基づく条件分岐のみ
- 注意点：
  - 実際の支払いゲートウェイとの連携はなく、設定値による模擬動作のみ
  - エラーハンドリングがないため、EventBus障害時の挙動に注意

## 6) レビュアーチェックリスト（最小）
- [ ] UT-PAY-001, UT-PAY-002: 支払い成功/失敗の分岐ロジックが正しくテストされているか確認
- [ ] UT-PAY-003: OrderIdの伝播が正しく検証されているか確認
- [ ] UT-PAY-008: EventBus障害時のテストが十分か（現状は例外伝播のみ）
- [ ] UT-PAY-009〜011: 境界値テストの範囲が適切か確認
- [ ] record型のテスト（UT-PAY-015〜025）が必要十分か確認

## 7) 解析対象ファイル一覧

| ファイルパス | 説明 |
|-------------|------|
| `src/PaymentProcessor/IntegrationEvents/EventHandling/OrderStatusChangedToStockConfirmedIntegrationEventHandler.cs` | メインのイベントハンドラ、支払い処理ロジック |
| `src/PaymentProcessor/PaymentOptions.cs` | 支払い成功/失敗を制御する設定クラス |
| `src/PaymentProcessor/IntegrationEvents/Events/OrderPaymentSucceededIntegrationEvent.cs` | 支払い成功イベント |
| `src/PaymentProcessor/IntegrationEvents/Events/OrderPaymentFailedIntegrationEvent.cs` | 支払い失敗イベント |
| `src/PaymentProcessor/IntegrationEvents/Events/OrderStatusChangedToStockConfirmedIntegrationEvent.cs` | 在庫確認完了イベント（入力イベント） |
| `src/PaymentProcessor/Program.cs` | アプリケーションエントリーポイント |
| `src/PaymentProcessor/GlobalUsings.cs` | グローバルusing定義 |

## 8) テストケース分布

| カテゴリ | 件数 | 割合 |
|---------|------|------|
| EventHandler（Handle メソッド） | 11 | 44% |
| PaymentOptions | 3 | 12% |
| OrderPaymentSucceededIntegrationEvent | 4 | 16% |
| OrderPaymentFailedIntegrationEvent | 3 | 12% |
| OrderStatusChangedToStockConfirmedIntegrationEvent | 3 | 12% |
| record等価性テスト | 2 | 8% |

| テスト観点 | 件数 | 割合 |
|-----------|------|------|
| 正常系 | 19 | 76% |
| 異常系 | 3 | 12% |
| 境界値 | 3 | 12% |

| 優先度 | 件数 | 割合 |
|--------|------|------|
| 高 | 4 | 16% |
| 中 | 16 | 64% |
| 低 | 5 | 20% |
