---
generated_at: 2026-01-14 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Shared モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. なし - 全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Shared/ActivityExtensions.cs` - Activity拡張メソッド（例外タグ設定）
- E-02: `src/Shared/MigrateDbContextExtensions.cs` - DBマイグレーション拡張メソッド
- E-03: OpenTelemetry例外セマンティック規約（https://opentelemetry.io/docs/specs/otel/trace/semantic_conventions/exceptions/）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SetExceptionTagsが例外情報をActivityに設定する | E-01 (L6-17) | ○ |
| C-02 | Activity=nullの場合は早期リターンする | E-01 (L8-11) | ○ |
| C-03 | ネストした例外でもex.ToString()でスタックトレースが取得される | E-01 (L14) | ○ |
| C-04 | 空文字列のメッセージも正しく処理される | E-01 (L13) | ○ |
| C-05 | AddMigration<TContext>がシーダーなしでMigrationHostedServiceを登録 | E-02 (L10-12) | ○ |
| C-06 | OpenTelemetryトレーシングソース"DbMigrations"が登録される | E-02 (L18) | ○ |
| C-07 | AddMigration<TContext>(seeder)がカスタムシーダー付きで登録 | E-02 (L14-21) | ○ |
| C-08 | AddMigration<TContext, TDbSeeder>がIDbSeederをScopedで登録 | E-02 (L23-29) | ○ |
| C-09 | 登録されたシーダーのSeedAsyncが呼び出される | E-02 (L28, L66) | ○ |
| C-10 | MigrateDbContextAsyncがマイグレーションを実行する | E-02 (L31-56) | ○ |
| C-11 | マイグレーション例外時にLogErrorが呼び出される | E-02 (L50) | ○ |
| C-12 | 例外発生時にSetExceptionTagsが呼び出される | E-02 (L52, L70) | ○ |
| C-13 | InvokeSeederがMigrateAsync後にシーダーを実行する | E-02 (L65-66) | ○ |
| C-14 | InvokeSeeder内の例外がActivityに記録される | E-02 (L68-72) | ○ |
| C-15 | MigrateAsync失敗時に例外がActivityに記録される | E-02 (L68-72) | ○ |
| C-16 | MigrationHostedService.StartAsyncでマイグレーションが実行される | E-02 (L79-82) | ○ |
| C-17 | マイグレーション失敗時にStartAsyncが例外をスローする | E-02 (L54) | ○ |
| C-18 | ExecuteAsyncがTask.CompletedTaskを返す | E-02 (L84-87) | ○ |
| C-19 | IDbSeeder.SeedAsyncインターフェースが定義されている | E-02 (L90-93) | ○ |
| C-20 | シード中の例外が適切にスローされる | E-02 (L68-72) | ○ |
| C-21 | AddMigrationがIServiceCollectionを返す（Fluent API） | E-02 (L12, L20, L28) | ○ |
| C-22 | ExecutionStrategyが使用される | E-02 (L44-46) | ○ |
| C-23 | Activityに"Migration operation {DbContextName}"名が設定される | E-02 (L38) | ○ |
| C-24 | Activityに"Migrating {DbContextName}"名が設定される | E-02 (L61) | ○ |
| C-25 | SetExceptionTagsがActivityStatusCode.Errorを設定する | E-01 (L16) | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの項目はありません
- Sharedモジュールは小規模なユーティリティモジュールであり、全てのテストケースがソースコードから直接導出可能です

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースに明確な根拠があり、コードカバレッジも十分
- 注意点：
  - MigrationHostedServiceはprivateクラスのため、直接のユニットテストではなく統合テストが必要な場合あり
  - ActivitySourceのテストには適切なOpenTelemetryテストインフラが必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがソースコードの全publicメソッドをカバーしているか確認
- [ ] 異常系テストケースが適切なエラーハンドリングを検証しているか確認
- [ ] OpenTelemetryトレーシングの設定が正しくテストされているか確認
- [ ] DIコンテナ登録のライフタイム（Scoped/Singleton）が正しくテストされているか確認
- [ ] ExecutionStrategy使用時のリトライ動作テストの必要性を検討

## 補足情報

### 対象ファイル一覧
| ファイル | 行数 | クラス/インターフェース |
|---------|------|------------------------|
| `src/Shared/ActivityExtensions.cs` | 18 | ActivityExtensions |
| `src/Shared/MigrateDbContextExtensions.cs` | 93 | MigrateDbContextExtensions, MigrationHostedService, IDbSeeder |

### テスト優先度の分布
| 優先度 | 件数 | 割合 |
|--------|------|------|
| 高 | 12 | 48% |
| 中 | 11 | 44% |
| 低 | 2 | 8% |

### テスト観点の分布
| 観点 | 件数 | 割合 |
|------|------|------|
| 正常系 | 17 | 68% |
| 異常系 | 7 | 28% |
| 境界値 | 1 | 4% |
