---
generated_at: 2026-01-14 10:30:00
metrics:
  claims_total: 80
  claims_with_evidence: 80
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：WebApp単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：80 / 80、根拠なし：0
- 優先レビュー（高）
  1. **チェックアウトフロー（UT-WAP-018〜021）**：重要なビジネスロジック
  2. **認証関連テスト（UT-WAP-011〜012, 028）**：セキュリティに関わる
  3. **AIチャット機能テスト（UT-WAP-050〜061）**：外部サービス連携

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebApp/Services/OrderingService.cs` - OrderingServiceクラス実装
- E-02: `src/WebApp/Services/BasketService.cs` - BasketServiceクラス実装
- E-03: `src/WebApp/Services/BasketState.cs` - BasketStateクラス実装
- E-04: `src/WebApp/Services/IBasketState.cs` - IBasketStateインターフェース
- E-05: `src/WebApp/Services/BasketItem.cs` - BasketItemクラス定義
- E-06: `src/WebApp/Services/BasketCheckoutInfo.cs` - BasketCheckoutInfoクラス定義
- E-07: `src/WebApp/Services/LogOutService.cs` - LogOutServiceクラス実装
- E-08: `src/WebApp/Services/ProductImageUrlProvider.cs` - ProductImageUrlProviderクラス実装
- E-09: `src/WebApp/Services/OrderStatus/OrderStatusNotificationService.cs` - 通知サービス実装
- E-10: `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToPaidIntegrationEvent.cs` - Paidイベント定義
- E-11: `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToCancelledIntegrationEvent.cs` - Cancelledイベント定義
- E-12: `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToAwaitingValidationIntegrationEvent.cs` - AwaitingValidationイベント定義
- E-13: `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToStockConfirmedIntegrationEvent.cs` - StockConfirmedイベント定義
- E-14: `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToShippedIntegrationEvent.cs` - Shippedイベント定義
- E-15: `src/WebApp/Services/OrderStatus/IntegrationEvents/Events/OrderStatusChangedToSubmittedIntegrationEvent.cs` - Submittedイベント定義
- E-16: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToPaidIntegrationEventHandler.cs` - Paidハンドラー
- E-17: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToCancelledIntegrationEventHandler.cs` - Cancelledハンドラー
- E-18: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToAwaitingValidationIntegrationEventHandler.cs` - AwaitingValidationハンドラー
- E-19: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToStockConfirmedIntegrationEventHandler.cs` - StockConfirmedハンドラー
- E-20: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToShippedIntegrationEventHandler.cs` - Shippedハンドラー
- E-21: `src/WebApp/Services/OrderStatus/IntegrationEvents/EventHandling/OrderStatusChangedToSubmittedIntegrationEventHandler.cs` - Submittedハンドラー
- E-22: `src/WebApp/Components/Chatbot/ChatState.cs` - ChatStateクラス実装
- E-23: `src/WebApp/Components/Chatbot/MessageProcessor.cs` - MessageProcessorクラス実装
- E-24: `src/WebApp/Extensions/Extensions.cs` - 拡張メソッド実装
- E-25: `src/WebApp/Program.cs` - アプリケーションエントリーポイント

## 3) Claims と根拠の対応（レビューの主戦場）

### OrderingService関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-WAP-001) | GetOrdersがOrderRecord[]を返却する | E-01 L7-10 | ○ |
| C-02 (UT-WAP-002) | GetOrdersがAPI呼び出し失敗時に例外をスローする | E-01 L7-10 | ○ |
| C-03 (UT-WAP-003) | CreateOrderがx-requestidヘッダー付きでPOSTする | E-01 L12-18 | ○ |
| C-04 (UT-WAP-004) | CreateOrderが無効リクエストで失敗する | E-01 L12-18 | ○ |

### BasketService関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 (UT-WAP-005) | GetBasketAsyncがBasketQuantityコレクションを返却する | E-02 L9-13 | ○ |
| C-06 (UT-WAP-006) | GetBasketAsyncがgRPCエラー時に例外をスローする | E-02 L9-13 | ○ |
| C-07 (UT-WAP-007) | DeleteBasketAsyncがgRPC呼び出しを行う | E-02 L15-18 | ○ |
| C-08 (UT-WAP-008) | UpdateBasketAsyncがgRPC呼び出しを行う | E-02 L20-35 | ○ |
| C-09 (UT-WAP-009) | UpdateBasketAsyncが空コレクションを処理できる | E-02 L20-35 | ○ |
| C-10 (UT-WAP-010) | MapToBasketがレスポンスを正しくマッピングする | E-02 L37-46 | ○ |

### BasketState関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 (UT-WAP-011) | GetBasketItemsAsyncが認証済みユーザーの買い物かごを取得する | E-03 L21-24 | ○ |
| C-12 (UT-WAP-012) | GetBasketItemsAsyncが未認証ユーザーに空コレクションを返却する | E-03 L22-24 | ○ |
| C-13 (UT-WAP-013) | AddAsyncが新商品を買い物かごに追加する | E-03 L33-56 | ○ |
| C-14 (UT-WAP-014) | AddAsyncが既存商品の数量を増加する | E-03 L37-45 | ○ |
| C-15 (UT-WAP-015) | SetQuantityAsyncが商品の数量を設定する | E-03 L58-76 | ○ |
| C-16 (UT-WAP-016) | SetQuantityAsyncが数量0で商品を削除する | E-03 L67-70 | ○ |
| C-17 (UT-WAP-017) | SetQuantityAsyncが存在しない商品を無視する | E-03 L61 | ○ |
| C-18 (UT-WAP-018) | CheckoutAsyncがチェックアウトを完了する | E-03 L78-109 | ○ |
| C-19 (UT-WAP-019) | CheckoutAsyncがBuyerIdなしでInvalidOperationExceptionをスローする | E-03 L85 | ○ |
| C-20 (UT-WAP-020) | CheckoutAsyncがUserNameなしでInvalidOperationExceptionをスローする | E-03 L86 | ○ |
| C-21 (UT-WAP-021) | CheckoutAsyncがRequestIdを自動生成する | E-03 L80-83 | ○ |
| C-22 (UT-WAP-022) | DeleteBasketAsyncがBasketServiceに委譲する | E-03 L18-19 | ○ |
| C-23 (UT-WAP-023) | NotifyOnChangeがサブスクリプションを登録する | E-03 L26-31 | ○ |
| C-24 (UT-WAP-024) | NotifyOnChangeのDisposeがサブスクリプションを解除する | E-03 L151-155 | ○ |

### BasketItem/BasketCheckoutInfo関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 (UT-WAP-025) | BasketItemの全プロパティが設定・取得可能 | E-05 L3-11 | ○ |
| C-26 (UT-WAP-026) | BasketCheckoutInfoのRequired属性が機能する | E-06 L7-20 | ○ |
| C-27 (UT-WAP-027) | BasketCheckoutInfoの必須フィールドがnullでバリデーションエラー | E-06 L7-20 | ○ |

### LogOutService/ProductImageUrlProvider関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 (UT-WAP-028) | LogOutAsyncがCookie/OIDC認証をクリアする | E-07 L9-13 | ○ |
| C-29 (UT-WAP-029) | GetProductImageUrlが正しいURLを生成する | E-08 L7-8 | ○ |
| C-30 (UT-WAP-030) | GetProductImageUrlがproductId=0を処理できる | E-08 L7-8 | ○ |

### OrderStatusNotificationService関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 (UT-WAP-031) | SubscribeToOrderStatusNotificationsがサブスクリプションを登録する | E-09 L9-25 | ○ |
| C-32 (UT-WAP-032) | 同一buyerIdで複数サブスクリプションが登録可能 | E-09 L15-21 | ○ |
| C-33 (UT-WAP-033) | NotifyOrderStatusChangedAsyncが登録済みサブスクリプションに通知する | E-09 L27-35 | ○ |
| C-34 (UT-WAP-034) | NotifyOrderStatusChangedAsyncが未登録buyerIdでTask.CompletedTaskを返却する | E-09 L31-33 | ○ |
| C-35 (UT-WAP-035) | Unsubscribeがサブスクリプションを解除する | E-09 L37-50 | ○ |
| C-36 (UT-WAP-036) | 最後のサブスクリプション解除でbuyerIdエントリが削除される | E-09 L43-46 | ○ |

### Integration Event Handler関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 (UT-WAP-037) | OrderStatusChangedToPaidIntegrationEventHandlerがNotifyOrderStatusChangedAsyncを呼び出す | E-16 L10-14 | ○ |
| C-38 (UT-WAP-038) | OrderStatusChangedToCancelledIntegrationEventHandlerがNotifyOrderStatusChangedAsyncを呼び出す | E-17 L10-14 | ○ |
| C-39 (UT-WAP-039) | OrderStatusChangedToAwaitingValidationIntegrationEventHandlerがNotifyOrderStatusChangedAsyncを呼び出す | E-18 L10-14 | ○ |
| C-40 (UT-WAP-040) | OrderStatusChangedToStockConfirmedIntegrationEventHandlerがNotifyOrderStatusChangedAsyncを呼び出す | E-19 L10-14 | ○ |
| C-41 (UT-WAP-041) | OrderStatusChangedToShippedIntegrationEventHandlerがNotifyOrderStatusChangedAsyncを呼び出す | E-20 L10-14 | ○ |
| C-42 (UT-WAP-042) | OrderStatusChangedToSubmittedIntegrationEventHandlerがNotifyOrderStatusChangedAsyncを呼び出す | E-21 L10-14 | ○ |

### Integration Event関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 (UT-WAP-043) | OrderStatusChangedToPaidIntegrationEventのプロパティが正しく初期化される | E-10 L5-19 | ○ |
| C-44 (UT-WAP-044) | OrderStatusChangedToCancelledIntegrationEventのプロパティが正しく初期化される | E-11 L5-19 | ○ |
| C-45 (UT-WAP-045) | OrderStatusChangedToAwaitingValidationIntegrationEventのプロパティが正しく初期化される | E-12 L5-19 | ○ |
| C-46 (UT-WAP-046) | OrderStatusChangedToStockConfirmedIntegrationEventのプロパティが正しく初期化される | E-13 L5-19 | ○ |
| C-47 (UT-WAP-047) | OrderStatusChangedToShippedIntegrationEventのプロパティが正しく初期化される | E-14 L5-19 | ○ |
| C-48 (UT-WAP-048) | OrderStatusChangedToSubmittedIntegrationEventのプロパティが正しく初期化される | E-15 L5-19 | ○ |

### ChatState関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 (UT-WAP-049) | ChatStateのコンストラクタで依存関係が注入される | E-22 L19-65 | ○ |
| C-50 (UT-WAP-050) | AddUserMessageAsyncがユーザーメッセージとAI応答を追加する | E-22 L69-93 | ○ |
| C-51 (UT-WAP-051) | AddUserMessageAsyncがAI呼び出し失敗時にエラーメッセージを追加する | E-22 L84-91 | ○ |
| C-52 (UT-WAP-052) | AddUserMessageAsyncがonMessageAddedコールバックを2回呼び出す | E-22 L73, L92 | ○ |
| C-53 (UT-WAP-053) | GetUserInfoがユーザー情報をJSON形式で返却する | E-22 L96-115 | ○ |
| C-54 (UT-WAP-054) | GetUserInfoがClaimなしで空文字を返却する | E-22 L113-114 | ○ |
| C-55 (UT-WAP-055) | SearchCatalogがカタログ検索結果をJSON形式で返却する | E-22 L117-134 | ○ |
| C-56 (UT-WAP-056) | SearchCatalogがAPI呼び出し失敗時にエラーメッセージを返却する | E-22 L130-133 | ○ |
| C-57 (UT-WAP-057) | AddToCartが商品を買い物かごに追加する | E-22 L136-153 | ○ |
| C-58 (UT-WAP-058) | AddToCartが未認証時にエラーメッセージを返却する | E-22 L145-148 | ○ |
| C-59 (UT-WAP-059) | AddToCartがその他の例外時にエラーメッセージを返却する | E-22 L149-152 | ○ |
| C-60 (UT-WAP-060) | GetCartContentsが買い物かご内容をJSON形式で返却する | E-22 L155-167 | ○ |
| C-61 (UT-WAP-061) | GetCartContentsが例外時にエラーメッセージを返却する | E-22 L163-166 | ○ |

### MessageProcessor関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 (UT-WAP-062) | AllowImagesがMarkdown画像をHTMLに変換する | E-23 L10-31 | ○ |
| C-63 (UT-WAP-063) | AllowImagesが画像以外のテキストをHTMLエンコードする | E-23 L22-23, L28 | ○ |
| C-64 (UT-WAP-064) | AllowImagesが空文字列を処理できる | E-23 L10-31 | ○ |
| C-65 (UT-WAP-065) | AllowImagesが複数の画像を正しく変換する | E-23 L20 (foreach) | ○ |
| C-66 (UT-WAP-066) | AllowImagesがエスケープされた<>を復元する | E-23 L18 | ○ |

### Extensions関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 (UT-WAP-067) | AddApplicationServicesが全サービスを登録する | E-24 L13-41 | ○ |
| C-68 (UT-WAP-068) | AddEventBusSubscriptionsが全イベントハンドラを登録する | E-24 L43-51 | ○ |
| C-69 (UT-WAP-069) | AddAuthenticationServicesが認証サービスを設定する | E-24 L53-92 | ○ |
| C-70 (UT-WAP-070) | AddAuthenticationServicesが必須構成値なしで例外をスローする | E-24 L60-61 | ○ |
| C-71 (UT-WAP-071) | GetBuyerIdAsyncがsubクレームからBuyerIdを取得する | E-24 L111-116 | ○ |
| C-72 (UT-WAP-072) | GetBuyerIdAsyncがsubクレームなしでnullを返却する | E-24 L115 | ○ |
| C-73 (UT-WAP-073) | GetUserNameAsyncがnameクレームからUserNameを取得する | E-24 L118-123 | ○ |
| C-74 (UT-WAP-074) | GetUserNameAsyncがnameクレームなしでnullを返却する | E-24 L122 | ○ |
| C-75 (UT-WAP-075) | AddAIServicesがOllama有効時にOllamaクライアントを設定する | E-24 L97-101 | ○ |
| C-76 (UT-WAP-076) | AddAIServicesがchatModel接続文字列設定時にOpenAIクライアントを設定する | E-24 L102-106 | ○ |
| C-77 (UT-WAP-077) | AddAIServicesがAI設定なしで何も登録しない | E-24 L94-108 | ○ |

### Record型関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 (UT-WAP-078) | OrderRecordのプロパティが正しく初期化される | E-01 L21-25 | ○ |
| C-79 (UT-WAP-079) | CreateOrderRequestのプロパティが正しく初期化される | E-03 L158-172 | ○ |
| C-80 (UT-WAP-080) | BasketQuantityのプロパティが正しく初期化される | E-02 L49 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースがソースコードに基づいて生成されており、根拠なしの項目はありません。
- ただし、以下の点は実装時に確認が必要です：
  - 外部依存（gRPC、HTTP、AI）のモック実装方法
  - Blazor ServerのAuthenticationStateProviderのモック方法

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - record型のプロパティテスト（UT-WAP-025, 043-048, 078-080）
- 0: 低リスク - 境界値テスト（UT-WAP-030, 064）
- 1: 中リスク - サブスクリプション管理テスト（UT-WAP-023-024, 031-036）- スレッドセーフティ
- 1: 中リスク - AI機能テスト（UT-WAP-049-061）- 外部サービス依存
- 2: 高リスク - チェックアウトフロー（UT-WAP-018-021）- 重要なビジネスロジック
- 2: 高リスク - 認証テスト（UT-WAP-011-012, 028, 071-074）- セキュリティ関連

## 6) レビュアーチェックリスト（最小）
- [ ] チェックアウトフロー（UT-WAP-018-021）のテストケースが注文作成とカート削除の両方をカバーしているか確認
- [ ] 認証テスト（UT-WAP-011-012）がBlazor Serverの認証状態を正しくモックできているか確認
- [ ] gRPCクライアント（BasketService）のモック実装がRpcExceptionを適切にシミュレートできるか確認
- [ ] OrderStatusNotificationServiceのスレッドセーフティテストが並行アクセスを考慮しているか確認
- [ ] ChatStateのAIツール関数テストが例外ハンドリングを網羅しているか確認
- [ ] MessageProcessorのXSS対策テストが悪意のある入力パターンを網羅しているか確認
- [ ] Extensions.AddAuthenticationServicesの構成エラーテストが全必須構成値をカバーしているか確認
