---
generated_at: 2026-01-14 22:25:00
metrics:
  claims_total: 64
  claims_with_evidence: 64
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：WebhookClient.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：64 / 64、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコードの根拠あり
  2. **推奨事項**：実際のテスト実装時にHttpClient/認証周りのモック設計を検討
  3. **推奨事項**：ConcurrentQueue/ConcurrentDictionaryのスレッドセーフ性テストの追加検討

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WebhookClient/Services/HooksRepository.cs`
- E-02: `src/WebhookClient/Services/WebhooksClient.cs`
- E-03: `src/WebhookClient/Services/WebhookClientOptions.cs`
- E-04: `src/WebhookClient/Services/WebHookReceived.cs`
- E-05: `src/WebhookClient/Services/WebhookData.cs`
- E-06: `src/WebhookClient/Services/WebhookResponse.cs`
- E-07: `src/WebhookClient/Services/WebhookSubscriptionRequest.cs`
- E-08: `src/WebhookClient/Services/WebhookType.cs`
- E-09: `src/WebhookClient/Endpoints/WebhookEndpoints.cs`
- E-10: `src/WebhookClient/Endpoints/AuthenticationEndpoints.cs`
- E-11: `src/WebhookClient/Extensions/Extensions.cs`
- E-12: `src/WebhookClient/Program.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HooksRepository.AddNew - データがキューに追加される | E-01 L10-28 `_data.Enqueue(hook)` | ○ |
| C-02 | HooksRepository.AddNew - サブスクライバへ通知される | E-01 L14-25 `subscription.Key.NotifyAsync()` | ○ |
| C-03 | HooksRepository.AddNew - 例外がスワローされる | E-01 L18-24 try-catch構造 | ○ |
| C-04 | HooksRepository.AddNew - null許容（境界値） | E-01 L10 パラメータにnull check無し | ○ |
| C-05 | HooksRepository.GetAll - 全データ取得 | E-01 L30-33 `_data.AsEnumerable()` | ○ |
| C-06 | HooksRepository.GetAll - 空時の挙動 | E-01 L30-33 ConcurrentQueue特性 | ○ |
| C-07 | HooksRepository.GetAll - FIFO順序保持 | E-01 L7 ConcurrentQueue使用 | ○ |
| C-08 | HooksRepository.Subscribe - IDisposable返却 | E-01 L35-39 `return subscription` | ○ |
| C-09 | HooksRepository.Subscribe - 複数登録可能 | E-01 L8 ConcurrentDictionary使用 | ○ |
| C-10 | OnChangeSubscription.Dispose - サブスクリプション解除 | E-01 L46 `owner._onChangeSubscriptions.Remove(this, out _)` | ○ |
| C-11 | OnChangeSubscription.NotifyAsync - コールバック実行 | E-01 L44 `callback()` | ○ |
| C-12 | WebhooksClient.AddWebHookAsync - POSTリクエスト送信 | E-02 L5-8 `client.PostAsJsonAsync("/api/webhooks", payload)` | ○ |
| C-13 | WebhooksClient.AddWebHookAsync - サーバーエラー時のレスポンス | E-02 L5-8 HttpResponseMessage返却 | ○ |
| C-14 | WebhooksClient.AddWebHookAsync - ネットワークエラー時の例外 | E-02 L5-8 HttpClient標準動作 | ○ |
| C-15 | WebhooksClient.AddWebHookAsync - 空ペイロード許容 | E-02 L5 パラメータ型確認 | ○ |
| C-16 | WebhooksClient.LoadWebhooks - GET取得 | E-02 L10-13 `client.GetFromJsonAsync` | ○ |
| C-17 | WebhooksClient.LoadWebhooks - サーバーエラー時例外 | E-02 L10-13 GetFromJsonAsync標準動作 | ○ |
| C-18 | WebhooksClient.LoadWebhooks - 空配列時の挙動 | E-02 L12 空配列はそのまま返却 | ○ |
| C-19 | WebhooksClient.LoadWebhooks - null時空配列返却 | E-02 L12 `?? []` null合体演算子 | ○ |
| C-20 | WebhookClientOptions.Token - プロパティ動作 | E-03 L5 `public string? Token { get; set; }` | ○ |
| C-21 | WebhookClientOptions.SelfUrl - プロパティ動作 | E-03 L6 `public string? SelfUrl { get; set; }` | ○ |
| C-22 | WebhookClientOptions.ValidateToken - プロパティ動作 | E-03 L7 `public bool ValidateToken { get; set; }` | ○ |
| C-23 | WebHookReceived.When - プロパティ動作 | E-04 L5 `public DateTime When { get; set; }` | ○ |
| C-24 | WebHookReceived.Data - プロパティ動作 | E-04 L7 `public string? Data { get; set; }` | ○ |
| C-25 | WebHookReceived.Token - プロパティ動作 | E-04 L9 `public string? Token { get; set; }` | ○ |
| C-26 | WebhookData.When - プロパティ動作 | E-05 L7 `public DateTime When { get; set; }` | ○ |
| C-27 | WebhookData.Payload - プロパティ動作 | E-05 L9 `public string? Payload { get; set; }` | ○ |
| C-28 | WebhookData.Type - プロパティ動作 | E-05 L11 `public string? Type { get; set; }` | ○ |
| C-29 | WebhookResponse.Date - プロパティ動作 | E-06 L5 `public DateTime Date { get; set; }` | ○ |
| C-30 | WebhookResponse.DestUrl - プロパティ動作 | E-06 L6 `public string? DestUrl { get; set; }` | ○ |
| C-31 | WebhookResponse.Token - プロパティ動作 | E-06 L7 `public string? Token { get; set; }` | ○ |
| C-32 | WebhookSubscriptionRequest.Url - プロパティ動作 | E-07 L5 `public string? Url { get; set; }` | ○ |
| C-33 | WebhookSubscriptionRequest.Token - プロパティ動作 | E-07 L6 `public string? Token { get; set; }` | ○ |
| C-34 | WebhookSubscriptionRequest.Event - プロパティ動作 | E-07 L7 `public string? Event { get; set; }` | ○ |
| C-35 | WebhookSubscriptionRequest.GrantUrl - プロパティ動作 | E-07 L8 `public string? GrantUrl { get; set; }` | ○ |
| C-36 | WebhookType.CatalogItemPriceChange = 1 | E-08 L5 `CatalogItemPriceChange = 1` | ○ |
| C-37 | WebhookType.OrderShipped = 2 | E-08 L6 `OrderShipped = 2` | ○ |
| C-38 | WebhookType.OrderPaid = 3 | E-08 L7 `OrderPaid = 3` | ○ |
| C-39 | WebhookEndpoints - /checkエンドポイントマッピング | E-09 L16 `app.MapMethods("/check", [HttpMethods.Options], ...)` | ○ |
| C-40 | /check - 有効トークンでOk返却 | E-09 L18-25 条件分岐確認 | ○ |
| C-41 | /check - ヘッダー転送 | E-09 L20-23 `response.Headers.Append(webhookCheckHeader, value)` | ○ |
| C-42 | /check - 無効トークンでBadRequest | E-09 L28 `TypedResults.BadRequest("Invalid token")` | ○ |
| C-43 | /check - 空トークン時の挙動 | E-09 L20 `!string.IsNullOrWhiteSpace(value)` | ○ |
| C-44 | WebhookEndpoints - /webhook-receivedマッピング | E-09 L31 `app.MapPost("/webhook-received", ...)` | ○ |
| C-45 | /webhook-received - 有効トークンで処理 | E-09 L37-48 条件分岐・Ok返却 | ○ |
| C-46 | /webhook-received - HooksRepository連携 | E-09 L46 `await hooksRepository.AddNew(newHook)` | ○ |
| C-47 | /webhook-received - 無効トークンでBadRequest | E-09 L52 `Results.BadRequest()` | ○ |
| C-48 | /webhook-received - ログ出力 | E-09 L35, L39, L47, L51 `logger.LogInformation` | ○ |
| C-49 | AuthenticationEndpoints - /logoutマッピング | E-10 L12 `app.MapPost("/logout", ...)` | ○ |
| C-50 | /logout - CSRF検証 | E-10 L14 `await antiforgery.ValidateRequestAsync(httpContext)` | ○ |
| C-51 | /logout - Cookie認証サインアウト | E-10 L15 `SignOutAsync(CookieAuthenticationDefaults.AuthenticationScheme)` | ○ |
| C-52 | /logout - OIDC認証サインアウト | E-10 L16 `SignOutAsync(OpenIdConnectDefaults.AuthenticationScheme)` | ○ |
| C-53 | /logout - 無効トークン時例外 | E-10 L14 ValidateRequestAsync標準動作 | ○ |
| C-54 | Extensions.AddApplicationServices - Options登録 | E-11 L15 `.BindConfiguration(nameof(WebhookClientOptions))` | ○ |
| C-55 | Extensions.AddApplicationServices - HooksRepositoryシングルトン | E-11 L16 `AddSingleton<HooksRepository>()` | ○ |
| C-56 | Extensions.AddApplicationServices - HttpClient構成 | E-11 L19 `BaseAddress = new("http://webhooks-api")` | ○ |
| C-57 | Extensions.AddAuthenticationServices - 認証サービス登録 | E-11 L34-35 `AddAuthorization()/AddAuthentication()` | ○ |
| C-58 | Extensions.AddAuthenticationServices - Cookie認証構成 | E-11 L40-47 `.AddCookie(options => ...)` | ○ |
| C-59 | Extensions.AddAuthenticationServices - OIDC構成 | E-11 L48-61 `.AddOpenIdConnect(options => ...)` | ○ |
| C-60 | Extensions.AddAuthenticationServices - Cookie有効期限設定 | E-11 L42 `options.ExpireTimeSpan = TimeSpan.FromMinutes(sessionCookieLifetime)` | ○ |
| C-61 | Extensions.AddAuthenticationServices - デフォルト60分 | E-11 L31 `GetValue("SessionCookieLifetimeMinutes", 60)` | ○ |
| C-62 | Extensions.AddAuthenticationServices - AuthStateProvider登録 | E-11 L63 `AddScoped<AuthenticationStateProvider, ServerAuthenticationStateProvider>()` | ○ |
| C-63 | Extensions.AddAuthenticationServices - IdentityUrl必須チェック | E-11 L29 `GetRequiredValue("IdentityUrl")` | ○ |
| C-64 | Extensions.AddAuthenticationServices - CallBackUrl必須チェック | E-11 L30 `GetRequiredValue("CallBackUrl")` | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースにソースコード上の根拠が確認できたため、不足情報はありません。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - DTOクラスのプロパティテスト（C-20〜C-35）
- **0: 低リスク** - 列挙型の値テスト（C-36〜C-38）
- **1: 中リスク** - HooksRepositoryのスレッドセーフ性（C-01〜C-11）- ConcurrentQueue/ConcurrentDictionaryを使用しているが、並行テストの追加を推奨
- **1: 中リスク** - WebhooksClientのHTTP通信テスト（C-12〜C-19）- モック化の設計が必要
- **1: 中リスク** - 認証関連テスト（C-49〜C-64）- OpenIdConnect/Cookie認証のモック化が必要

## 6) レビュアーチェックリスト（最小）
- [ ] HooksRepositoryの並行処理テストが実装時に追加されているか確認
- [ ] WebhooksClientのHttpClientモック設計が適切か確認
- [ ] 認証エンドポイントテストでIAntiforgeryモックが正しく構成されているか確認
- [ ] トークン検証ロジック（ValidateToken=true/false）の両方のパスがテストされているか確認
- [ ] OpenIdConnect設定値（ClientId, ClientSecret, Scopes）のテストカバレッジ確認
- [ ] 実際のテスト実装時にIntegration Test（E2E）の追加を検討
