---
generated_at: 2026-01-14 12:30:00
metrics:
  claims_total: 72
  claims_with_evidence: 72
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Webhooks.API 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：72 / 72、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Webhooks.API/Model/WebhookSubscription.cs` - エンティティモデルの定義
- E-02: `src/Webhooks.API/Model/WebhookData.cs` - Webhookデータモデルの定義
- E-03: `src/Webhooks.API/Model/WebhookSubscriptionRequest.cs` - リクエストモデルとバリデーション
- E-04: `src/Webhooks.API/Model/WebhookType.cs` - WebhookTypeの列挙型定義
- E-05: `src/Webhooks.API/Services/WebhooksRetriever.cs` - サブスクリプション取得サービス
- E-06: `src/Webhooks.API/Services/WebhooksSender.cs` - Webhook送信サービス
- E-07: `src/Webhooks.API/Services/GrantUrlTesterService.cs` - Grant URL検証サービス
- E-08: `src/Webhooks.API/Services/IWebhooksRetriever.cs` - IWebhooksRetrieverインターフェース
- E-09: `src/Webhooks.API/Services/IWebhooksSender.cs` - IWebhooksSenderインターフェース
- E-10: `src/Webhooks.API/Services/IGrantUrlTesterService.cs` - IGrantUrlTesterServiceインターフェース
- E-11: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToPaidIntegrationEventHandler.cs` - 支払完了イベントハンドラ
- E-12: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEventHandler.cs` - 出荷完了イベントハンドラ
- E-13: `src/Webhooks.API/IntegrationEvents/ProductPriceChangedIntegrationEventHandler.cs` - 価格変更イベントハンドラ
- E-14: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToPaidIntegrationEvent.cs` - 支払完了統合イベント
- E-15: `src/Webhooks.API/IntegrationEvents/OrderStatusChangedToShippedIntegrationEvent.cs` - 出荷完了統合イベント
- E-16: `src/Webhooks.API/IntegrationEvents/ProductPriceChangedIntegrationEvent.cs` - 価格変更統合イベント
- E-17: `src/Webhooks.API/IntegrationEvents/OrderStockItem.cs` - 在庫アイテムレコード
- E-18: `src/Webhooks.API/Infrastructure/WebhooksContext.cs` - DbContext定義
- E-19: `src/Webhooks.API/Apis/WebHooksApi.cs` - WebHooks APIエンドポイント
- E-20: `src/Webhooks.API/Extensions/RouteHandlerBuilderExtensions.cs` - バリデーション拡張メソッド
- E-21: `src/Webhooks.API/Extensions/Extensions.cs` - アプリケーションサービス設定
- E-22: `src/Webhooks.API/Exceptions/WebhooksDomainException.cs` - ドメイン例外クラス
- E-23: `src/Webhooks.API/Program.cs` - アプリケーションエントリポイント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-07 | WebhookSubscriptionエンティティのプロパティテスト | E-01 | ○ |
| C-08〜C-12 | WebhookDataコンストラクタとプロパティテスト | E-02 | ○ |
| C-13〜C-18 | WebhookSubscriptionRequestバリデーションテスト | E-03 | ○ |
| C-19〜C-21 | WebhookType列挙型テスト | E-04 | ○ |
| C-22〜C-24 | WebhooksRetrieverサービステスト | E-05, E-08 | ○ |
| C-25〜C-30 | WebhooksSenderサービステスト | E-06, E-09 | ○ |
| C-31〜C-40 | GrantUrlTesterServiceテスト | E-07, E-10 | ○ |
| C-41〜C-43 | OrderStatusChangedToPaidIntegrationEventHandlerテスト | E-11 | ○ |
| C-44〜C-46 | OrderStatusChangedToShippedIntegrationEventHandlerテスト | E-12 | ○ |
| C-47 | ProductPriceChangedIntegrationEventHandlerテスト | E-13 | ○ |
| C-48〜C-51 | 統合イベントレコードテスト | E-14, E-15, E-16, E-17 | ○ |
| C-52〜C-54 | WebhooksContextテスト | E-18 | ○ |
| C-55〜C-64 | WebHooksApi APIエンドポイントテスト | E-19 | ○ |
| C-65〜C-69 | RouteHandlerBuilderExtensionsテスト | E-20 | ○ |
| C-70〜C-71 | Extensions設定テスト | E-21 | ○ |
| C-72 | WebhooksDomainExceptionテスト | E-22 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全てのテストケースに対応するソースコードが存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに基づいて生成されている
- 注意点:
  - ProductPriceChangedIntegrationEventHandlerは未実装（Task.CompletedTaskを返すのみ）のため、将来の実装時にテストケースの追加が必要
  - プライベートメソッド（CheckSameOrigin, OnSendData, ToErrors）のテストはリフレクションまたは統合テストで検証する必要あり

## 6) レビュアーチェックリスト（最小）
- [ ] WebhookSubscriptionRequestのバリデーションロジックが仕様通りか確認
- [ ] GrantUrlTesterServiceの同一オリジン検証ロジックが正しいか確認
- [ ] WebhooksSenderのHTTPリクエスト構築が正しいか確認
- [ ] APIエンドポイントのアクセス制御（ユーザーIDによるフィルタリング）が適切か確認
- [ ] イベントハンドラのWebhookType指定が正しいか確認
- [ ] ProductPriceChangedIntegrationEventHandlerの未実装が意図的かどうか確認

## 7) 解析対象ファイル一覧

| カテゴリ | ファイル | クラス/メソッド数 |
|---------|---------|------------------|
| Model | WebhookSubscription.cs | 1クラス, 5プロパティ |
| Model | WebhookData.cs | 1クラス, 1コンストラクタ, 3プロパティ |
| Model | WebhookSubscriptionRequest.cs | 1クラス, 4プロパティ, 1メソッド |
| Model | WebhookType.cs | 1列挙型, 3値 |
| Service | WebhooksRetriever.cs | 1クラス, 1メソッド |
| Service | WebhooksSender.cs | 1クラス, 2メソッド |
| Service | GrantUrlTesterService.cs | 1クラス, 2メソッド |
| Service Interface | IWebhooksRetriever.cs | 1インターフェース |
| Service Interface | IWebhooksSender.cs | 1インターフェース |
| Service Interface | IGrantUrlTesterService.cs | 1インターフェース |
| IntegrationEvents | OrderStatusChangedToPaidIntegrationEventHandler.cs | 1クラス, 1メソッド |
| IntegrationEvents | OrderStatusChangedToShippedIntegrationEventHandler.cs | 1クラス, 1メソッド |
| IntegrationEvents | ProductPriceChangedIntegrationEventHandler.cs | 1クラス, 1メソッド |
| IntegrationEvents | OrderStatusChangedToPaidIntegrationEvent.cs | 1レコード |
| IntegrationEvents | OrderStatusChangedToShippedIntegrationEvent.cs | 1レコード |
| IntegrationEvents | ProductPriceChangedIntegrationEvent.cs | 1レコード |
| IntegrationEvents | OrderStockItem.cs | 1レコード |
| Infrastructure | WebhooksContext.cs | 1クラス, 1DbSet, 1メソッド |
| API | WebHooksApi.cs | 1静的クラス, 4エンドポイント |
| Extensions | RouteHandlerBuilderExtensions.cs | 1静的クラス, 2メソッド |
| Extensions | Extensions.cs | 1静的クラス, 2メソッド |
| Exceptions | WebhooksDomainException.cs | 1クラス |

## 8) テストケース分類

| 観点 | テストケース数 | 割合 |
|------|---------------|------|
| 正常系 | 45 | 62.5% |
| 異常系 | 17 | 23.6% |
| 境界値 | 10 | 13.9% |

| 優先度 | テストケース数 | 割合 |
|--------|---------------|------|
| 高 | 37 | 51.4% |
| 中 | 26 | 36.1% |
| 低 | 9 | 12.5% |
