---
generated_at: 2026-01-14 22:15:00
metrics:
  claims_total: 41
  claims_with_evidence: 41
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：eShop.AppHost 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：41 / 41、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースがソースコードに基づいて作成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/eShop-main/src/eShop.AppHost/Extensions.cs`
- E-02: `/Users/tomokababa/Work/route06/eShop-main/src/eShop.AppHost/Program.cs`
- E-03: `/Users/tomokababa/Work/route06/eShop-main/docs/code-to-docs/単体テストケース一覧/plan.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AddForwardedHeaders メソッドが存在し、TryAddEventingSubscriberを呼び出す | E-01 (L22-26) | ○ |
| C-02 | AddForwardedHeaders がbuilderを返却する（Fluent API） | E-01 (L26) | ○ |
| C-03 | AddForwardHeadersSubscriber.SubscribeAsync がイベント購読を行う | E-01 (L30-46) | ○ |
| C-04 | BeforeStartEvent時に全ProjectResourceに環境変数を設定する | E-01 (L32-43) | ○ |
| C-05 | 環境変数名はASPNETCORE_FORWARDEDHEADERS_ENABLEDである | E-01 (L38) | ○ |
| C-06 | AddOpenAI メソッドが存在しOpenAI設定を行う | E-01 (L52-159) | ○ |
| C-07 | OpenAITarget.OpenAI の場合、APIキーパラメータを追加する | E-01 (L83-93) | ○ |
| C-08 | OpenAITarget.AzureOpenAI の場合、AzureOpenAIリソースを追加する | E-01 (L137-156) | ○ |
| C-09 | OpenAITarget.AzureOpenAIExisting の場合、エンドポイントパラメータを追加する | E-01 (L68-80) | ○ |
| C-10 | OpenAITarget.AzureOpenAIExistingWithKey の場合、エンドポイントとキーを追加する | E-01 (L68-93) | ○ |
| C-11 | chatModelNameは"gpt-4.1-mini"である | E-01 (L63) | ○ |
| C-12 | textEmbeddingModelNameは"text-embedding-3-small"である | E-01 (L60) | ○ |
| C-13 | AddOllama メソッドが存在しOllama設定を行う | E-01 (L164-183) | ○ |
| C-14 | Ollamaにデータボリューム、GPU、WebUIを設定する | E-01 (L168-171) | ○ |
| C-15 | embeddingモデルは"all-minilm"である | E-01 (L172) | ○ |
| C-16 | chatモデルは"llama3.1"である | E-01 (L173) | ○ |
| C-17 | catalogApiにOllamaEnabled=trueを設定する | E-01 (L176) | ○ |
| C-18 | webAppにOllamaEnabled=trueを設定する | E-01 (L179) | ○ |
| C-19 | ConfigureMobileBffRoutes メソッドが存在する | E-01 (L185-250) | ○ |
| C-20 | catalogApiのクラスタを作成する | E-01 (L192) | ○ |
| C-21 | /catalog-api/api/catalog/items ルートを設定する | E-01 (L194-196) | ○ |
| C-22 | /catalog-api/api/catalog/items/by ルートを設定する | E-01 (L198-200) | ○ |
| C-23 | /catalog-api/api/catalog/items/{id} ルートを設定する | E-01 (L202-204) | ○ |
| C-24 | /catalog-api/api/catalog/items/by/{name} ルートを設定する | E-01 (L206-208) | ○ |
| C-25 | セマンティック検索ルート（v1形式）を設定する | E-01 (L210-212) | ○ |
| C-26 | セマンティック検索ルート（v2形式）を設定する | E-01 (L214-216) | ○ |
| C-27 | タイプ・ブランドフィルタルートを設定する | E-01 (L218-220) | ○ |
| C-28 | 全タイプ・ブランドフィルタルートを設定する | E-01 (L222-224) | ○ |
| C-29 | catalogTypesルートを設定する | E-01 (L226-228) | ○ |
| C-30 | catalogBrandsルートを設定する | E-01 (L230-232) | ○ |
| C-31 | 商品画像ルートを設定する | E-01 (L234-236) | ○ |
| C-32 | Catalogキャッチオールルートを設定する | E-01 (L239-240) | ○ |
| C-33 | Orderingルートを設定する | E-01 (L243-244) | ○ |
| C-34 | Identityルートを設定する | E-01 (L247-248) | ○ |
| C-35 | ShouldUseHttpForEndpoints 関数が存在する | E-02 (L106-113) | ○ |
| C-36 | 環境変数名はESHOP_USE_HTTP_ENDPOINTSである | E-02 (L108) | ○ |
| C-37 | 環境変数が1の場合のみtrueを返す | E-02 (L112) | ○ |
| C-38 | int.TryParseで数値変換を行う | E-02 (L112) | ○ |
| C-39 | OpenAITarget enum が定義されている | E-01 (L9-15) | ○ |
| C-40 | OpenAI, AzureOpenAI, AzureOpenAIExisting, AzureOpenAIExistingWithKey の4値が定義されている | E-01 (L11-14) | ○ |
| C-41 | api-versionクエリパラメータで1.0, 1, 2.0をサポートする | E-01 (L195, 199, 203, etc.) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースがソースコードの実装に基づいて作成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから直接導出されています
- 注意点：
  - AddOpenAIメソッドはASPIREINTERACTION001警告を抑制しているため、将来のAPI変更に注意が必要
  - ShouldUseHttpForEndpointsはテスト専用と明記されているため、本番環境での誤用に注意

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがすべてのpublicメソッドを網羅しているか確認
- [ ] OpenAITargetの各分岐に対するテストケースが適切か確認
- [ ] ConfigureMobileBffRoutesの各ルート設定に対するテストケースが適切か確認
- [ ] ShouldUseHttpForEndpointsの境界値テストが十分か確認
- [ ] privateクラスAddForwardHeadersSubscriberのテスト可能性を確認（リフレクションまたは統合テストが必要か検討）
