---
generated_at: 2026-01-14 20:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 50
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：eShop.ServiceDefaults 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：50 / 50、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/eShop.ServiceDefaults/ClaimsPrincipalExtensions.cs`
- E-02: `src/eShop.ServiceDefaults/ConfigurationExtensions.cs`
- E-03: `src/eShop.ServiceDefaults/AuthenticationExtensions.cs`
- E-04: `src/eShop.ServiceDefaults/OpenApiOptionsExtensions.cs`
- E-05: `src/eShop.ServiceDefaults/OpenApi.Extensions.cs`
- E-06: `src/eShop.ServiceDefaults/Extensions.cs`
- E-07: `src/eShop.ServiceDefaults/HttpClientExtensions.cs`
- E-08: `src/eShop.ServiceDefaults/eShop.ServiceDefaults.csproj`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ClaimsPrincipalExtensions.GetUserId - subクレームでユーザーID取得 | E-01 (L7-8) | ○ |
| C-02 | ClaimsPrincipalExtensions.GetUserId - クレームなし時null返却 | E-01 (L7-8) FindFirst?.Value | ○ |
| C-03 | ClaimsPrincipalExtensions.GetUserId - 空文字列の境界値 | E-01 (L7-8) Value返却ロジック | ○ |
| C-04 | ClaimsPrincipalExtensions.GetUserName - Nameクレームでユーザー名取得 | E-01 (L10-11) | ○ |
| C-05 | ClaimsPrincipalExtensions.GetUserName - クレームなし時null返却 | E-01 (L10-11) FindFirst?.Value | ○ |
| C-06 | ConfigurationExtensions.GetRequiredValue - 設定値取得 | E-02 (L5-6) | ○ |
| C-07 | ConfigurationExtensions.GetRequiredValue - 未設定時例外スロー | E-02 (L5-6) ?? throw | ○ |
| C-08 | ConfigurationExtensions.GetRequiredValue - IConfigurationSectionパス情報 | E-02 (L6) s.Path + ":" | ○ |
| C-09 | AuthenticationExtensions.AddDefaultAuthentication - JWT認証設定 | E-03 (L33-50) | ○ |
| C-10 | AuthenticationExtensions.AddDefaultAuthentication - Identityセクションなし時スキップ | E-03 (L24-28) | ○ |
| C-11 | AuthenticationExtensions.AddDefaultAuthentication - Url必須検証 | E-03 (L35) GetRequiredValue | ○ |
| C-12 | AuthenticationExtensions.AddDefaultAuthentication - Audience必須検証 | E-03 (L36) GetRequiredValue | ○ |
| C-13 | OpenApiOptionsExtensions.ApplyApiVersionInfo - バージョン情報設定 | E-04 (L16-33) | ○ |
| C-14 | OpenApiOptionsExtensions.ApplyApiVersionInfo - バージョン未発見時スキップ | E-04 (L23-26) | ○ |
| C-15 | OpenApiOptionsExtensions.BuildDescription - 非推奨メッセージ追加 | E-04 (L39-51) | ○ |
| C-16 | OpenApiOptionsExtensions.BuildDescription - サンセット日追加 | E-04 (L56-66) | ○ |
| C-17 | OpenApiOptionsExtensions.BuildDescription - HTMLリンク追加 | E-04 (L68-96) | ○ |
| C-18 | OpenApiOptionsExtensions.BuildDescription - ピリオド処理 | E-04 (L43-48) | ○ |
| C-19 | OpenApiOptionsExtensions.ApplySecuritySchemeDefinitions - OAuth2スキーム追加 | E-04 (L102-106, L175-206) | ○ |
| C-20 | OpenApiOptionsExtensions.ApplySecuritySchemeDefinitions - Identityなし時スキップ | E-04 (L179-183) | ○ |
| C-21 | OpenApiOptionsExtensions.ApplyAuthorizationChecks - 401/403追加 | E-04 (L108-136) | ○ |
| C-22 | OpenApiOptionsExtensions.ApplyAuthorizationChecks - 認可なし時スキップ | E-04 (L114-117) | ○ |
| C-23 | OpenApiOptionsExtensions.ApplyOperationDeprecatedStatus - 非推奨ステータス | E-04 (L138-147) | ○ |
| C-24 | OpenApiOptionsExtensions.ApplyApiVersionDescription - パラメータ説明 | E-04 (L149-173) | ○ |
| C-25 | OpenApiOptionsExtensions.ApplyApiVersionDescription - v2サンプル | E-04 (L164-166) | ○ |
| C-26 | Extensions.UseDefaultOpenApi - OpenAPIエンドポイント設定 | E-05 (L14-37) | ○ |
| C-27 | Extensions.UseDefaultOpenApi - OpenApiセクションなし時スキップ | E-05 (L19-22) | ○ |
| C-28 | Extensions.UseDefaultOpenApi - 開発環境Scalar設定 | E-05 (L26-34) | ○ |
| C-29 | Extensions.AddDefaultOpenApi - バージョン付きOpenAPI設定 | E-05 (L39-76) | ○ |
| C-30 | Extensions.AddDefaultOpenApi - OpenApiセクションなし時スキップ | E-05 (L51-54) | ○ |
| C-31 | Extensions.AddServiceDefaults - サービスデフォルト設定 | E-06 (L16-32) | ○ |
| C-32 | Extensions.AddBasicServiceDefaults - 基本サービス設定 | E-06 (L40-48) | ○ |
| C-33 | Extensions.ConfigureOpenTelemetry - OpenTelemetry設定 | E-06 (L50-83) | ○ |
| C-34 | Extensions.ConfigureOpenTelemetry - 開発環境AlwaysOnSampler | E-06 (L68-72) | ○ |
| C-35 | Extensions.AddOpenTelemetryExporters - OTLP有効時エクスポーター追加 | E-06 (L85-97) | ○ |
| C-36 | Extensions.AddOpenTelemetryExporters - OTLP無効時スキップ | E-06 (L87-89) | ○ |
| C-37 | Extensions.AddDefaultHealthChecks - selfヘルスチェック追加 | E-06 (L99-106) | ○ |
| C-38 | Extensions.MapDefaultEndpoints - 開発環境ヘルスエンドポイント | E-06 (L115-125) | ○ |
| C-39 | Extensions.MapDefaultEndpoints - 非開発環境スキップ | E-06 (L115) IsDevelopment条件 | ○ |
| C-40 | Extensions.MapDefaultEndpoints - liveタグフィルタ | E-06 (L121-124) | ○ |
| C-41 | HttpClientExtensions.AddAuthToken - ハンドラー登録 | E-07 (L11-20) | ○ |
| C-42 | HttpClientAuthorizationDelegatingHandler コンストラクタ | E-07 (L26-29) | ○ |
| C-43 | HttpClientAuthorizationDelegatingHandler コンストラクタ(innerHandler) | E-07 (L31-34) | ○ |
| C-44 | HttpClientAuthorizationDelegatingHandler.SendAsync - トークン設定 | E-07 (L36-48) | ○ |
| C-45 | HttpClientAuthorizationDelegatingHandler.SendAsync - HttpContextなし時スキップ | E-07 (L38) if条件 | ○ |
| C-46 | HttpClientAuthorizationDelegatingHandler.SendAsync - トークンなし時スキップ | E-07 (L42) if条件 | ○ |
| C-47 | HttpClientAuthorizationDelegatingHandler.SendAsync - base.SendAsync呼び出し | E-07 (L48) | ○ |
| C-48 | SecuritySchemeDefinitionsTransformer.TransformAsync - OAuth2スキーム追加 | E-04 (L177-205) | ○ |
| C-49 | SecuritySchemeDefinitionsTransformer.TransformAsync - URL設定 | E-04 (L195-196) | ○ |
| C-50 | SecuritySchemeDefinitionsTransformer.TransformAsync - Identityなし時スキップ | E-04 (L180-183) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全テストケースはソースコードから直接抽出されており、根拠が明確です。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいており、信頼度が高い
- 注意点：
  - 認証関連（UT-ESD-009〜012, UT-ESD-044〜046）は実行時の挙動検証が重要
  - OpenTelemetry設定（UT-ESD-033〜036）は環境依存のため統合テストでの検証も推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ClaimsPrincipalExtensionsのテストケースがnullハンドリングを網羅しているか確認
- [ ] ConfigurationExtensionsの例外メッセージが適切か確認
- [ ] AuthenticationExtensionsのJWT設定が本番環境で正しく動作するか確認
- [ ] OpenAPIセキュリティスキームの設定が要件を満たしているか確認
- [ ] HttpClientAuthorizationDelegatingHandlerのトークン伝播が期待通りか確認
- [ ] HealthCheckエンドポイントのセキュリティ考慮が十分か確認
- [ ] OpenTelemetry設定が本番環境要件を満たしているか確認
