---
generated_at: 2026-01-14 20:15:00
metrics:
  claims_total: 40
  claims_with_evidence: 36
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：36 / 40、根拠なし：4
- 優先レビュー（高）
  1. **UAT-032 AI検索機能**：AI機能の有効化条件が環境依存
  2. **UAT-033 レスポンシブデザイン**：CSS/レイアウトの詳細確認が必要
  3. **UAT-034 パフォーマンス**：具体的な閾値の根拠なし
  4. **UAT-038 カート永続化**：永続化の具体的実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）

### Razor コンポーネント（WebApp）
- E-01: `src/WebApp/Components/Pages/Catalog/Catalog.razor`
- E-02: `src/WebApp/Components/Pages/Item/ItemPage.razor`
- E-03: `src/WebApp/Components/Pages/Cart/CartPage.razor`
- E-04: `src/WebApp/Components/Pages/Checkout/Checkout.razor`
- E-05: `src/WebApp/Components/Pages/User/Orders.razor`
- E-06: `src/WebApp/Components/Pages/User/LogIn.razor`
- E-07: `src/WebApp/Components/Pages/User/LogOut.razor`
- E-08: `src/WebAppComponents/Catalog/CatalogSearch.razor`

### サービス層
- E-09: `src/WebApp/Services/BasketState.cs`
- E-10: `src/WebApp/Services/BasketService.cs`
- E-11: `src/WebApp/Services/OrderingService.cs`

### API層
- E-12: `src/Ordering.API/Apis/OrdersApi.cs`
- E-13: `src/Catalog.API/Apis/CatalogApi.cs`

### E2Eテスト
- E-14: `e2e/BrowseItemTest.spec.ts`
- E-15: `e2e/AddItemTest.spec.ts`
- E-16: `e2e/RemoveItemTest.spec.ts`

### Webhook管理
- E-17: `src/WebhookClient/Components/Pages/Home/Home.razor`
- E-18: `src/WebhookClient/Components/Pages/AddWebhook.razor`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 商品一覧は9件ずつページング表示 | E-01 (PageSize=9) | ○ |
| C-02 | ページリンクで次ページに遷移可能 | E-01 (GetVisiblePageIndexes) | ○ |
| C-03 | ブランドフィルターで絞り込み可能 | E-01, E-08 (BrandId パラメータ) | ○ |
| C-04 | 商品タイプフィルターで絞り込み可能 | E-01, E-08 (ItemTypeId パラメータ) | ○ |
| C-05 | 商品詳細画面で商品情報が表示される | E-02, E-14 | ○ |
| C-06 | 未ログイン時は「Log in to purchase」表示 | E-02 (isLoggedIn 判定) | ○ |
| C-07 | ログイン時は「Add to shopping bag」表示 | E-02 (isLoggedIn 判定) | ○ |
| C-08 | 存在しない商品は「Not found」表示 | E-02 (notFound, HttpStatusCode.NotFound) | ○ |
| C-09 | ログイン後は元のページにリダイレクト | E-06 (ReturnUrl 処理) | ○ |
| C-10 | ログアウト機能が存在する | E-07, UserMenu.razor | ○ |
| C-11 | 商品をカートに追加できる | E-09 (AddAsync), E-15 | ○ |
| C-12 | カート画面は認証必須 | E-03 ([Authorize] 属性) | ○ |
| C-13 | カート内数量を更新できる | E-03 (UpdateQuantityAsync), E-09 (SetQuantityAsync) | ○ |
| C-14 | 数量0でカートから削除される | E-09 (SetQuantityAsync - quantity > 0 判定), E-16 | ○ |
| C-15 | 空カートは専用メッセージ表示 | E-03 (basketItems.Count == 0) | ○ |
| C-16 | 未ログイン時はカートにアクセス不可 | E-03 ([Authorize] 属性) | ○ |
| C-17 | チェックアウト画面で住所入力可能 | E-04 (配送先フォーム) | ○ |
| C-18 | ユーザー住所が自動入力される | E-04 (PopulateFormWithDefaultInfo, ReadClaim) | ○ |
| C-19 | 必須項目のバリデーションが動作 | E-04 (DataAnnotationsValidator) | ○ |
| C-20 | 空カートでは注文不可 | E-04 (PerformCustomValidationAsync) | ○ |
| C-21 | 注文確定後は注文履歴に遷移 | E-04 (HandleValidSubmitAsync - NavigateTo) | ○ |
| C-22 | 注文履歴に注文情報が表示される | E-05, E-11 (OrderRecord) | ○ |
| C-23 | 注文なしは専用メッセージ表示 | E-05 (orders.Length == 0) | ○ |
| C-24 | 未ログイン時は注文履歴にアクセス不可 | E-05 ([Authorize] 属性) | ○ |
| C-25 | 注文ステータスがリアルタイム更新 | E-05 (OrdersRefreshOnStatusChange) | ○ |
| C-26 | Webhook一覧が表示される | E-17 (RegisteredHooks) | ○ |
| C-27 | 未ログイン時はWebhook管理不可 | E-17 (AuthorizeView - NotAuthorized) | ○ |
| C-28 | 新規Webhook登録が可能 | E-18 (RegisterAsync) | ○ |
| C-29 | OrderPaidイベントが受信表示される | E-17 (ReceivedMessages) | ○ |
| C-30 | E2E購入フローが完了する | E-01〜E-05, E-09〜E-11 | ○ |
| C-31 | 複数商品の購入が可能 | E-09 (AddAsync - 複数回呼び出し対応) | ○ |
| C-32 | セマンティック検索が動作する | E-13 (GetItemsBySemanticRelevance) | △ |
| C-33 | モバイル対応レイアウトが適用される | **根拠なし** - CSS/レイアウト詳細未確認 | △ |
| C-34 | ページが3秒以内に表示される | **根拠なし** - 性能要件の明示なし | △ |
| C-35 | API障害時に適切なエラー表示 | E-02 (HttpRequestException 処理) | ○ |
| C-36 | 認証必須画面がリダイレクトされる | E-03, E-04, E-05 ([Authorize] 属性) | ○ |
| C-37 | CSRF対策が適用される | E-02, E-03, E-04 (AntiforgeryToken) | ○ |
| C-38 | カート内容が永続化される | E-10 (BasketService) | △ |
| C-39 | カート内商品数が詳細画面で表示 | E-02 (numInCart, UpdateNumInCartAsync) | ○ |
| C-40 | チェックアウトからカートに戻れる | E-04 (Back to the shopping bag リンク) | ○ |

## 4) 不足情報（Unknown / Missing）

### UAT-032 AI検索機能
- AI機能(CatalogAI)の有効化条件が環境設定依存
- 候補：appsettings.json / 環境変数 / Aspire設定

### UAT-033 レスポンシブデザイン
- CSS/スタイルシートの詳細分析が未実施
- 候補：wwwroot/css / Tailwind設定 / コンポーネントスタイル

### UAT-034 パフォーマンス
- 具体的な性能要件の定義が見当たらない
- 候補：非機能要件定義書 / SLA文書 / 性能テスト仕様

### UAT-038 カート永続化
- BasketServiceの永続化先（Redis/DB）の詳細実装確認が必要
- 候補：Basket.API / Redis設定 / 永続化インフラ設定

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 1（中リスク） | AI検索機能 | 環境依存のため本番環境での動作確認が必要 |
| 1（中リスク） | パフォーマンス | 具体的な性能目標値の確認が必要 |
| 0（低リスク） | レスポンシブデザイン | UIの見た目確認のみで機能に影響なし |
| 0（低リスク） | カート永続化 | 基本機能は動作するが詳細実装の確認推奨 |

## 6) レビュアーチェックリスト（最小）

- [ ] E2Eテスト（UAT-001, 005, 011, 014）が実行環境で正常に動作するか確認
- [ ] [Authorize]属性による認証保護が全ての保護対象画面に適用されているか確認
- [ ] チェックアウトフローの住所バリデーションが適切か確認
- [ ] カート→注文→注文履歴の一連のフローが正常に動作するか確認
- [ ] AI検索機能の有効/無効時の両方の動作を確認
- [ ] モバイルデバイスでの画面表示を目視確認
- [ ] 本番相当環境での性能測定を実施
