---
generated_at: 2026-01-14 21:30:00
metrics:
  claims_total: 5
  claims_with_evidence: 5
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-該当なし

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：5 / 5、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠が存在）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧ファイル
- E-02: プロジェクトコードベース全体のスキャン結果
- E-03: `eShop.sln` - ソリューションファイル
- E-04: MicrosoftのeShop公式ドキュメント・リポジトリ情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 本プロジェクトには帳票生成機能が実装されていない | E-01, E-02 | ○ |
| C-02 | eShopはマイクロソフトのeコマースサンプルアプリケーションである | E-03, E-04 | ○ |
| C-03 | PDF出力、請求書、領収書などの帳票機能は含まれていない | E-02 | ○ |
| C-04 | プロジェクトの目的はマイクロサービスアーキテクチャの学習・デモンストレーションである | E-04 | ○ |
| C-05 | .NET Aspireを使用したマイクロサービスアーキテクチャを採用している | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし
  - 本ドキュメントの主張は「帳票機能が存在しない」という事実確認であり、全ての主張についてコードベースの調査と帳票一覧.csvにより根拠が確認された

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 本ドキュメントは「帳票機能が未実装である」という事実を記録するものであり、誤った設計に基づく実装リスクは存在しない

## 6) レビュアーチェックリスト（最小）
- [ ] 帳票一覧.csvの内容が「該当なし」であることを確認
- [ ] プロジェクト内に帳票生成関連のコード（PDF生成ライブラリ、テンプレートエンジン等）が存在しないことを確認
- [ ] 将来的に帳票機能が追加される可能性がある場合、本ドキュメントの更新が必要であることを認識
