---
generated_at: 2026-01-14 20:15:00
metrics:
  claims_total: 70
  claims_with_evidence: 67
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：67 / 70、根拠なし：3
- 優先レビュー（高）
  1. **BR-003 パスワードリセット**：実装詳細未確認
  2. **BR-055 カード種類一覧取得**：具体的なカード種類リスト未確認
  3. **BR-051 グレースピリオド確認**：待機時間の設定値未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs`
- E-02: `src/Ordering.Domain/AggregatesModel/OrderAggregate/OrderStatus.cs`
- E-03: `src/Ordering.Domain/AggregatesModel/OrderAggregate/OrderItem.cs`
- E-04: `src/Ordering.Domain/AggregatesModel/BuyerAggregate/Buyer.cs`
- E-05: `src/Ordering.Domain/AggregatesModel/BuyerAggregate/PaymentMethod.cs`
- E-06: `src/Ordering.Domain/AggregatesModel/BuyerAggregate/CardType.cs`
- E-07: `src/Basket.API/Grpc/BasketService.cs`
- E-08: `src/Catalog.API/Apis/CatalogApi.cs`
- E-09: `src/Catalog.API/Model/CatalogItem.cs`
- E-10: `src/Ordering.API/Apis/OrdersApi.cs`
- E-11: `src/Ordering.API/Application/Commands/CreateOrderCommand.cs`
- E-12: `src/Ordering.API/Application/Commands/CreateOrderCommandHandler.cs`
- E-13: `src/Ordering.API/Application/Validations/CreateOrderCommandValidator.cs`
- E-14: `src/Identity.API/Services/EFLoginService.cs`
- E-15: `src/Identity.API/Models/AccountViewModels/RegisterViewModel.cs`
- E-16: `src/WebApp/Services/BasketState.cs`
- E-17: `src/WebApp/Services/OrderingService.cs`
- E-18: `src/OrderProcessor/Services/GracePeriodManagerService.cs`
- E-19: `src/PaymentProcessor/Program.cs`
- E-20: `src/Webhooks.API/Apis/WebHooksApi.cs`
- E-21: `src/Webhooks.API/Model/WebhookType.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001 ユーザー登録（メールアドレスとパスワード） | E-15 | ○ |
| C-02 | BR-002 ユーザーログイン（認証処理） | E-14 | ○ |
| C-03 | BR-003 パスワードリセット機能 | **根拠なし** | △ |
| C-04 | BR-004 商品一覧表示（ページネーション付き） | E-08 | ○ |
| C-05 | BR-005 商品詳細表示（ID指定） | E-08 | ○ |
| C-06 | BR-006 商品名検索（前方一致） | E-08 | ○ |
| C-07 | BR-007 セマンティック検索（AI埋め込み） | E-08 | ○ |
| C-08 | BR-008 ブランド別検索 | E-08 | ○ |
| C-09 | BR-009 タイプ別検索 | E-08 | ○ |
| C-10 | BR-010 商品登録 | E-08 | ○ |
| C-11 | BR-011 商品更新（価格変更イベント） | E-08 | ○ |
| C-12 | BR-012 商品削除 | E-08 | ○ |
| C-13 | BR-013 商品画像取得 | E-08 | ○ |
| C-14 | BR-014 ブランド一覧取得 | E-08 | ○ |
| C-15 | BR-015 タイプ一覧取得 | E-08 | ○ |
| C-16 | BR-016 在庫引当（RemoveStock） | E-09 | ○ |
| C-17 | BR-017 在庫補充（AddStock） | E-09 | ○ |
| C-18 | BR-018 在庫切れ判定（例外スロー） | E-09 | ○ |
| C-19 | BR-019 再発注フラグ管理 | E-09 | ○ |
| C-20 | BR-020 買い物かご取得 | E-07 | ○ |
| C-21 | BR-021 買い物かご更新 | E-07 | ○ |
| C-22 | BR-022 買い物かご削除 | E-07 | ○ |
| C-23 | BR-023 商品追加（数量加算） | E-16 | ○ |
| C-24 | BR-024 数量変更 | E-16 | ○ |
| C-25 | BR-025 注文作成（べき等性） | E-10, E-12 | ○ |
| C-26 | BR-026 注文一覧取得 | E-10 | ○ |
| C-27 | BR-027 注文詳細取得 | E-10 | ○ |
| C-28 | BR-028 注文キャンセル | E-01, E-10 | ○ |
| C-29 | BR-029 注文出荷 | E-01, E-10 | ○ |
| C-30 | BR-030 注文ドラフト作成 | E-10 | ○ |
| C-31 | BR-031 住所情報必須 | E-13 | ○ |
| C-32 | BR-032 カード情報必須 | E-13 | ○ |
| C-33 | BR-033 カード番号検証（12-19桁） | E-13 | ○ |
| C-34 | BR-034 カード有効期限検証 | E-13 | ○ |
| C-35 | BR-035 注文明細必須 | E-13 | ○ |
| C-36 | BR-036 注文数量検証 | E-03 | ○ |
| C-37 | BR-037 割引額検証 | E-03 | ○ |
| C-38 | BR-038 注文ステータス:Submitted | E-01, E-02 | ○ |
| C-39 | BR-039 注文ステータス:AwaitingValidation | E-01, E-02 | ○ |
| C-40 | BR-040 注文ステータス:StockConfirmed | E-01, E-02 | ○ |
| C-41 | BR-041 注文ステータス:Paid | E-01, E-02 | ○ |
| C-42 | BR-042 注文ステータス:Shipped | E-01, E-02 | ○ |
| C-43 | BR-043 注文ステータス:Cancelled | E-01, E-02 | ○ |
| C-44 | BR-044 在庫不足キャンセル | E-01 | ○ |
| C-45 | BR-045 購入者情報管理 | E-04 | ○ |
| C-46 | BR-046 支払方法登録 | E-04, E-05 | ○ |
| C-47 | BR-047 支払方法検証 | E-04, E-05 | ○ |
| C-48 | BR-048 決済処理実行 | E-19 | ○ |
| C-49 | BR-049 決済成功処理 | E-12 | ○ |
| C-50 | BR-050 決済失敗処理 | E-12 | ○ |
| C-51 | BR-051 グレースピリオド確認 | E-18 | ○ |
| C-52 | BR-052 グレースピリオド完了イベント | E-18 | ○ |
| C-53 | BR-053 チェックアウト処理 | E-16 | ○ |
| C-54 | BR-054 チェックアウト情報 | E-16 | ○ |
| C-55 | BR-055 カード種類一覧取得 | **根拠なし** | △ |
| C-56 | BR-056 Webhook登録 | E-20 | ○ |
| C-57 | BR-057 Webhook一覧取得 | E-20 | ○ |
| C-58 | BR-058 Webhook削除 | E-20 | ○ |
| C-59 | BR-059 価格変更通知 | E-21 | ○ |
| C-60 | BR-060 出荷通知 | E-21 | ○ |
| C-61 | BR-061 支払完了通知 | E-21 | ○ |
| C-62 | BR-062 注文開始イベント | E-12 | ○ |
| C-63 | BR-063 在庫確認要求イベント | E-01 | ○ |
| C-64 | BR-064 在庫確認完了イベント | E-08 | ○ |
| C-65 | BR-065 在庫不足イベント | E-08 | ○ |
| C-66 | BR-066 支払確認要求イベント | E-01 | ○ |
| C-67 | BR-067 価格変更イベント | E-08 | ○ |
| C-68 | BR-068 注文合計金額計算 | E-01 | ○ |
| C-69 | BR-069 割引適用 | E-01, E-03 | ○ |
| C-70 | BR-070 割引検証 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）

- **BR-003 パスワードリセット**：Identity.APIのコードにリセット機能の実装は推測されるが、具体的なコントローラ/サービスの実装を確認できていない
  - 候補：ForgotPasswordViewModel.cs / ResetPasswordViewModel.cs（存在確認済み）

- **BR-055 カード種類一覧取得**：CardType.csにはId/Nameのみ定義されており、具体的なカード種類（Amex/Visa/MasterCard等）のシードデータを確認できていない
  - 候補：OrderingContextSeed.cs / Database Migration

- **BR-051 グレースピリオド確認時間**：BackgroundTaskOptionsの設定値が環境設定ファイルに依存
  - 候補：appsettings.json / 環境変数設定

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**：ほとんどの業務要件はソースコードから直接確認可能
- **1（中リスク）**：
  - BR-003（パスワードリセット）：セキュリティ関連のため実装詳細の確認推奨
  - BR-055（カード種類）：決済に関連するためマスタデータの確認推奨
- **0（低リスク）**：その他の業務要件はドメインモデル/APIから明確に読み取れる

## 6) レビュアーチェックリスト（最小）

- [ ] BR-003（パスワードリセット）の実装有無を確認
- [ ] CardTypeのマスタデータ（シードデータ）を確認
- [ ] グレースピリオドの設定値（GracePeriodTime）を確認
- [ ] 注文状態遷移の制約がドメインロジックと一致することを確認
- [ ] バリデーションルール（カード番号桁数、有効期限等）がフロントエンドと一致することを確認
- [ ] Webhook通知のリトライ/エラーハンドリングの詳細を確認
