---
generated_at: 2026-01-14 20:25:00
metrics:
  claims_total: 61
  claims_with_evidence: 61
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：61 / 61、根拠なし：0
- 優先レビュー（高）
  - なし（全ての機能にソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Catalog.API/Apis/CatalogApi.cs`
- E-02: `src/Ordering.API/Apis/OrdersApi.cs`
- E-03: `src/Webhooks.API/Apis/WebHooksApi.cs`
- E-04: `src/Basket.API/Grpc/BasketService.cs`
- E-05: `src/Identity.API/Services/EFLoginService.cs`
- E-06: `src/PaymentProcessor/IntegrationEvents/EventHandling/OrderStatusChangedToStockConfirmedIntegrationEventHandler.cs`
- E-07: `src/OrderProcessor/Services/GracePeriodManagerService.cs`
- E-08: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs`
- E-09: `src/Catalog.API/Services/CatalogAI.cs`
- E-10: `src/WebApp/Components/Pages/Catalog/Catalog.razor`
- E-11: `src/WebApp/Components/Pages/Item/ItemPage.razor`
- E-12: `src/WebApp/Components/Pages/Cart/CartPage.razor`
- E-13: `src/WebApp/Components/Pages/Checkout/Checkout.razor`
- E-14: `src/WebApp/Components/Pages/User/Orders.razor`
- E-15: `src/WebApp/Components/Chatbot/Chatbot.razor`
- E-16: `src/WebApp/Components/Pages/User/LogIn.razor`
- E-17: `src/WebApp/Components/Pages/User/LogOut.razor`
- E-18: `src/WebhookClient/Components/Pages/Home/Home.razor`
- E-19: `src/WebhookClient/Components/Pages/AddWebhook.razor`
- E-20: `src/WebhookClient/Components/Pages/Home/ReceivedMessages.razor`
- E-21: `src/WebhookClient/Components/Pages/Home/RegisteredHooks.razor`
- E-22: `src/Webhooks.API/Services/WebhooksSender.cs`
- E-23: `src/Webhooks.API/Services/GrantUrlTesterService.cs`
- E-24: `src/EventBus/EventBus.csproj`
- E-25: `src/EventBusRabbitMQ/EventBusRabbitMQ.csproj`
- E-26: `src/IntegrationEventLogEF/Services/IntegrationEventLogService.cs`
- E-27: `src/HybridApp/Components/Pages/Catalog/Catalog.razor`
- E-28: `src/HybridApp/Components/Pages/Item/ItemPage.razor`
- E-29: `src/WebApp/Services/BasketService.cs`
- E-30: `src/WebApp/Services/OrderingService.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 商品一覧取得 - カタログ内の商品をページネーション付きで一覧表示する機能 | E-01 (GetAllItems メソッド) | ○ |
| C-02 | 商品詳細取得 - 指定されたIDの商品詳細情報を取得する機能 | E-01 (GetItemById メソッド) | ○ |
| C-03 | 商品一括取得 - 複数のIDを指定して商品を一括取得する機能 | E-01 (GetItemsByIds メソッド) | ○ |
| C-04 | 商品画像取得 - 商品IDに対応する商品画像ファイルを取得する機能 | E-01 (GetItemPictureById メソッド) | ○ |
| C-05 | 商品名検索 - 商品名の前方一致で商品を検索する機能 | E-01 (GetItemsByName メソッド) | ○ |
| C-06 | AI商品検索 - AI（ベクトル埋め込み）を使用してセマンティック検索を実行 | E-01, E-09 (GetItemsBySemanticRelevance, CatalogAI) | ○ |
| C-07 | タイプ別商品取得 - 商品タイプとブランドでフィルタリングした商品一覧を取得 | E-01 (GetItemsByBrandAndTypeId メソッド) | ○ |
| C-08 | ブランド別商品取得 - ブランドでフィルタリングした商品一覧を取得 | E-01 (GetItemsByBrandId メソッド) | ○ |
| C-09 | 商品タイプ一覧取得 - カタログ内の商品タイプ一覧を取得 | E-01 (GET /catalogtypes エンドポイント) | ○ |
| C-10 | ブランド一覧取得 - カタログ内のブランド一覧を取得 | E-01 (GET /catalogbrands エンドポイント) | ○ |
| C-11 | 商品登録 - 新しい商品をカタログに登録する機能 | E-01 (CreateItem メソッド) | ○ |
| C-12 | 商品更新 - 既存の商品情報を更新する機能 | E-01 (UpdateItem メソッド) | ○ |
| C-13 | 商品削除 - 指定されたIDの商品をカタログから削除する機能 | E-01 (DeleteItemById メソッド) | ○ |
| C-14 | かご取得 - ユーザーの買い物かごの内容を取得する機能（gRPC） | E-04 (GetBasket メソッド) | ○ |
| C-15 | かご更新 - 買い物かごに商品を追加・数量変更する機能（gRPC） | E-04 (UpdateBasket メソッド) | ○ |
| C-16 | かご削除 - 買い物かごの内容を全て削除する機能（gRPC） | E-04 (DeleteBasket メソッド) | ○ |
| C-17 | 注文作成 - 買い物かごの内容から新しい注文を作成する機能 | E-02 (CreateOrderAsync メソッド) | ○ |
| C-18 | 注文下書き作成 - 注文の下書きを作成する機能 | E-02 (CreateOrderDraftAsync メソッド) | ○ |
| C-19 | 注文詳細取得 - 指定されたIDの注文詳細を取得する機能 | E-02 (GetOrderAsync メソッド) | ○ |
| C-20 | ユーザー注文履歴取得 - ログインユーザーの注文履歴一覧を取得 | E-02 (GetOrdersByUserAsync メソッド) | ○ |
| C-21 | 注文キャンセル - 注文をキャンセルする機能 | E-02 (CancelOrderAsync メソッド) | ○ |
| C-22 | 注文発送処理 - 注文を発送済みステータスに変更する機能 | E-02 (ShipOrderAsync メソッド) | ○ |
| C-23 | カードタイプ取得 - 利用可能なカードタイプ一覧を取得する機能 | E-02 (GetCardTypesAsync メソッド) | ○ |
| C-24 | 注文ステータス管理 - 注文ステータスの遷移を管理 | E-08 (Order クラス, OrderStatus) | ○ |
| C-25 | 在庫検証待ち処理 - 注文の在庫検証待ちステータスへの遷移処理 | E-08 (SetAwaitingValidationStatus メソッド) | ○ |
| C-26 | 在庫確認済み処理 - 在庫確認完了時のステータス遷移処理 | E-08 (SetStockConfirmedStatus メソッド) | ○ |
| C-27 | 支払い完了処理 - 支払い完了時のステータス遷移処理 | E-08 (SetPaidStatus メソッド) | ○ |
| C-28 | 在庫不足キャンセル処理 - 在庫不足による自動キャンセル処理 | E-08 (SetCancelledStatusWhenStockIsRejected メソッド) | ○ |
| C-29 | 決済シミュレーション - 注文の決済処理をシミュレーションする機能 | E-06 (Handle メソッド) | ○ |
| C-30 | 猶予期間確認処理 - 猶予期間を超えた注文を定期的に確認するバックグラウンドサービス | E-07 (ExecuteAsync, CheckConfirmedGracePeriodOrders メソッド) | ○ |
| C-31 | ユーザーログイン - メールアドレスとパスワードでユーザー認証を行う機能 | E-05 (EFLoginService クラス) | ○ |
| C-32 | ユーザー検索 - メールアドレスでユーザーを検索する機能 | E-05 (FindByUsername メソッド) | ○ |
| C-33 | 認証情報検証 - ユーザーのパスワードを検証する機能 | E-05 (ValidateCredentials メソッド) | ○ |
| C-34 | サインイン処理 - ユーザーのサインイン状態を確立する機能 | E-05 (SignIn, SignInAsync メソッド) | ○ |
| C-35 | Webhook一覧取得 - ユーザーが登録したWebhookサブスクリプション一覧を取得 | E-03 (GET / エンドポイント) | ○ |
| C-36 | Webhook詳細取得 - 指定されたIDのWebhookサブスクリプション詳細を取得 | E-03 (GET /{id} エンドポイント) | ○ |
| C-37 | Webhook登録 - 新しいWebhookサブスクリプションを登録する機能 | E-03 (POST / エンドポイント) | ○ |
| C-38 | Webhook削除 - 指定されたIDのWebhookサブスクリプションを削除 | E-03 (DELETE /{id} エンドポイント) | ○ |
| C-39 | Webhook送信 - 登録されたWebhookエンドポイントにイベント通知を送信 | E-22 (WebhooksSender クラス) | ○ |
| C-40 | Grant URL検証 - Webhook登録時にGrant URLの有効性を検証 | E-23 (GrantUrlTesterService クラス) | ○ |
| C-41 | カタログ画面 - 商品一覧を表示しフィルタリングできる画面 | E-10 (Catalog.razor) | ○ |
| C-42 | 商品詳細画面 - 商品の詳細情報を表示しカートに追加できる画面 | E-11 (ItemPage.razor) | ○ |
| C-43 | 買い物かご画面 - 買い物かごの内容を表示し数量変更できる画面 | E-12 (CartPage.razor) | ○ |
| C-44 | チェックアウト画面 - 配送先住所を入力し注文を確定する画面 | E-13 (Checkout.razor) | ○ |
| C-45 | 注文履歴画面 - ユーザーの注文履歴一覧を表示する画面 | E-14 (Orders.razor) | ○ |
| C-46 | AIチャットボット - Azure OpenAIを使用した商品検索支援チャットボット機能 | E-15 (Chatbot.razor) | ○ |
| C-47 | ログイン画面 - ユーザー認証を行うログイン画面 | E-16 (LogIn.razor) | ○ |
| C-48 | ログアウト処理 - ユーザーのログアウト処理を行う機能 | E-17 (LogOut.razor) | ○ |
| C-49 | WebhookClientホーム画面 - 登録済みWebhookと受信メッセージを表示 | E-18 (Home.razor) | ○ |
| C-50 | Webhook登録画面 - 新しいWebhookを登録する画面 | E-19 (AddWebhook.razor) | ○ |
| C-51 | 受信メッセージ表示 - Webhookで受信したメッセージ一覧を表示 | E-20 (ReceivedMessages.razor) | ○ |
| C-52 | 登録済みWebhook表示 - 登録済みのWebhook一覧を表示 | E-21 (RegisteredHooks.razor) | ○ |
| C-53 | 統合イベント発行 - マイクロサービス間でイベントを発行する機能 | E-24 (EventBus プロジェクト) | ○ |
| C-54 | 統合イベント購読 - 統合イベントを購読しハンドラを実行する機能 | E-24 (EventBus プロジェクト) | ○ |
| C-55 | RabbitMQ連携 - RabbitMQを使用したメッセージブローカー連携機能 | E-25 (EventBusRabbitMQ プロジェクト) | ○ |
| C-56 | イベントログ保存 - 統合イベントをデータベースに永続化する機能 | E-26 (IntegrationEventLogService) | ○ |
| C-57 | イベントログ取得 - 保存済みの統合イベントを取得する機能 | E-26 (IntegrationEventLogService) | ○ |
| C-58 | 埋め込みベクトル生成 - 商品情報からAI埋め込みベクトルを生成する機能 | E-09 (GetEmbeddingAsync メソッド) | ○ |
| C-59 | 一括埋め込み生成 - 複数商品の埋め込みベクトルを一括生成する機能 | E-09 (GetEmbeddingsAsync メソッド) | ○ |
| C-60 | HybridAppカタログ - MAUI Blazor Hybridアプリでのカタログ表示機能 | E-27 (HybridApp/Catalog.razor) | ○ |
| C-61 | HybridApp商品詳細 - MAUI Blazor Hybridアプリでの商品詳細表示機能 | E-28 (HybridApp/ItemPage.razor) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての機能についてソースコードから直接根拠を確認）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての機能がソースコードに基づいて抽出されており、高い信頼性があります

## 6) レビュアーチェックリスト（最小）
- [ ] 各機能の説明が実際のコードの挙動と一致しているか確認
- [ ] APIエンドポイントのパスが正確か確認
- [ ] 機能のカテゴリ分類が適切か確認
- [ ] 漏れている機能がないか確認（特にバックエンドの内部処理）
- [ ] 各サービスの統合イベント連携が正しく記載されているか確認
