# 機能設計書 10-ブランド一覧取得

## 概要

本ドキュメントは、eShopアプリケーションにおけるブランド一覧取得機能の設計仕様を定義する。カタログに登録されているすべてのブランドを取得するREST APIエンドポイントを提供する。

### 本機能の処理概要

**業務上の目的・背景**：ECサイトにおいて、商品のフィルタリングやナビゲーションに使用するブランド一覧を提供する。ユーザーが商品を絞り込む際の選択肢として、また管理画面での商品登録時のブランド選択に使用される。

**機能の利用シーン**：カタログ画面でのブランドフィルタドロップダウン、ブランドナビゲーション、商品登録・編集画面でのブランド選択など、ブランド一覧を表示する場面で利用される。

**主要な処理内容**：
1. CatalogBrandsテーブルから全レコードを取得
2. ブランド名でソートしてリストとして返却

**関連システム・外部連携**：PostgreSQLデータベースからEntity Framework Coreを通じてデータを取得する。

**権限による制御**：本APIエンドポイントは認証不要で公開されており、誰でもアクセス可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | カタログ画面 | 参照画面 | CatalogSearchコンポーネントでブランドフィルタリング用一覧を取得 |
| 25 | カタログ画面（HybridApp） | 参照画面 | CatalogSearchでブランドフィルタリング用一覧を取得 |

## 機能種別

CRUD操作（Read）/ マスタデータ取得

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| (なし) | - | - | パラメータなし | - |

### 入力データソース

- HTTPリクエスト: `GET /api/catalog/catalogbrands`

## 出力仕様

### 出力データ

**正常時（200 OK）: List&lt;CatalogBrand&gt;**

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Id | int | ブランドID |
| Brand | string | ブランド名 |

### 出力先

- HTTP Response Body（JSON配列形式）
- Content-Type: application/json

## 処理フロー

### 処理シーケンス

```
1. HTTPリクエスト受信
   └─ パラメータなし

2. データベースクエリ実行
   ├─ CatalogBrandsテーブルから全件取得
   └─ OrderBy(x => x.Brand)でブランド名順にソート

3. レスポンス生成
   └─ List<CatalogBrand>をJSONで返却
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B[CatalogBrandsクエリ]
    B --> C[ブランド名でソート]
    C --> D[ToListAsync]
    D --> E[List返却]
    E --> F[200 OK]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 全件取得 | ページネーションなしで全ブランドを取得 | 常時 |
| BR-002 | ソート順 | ブランド名（Brand）の昇順でソート | 常時 |

### 計算ロジック

本機能に計算ロジックはない。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ブランド一覧取得 | CatalogBrand | SELECT | 全ブランドを取得 |

### テーブル別操作詳細

#### CatalogBrand

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | Id, Brand | 全件取得、ORDER BY Brand ASC | マスタデータ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | BadRequest | リクエスト形式が不正 | ProblemDetails形式でエラー詳細を返却 |
| 500 | InternalServerError | データベース接続エラー等 | サーバーエラーとして処理 |

### リトライ仕様

本機能では明示的なリトライ処理は実装されていない。

## トランザクション仕様

読み取り専用操作のため、明示的なトランザクション制御は行わない。

## パフォーマンス要件

- マスタデータのため、レコード数は限定的（通常数十件程度）
- 全件取得でもパフォーマンス影響は軽微

## セキュリティ考慮事項

- 認証不要のパブリックAPI
- マスタデータのため、機密情報は含まれない

## 備考

- V1/V2両方のAPIバージョンで共通のエンドポイント（apiグループ）
- ブランドはシードデータとして事前登録されている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CatalogBrand.cs | `src/Catalog.API/Model/CatalogBrand.cs` | ブランドエンティティの構造 |

**読解のコツ**: CatalogBrandは単純なエンティティで、Id（int）とBrand（string、[Required]）の2プロパティのみ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CatalogApi.cs | `src/Catalog.API/Apis/CatalogApi.cs` | インラインラムダでの実装 |

**主要処理フロー**:
1. **84-90行目**: `/catalogbrands` エンドポイント定義（インラインラムダ）
2. **86行目**: `context.CatalogBrands.OrderBy(x => x.Brand).ToListAsync()`
3. ラムダ式内で直接クエリを実行し、結果を返却

#### Step 3: データアクセス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CatalogContext.cs | `src/Catalog.API/Infrastructure/CatalogContext.cs` | CatalogBrandsのDbSet定義 |

**主要処理フロー**:
- **15行目**: `DbSet<CatalogBrand> CatalogBrands`

### プログラム呼び出し階層図

```
HTTP Request (GET /api/catalog/catalogbrands)
    │
    └─ インラインラムダ式
           │
           └─ CatalogContext.CatalogBrands
                  ├─ OrderBy(x => x.Brand)
                  └─ ToListAsync()
                         │
                         └─ List<CatalogBrand>
```

### データフロー図

```
[入力]                [処理]                              [出力]

HTTPリクエスト         インラインラムダ                    HTTPレスポンス
  │                        │                                │
  └─ (パラメータなし) ────▶│                                │
                           │   PostgreSQL                   │
                           │   (CatalogBrand table)         │
                           │      │                         │
                           │      ▼                         │
                           └─▶ List<CatalogBrand> ─────────▶ JSON配列
                                 ├─ { Id: 1, Brand: "..." }
                                 ├─ { Id: 2, Brand: "..." }
                                 └─ ...
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CatalogApi.cs | `src/Catalog.API/Apis/CatalogApi.cs` | ソース | APIエンドポイント定義 |
| CatalogBrand.cs | `src/Catalog.API/Model/CatalogBrand.cs` | ソース | ブランドエンティティモデル |
| CatalogContext.cs | `src/Catalog.API/Infrastructure/CatalogContext.cs` | ソース | DbContext・DbSet定義 |
| CatalogBrandEntityTypeConfiguration.cs | `src/Catalog.API/Infrastructure/EntityConfigurations/CatalogBrandEntityTypeConfiguration.cs` | ソース | エンティティ設定 |
