# 機能設計書 17-注文作成

## 概要

本ドキュメントは、eShopシステムにおける注文作成機能の詳細設計を記載する。

### 本機能の処理概要

本機能は、買い物かごの内容から新しい注文を作成するためのREST APIエンドポイントを提供する。配送先住所、支払いカード情報、注文商品を受け取り、DDDパターンに基づいてOrderエンティティを生成・永続化する。注文作成時にはドメインイベントおよび統合イベントが発行され、買い物かごのクリアや在庫検証などの後続処理がトリガーされる。

**業務上の目的・背景**：EC事業の中核となる受注処理機能である。ユーザーが商品を購入する意思を示し、配送・決済情報を確定することで、商品の引き渡しおよび代金回収のプロセスが開始される。本機能は注文のライフサイクルの起点となる重要な機能である。

**機能の利用シーン**：
- チェックアウト画面で注文を確定する場合
- 配送先住所と支払い情報を入力して注文を完了する場合

**主要な処理内容**：
1. HTTPリクエストから注文情報（配送先住所、カード情報、商品リスト）を受け取る
2. 重複リクエスト防止のためのIdempotencyチェックを行う
3. OrderStartedIntegrationEventを発行し、買い物かごをクリアする
4. DDDパターンに基づきOrderエンティティを生成する
5. OrderStartedDomainEventを発行し、Buyer/PaymentMethodを検証・作成する
6. データベースに注文を永続化する
7. OK (200)レスポンスを返却する

**関連システム・外部連携**：
- イベントバス（RabbitMQ）への統合イベント発行
- Basket.API（買い物かごクリア）
- Catalog.API（在庫検証）
- PaymentProcessor（決済処理）

**権限による制御**：認証が必須。ユーザーIDはリクエストから取得する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | チェックアウト画面 | 主機能 | BasketState.CheckoutAsyncで注文を作成 |

## 機能種別

CRUD操作（Create） / イベント駆動 / DDDパターン

## 入力仕様

### 入力パラメータ

**HTTPヘッダー**

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| x-requestid | Guid | Yes | 冪等性のためのリクエストID | 空GUIDは不可 |

**リクエストボディ（CreateOrderRequest）**

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| UserId | string | Yes | ユーザーID | - |
| UserName | string | Yes | ユーザー名 | - |
| City | string | Yes | 配送先都市 | - |
| Street | string | Yes | 配送先通り | - |
| State | string | Yes | 配送先州 | - |
| Country | string | Yes | 配送先国 | - |
| ZipCode | string | Yes | 配送先郵便番号 | - |
| CardNumber | string | Yes | カード番号 | マスク処理される |
| CardHolderName | string | Yes | カード名義人 | - |
| CardExpiration | DateTime | Yes | カード有効期限 | - |
| CardSecurityNumber | string | Yes | セキュリティコード | - |
| CardTypeId | int | Yes | カードタイプID | - |
| Buyer | string | Yes | 購入者名 | - |
| Items | List<BasketItem> | Yes | 注文商品リスト | - |

### 入力データソース

- HTTPヘッダー: x-requestid（冪等性キー）
- リクエストボディ: HTTP POSTリクエストボディ（JSON形式）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| - | - | 成功時はレスポンスボディなし |

### 出力先

- HTTPレスポンス（200 OK / 400 BadRequest）
- PostgreSQL Ordersテーブル（INSERT）
- PostgreSQL OrderItemsテーブル（INSERT）
- PostgreSQL Buyersテーブル（INSERT/UPDATE）
- PostgreSQL PaymentMethodsテーブル（INSERT/UPDATE）
- 統合イベントログ
- イベントバス

## 処理フロー

### 処理シーケンス

```
1. HTTPリクエスト受信
   └─ POST /api/orders

2. リクエストID検証
   └─ x-requestid が空GUIDの場合はBadRequest (400)

3. カード番号マスク
   └─ 末尾4桁以外をXでマスク

4. IdentifiedCommandでラップ
   └─ CreateOrderCommandを冪等性対応コマンドに変換

5. CreateOrderCommandHandler実行
   ├─ OrderStartedIntegrationEvent発行（買い物かごクリア用）
   └─ Orderエンティティ生成
       ├─ AddressバリューオブジェクトS生成
       ├─ OrderStartedDomainEvent追加
       └─ 各OrderItem追加

6. UnitOfWork.SaveEntitiesAsync
   ├─ Ordersテーブル INSERT
   ├─ OrderItemsテーブル INSERT
   ├─ ドメインイベント発行
   │   └─ OrderStartedDomainEventHandler
   │       ├─ Buyer検証/作成
   │       └─ PaymentMethod検証/作成
   └─ トランザクションコミット

7. レスポンス返却
   └─ OK (200)
```

### フローチャート

```mermaid
flowchart TD
    A[POST /api/orders] --> B{requestId有効?}
    B -->|No| C[BadRequest 400]
    B -->|Yes| D[カード番号マスク]
    D --> E[IdentifiedCommand生成]
    E --> F{重複チェック}
    F -->|重複| G[true返却]
    F -->|新規| H[統合イベント発行]
    H --> I[Orderエンティティ生成]
    I --> J[OrderItem追加]
    J --> K[DB保存]
    K --> L[ドメインイベント処理]
    L --> M[OK 200]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-17-01 | 冪等性保証 | 同一requestIdのリクエストは重複処理しない | 常に |
| BR-17-02 | カード番号マスク | カード番号は末尾4桁以外をマスクして保存 | 注文作成時 |
| BR-17-03 | 初期ステータス | 注文は「Submitted」ステータスで作成される | 注文作成時 |
| BR-17-04 | 自動カートクリア | 注文作成時に買い物かごは自動クリアされる | 注文作成成功時 |
| BR-17-05 | 同一商品集約 | 同じ商品IDの注文明細は数量を集約する | AddOrderItem時 |

### 計算ロジック

注文合計金額:
- 合計 = Σ (各商品の単価 × 数量)

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 注文作成 | Orders | INSERT | 注文レコード作成 |
| 明細作成 | OrderItems | INSERT | 注文明細レコード作成 |
| 購入者作成/更新 | Buyers | INSERT/UPDATE | 購入者情報作成/更新 |
| 支払方法作成/更新 | PaymentMethods | INSERT/UPDATE | 支払方法情報作成/更新 |
| 冪等性管理 | ClientRequest | INSERT | リクエストID記録 |
| イベントログ | IntegrationEventLog | INSERT | 統合イベント永続化 |

### テーブル別操作詳細

#### Orders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | Id | 自動採番 | 主キー |
| INSERT | OrderDate | DateTime.UtcNow | 注文日時 |
| INSERT | Address_* | 入力値 | 配送先住所（ValueObject） |
| INSERT | BuyerId | 後から設定 | ドメインイベント処理後 |
| INSERT | OrderStatus | Submitted | 初期ステータス |
| INSERT | PaymentId | 後から設定 | ドメインイベント処理後 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | Bad Request | x-requestidが空GUIDの場合 | 有効なGUIDを指定 |
| 400 | Bad Request | バリデーションエラー | 入力値を修正 |
| 500 | Internal Server Error | DB保存失敗時 | サーバーログを確認 |

### リトライ仕様

- IdentifiedCommandパターンにより、同一requestIdでの再リクエストは冪等に処理される
- 重複リクエストはtrueを返して正常終了扱いとなる

## トランザクション仕様

- TransactionBehaviorにより、コマンド実行全体がトランザクションでラップされる
- 統合イベントログとOrdersテーブルの更新はアトミックに実行される
- エラー発生時は自動ロールバック

## パフォーマンス要件

- DDDパターンによる複数ドメインイベント処理があるため、処理時間は数百ミリ秒程度
- 統合イベント発行は非同期処理

## セキュリティ考慮事項

- カード番号はマスク処理されて保存される
- セキュリティコードは保存されない（ドメインイベント処理時のみ使用）
- 認証必須

## 備考

- DDDパターン（Domain-Driven Design）を採用しており、ビジネスロジックはドメイン層に集約
- CQRSパターン（Command Query Responsibility Segregation）を採用しており、コマンドとクエリが分離
- MediatRライブラリを使用したコマンド/イベントハンドリング

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Order.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` | 注文エンティティ（Aggregate Root） |
| 1-2 | OrderItem.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/OrderItem.cs` | 注文明細エンティティ |
| 1-3 | Address.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Address.cs` | 住所バリューオブジェクト |
| 1-4 | OrderStatus.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/OrderStatus.cs` | 注文ステータス列挙型 |
| 1-5 | CreateOrderCommand.cs | `src/Ordering.API/Application/Commands/CreateOrderCommand.cs` | コマンドオブジェクト |

**読解のコツ**: DDDパターンでは、Aggregate Rootを通じてのみ子エンティティを操作する。Order.AddOrderItem()メソッドがその例。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | OrdersApi.cs | `src/Ordering.API/Apis/OrdersApi.cs` | APIエンドポイント、CreateOrderAsync |

**主要処理フロー**:
1. **17行目**: `api.MapPost("/", CreateOrderAsync)` - エンドポイント定義
2. **118-168行目**: `CreateOrderAsync` - API処理
3. **132-135行目**: requestId検証
4. **140-144行目**: CreateOrderCommand生成（カード番号マスク）
5. **146行目**: IdentifiedCommandでラップ
6. **155行目**: Mediator.Send

#### Step 3: コマンドハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CreateOrderCommandHandler.cs | `src/Ordering.API/Application/Commands/CreateOrderCommandHandler.cs` | コマンドハンドラ実装 |
| 3-2 | IdentifiedCommandHandler.cs | `src/Ordering.API/Application/Commands/IdentifiedCommandHandler.cs` | 冪等性ハンドラ |

**主要処理フロー**:
- **29-52行目**: `Handle`メソッド
- **32-33行目**: 統合イベント発行
- **39行目**: Addressバリューオブジェクト生成
- **40行目**: Orderエンティティ生成
- **42-45行目**: OrderItem追加
- **49行目**: リポジトリへ追加
- **51行目**: UnitOfWork.SaveEntitiesAsync

#### Step 4: ドメインモデルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Order.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` | Orderコンストラクタとドメインイベント追加 |

**主要処理フロー**:
- **52-65行目**: コンストラクタ - 初期値設定とOrderStartedDomainEvent追加
- **71-91行目**: `AddOrderItem` - 明細追加（同一商品集約あり）
- **170-178行目**: `AddOrderStartedDomainEvent` - ドメインイベント追加

### プログラム呼び出し階層図

```
OrdersApi.CreateOrderAsync (APIエントリーポイント)
    │
    ├─ IdentifiedCommand<CreateOrderCommand>生成
    │
    └─ Mediator.Send()
           │
           └─ IdentifiedCommandHandler.Handle()
                  │
                  ├─ RequestManager.ExistAsync() // 重複チェック
                  │
                  └─ CreateOrderCommandHandler.Handle()
                         │
                         ├─ OrderingIntegrationEventService.AddAndSaveEventAsync()
                         │      └─ OrderStartedIntegrationEvent
                         │
                         ├─ new Order() // Aggregate生成
                         │      └─ AddOrderStartedDomainEvent()
                         │
                         ├─ order.AddOrderItem() × N
                         │
                         ├─ OrderRepository.Add()
                         │
                         └─ UnitOfWork.SaveEntitiesAsync()
                                │
                                └─ DispatchDomainEventsAsync()
                                       │
                                       └─ OrderStartedDomainEventHandler
                                              ├─ Buyer検証/作成
                                              └─ PaymentMethod検証/作成
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTP POST        OrdersApi.CreateOrderAsync   PostgreSQL
  Body  ──────▶    冪等性チェック  ──────────▶ Orders
(CreateOrder       統合イベント発行            OrderItems
 Request)              ↓                      Buyers
                   Orderエンティティ生成       PaymentMethods
                       ↓                      IntegrationEventLog
                   ドメインイベント処理              │
                       ↓                           ▼
                   DB保存                    HTTP 200 OK
                       │
                       ▼
                  RabbitMQ
              (OrderStartedIntegrationEvent)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OrdersApi.cs | `src/Ordering.API/Apis/OrdersApi.cs` | ソース | APIエンドポイント |
| OrderServices.cs | `src/Ordering.API/Apis/OrderServices.cs` | ソース | DI用サービスクラス |
| CreateOrderCommand.cs | `src/Ordering.API/Application/Commands/CreateOrderCommand.cs` | ソース | コマンドオブジェクト |
| CreateOrderCommandHandler.cs | `src/Ordering.API/Application/Commands/CreateOrderCommandHandler.cs` | ソース | コマンドハンドラ |
| IdentifiedCommandHandler.cs | `src/Ordering.API/Application/Commands/IdentifiedCommandHandler.cs` | ソース | 冪等性ハンドラ |
| Order.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` | ソース | 注文Aggregate Root |
| OrderItem.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/OrderItem.cs` | ソース | 注文明細エンティティ |
| Address.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Address.cs` | ソース | 住所バリューオブジェクト |
| OrderStartedDomainEvent.cs | `src/Ordering.Domain/Events/OrderStartedDomainEvent.cs` | ソース | ドメインイベント |
| ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandler.cs | `src/Ordering.API/Application/DomainEventHandlers/ValidateOrAddBuyerAggregateWhenOrderStartedDomainEventHandler.cs` | ソース | ドメインイベントハンドラ |
