# 機能設計書 24-注文ステータス管理

## 概要

本ドキュメントは、eShopシステムにおける注文ステータス管理機能の設計を記述するものである。注文のライフサイクル全体にわたるステータス遷移（Submitted→AwaitingValidation→StockConfirmed→Paid→Shipped/Cancelled）を管理し、各遷移に応じたビジネスルールを適用するための機能仕様を定義する。

### 本機能の処理概要

注文ステータス管理機能は、注文ドメインエンティティ（Order）において、注文の状態を一元管理する機能である。各ステータス遷移は厳密なビジネスルールに基づいて制御され、不正な遷移を防止する。また、ステータス変更時にはドメインイベントを発行し、関連するサービスへの通知を行う。

**業務上の目的・背景**：ECサイトにおいて、注文は複数のステータスを経て処理される。注文作成から在庫確認、決済、発送まで、各ステップで適切な処理が行われることを保証する必要がある。ステータス管理をドメインモデルに集約することで、ビジネスルールの一元管理と整合性の維持が可能になる。また、ステータス遷移をイベント駆動で通知することで、マイクロサービス間の疎結合を維持しながら協調動作を実現する。

**機能の利用シーン**：
- 顧客が注文を確定した時（Submitted）
- 猶予期間経過後に在庫確認を開始する時（AwaitingValidation）
- 在庫が確認された時（StockConfirmed）
- 決済が完了した時（Paid）
- 商品が発送された時（Shipped）
- 注文がキャンセルされた時（Cancelled）

**主要な処理内容**：
1. 注文作成時に初期ステータス「Submitted」を設定
2. 各ステータス遷移メソッドで事前条件を検証
3. ステータス変更と説明文の更新
4. ステータス変更に対応するドメインイベントを発行
5. ドメインイベントハンドラで統合イベントを発行

**関連システム・外部連携**：
- イベントバス（RabbitMQ）を通じて各ステータス変更の統合イベントを発行
- 各マイクロサービス（Catalog、Payment、Webhooks等）と連携

**権限による制御**：
- ステータス遷移は内部処理として実行（直接的な権限チェックなし）
- APIレベルでの認証・認可は各エンドポイントで制御

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | チェックアウト画面 | 参照画面 | 注文作成時のSubmitted設定 |
| 5 | 注文履歴画面 | 主画面 | 各ステータスの注文を表示 |

## 機能種別

ドメインロジック / ステートマシン / イベント駆動

## 入力仕様

### 入力パラメータ（各メソッド共通）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Order | Order | Yes | ステータス変更対象の注文エンティティ | - |
| orderStockRejectedItems | IEnumerable<int> | 条件付き | 在庫不足キャンセル時の商品IDリスト | SetCancelledStatusWhenStockIsRejectedのみ |

### 入力データソース

- リポジトリから取得したOrderエンティティ
- コマンドハンドラからの呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| OrderStatus | OrderStatus | 変更後のステータス |
| Description | string | ステータスに応じた説明文 |
| DomainEvent | DomainEvent | 発行されるドメインイベント |

### 出力先

- Orderエンティティのプロパティ更新
- MediatRを通じたドメインイベント発行

## 処理フロー

### 処理シーケンス

```
【注文ステータスの遷移フロー】

1. Submitted（初期状態）
   └─ 注文作成時に自動設定
   └─ OrderStartedDomainEventを発行

2. AwaitingValidation（在庫検証待ち）
   └─ 事前条件: Submittedステータスであること
   └─ 猶予期間経過後に遷移
   └─ OrderStatusChangedToAwaitingValidationDomainEventを発行

3. StockConfirmed（在庫確認済み）
   └─ 事前条件: AwaitingValidationステータスであること
   └─ 在庫確認成功時に遷移
   └─ OrderStatusChangedToStockConfirmedDomainEventを発行

4. Paid（支払い完了）
   └─ 事前条件: StockConfirmedステータスであること
   └─ 決済成功時に遷移
   └─ OrderStatusChangedToPaidDomainEventを発行

5a. Shipped（発送済み）
    └─ 事前条件: Paidステータスであること
    └─ 発送処理完了時に遷移
    └─ OrderShippedDomainEventを発行

5b. Cancelled（キャンセル）
    └─ 事前条件: Paid/Shipped以外のステータスであること
    └─ 顧客キャンセルまたはシステムキャンセル時に遷移
    └─ OrderCancelledDomainEventを発行

【在庫不足キャンセル】
    └─ 事前条件: AwaitingValidationステータスであること
    └─ 在庫確認失敗時に遷移
    └─ ドメインイベントは発行しない（説明文に不足商品を記録）
```

### フローチャート

```mermaid
stateDiagram-v2
    [*] --> Submitted: 注文作成
    Submitted --> AwaitingValidation: 猶予期間経過
    AwaitingValidation --> StockConfirmed: 在庫確認OK
    AwaitingValidation --> Cancelled: 在庫不足
    StockConfirmed --> Paid: 決済成功
    StockConfirmed --> Cancelled: 決済失敗
    Paid --> Shipped: 発送完了
    Submitted --> Cancelled: 顧客キャンセル
    AwaitingValidation --> Cancelled: 顧客キャンセル
    StockConfirmed --> Cancelled: 顧客キャンセル
    Shipped --> [*]
    Cancelled --> [*]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-24-01 | 初期ステータス | 新規注文は必ずSubmittedステータスで作成 | 注文作成時 |
| BR-24-02 | AwaitingValidation遷移制限 | Submittedからのみ遷移可能 | SetAwaitingValidationStatus呼び出し時 |
| BR-24-03 | StockConfirmed遷移制限 | AwaitingValidationからのみ遷移可能 | SetStockConfirmedStatus呼び出し時 |
| BR-24-04 | Paid遷移制限 | StockConfirmedからのみ遷移可能 | SetPaidStatus呼び出し時 |
| BR-24-05 | Shipped遷移制限 | Paidからのみ遷移可能、それ以外は例外 | SetShippedStatus呼び出し時 |
| BR-24-06 | Cancelled遷移制限 | Paid/Shipped以外から遷移可能、それ以外は例外 | SetCancelledStatus呼び出し時 |
| BR-24-07 | 在庫不足キャンセル | AwaitingValidationからのみ遷移可能、不足商品名を記録 | SetCancelledStatusWhenStockIsRejected呼び出し時 |

### 計算ロジック

特になし（ステータス遷移ロジックのみ）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ステータス更新 | ordering.orders | UPDATE | OrderStatusとDescriptionを更新 |

### テーブル別操作詳細

#### ordering.orders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | OrderStatus | 'Submitted' (1) / 'AwaitingValidation' (2) / 'StockConfirmed' (3) / 'Paid' (4) / 'Shipped' (5) / 'Cancelled' (6) | 列挙型の値 |
| UPDATE | Description | ステータスに応じたメッセージ | 各ステータス遷移時に更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | OrderingDomainException | Paid/Shippedからキャンセル試行 | 業務ルール違反として例外スロー |
| - | OrderingDomainException | Paid以外から発送試行 | 業務ルール違反として例外スロー |
| - | 無視（遷移しない） | 不正なステータスからの遷移試行 | 条件に合わない場合は何もしない |

### リトライ仕様

- ドメインロジックのため、上位層（コマンドハンドラ）でリトライ制御

## トランザクション仕様

- コマンドハンドラのUnitOfWorkでトランザクション管理
- ステータス変更とドメインイベント発行は同一トランザクション内
- ドメインイベントディスパッチはコミット後

## パフォーマンス要件

- ステータス変更処理: インメモリ操作のため即座に完了
- データベース永続化は上位層で制御

## セキュリティ考慮事項

- ステータス遷移はドメインモデル内部でのみ可能
- 外部からの直接的なステータス操作を防止
- 監査ログへの遷移履歴記録（統合イベント経由）

## 備考

- DDDパターンに基づくドメインモデルとして実装
- ステートパターン/ステートマシンとして動作
- 不変条件（invariant）をドメインモデルで保証

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、注文のステータスを表す列挙型と注文エンティティの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OrderStatus.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/OrderStatus.cs` | 6種類のステータス（Submitted〜Cancelled）を確認 |
| 1-2 | Order.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` | OrderStatusプロパティと各Set*Status()メソッドを理解 |

**読解のコツ**: OrderStatusは`[JsonConverter(typeof(JsonStringEnumConverter))]`属性により、JSONシリアライズ時に文字列として出力される。データベースには整数値として保存される。

#### Step 2: 初期ステータス設定を理解する

注文作成時のステータス設定を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Order.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` | コンストラクタでのSubmitted設定を確認 |

**主要処理フロー**:
- **52-65行目**: Orderコンストラクタ
- **57行目**: `OrderStatus = OrderStatus.Submitted` で初期ステータス設定
- **63-64行目**: AddOrderStartedDomainEventでドメインイベント発行

#### Step 3: 各ステータス遷移メソッドを理解する

各ステータス遷移の事前条件と処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Order.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` | SetAwaitingValidationStatus()メソッド |
| 3-2 | Order.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` | SetStockConfirmedStatus()メソッド |
| 3-3 | Order.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` | SetPaidStatus()メソッド |
| 3-4 | Order.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` | SetShippedStatus()メソッド |
| 3-5 | Order.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` | SetCancelledStatus()メソッド |
| 3-6 | Order.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` | SetCancelledStatusWhenStockIsRejected()メソッド |

**主要処理フロー**:

**SetAwaitingValidationStatus() (99-106行目)**:
- **101行目**: Submittedからのみ遷移可能をチェック
- **103行目**: ドメインイベント発行
- **104行目**: ステータスをAwaitingValidationに変更

**SetStockConfirmedStatus() (108-117行目)**:
- **110行目**: AwaitingValidationからのみ遷移可能をチェック
- **112行目**: ドメインイベント発行
- **114行目**: ステータスをStockConfirmedに変更
- **115行目**: 説明文を設定

**SetPaidStatus() (119-128行目)**:
- **121行目**: StockConfirmedからのみ遷移可能をチェック
- **123行目**: ドメインイベント発行
- **125行目**: ステータスをPaidに変更
- **126行目**: 説明文を設定

**SetShippedStatus() (130-140行目)**:
- **132-135行目**: Paidからのみ遷移可能、違反時は例外スロー
- **137行目**: ステータスをShippedに変更
- **138行目**: 説明文を設定
- **139行目**: ドメインイベント発行

**SetCancelledStatus() (142-153行目)**:
- **144-148行目**: Paid/Shippedからは遷移不可、違反時は例外スロー
- **150行目**: ステータスをCancelledに変更
- **151行目**: 説明文を設定
- **152行目**: ドメインイベント発行

**SetCancelledStatusWhenStockIsRejected() (155-168行目)**:
- **157行目**: AwaitingValidationからのみ遷移可能をチェック
- **159行目**: ステータスをCancelledに変更
- **161-166行目**: 不足商品名を抽出して説明文に記録

#### Step 4: 例外処理を理解する

不正なステータス遷移時の例外処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Order.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` | StatusChangeExceptionメソッド |
| 4-2 | OrderingDomainException.cs | `src/Ordering.Domain/Exceptions/OrderingDomainException.cs` | ドメイン例外クラス |

**主要処理フロー**:
- **180-183行目**: StatusChangeException()メソッド
- **182行目**: OrderingDomainExceptionをスローしてエラーメッセージを出力

### プログラム呼び出し階層図

```
Order (Aggregate Root)
    │
    ├─ Order() コンストラクタ
    │      └─ OrderStatus = Submitted
    │      └─ AddOrderStartedDomainEvent()
    │
    ├─ SetAwaitingValidationStatus()
    │      ├─ [前提条件] OrderStatus == Submitted
    │      ├─ AddDomainEvent(OrderStatusChangedToAwaitingValidationDomainEvent)
    │      └─ OrderStatus = AwaitingValidation
    │
    ├─ SetStockConfirmedStatus()
    │      ├─ [前提条件] OrderStatus == AwaitingValidation
    │      ├─ AddDomainEvent(OrderStatusChangedToStockConfirmedDomainEvent)
    │      ├─ OrderStatus = StockConfirmed
    │      └─ Description = "All the items were confirmed..."
    │
    ├─ SetPaidStatus()
    │      ├─ [前提条件] OrderStatus == StockConfirmed
    │      ├─ AddDomainEvent(OrderStatusChangedToPaidDomainEvent)
    │      ├─ OrderStatus = Paid
    │      └─ Description = "The payment was performed..."
    │
    ├─ SetShippedStatus()
    │      ├─ [前提条件] OrderStatus == Paid (違反時は例外)
    │      ├─ OrderStatus = Shipped
    │      ├─ Description = "The order was shipped."
    │      └─ AddDomainEvent(OrderShippedDomainEvent)
    │
    ├─ SetCancelledStatus()
    │      ├─ [前提条件] OrderStatus != Paid && != Shipped (違反時は例外)
    │      ├─ OrderStatus = Cancelled
    │      ├─ Description = "The order was cancelled."
    │      └─ AddDomainEvent(OrderCancelledDomainEvent)
    │
    └─ SetCancelledStatusWhenStockIsRejected()
           ├─ [前提条件] OrderStatus == AwaitingValidation
           ├─ OrderStatus = Cancelled
           └─ Description = "The product items don't have stock..."
```

### データフロー図

```
[ステータス遷移の流れ]

              ┌──────────────────────────────────────────────────────────────┐
              │                                                              │
              ▼                                                              │
┌──────────────────┐     ┌─────────────────────┐     ┌─────────────────┐    │
│   Submitted (1)  │────▶│AwaitingValidation(2)│────▶│StockConfirmed(3)│    │
└──────────────────┘     └─────────────────────┘     └─────────────────┘    │
        │                         │                          │              │
        │                         │                          │              │
        │                         ▼                          ▼              │
        │              ┌─────────────────┐        ┌─────────────────┐       │
        └─────────────▶│  Cancelled (6)  │◀───────│    Paid (4)     │───────┘
                       └─────────────────┘        └─────────────────┘
                               ▲                          │
                               │                          │
                               │                          ▼
                               │                  ┌─────────────────┐
                               │                  │   Shipped (5)   │
                               │                  └─────────────────┘
                               │                          │
                               └──────────────────────────┘
                                  (Paid/Shipped からはキャンセル不可)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Order.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` | ソース | 注文エンティティ（集約ルート） |
| OrderStatus.cs | `src/Ordering.Domain/AggregatesModel/OrderAggregate/OrderStatus.cs` | ソース | ステータス列挙型 |
| OrderingDomainException.cs | `src/Ordering.Domain/Exceptions/OrderingDomainException.cs` | ソース | ドメイン例外 |
| OrderStartedDomainEvent.cs | `src/Ordering.Domain/Events/OrderStartedDomainEvent.cs` | ソース | 注文開始イベント |
| OrderStatusChangedToAwaitingValidationDomainEvent.cs | `src/Ordering.Domain/Events/OrderStatusChangedToAwaitingValidationDomainEvent.cs` | ソース | 在庫検証待ちイベント |
| OrderStatusChangedToStockConfirmedDomainEvent.cs | `src/Ordering.Domain/Events/OrderStatusChangedToStockConfirmedDomainEvent.cs` | ソース | 在庫確認イベント |
| OrderStatusChangedToPaidDomainEvent.cs | `src/Ordering.Domain/Events/OrderStatusChangedToPaidDomainEvent.cs` | ソース | 支払完了イベント |
| OrderShippedDomainEvent.cs | `src/Ordering.Domain/Events/OrderShippedDomainEvent.cs` | ソース | 発送イベント |
| OrderCancelledDomainEvent.cs | `src/Ordering.Domain/Events/OrderCancelledDomainEvent.cs` | ソース | キャンセルイベント |
