# 機能設計書 4-商品画像取得

## 概要

本ドキュメントは、eShopアプリケーションにおける商品画像取得機能の設計仕様を定義する。商品IDを指定して、その商品に対応する画像ファイルを取得するREST APIエンドポイントを提供する。

### 本機能の処理概要

**業務上の目的・背景**：ECサイトにおいて、商品の視覚的な情報は購買意思決定において非常に重要である。商品画像を効率的に配信することで、ユーザーが商品の外観を確認でき、購買体験を向上させる。

**機能の利用シーン**：商品一覧画面でのサムネイル表示、商品詳細画面での商品画像表示、買い物かご画面での商品確認など、商品画像を表示するすべての場面で利用される。

**主要な処理内容**：
1. パスパラメータから商品IDを取得
2. データベースから該当商品の画像ファイル名を取得
3. ファイルシステムから画像ファイルを読み込み
4. 適切なMIMEタイプを判定してレスポンスとして返却

**関連システム・外部連携**：PostgreSQLデータベースから商品情報を取得し、ファイルシステム（Picsディレクトリ）から画像ファイルを配信する。

**権限による制御**：本APIエンドポイントは認証不要で公開されており、誰でもアクセス可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | 商品詳細画面 | 参照画面 | IProductImageUrlProviderで商品画像URLを取得 |
| 3 | カート画面 | 参照画面 | IProductImageUrlProviderで商品画像URLを取得 |
| 26 | 商品詳細画面（HybridApp） | 参照画面 | IProductImageUrlProviderで商品画像URLを取得 |

## 機能種別

ファイル取得 / 静的コンテンツ配信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | int | Yes | 商品ID | パスパラメータとして指定 |

### 入力データソース

- URLパスパラメータ: `/api/catalog/items/{id}/pic`

## 出力仕様

### 出力データ

**正常時（200 OK）: バイナリ画像データ**

| 項目名 | 型 | 説明 |
|--------|-----|------|
| (body) | byte[] | 画像ファイルのバイナリデータ |

**サポートするMIMEタイプ**

| 拡張子 | MIMEタイプ |
|--------|-----------|
| .png | image/png |
| .gif | image/gif |
| .jpg, .jpeg | image/jpeg |
| .bmp | image/bmp |
| .tiff | image/tiff |
| .wmf | image/wmf |
| .jp2 | image/jp2 |
| .svg | image/svg+xml |
| .webp | image/webp |
| その他 | application/octet-stream |

### 出力先

- HTTP Response Body（バイナリ形式）
- Content-Type: 画像のMIMEタイプ

## 処理フロー

### 処理シーケンス

```
1. HTTPリクエスト受信
   └─ パスパラメータからidを取得

2. データベースクエリ実行
   └─ CatalogItemsテーブルからFindAsyncで商品を取得

3. 存在チェック
   ├─ 商品が存在しない場合: NotFound(404)を返却
   └─ PictureFileNameがnullの場合: NotFound(404)を返却

4. ファイルパス構築
   └─ ContentRootPath/Pics/{PictureFileName}

5. MIMEタイプ判定
   └─ ファイル拡張子からMIMEタイプを決定

6. ファイル情報取得
   └─ ファイルの最終更新日時を取得

7. レスポンス生成
   └─ PhysicalFileHttpResultで画像ファイルを返却
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B[id取得]
    B --> C[FindAsync実行]
    C --> D{商品存在?}
    D -->|No| E[NotFound 404]
    D -->|Yes| F{PictureFileName存在?}
    F -->|No| E
    F -->|Yes| G[ファイルパス構築]
    G --> H[MIMEタイプ判定]
    H --> I[ファイル情報取得]
    I --> J[PhysicalFile返却]
    J --> K[200 OK]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 画像パス構築 | 画像はContentRootPath/Picsディレクトリに配置 | 常時 |
| BR-002 | MIMEタイプ判定 | ファイル拡張子に基づいてMIMEタイプを決定 | 常時 |
| BR-003 | 不明拡張子フォールバック | 不明な拡張子はapplication/octet-streamとして返却 | 拡張子不明時 |
| BR-004 | 最終更新日時付与 | レスポンスにファイルの最終更新日時を含める | 常時 |

### 計算ロジック

- ファイルパス: `Path.Combine(contentRootPath, "Pics", pictureFileName)`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 商品情報取得 | Catalog | SELECT | 指定IDの商品からPictureFileNameを取得 |

### テーブル別操作詳細

#### Catalog

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | PictureFileName | WHERE Id = {id} | FindAsyncで主キー検索 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | NotFound | 商品が存在しない | NotFound応答を返却 |
| 404 | NotFound | PictureFileNameがnull | NotFound応答を返却 |
| 500 | InternalServerError | ファイルが存在しない等 | サーバーエラーとして処理 |

### リトライ仕様

本機能では明示的なリトライ処理は実装されていない。

## トランザクション仕様

読み取り専用操作のため、明示的なトランザクション制御は行わない。

## パフォーマンス要件

- FindAsyncによる主キー検索で高速にDB検索
- PhysicalFileHttpResultによりファイルストリーミングで効率的な配信
- lastModifiedヘッダにより、ブラウザキャッシュを活用可能

## セキュリティ考慮事項

- 認証不要のパブリックAPI
- パストラバーサル攻撃対策: PictureFileNameはDBから取得するため、ユーザー入力による直接的なパス操作は不可
- ファイルはContentRootPath/Picsディレクトリに限定

## 備考

- 画像ファイルはアプリケーションのPicsディレクトリに事前配置されている必要がある
- 商品登録時にPictureFileNameが設定されていない場合は画像取得不可

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CatalogItem.cs | `src/Catalog.API/Model/CatalogItem.cs` | PictureFileNameプロパティの定義 |

**読解のコツ**: PictureFileNameはnullable string型（string?）であることに注目。画像が設定されていない商品も存在しうる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CatalogApi.cs | `src/Catalog.API/Apis/CatalogApi.cs` | GetItemPictureByIdメソッドとMIMEタイプ判定 |

**主要処理フロー**:
1. **46-50行目**: `/items/{id:int}/pic` エンドポイント定義
2. **202-224行目**: `GetItemPictureById` メソッド実装
3. **210行目**: FindAsyncで商品検索
4. **212-215行目**: 存在チェック（item null または PictureFileName null）
5. **217行目**: GetFullPathでファイルパス構築
6. **219-220行目**: MIMEタイプ判定と最終更新日時取得
7. **223行目**: PhysicalFileで返却
8. **406-418行目**: GetImageMimeTypeFromImageFileExtensionメソッド（MIMEタイプマッピング）
9. **420-421行目**: GetFullPathメソッド（パス構築）

#### Step 3: レスポンス形式を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CatalogApi.cs | `src/Catalog.API/Apis/CatalogApi.cs` | ProducesResponseType属性でサポートMIMEタイプを確認 |

**主要処理フロー**:
- **202-204行目**: ProducesResponseType属性でサポートする画像形式を宣言

### プログラム呼び出し階層図

```
HTTP Request (GET /api/catalog/items/{id}/pic)
    │
    └─ CatalogApi.GetItemPictureById()
           │
           ├─ CatalogContext.CatalogItems.FindAsync(id)
           │      │
           │      ├─ null → TypedResults.NotFound
           │      └─ item.PictureFileName == null → TypedResults.NotFound
           │
           ├─ GetFullPath()
           │      └─ Path.Combine(contentRootPath, "Pics", pictureFileName)
           │
           ├─ GetImageMimeTypeFromImageFileExtension()
           │      └─ switch式でMIMEタイプ判定
           │
           └─ TypedResults.PhysicalFile()
                  └─ ファイルストリーミング返却
```

### データフロー図

```
[入力]                [処理]                              [出力]

HTTPリクエスト         CatalogApi.GetItemPictureById()    HTTPレスポンス
  │                        │                                │
  └─ id ──────────────────▶│                                │
                           │   PostgreSQL                   │
                           │   (Catalog)                    │
                           │      │                         │
                           │      ▼                         │
                           │   PictureFileName              │
                           │      │                         │
                           │      ▼                         │
                           │   ファイルシステム             │
                           │   /Pics/{filename}             │
                           │      │                         │
                           │      ├─ NotFound ─────────────▶ 404
                           │      │                         │
                           │      ▼                         │
                           └─▶ バイナリデータ ─────────────▶ 200 OK
                                 Content-Type: image/*
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CatalogApi.cs | `src/Catalog.API/Apis/CatalogApi.cs` | ソース | APIエンドポイント定義・MIMEタイプ判定 |
| CatalogItem.cs | `src/Catalog.API/Model/CatalogItem.cs` | ソース | PictureFileNameプロパティ定義 |
| CatalogContext.cs | `src/Catalog.API/Infrastructure/CatalogContext.cs` | ソース | DbContext |
| Pics/ | `src/Catalog.API/Pics/` | 静的ファイル | 商品画像ファイル格納ディレクトリ |
