# 機能設計書 44-チェックアウト画面

## 概要

本ドキュメントは、eShop WebAppにおけるチェックアウト画面の機能設計を記載する。本画面は認証済みユーザーが配送先住所を入力し、注文を確定する機能を提供する。

### 本機能の処理概要

本機能は、ユーザーが買い物かごに入れた商品の注文を確定するための画面である。配送先住所（Street, City, State, ZipCode, Country）を入力し、「Place order」ボタンで注文を作成する。注文成功後は注文履歴画面にリダイレクトされる。

**業務上の目的・背景**：ECサイトにおける購入プロセスの最終段階として、ユーザーの配送先情報を収集し、注文を確定する。これにより、倉庫からの商品出荷に必要な情報を取得し、注文管理システムへの注文登録を行う。

**機能の利用シーン**：買い物かご画面で「Check out」をクリックした後に表示される。ユーザーは配送先住所を確認・入力し、「Place order」で注文を確定する。注文確定後は注文履歴画面で注文状態を確認できる。

**主要な処理内容**：
1. 初期化時にユーザークレームから配送先情報のデフォルト値を取得
2. EditFormでバリデーション付き入力フォームを表示
3. 送信時にカスタムバリデーション（かご空チェック）を実行
4. BasketState.CheckoutAsyncで注文を作成
5. 注文完了後、注文履歴画面（/user/orders）にリダイレクト

**関連システム・外部連携**：Ordering.API（注文作成REST API）、Basket.API（かご情報取得・削除）

**権限による制御**：本画面は認証必須（@attribute [Authorize]）。未認証ユーザーはログイン画面にリダイレクトされる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | チェックアウト画面 | 主画面 | 配送先住所入力・注文確定 |
| 3 | カート画面 | 遷移元画面 | 「Check out」ボタンで遷移 |
| 5 | 注文履歴画面 | 遷移先画面 | 注文確定後にリダイレクト |

## 機能種別

画面表示機能 / データ入力 / 注文作成（CRUD操作のCreate）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Street | string | Yes | 番地・通り名 | Required |
| City | string | Yes | 市区町村 | Required |
| State | string | Yes | 州・都道府県 | Required |
| ZipCode | string | Yes | 郵便番号 | Required |
| Country | string | Yes | 国 | Required |
| RequestId | Guid | - | リクエスト識別子（自動生成） | 自動設定 |
| CardTypeId | int | - | カードタイプ（固定値1） | 自動設定 |

### 入力データソース

- フォーム入力: 配送先住所情報
- ユーザークレーム: 住所のデフォルト値（address_street, address_city等）
- システム生成: RequestId（GUID）、CardTypeId（固定値）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 注文 | Order | Ordering.APIに作成された注文 |
| リダイレクト | - | /user/ordersへの画面遷移 |

### 出力先

- Ordering.API: 注文データの永続化
- 画面遷移: 注文履歴画面へリダイレクト

## 処理フロー

### 処理シーケンス

```
1. 画面初期化（OnInitialized）
   └─ PopulateFormWithDefaultInfo でデフォルト値設定
   └─ ユーザークレームから住所情報を取得

2. 画面表示
   └─ EditFormで配送先住所入力フォームを表示
   └─ DataAnnotationsValidatorでバリデーション

3. 送信処理（HandleSubmitAsync）
   └─ PerformCustomValidationAsync でかご空チェック
   └─ editContext.Validate() でバリデーション実行

4. 注文確定（HandleValidSubmitAsync）
   └─ CardTypeId = 1 を設定
   └─ BasketState.CheckoutAsync(Info) で注文作成
   └─ Ordering.API POST /api/orders にリクエスト
   └─ かご内容を削除
   └─ /user/orders にリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[/checkout アクセス] --> B{認証済み?}
    B -->|No| C[ログイン画面へリダイレクト]
    B -->|Yes| D[OnInitialized]
    D --> E[PopulateFormWithDefaultInfo]
    E --> F[クレームから住所取得]
    F --> G[フォーム表示]
    G --> H{Place order クリック}
    H --> I[HandleSubmitAsync]
    I --> J[PerformCustomValidationAsync]
    J --> K{かご空?}
    K -->|Yes| L[エラー: Your cart is empty]
    L --> G
    K -->|No| M[editContext.Validate]
    M --> N{バリデーションOK?}
    N -->|No| O[バリデーションエラー表示]
    O --> G
    N -->|Yes| P[HandleValidSubmitAsync]
    P --> Q[BasketState.CheckoutAsync]
    Q --> R[Ordering.API 注文作成]
    R --> S[かご削除]
    S --> T[/user/orders リダイレクト]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-44-01 | 認証必須 | 本画面へのアクセスは認証済みユーザーのみ | 常に適用 |
| BR-44-02 | かご必須 | かごが空の場合は注文不可 | 注文実行時 |
| BR-44-03 | 住所必須 | 全ての住所項目は入力必須 | 注文実行時 |
| BR-44-04 | カードタイプ固定 | CardTypeIdは1固定 | 注文作成時 |
| BR-44-05 | カード情報固定 | テスト用にカード番号等は固定値 | 注文作成時 |
| BR-44-06 | リクエストID | 重複注文防止のためGUIDを使用 | 注文作成時 |

### 計算ロジック

- RequestId生成: `Guid.NewGuid()`
- デフォルト住所取得: `HttpContext.User.Claims.FirstOrDefault(x => x.Type == type)?.Value`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 注文作成 | Orders | INSERT | 新規注文を作成（API経由） |
| 注文明細作成 | OrderItems | INSERT | 注文明細を作成（API経由） |
| かご取得 | Basket (Redis) | GET | かご内容を取得（gRPC経由） |
| かご削除 | Basket (Redis) | DELETE | 注文後にかごを削除（gRPC経由） |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 401 | Unauthorized | 未認証アクセス | ログイン画面へリダイレクト |
| - | ValidationError | 必須項目未入力 | バリデーションメッセージ表示 |
| - | EmptyCartError | かごが空 | "Your cart is empty"メッセージ表示 |
| - | APIエラー | Ordering.APIとの通信失敗 | エラーハンドリング未実装 |

### リトライ仕様

- RequestIdによる冪等性保証（同一リクエストの重複実行防止）
- 自動リトライは行わない

## トランザクション仕様

- 注文作成: Ordering.API側でトランザクション管理
- かご削除: 注文成功後に実行

## パフォーマンス要件

- フォーム入力はクライアントサイドで即時バリデーション
- Enhance属性で部分的な画面更新を実現

## セキュリティ考慮事項

- 認証必須（@attribute [Authorize]）
- AntiforgeryTokenは暗黙的に使用（EditFormのデフォルト）
- ユーザーは自分のかごのみで注文可能
- カード情報はテスト用固定値（本番では決済サービス連携が必要）

## 備考

- 現在のカード情報は固定値（CardNumber: "1111222233334444"）でテスト用
- 実際の決済処理は PaymentProcessor サービスでシミュレーション
- ParseExpiryDateメソッドは定義されているが現在未使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

注文作成に必要なデータ型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BasketCheckoutInfo.cs | `src/WebApp/Services/BasketCheckoutInfo.cs` | チェックアウト情報の型定義 |
| 1-2 | CreateOrderRequest | `src/WebApp/Services/BasketState.cs` | 注文作成リクエストの型定義（ファイル末尾） |

**読解のコツ**: BasketCheckoutInfoは住所情報とリクエストIDを持つ。CreateOrderRequestはBasketState.cs内でrecordとして定義。

#### Step 2: エントリーポイントを理解する

メインのページコンポーネント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Checkout.razor | `src/WebApp/Components/Pages/Checkout/Checkout.razor` | フォーム処理、バリデーション、注文確定 |

**主要処理フロー**:
- **1行目**: `@page "/checkout"` - ルーティング
- **6行目**: `@attribute [Authorize]` - 認証必須
- **12行目**: EditFormでEnhance属性付きフォーム
- **64-66行目**: EditContextとValidationMessageStore
- **74-83行目**: OnInitialized - フォーム初期化
- **85-99行目**: PopulateFormWithDefaultInfo - クレームからデフォルト値取得
- **101-109行目**: HandleSubmitAsync - 送信処理
- **111-116行目**: HandleValidSubmitAsync - 注文確定処理
- **118-126行目**: PerformCustomValidationAsync - かご空チェック

#### Step 3: サービス層を理解する

注文作成のサービス処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | BasketState.cs | `src/WebApp/Services/BasketState.cs` | CheckoutAsyncメソッド |
| 3-2 | OrderingService.cs | `src/WebApp/Services/OrderingService.cs` | CreateOrderメソッド |

**BasketState.cs CheckoutAsync主要処理フロー**:
- **78-109行目**: CheckoutAsyncメソッド
- **80-83行目**: RequestIdの設定（デフォルトの場合は新規生成）
- **85-86行目**: buyerIdとuserNameを認証情報から取得
- **89行目**: かご内容を取得
- **92-106行目**: CreateOrderRequestの作成
- **107行目**: OrderingService.CreateOrderを呼び出し
- **108行目**: DeleteBasketAsyncでかご削除

**OrderingService.cs主要処理フロー**:
- **12-18行目**: CreateOrderメソッド
- **14行目**: x-requestidヘッダーでリクエストIDを送信
- **15行目**: JsonContent.Createでリクエストボディ作成

### プログラム呼び出し階層図

```
Checkout.razor (エントリーポイント)
    │
    ├─ OnInitialized
    │      └─ PopulateFormWithDefaultInfo
    │             └─ HttpContext.User.Claims (住所デフォルト値)
    │
    └─ HandleSubmitAsync (フォーム送信時)
           ├─ PerformCustomValidationAsync
           │      └─ BasketState.GetBasketItemsAsync() (かご空チェック)
           │
           └─ HandleValidSubmitAsync
                  └─ BasketState.CheckoutAsync(Info)
                         ├─ AuthenticationStateProvider.GetBuyerIdAsync()
                         ├─ AuthenticationStateProvider.GetUserNameAsync()
                         ├─ FetchBasketItemsAsync() (かご内容取得)
                         ├─ OrderingService.CreateOrder()
                         │      └─ HttpClient.SendAsync()
                         │             └─ Ordering.API POST /api/orders
                         └─ DeleteBasketAsync() (かご削除)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ユーザークレーム    ───▶ PopulateFormWithDefaultInfo
address_street           │
address_city             ▼
address_state      フォーム入力
address_country          │
address_zip_code         ▼
                   ┌─────────────────┐
フォーム送信     ──│ HandleSubmitAsync│
BasketCheckoutInfo │                 │
                   └────────┬────────┘
                            │
                            ▼
                   ┌─────────────────┐
                   │ CheckoutAsync   │
                   └────────┬────────┘
                            │
                            ▼
Ordering.API      ◀──CreateOrderRequest──▶ 注文作成
POST /api/orders         │
                         ▼
                   かご削除 → /user/orders リダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Checkout.razor | `src/WebApp/Components/Pages/Checkout/Checkout.razor` | ソース | メインページコンポーネント |
| BasketState.cs | `src/WebApp/Services/BasketState.cs` | ソース | かご状態管理・チェックアウト処理 |
| OrderingService.cs | `src/WebApp/Services/OrderingService.cs` | ソース | 注文API通信 |
| BasketCheckoutInfo.cs | `src/WebApp/Services/BasketCheckoutInfo.cs` | ソース | チェックアウト情報型 |
| BasketService.cs | `src/WebApp/Services/BasketService.cs` | ソース | かごgRPCクライアント |
