# 機能設計書 45-注文履歴画面

## 概要

本ドキュメントは、eShop WebAppにおける注文履歴画面の機能設計を記載する。本画面は認証済みユーザーの注文履歴一覧を表示し、リアルタイムでのステータス更新通知機能を提供する。

### 本機能の処理概要

本機能は、ユーザーが過去に行った注文の一覧（注文番号、日付、合計金額、ステータス）を表示する画面である。SignalRを使用したリアルタイム通知機能により、注文ステータスが変更された際に自動的に画面が更新される。

**業務上の目的・背景**：ECサイトにおいて、ユーザーが自身の注文状況を確認することは重要な機能である。特に注文確定後のステータス（処理中、在庫確認、支払い完了、発送済みなど）をリアルタイムで把握できることで、ユーザー体験が向上し、問い合わせ対応の負荷も軽減できる。

**機能の利用シーン**：チェックアウト画面で注文確定後にリダイレクトされる画面として使用される。また、ユーザーメニューの「My orders」リンクからもアクセス可能。注文ステータスの変更時に自動更新されるため、画面を開いたままにしておくと最新状態が表示される。

**主要な処理内容**：
1. 初期化時にOrderingService.GetOrdersで注文履歴を取得
2. 注文一覧を表形式で表示（Number, Date, Total, Status）
3. OrdersRefreshOnStatusChangeコンポーネントでSignalR接続を確立
4. 注文ステータス変更通知を受信した際に画面をリフレッシュ

**関連システム・外部連携**：Ordering.API（注文履歴取得REST API）、OrderStatusNotificationService（SignalRによるリアルタイム通知）

**権限による制御**：本画面は認証必須（@attribute [Authorize]）。未認証ユーザーはログイン画面にリダイレクトされる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 注文履歴画面 | 主画面 | 注文一覧表示・リアルタイム更新 |
| 4 | チェックアウト画面 | 遷移元画面 | 注文確定後にリダイレクト |
| 7 | ユーザーメニュー | 遷移元 | 「My orders」リンクからアクセス |

## 機能種別

画面表示機能（CRUD操作のRead）/ リアルタイム通知（SignalR）

## 入力仕様

### 入力パラメータ

本画面には明示的な入力パラメータはない。ユーザー識別は認証情報から自動取得。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| (なし) | - | - | - | - |

### 入力データソース

- 認証情報: ユーザーID（buyerId）
- Ordering.API: 注文履歴データ
- OrderStatusNotificationService: ステータス変更通知

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| orders | OrderRecord[] | 注文履歴一覧 |
| orders[].OrderNumber | int | 注文番号 |
| orders[].Date | DateTime | 注文日時 |
| orders[].Total | decimal | 合計金額 |
| orders[].Status | string | 注文ステータス |

### 出力先

- 画面表示: 注文履歴テーブル（番号、日付、合計、ステータス）

## 処理フロー

### 処理シーケンス

```
1. 画面初期化（OnInitializedAsync）
   └─ OrderingService.GetOrdersで注文履歴を取得

2. 画面表示
   └─ 注文がない場合: 空メッセージを表示
   └─ 注文がある場合: 一覧テーブルを表示

3. SignalR接続確立（OrdersRefreshOnStatusChange）
   └─ OnAfterRenderAsyncでbuyerIdを取得
   └─ OrderStatusNotificationService.SubscribeToOrderStatusNotifications

4. ステータス変更通知受信時
   └─ HandleOrderStatusChangedでNav.Refresh()を呼び出し
   └─ 画面全体がリフレッシュされ最新データを取得
```

### フローチャート

```mermaid
flowchart TD
    A[/user/orders アクセス] --> B{認証済み?}
    B -->|No| C[ログイン画面へリダイレクト]
    B -->|Yes| D[OnInitializedAsync]
    D --> E[OrderingService.GetOrders]
    E --> F{注文あり?}
    F -->|No| G[空メッセージ表示]
    F -->|Yes| H[注文一覧表示]
    G --> I[OnAfterRenderAsync]
    H --> I
    I --> J[GetBuyerIdAsync]
    J --> K[SubscribeToOrderStatusNotifications]
    K --> L[SignalR接続待機]
    L --> M{ステータス変更通知?}
    M -->|Yes| N[HandleOrderStatusChanged]
    N --> O[Nav.Refresh]
    O --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-45-01 | 認証必須 | 本画面へのアクセスは認証済みユーザーのみ | 常に適用 |
| BR-45-02 | 自分の注文のみ | ユーザーは自身の注文履歴のみ閲覧可能 | 常に適用 |
| BR-45-03 | リアルタイム更新 | ステータス変更時に自動で画面更新 | SignalR接続中 |
| BR-45-04 | 価格表示形式 | 金額は小数点以下2桁で表示 | 常に適用 |
| BR-45-05 | ステータス表示 | ステータスは小文字でCSSクラスとしても使用 | 常に適用 |

### 計算ロジック

特になし（注文情報はAPI側で計算済み）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 注文履歴取得 | Orders | SELECT | ユーザーの注文一覧を取得（API経由） |

※ 本画面は読み取り専用で、データの更新は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 401 | Unauthorized | 未認証アクセス | ログイン画面へリダイレクト |
| - | APIエラー | Ordering.APIとの通信失敗 | Loading表示が継続 |
| - | SignalRエラー | 通知サービス接続失敗 | 自動更新が無効化 |

### リトライ仕様

- 自動リトライは行わない
- ステータス変更通知受信時に画面リフレッシュで最新データ取得

## トランザクション仕様

読み取り専用のため、トランザクション管理は不要。

## パフォーマンス要件

- ストリームレンダリング（@attribute [StreamRendering]）を使用して初期表示を高速化
- SignalRによるプッシュ通知でポーリング不要

## セキュリティ考慮事項

- 認証必須（@attribute [Authorize]）
- buyerIdによるフィルタリングでユーザー固有データのみ取得
- SignalR接続はbuyerIdベースで購読

## 備考

- StatusはOrdering.Domain側で定義されたステータス（Submitted, AwaitingValidation, StockConfirmed, Paid, Shipped, Cancelled）
- ステータスの小文字版がCSSクラスとして使用される（例: status paid）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

注文履歴データの型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OrderingService.cs | `src/WebApp/Services/OrderingService.cs` | OrderRecord型定義（ファイル末尾） |

**読解のコツ**: OrderRecordはrecord型でOrderNumber, Date, Status, Totalを持つ。

**主要処理フロー**:
- **21-25行目**: OrderRecord record定義

#### Step 2: エントリーポイントを理解する

メインのページコンポーネント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Orders.razor | `src/WebApp/Components/Pages/User/Orders.razor` | 注文履歴表示、ストリームレンダリング |

**主要処理フロー**:
- **1行目**: `@page "/user/orders"` - ルーティング
- **2行目**: `@attribute [Authorize]` - 認証必須
- **3行目**: `@attribute [StreamRendering]` - ストリームレンダリング有効化
- **8行目**: `<OrdersRefreshOnStatusChange />` - リアルタイム更新コンポーネント
- **51-57行目**: OnInitializedAsyncで注文取得
- **41-42行目**: ステータス表示とCSSクラス

#### Step 3: リアルタイム更新コンポーネントを理解する

SignalR接続とステータス変更通知。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OrdersRefreshOnStatusChange.razor | `src/WebApp/Components/Pages/User/OrdersRefreshOnStatusChange.razor` | SignalR購読・画面リフレッシュ |

**主要処理フロー**:
- **1行目**: `@rendermode InteractiveServer` - サーバーサイドインタラクティブ
- **10-20行目**: OnAfterRenderAsyncでSignalR購読開始
- **14行目**: `GetBuyerIdAsync()` - buyerID取得
- **17-18行目**: `SubscribeToOrderStatusNotifications` - 購読登録
- **22-33行目**: HandleOrderStatusChangedで画面リフレッシュ
- **27行目**: `Nav.Refresh()` - 画面全体をリフレッシュ

#### Step 4: サービス層を理解する

APIとの通信とSignalR通知。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | OrderingService.cs | `src/WebApp/Services/OrderingService.cs` | GetOrdersメソッド |
| 4-2 | OrderStatusNotificationService.cs | `src/WebApp/Services/OrderStatusNotificationService.cs` | SignalR接続管理 |

**OrderingService.cs主要処理フロー**:
- **7-10行目**: GetOrdersメソッド - 注文履歴取得

### プログラム呼び出し階層図

```
Orders.razor (エントリーポイント)
    │
    ├─ OnInitializedAsync
    │      └─ OrderingService.GetOrders()
    │             └─ HttpClient.GetFromJsonAsync<OrderRecord[]>()
    │                    └─ Ordering.API GET /api/orders
    │
    └─ OrdersRefreshOnStatusChange.razor (子コンポーネント)
           │
           ├─ OnAfterRenderAsync
           │      ├─ AuthenticationStateProvider.GetBuyerIdAsync()
           │      └─ OrderStatusNotificationService.SubscribeToOrderStatusNotifications()
           │             └─ SignalR HubConnection
           │
           └─ HandleOrderStatusChanged (通知受信時)
                  └─ NavigationManager.Refresh()
                         └─ 画面リロード → OnInitializedAsync再実行
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Ordering.API        ───▶ OrderingService
GET /api/orders           │
                          ▼
                   ┌─────────────────┐
                   │  Orders.razor   │──▶ 注文一覧HTML
                   └────────┬────────┘
                            │
                            ▼
                   ┌─────────────────────────┐
                   │ OrdersRefreshOnStatusChange │
                   └────────────┬────────────┘
                                │
SignalR Hub        ◀────────────┘
ステータス変更通知        │
                          ▼
                   Nav.Refresh() ──▶ 画面リロード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Orders.razor | `src/WebApp/Components/Pages/User/Orders.razor` | ソース | メインページコンポーネント |
| OrdersRefreshOnStatusChange.razor | `src/WebApp/Components/Pages/User/OrdersRefreshOnStatusChange.razor` | ソース | リアルタイム更新コンポーネント |
| OrderingService.cs | `src/WebApp/Services/OrderingService.cs` | ソース | 注文API通信 |
| OrderStatusNotificationService.cs | `src/WebApp/Services/OrderStatusNotificationService.cs` | ソース | SignalR通知サービス |
| AuthenticationExtensions.cs | `src/WebApp/Extensions/AuthenticationExtensions.cs` | ソース | GetBuyerIdAsync拡張メソッド |
