# 機能設計書 48-ログアウト処理

## 概要

本ドキュメントは、eShop WebAppにおけるログアウト処理機能の設計を記載する。本機能はユーザーのセッションを終了し、Cookie認証とOpenID Connect認証の両方からサインアウトする。

### 本機能の処理概要

本機能は、認証済みユーザーがシステムからログアウトするための処理を提供する。UserMenuコンポーネントからのフォーム送信を受け付け、LogOutServiceを通じてCookie認証とOpenID Connect認証の両方からサインアウトを実行する。

**業務上の目的・背景**：セキュリティの観点から、ユーザーが明示的にセッションを終了できる機能は必須である。特に共有PCや公共の場所でアクセスした場合、ログアウト機能がないと他者による不正アクセスのリスクがある。本機能はCookieとOpenID Connect両方のセッションを確実に終了させることで、セキュアなログアウトを実現する。

**機能の利用シーン**：ユーザーメニューのドロップダウンから「Log out」ボタンをクリックした際に実行される。ログアウト処理完了後、ユーザーはIdentity.APIのログアウト完了画面にリダイレクトされ、その後WebAppに戻る。

**主要な処理内容**：
1. UserMenuコンポーネントからログアウトフォームが送信される
2. LogOutService.LogOutAsyncが呼び出される
3. Cookie認証スキームからのサインアウトを実行
4. OpenID Connect認証スキームからのサインアウトを実行（IDプロバイダーへのリダイレクト含む）

**関連システム・外部連携**：Identity.API（OpenID Connectサインアウト）

**権限による制御**：ログアウト処理自体は認証済みユーザーのみが実行可能（AuthorizeViewのAuthorized内に配置）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | ログアウト画面 | 主画面 | ログアウトフォームの受付 |
| - | ユーザーメニュー | 呼び出し元 | ログアウトボタン配置 |

## 機能種別

認証解除処理 / セッション終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| (なし) | - | - | フォーム送信のみ | AntiforgeryToken検証 |

### 入力データソース

- フォーム送信: POSTリクエスト（AntiforgeryToken含む）
- HttpContext: 現在の認証情報

## 出力仕様

### 出力データ

本機能は直接的なデータ出力を行わず、セッション終了とリダイレクトを実行。

| 項目名 | 型 | 説明 |
|--------|-----|------|
| リダイレクト | - | Identity.APIログアウト画面へ |

### 出力先

- 認証Cookie: 削除
- Identity.API: OpenID Connectサインアウトリクエスト

## 処理フロー

### 処理シーケンス

```
1. ユーザーメニューから「Log out」ボタンクリック
   └─ フォームPOSTが /user/logout に送信

2. LogOutAsync実行（UserMenu.razor）
   └─ LogOutService.LogOutAsync(HttpContext)を呼び出し

3. Cookie認証サインアウト
   └─ httpContext.SignOutAsync(CookieAuthenticationDefaults.AuthenticationScheme)

4. OpenID Connectサインアウト
   └─ httpContext.SignOutAsync(OpenIdConnectDefaults.AuthenticationScheme)
   └─ Identity.APIにサインアウトリクエスト
   └─ Identity.APIログアウト画面にリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[ユーザーメニュー] --> B[Log outクリック]
    B --> C[フォームPOST /user/logout]
    C --> D[LogOutAsync]
    D --> E[LogOutService.LogOutAsync]
    E --> F[SignOutAsync Cookie]
    F --> G[SignOutAsync OpenIdConnect]
    G --> H[Identity.APIサインアウト]
    H --> I[ログアウト完了画面]
    I --> J[WebAppトップへリダイレクト]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-48-01 | 認証済み前提 | ログアウトは認証済みユーザーのみ実行可能 | AuthorizeViewで制御 |
| BR-48-02 | 両方のサインアウト | CookieとOpenID Connect両方からサインアウト | 常に適用 |
| BR-48-03 | CSRF対策 | AntiforgeryTokenによるフォーム検証 | 常に適用 |
| BR-48-04 | IDプロバイダー連携 | Identity.APIへもサインアウト通知 | OpenID Connectサインアウト時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能は直接的なデータベース操作を行わない。

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | - |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CSRF検証失敗 | AntiforgeryToken不正 | 400エラー（ASP.NET Core標準） |
| - | 通信エラー | Identity.APIとの通信失敗 | ローカルCookieのみクリア |

### リトライ仕様

自動リトライは行わない。ユーザーは再度ログアウト操作を試行可能。

## トランザクション仕様

トランザクション管理は不要。各サインアウト処理は独立して実行。

## パフォーマンス要件

- サインアウト処理は即座に実行
- Identity.APIへのリダイレクトは通常のHTTPリダイレクト

## セキュリティ考慮事項

- AntiforgeryTokenによるCSRF対策
- Cookie認証とOpenID Connect両方のセッションを確実に終了
- フォームPOSTでのみログアウト可能（GETリクエストでは不可）
- AuthorizeViewで認証済みユーザーのみにログアウトボタンを表示

## 備考

- LogOut.razorは実質的にエンドポイントとしてのみ機能（UIなし）
- 実際のログアウトロジックはUserMenu.razorのLogOutAsyncで処理
- Identity.APIのログアウト完了画面でリダイレクト先を指定可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

ログアウトボタンのUIと処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UserMenu.razor | `src/WebApp/Components/Layout/UserMenu.razor` | ログアウトフォームとイベントハンドラ |
| 1-2 | LogOut.razor | `src/WebApp/Components/Pages/User/LogOut.razor` | ログアウトエンドポイント定義 |

**UserMenu.razor主要処理フロー**:
- **8-9行目**: AuthorizeView - 認証状態に応じた表示切替
- **15-18行目**: ログアウトフォーム
- **15行目**: `action="user/logout"` - POSTの送信先
- **16行目**: `<AntiforgeryToken />` - CSRF対策
- **27-32行目**: LogOutAsyncメソッド - LogOutServiceを呼び出し

**LogOut.razor主要処理フロー**:
- **1行目**: `@page "/user/logout"` - エンドポイント定義
- **2-5行目**: コメント - UIなし、フォーム受付のみ

#### Step 2: サービス層を理解する

ログアウト処理の実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LogOutService.cs | `src/WebApp/Services/LogOutService.cs` | 実際のサインアウト処理 |

**主要処理フロー**:
- **9-13行目**: LogOutAsyncメソッド
- **11行目**: `SignOutAsync(CookieAuthenticationDefaults.AuthenticationScheme)` - Cookie認証からサインアウト
- **12行目**: `SignOutAsync(OpenIdConnectDefaults.AuthenticationScheme)` - OpenID Connectからサインアウト

#### Step 3: 認証スキームを理解する

使用される認証スキーム。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Microsoft.AspNetCore.Authentication.Cookies | ライブラリ | CookieAuthenticationDefaults.AuthenticationScheme = "Cookies" |
| 3-2 | Microsoft.AspNetCore.Authentication.OpenIdConnect | ライブラリ | OpenIdConnectDefaults.AuthenticationScheme = "OpenIdConnect" |

**読解のコツ**: SignOutAsync()は指定されたスキームに対してサインアウト処理を実行。OpenID Connectの場合はIDプロバイダーへのリダイレクトが発生。

### プログラム呼び出し階層図

```
UserMenu.razor (ログアウトボタン)
    │
    ├─ <form action="user/logout" method="post">
    │      └─ <AntiforgeryToken />
    │      └─ <button type="submit">Log out</button>
    │
    └─ LogOutAsync (@onsubmit)
           └─ LogOutService.LogOutAsync(HttpContext)
                  │
                  ├─ httpContext.SignOutAsync("Cookies")
                  │      └─ 認証Cookieを削除
                  │
                  └─ httpContext.SignOutAsync("OpenIdConnect")
                         └─ Identity.APIにサインアウトリクエスト
                         └─ ログアウト完了画面へリダイレクト

LogOut.razor (/user/logout)
    └─ POSTリクエストの受付エンドポイント（UIなし）
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ユーザーメニュー    ───▶ フォームPOST /user/logout
Log outクリック            │
                          ▼
                    ┌─────────────────┐
                    │   LogOutAsync   │
                    └────────┬────────┘
                             │
                             ▼
                    ┌─────────────────┐
                    │ LogOutService   │
                    │ .LogOutAsync    │
                    └────────┬────────┘
                             │
              ┌──────────────┴──────────────┐
              ▼                              ▼
       SignOutAsync                   SignOutAsync
       Cookies                        OpenIdConnect
              │                              │
              ▼                              ▼
       Cookie削除                    Identity.API
                                    サインアウト
                                           │
                                           ▼
                                    ログアウト完了
                                    画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LogOut.razor | `src/WebApp/Components/Pages/User/LogOut.razor` | ソース | ログアウトエンドポイント |
| UserMenu.razor | `src/WebApp/Components/Layout/UserMenu.razor` | ソース | ログアウトUI・処理呼び出し |
| LogOutService.cs | `src/WebApp/Services/LogOutService.cs` | ソース | ログアウト処理実装 |
