# 機能設計書 49-ホーム画面

## 概要

本ドキュメントは、eShop WebhookClientにおけるホーム画面の機能設計を記載する。本画面はWebhook管理のメイン画面として、登録済みWebhookの一覧表示と受信メッセージの一覧表示を提供する。

### 本機能の処理概要

本機能は、WebhookClientアプリケーションのメイン画面として、ユーザーが登録したWebhookサブスクリプションの一覧と、受信したWebhookメッセージ（OrderPaidイベント）の一覧を表示する。認証状態に応じて表示内容が切り替わる。

**業務上の目的・背景**：eShopのWebhook機能を利用することで、外部システムは注文状態の変更（特にOrderPaid）をリアルタイムで受信できる。本画面はWebhookの管理インターフェースとして、登録状況の確認と受信メッセージのモニタリングを提供する。

**機能の利用シーン**：
- 開発者がWebhook連携のテスト・デバッグを行う際
- システム管理者がWebhookの登録状況を確認する際
- OrderPaidイベントの受信状況をモニタリングする際

**主要な処理内容**：
1. 認証状態の確認（AuthorizeView）
2. 認証済みの場合：RegisteredHooksコンポーネントで登録済みWebhook一覧を表示
3. 未認証の場合：ログイン促進メッセージを表示
4. ReceivedMessagesコンポーネントで受信メッセージ一覧を表示
5. 「Add webhook registration」リンクでWebhook登録画面へ遷移

**関連システム・外部連携**：Webhooks.API（Webhook一覧取得）、HooksRepository（受信メッセージ管理）

**権限による制御**：Webhook一覧の表示と登録は認証済みユーザーのみ。受信メッセージ一覧は認証不要で全員に表示。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | ホーム画面 | 主画面 | Webhook管理メイン画面 |
| 22 | Webhook追加画面 | 遷移先画面 | 「Add webhook registration」リンクで遷移 |

## 機能種別

画面表示機能（CRUD操作のRead）/ 管理画面

## 入力仕様

### 入力パラメータ

本画面には明示的な入力パラメータはない。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| (なし) | - | - | - | - |

### 入力データソース

- Webhooks.API: 登録済みWebhook一覧
- HooksRepository: 受信Webhookメッセージ一覧

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| webhooks | IQueryable\<WebhookResponse\> | 登録済みWebhook一覧 |
| webhooks[].Date | DateTime | 登録日時 |
| webhooks[].DestUrl | string | 送信先URL |
| webhooks[].Token | string | 認証トークン |
| messages | IQueryable\<WebHookReceived\> | 受信メッセージ一覧 |
| messages[].When | DateTime | 受信日時 |
| messages[].Data | string | 受信データ |
| messages[].Token | string | 認証トークン |

### 出力先

- 画面表示: 登録済みWebhookテーブル、受信メッセージテーブル

## 処理フロー

### 処理シーケンス

```
1. 画面初期化
   └─ AuthorizeViewで認証状態を確認

2. 認証済みの場合
   └─ RegisteredHooksコンポーネント表示
   └─ WebhooksClient.LoadWebhooksで登録済みWebhook取得
   └─ 「Add webhook registration」リンク表示

3. 未認証の場合
   └─ ログイン促進メッセージを表示

4. 受信メッセージ表示（認証状態に関わらず）
   └─ ReceivedMessagesコンポーネント表示
   └─ HooksRepository.GetAllで受信メッセージ取得
   └─ 購読によるリアルタイム更新
```

### フローチャート

```mermaid
flowchart TD
    A[/ ホーム画面アクセス] --> B[AuthorizeView]
    B --> C{認証済み?}
    C -->|Yes| D[RegisteredHooksコンポーネント]
    D --> E[WebhooksClient.LoadWebhooks]
    E --> F[QuickGridで一覧表示]
    F --> G[Add webhook registration リンク]
    C -->|No| H[ログイン促進メッセージ]
    G --> I[ReceivedMessagesコンポーネント]
    H --> I
    I --> J[HooksRepository.GetAll]
    J --> K[QuickGridで一覧表示]
    K --> L[購読開始]
    L --> M{新メッセージ受信?}
    M -->|Yes| N[RefreshDataAsync]
    N --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-49-01 | Webhook管理認証 | Webhook一覧表示と登録は認証済みユーザーのみ | AuthorizeView Authorized |
| BR-49-02 | 受信メッセージ公開 | 受信メッセージ一覧は全員に表示 | 常に適用 |
| BR-49-03 | リアルタイム更新 | 受信メッセージは新着時に自動更新 | Subscribe有効時 |
| BR-49-04 | ソート可能 | QuickGridで各カラムのソートが可能 | QuickGrid使用 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Webhook一覧取得 | WebhookSubscriptions | SELECT | ユーザーのWebhook一覧を取得（API経由） |
| 受信メッセージ取得 | (インメモリ) | GET | HooksRepositoryから受信メッセージ取得 |

※ 受信メッセージはインメモリ（ConcurrentQueue）で管理

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 通信エラー | Webhooks.APIとの通信失敗 | Loading表示が継続 |
| - | 認証エラー | 未認証でWebhook一覧取得試行 | AuthorizeViewで制御済み |

### リトライ仕様

自動リトライは行わない。画面リロードでリトライ可能。

## トランザクション仕様

読み取り専用のため、トランザクション管理は不要。

## パフォーマンス要件

- QuickGridによる効率的なデータ表示
- 購読によるリアルタイム更新（ポーリング不要）

## セキュリティ考慮事項

- Webhook管理は認証済みユーザーのみ
- トークン情報の表示はログインユーザーに限定
- 受信メッセージのTokenは表示されるが、これはデバッグ目的

## 備考

- WebhookClientは主にデモ・テスト用途のアプリケーション
- HooksRepositoryはインメモリ実装のため、アプリ再起動で受信メッセージはクリアされる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

ホーム画面のメインコンポーネント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Home.razor | `src/WebhookClient/Components/Pages/Home/Home.razor` | ページ構造、AuthorizeView |

**主要処理フロー**:
- **1行目**: `@page "/"` - ルーティング
- **4行目**: `<PageTitle>Order management</PageTitle>` - ページタイトル
- **8-17行目**: AuthorizeView - 認証状態に応じた表示切替
- **10行目**: `<RegisteredHooks />` - Webhook一覧コンポーネント
- **11行目**: `href="add-webhook"` - Webhook登録画面へのリンク
- **22行目**: `<ReceivedMessages />` - 受信メッセージコンポーネント

#### Step 2: 子コンポーネントを理解する

登録済みWebhook一覧と受信メッセージ一覧。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RegisteredHooks.razor | `src/WebhookClient/Components/Pages/Home/RegisteredHooks.razor` | Webhook一覧表示 |
| 2-2 | ReceivedMessages.razor | `src/WebhookClient/Components/Pages/Home/ReceivedMessages.razor` | 受信メッセージ表示・購読 |

**RegisteredHooks.razor主要処理フロー**:
- **9-13行目**: QuickGridで一覧表示
- **10行目**: Date列（ソート可能、デフォルト降順）
- **23-26行目**: OnInitializedAsyncでWebhook取得

**ReceivedMessages.razor主要処理フロー**:
- **9-13行目**: QuickGridで一覧表示
- **28-32行目**: OnInitializedAsyncで購読開始・データ取得
- **30行目**: `HooksRepository.Subscribe` - 新メッセージ通知の購読
- **37-47行目**: OnMessageReceivedAsyncでデータ更新・画面再描画
- **49-52行目**: Disposeで購読解除

#### Step 3: サービス層を理解する

API通信とデータ管理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WebHooksClient.cs | `src/WebhookClient/Services/WebHooksClient.cs` | Webhook API通信 |
| 3-2 | HooksRepository.cs | `src/WebhookClient/Services/HooksRepository.cs` | 受信メッセージ管理 |

**WebHooksClient.cs主要処理フロー**:
- **10-13行目**: LoadWebhooksメソッド - Webhook一覧取得

**HooksRepository.cs主要処理フロー**:
- **10-28行目**: AddNewメソッド - 新しい受信メッセージを追加、購読者に通知
- **30-33行目**: GetAllメソッド - 全受信メッセージ取得
- **35-40行目**: Subscribeメソッド - 変更通知の購読

### プログラム呼び出し階層図

```
Home.razor (エントリーポイント)
    │
    ├─ AuthorizeView
    │      ├─ Authorized
    │      │      ├─ RegisteredHooks.razor
    │      │      │      └─ WebhooksClient.LoadWebhooks()
    │      │      │             └─ Webhooks.API GET /api/webhooks
    │      │      │
    │      │      └─ <a href="add-webhook">
    │      │
    │      └─ NotAuthorized
    │             └─ ログイン促進メッセージ
    │
    └─ ReceivedMessages.razor
           ├─ HooksRepository.Subscribe()
           │      └─ 変更通知コールバック登録
           │
           ├─ HooksRepository.GetAll()
           │      └─ ConcurrentQueueからデータ取得
           │
           └─ OnMessageReceivedAsync (通知受信時)
                  └─ RefreshDataAsync → StateHasChanged
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Webhooks.API        ───▶ WebhooksClient.LoadWebhooks
GET /api/webhooks         │
                          ▼
                    ┌─────────────────┐
                    │ RegisteredHooks │──▶ Webhook一覧HTML
                    └─────────────────┘

HooksRepository     ───▶ ReceivedMessages.OnInitializedAsync
(ConcurrentQueue)         │
                          ▼
                    ┌─────────────────┐
                    │ ReceivedMessages│──▶ 受信メッセージHTML
                    └────────┬────────┘
                             │
                             ▼
                    Subscribe購読
                             │
新Webhookメッセージ ────────┘
受信時                       │
                             ▼
                    RefreshDataAsync ──▶ 画面更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Home.razor | `src/WebhookClient/Components/Pages/Home/Home.razor` | ソース | ホーム画面メインコンポーネント |
| RegisteredHooks.razor | `src/WebhookClient/Components/Pages/Home/RegisteredHooks.razor` | ソース | 登録済みWebhook一覧 |
| ReceivedMessages.razor | `src/WebhookClient/Components/Pages/Home/ReceivedMessages.razor` | ソース | 受信メッセージ一覧 |
| WebHooksClient.cs | `src/WebhookClient/Services/WebHooksClient.cs` | ソース | Webhook API通信 |
| HooksRepository.cs | `src/WebhookClient/Services/HooksRepository.cs` | ソース | 受信メッセージ管理 |
