# 機能設計書 50-Webhook登録画面

## 概要

本ドキュメントは、eShop WebhookClientにおけるWebhook登録画面の機能設計を記載する。本画面は新しいWebhookサブスクリプション（OrderPaidイベント）を登録する機能を提供する。

### 本機能の処理概要

本機能は、ユーザーが新しいWebhookサブスクリプションをWebhooks.APIに登録するための画面である。OrderPaidイベントを受信するためのWebhook URLとGrant URLを設定し、認証トークンを指定してWebhookを登録する。

**業務上の目的・背景**：eShopシステムでは、注文が支払い完了（OrderPaid）状態になった際に外部システムに通知することができる。この機能を利用するには、Webhookを事前に登録する必要がある。本画面はその登録作業を行うインターフェースを提供する。

**機能の利用シーン**：
- 外部システムとのWebhook連携を設定する際
- OrderPaidイベントの通知先を登録する際
- Webhook機能のテスト・デバッグを行う際

**主要な処理内容**：
1. トークン入力フィールドを表示（デフォルト値は設定から取得）
2. 「Register」ボタンクリックでRegisterAsyncを実行
3. Grant URL（検証用）とWebhook URL（通知先）を生成
4. WebhooksClient.AddWebHookAsyncでWebhooks.APIに登録
5. 成功時はホーム画面にリダイレクト、失敗時はエラーメッセージ表示

**関連システム・外部連携**：Webhooks.API（Webhook登録REST API）

**権限による制御**：本画面は認証が必要（Webhooks.APIへのアクセスに認証が必要）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 22 | Webhook追加画面 | 主画面 | Webhook登録フォーム |
| 21 | ホーム画面 | 遷移元・遷移先 | 登録後にリダイレクト |

## 機能種別

データ登録機能（CRUD操作のCreate）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| token | string | Yes | 認証トークン | 空でないこと |

### 入力データソース

- フォーム入力: トークン
- 設定: デフォルトトークン（WebhookClientOptions.Token）
- 設定/自動生成: SelfUrl（NavigationManager.BaseUri）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| WebhookSubscriptionRequest | object | Webhooks.APIへの登録リクエスト |
| - Event | string | "OrderPaid"（固定） |
| - GrantUrl | string | Grant URL（{baseUrl}check） |
| - Url | string | Webhook URL（{baseUrl}webhook-received） |
| - Token | string | 認証トークン |

### 出力先

- Webhooks.API: POST /api/webhooks

## 処理フロー

### 処理シーケンス

```
1. 画面初期化（OnInitialized）
   └─ WebhookClientOptions.Tokenからデフォルトトークンを取得

2. 画面表示
   └─ トークン入力フィールド表示
   └─ 「Register」ボタン表示

3. 登録処理（RegisterAsync）
   └─ トークンが空の場合は処理中断
   └─ baseUrlを決定（SelfUrl設定値またはNav.BaseUri）
   └─ grantUrl = baseUrl + "check"
   └─ url = baseUrl + "webhook-received"
   └─ WebhookSubscriptionRequestを作成
   └─ WebhooksClient.AddWebHookAsyncでAPI呼び出し

4. 結果処理
   └─ 成功（IsSuccessStatusCode）: ホーム画面へリダイレクト
   └─ 失敗: エラーメッセージを表示
```

### フローチャート

```mermaid
flowchart TD
    A[/add-webhook アクセス] --> B[OnInitialized]
    B --> C[デフォルトトークン取得]
    C --> D[フォーム表示]
    D --> E{Registerクリック}
    E --> F{トークン空?}
    F -->|Yes| D
    F -->|No| G[baseUrl決定]
    G --> H[grantUrl, url生成]
    H --> I[WebhookSubscriptionRequest作成]
    I --> J[WebhooksClient.AddWebHookAsync]
    J --> K{成功?}
    K -->|Yes| L[ホーム画面へリダイレクト]
    K -->|No| M[エラーメッセージ表示]
    M --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-50-01 | イベント固定 | 登録できるイベントは"OrderPaid"のみ | 常に適用 |
| BR-50-02 | トークン必須 | 認証トークンは必須入力 | 登録時 |
| BR-50-03 | Grant URL検証 | 登録前にWebhooks.APIがGrant URLの検証を実施 | API側で実行 |
| BR-50-04 | URL自動生成 | grantUrl, urlはbaseUrlから自動生成 | 登録時 |
| BR-50-05 | 認証必須 | Webhook登録はWebhooks.APIへの認証が必要 | API呼び出し時 |

### 計算ロジック

- baseUrl: `!string.IsNullOrEmpty(options.Value.SelfUrl) ? options.Value.SelfUrl : Nav.BaseUri`
- grantUrl: `{baseUrl}check`
- url: `{baseUrl}webhook-received`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Webhook登録 | WebhookSubscriptions | INSERT | 新規Webhookサブスクリプションを登録（API経由） |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | BadRequest | 不正なリクエスト | エラーメッセージ表示 |
| 401 | Unauthorized | 認証失敗 | エラーメッセージ表示 |
| 403 | Forbidden | Grant URL検証失敗 | エラーメッセージ表示 |
| - | 通信エラー | Webhooks.APIとの通信失敗 | エラーメッセージ表示 |

### リトライ仕様

自動リトライは行わない。ユーザーは再度「Register」をクリックしてリトライ可能。

## トランザクション仕様

Webhook登録はWebhooks.API側でトランザクション管理。

## パフォーマンス要件

- 登録処理は即座に実行
- Grant URL検証が行われるため、応答時間はネットワーク状況に依存

## セキュリティ考慮事項

- トークンによる認証でWebhook呼び出しを保護
- Grant URL検証により、不正なURL登録を防止
- Webhooks.APIへのアクセスは認証済みユーザーのみ

## 備考

- OrderPaidイベントのみサポート（将来的に他イベントの追加可能性あり）
- grantUrl（/check）はWebhooks.APIからの検証リクエストを受け付けるエンドポイント
- url（/webhook-received）は実際のWebhook通知を受け取るエンドポイント

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

Webhook登録画面のRazorコンポーネント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AddWebhook.razor | `src/WebhookClient/Components/Pages/AddWebhook.razor` | フォーム処理、API呼び出し |

**主要処理フロー**:
- **1行目**: `@page "/add-webhook"` - ルーティング
- **9行目**: `<p>` - 説明テキスト（OrderPaid Webhookの登録）
- **11-17行目**: 登録フォーム（トークン入力、Registerボタン）
- **19-22行目**: エラーメッセージ表示
- **28-30行目**: OnInitialized - デフォルトトークン取得
- **32-63行目**: RegisterAsync - 登録処理

**RegisterAsync詳細**:
- **34-38行目**: トークン空チェック
- **40-43行目**: baseUrl決定ロジック
- **44行目**: grantUrl生成（{baseUrl}check）
- **45行目**: url生成（{baseUrl}webhook-received）
- **47-53行目**: WebhookSubscriptionRequest作成
- **55-63行目**: API呼び出しと結果処理

#### Step 2: サービス層を理解する

API通信クライアント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WebHooksClient.cs | `src/WebhookClient/Services/WebHooksClient.cs` | AddWebHookAsyncメソッド |

**主要処理フロー**:
- **5-8行目**: AddWebHookAsyncメソッド
- **7行目**: `client.PostAsJsonAsync("/api/webhooks", payload)` - POSTリクエスト

#### Step 3: 設定を理解する

オプション設定クラス。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WebhookClientOptions.cs | `src/WebhookClient/WebhookClientOptions.cs` | Token, SelfUrl設定 |

**読解のコツ**: Token（デフォルトトークン）とSelfUrl（自己URL）の設定値を確認。

### プログラム呼び出し階層図

```
AddWebhook.razor (エントリーポイント)
    │
    ├─ OnInitialized
    │      └─ options.Value.Token (デフォルトトークン取得)
    │
    └─ RegisterAsync (フォーム送信時)
           │
           ├─ トークン空チェック
           │
           ├─ baseUrl決定
           │      └─ options.Value.SelfUrl ?? Nav.BaseUri
           │
           ├─ URL生成
           │      ├─ grantUrl = {baseUrl}check
           │      └─ url = {baseUrl}webhook-received
           │
           ├─ WebhookSubscriptionRequest作成
           │      ├─ Event = "OrderPaid"
           │      ├─ GrantUrl = grantUrl
           │      ├─ Url = url
           │      └─ Token = token
           │
           └─ WebhooksClient.AddWebHookAsync(payload)
                  └─ HttpClient.PostAsJsonAsync("/api/webhooks", payload)
                         └─ Webhooks.API POST /api/webhooks
```

### データフロー図

```
[入力]                    [処理]                           [出力]

WebhookClientOptions ───▶ OnInitialized
Token (デフォルト値)       │
                          ▼
フォーム入力         ───▶ RegisterAsync
token                     │
                          ├─ baseUrl決定
                          │
                          ├─ grantUrl = {baseUrl}check
                          │
                          ├─ url = {baseUrl}webhook-received
                          │
                          ▼
                    ┌─────────────────┐
                    │ WebhookSubscription│
                    │    Request      │
                    └────────┬────────┘
                             │
                             ▼
Webhooks.API        ◀──POST /api/webhooks
                             │
                             ▼
                    ┌─────────────────┐
              ┌─────│    結果判定     │─────┐
              │     └─────────────────┘     │
              ▼                             ▼
         成功                           失敗
    ホーム画面へ                  エラーメッセージ
    リダイレクト                      表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AddWebhook.razor | `src/WebhookClient/Components/Pages/AddWebhook.razor` | ソース | Webhook登録画面 |
| WebHooksClient.cs | `src/WebhookClient/Services/WebHooksClient.cs` | ソース | Webhook API通信 |
| WebhookClientOptions.cs | `src/WebhookClient/WebhookClientOptions.cs` | ソース | オプション設定 |
| WebhookSubscriptionRequest.cs | `src/WebhookClient/Models/WebhookSubscriptionRequest.cs` | ソース | リクエストモデル |
