# 機能設計書 51-受信メッセージ表示

## 概要

本ドキュメントは、WebhookClientアプリケーションにおける「受信メッセージ表示」機能の設計仕様を定義する。この機能は、Webhookで受信したメッセージ一覧をリアルタイムで表示する画面コンポーネントである。

### 本機能の処理概要

本機能は、WebhookClientアプリケーションがWebhook APIから受信した通知メッセージを一覧形式で表示するBlazor Server画面コンポーネントである。

**業務上の目的・背景**：eShopシステムでは、注文が支払い完了（Paid）ステータスになった際にWebhook通知を外部システムへ送信する機能がある。本機能は、その受信側のクライアントとして、実際にどのようなWebhookメッセージを受信したかをユーザーが確認できるようにすることを目的としている。外部連携の監視・デバッグ・検証に活用される。

**機能の利用シーン**：Webhookサブスクリプションを登録後、注文が支払い完了ステータスに遷移した際に送信されるWebhook通知を確認する場面で利用される。開発者やシステム管理者がWebhook連携の動作確認を行う際に使用する。

**主要な処理内容**：
1. HooksRepositoryから受信済みWebhookメッセージ一覧を取得
2. QuickGridコンポーネントを使用してソート可能なテーブル形式で表示
3. HooksRepositoryの変更通知をサブスクライブし、新規メッセージ受信時に画面をリアルタイム更新
4. コンポーネント破棄時にサブスクリプションをDispose

**関連システム・外部連携**：Webhooks.APIサービスからのWebhook通知を受信し、WebhookClientアプリケーション内のHooksRepositoryに格納されたデータを表示する。

**権限による制御**：WebhookClientアプリケーションへのアクセスには認証が必要（Authorize属性）。認証済みユーザーのみがこの画面を閲覧できる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | ホーム画面 | 主画面 | HooksRepositoryで受信Webhookメッセージ一覧を表示 |

## 機能種別

データ表示 / リアルタイム更新

## 入力仕様

### 入力パラメータ

本コンポーネントは外部からのパラメータを受け取らない。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | - | - |

### 入力データソース

HooksRepository（インメモリキュー）から受信済みWebhookメッセージを取得する。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| When | DateTime | Webhookメッセージの受信日時 |
| Data | string | Webhookのペイロードデータ |
| Token | string | 検証用トークン |

### 出力先

Blazor Server画面上のQuickGridコンポーネントに表示。

## 処理フロー

### 処理シーケンス

```
1. コンポーネント初期化（OnInitializedAsync）
   └─ HooksRepository.Subscribeでリアルタイム更新を購読
   └─ RefreshDataAsyncを呼び出して初期データを取得

2. データ取得（RefreshDataAsync）
   └─ HooksRepository.GetAll()でメッセージ一覧を取得
   └─ AsQueryable()でIQueryable<WebHookReceived>に変換

3. メッセージ受信時（OnMessageReceivedAsync）
   └─ RefreshDataAsyncで最新データを取得
   └─ StateHasChanged()で画面を再描画

4. コンポーネント破棄時（Dispose）
   └─ subscription?.Dispose()でサブスクリプションを解除
```

### フローチャート

```mermaid
flowchart TD
    A[コンポーネント初期化] --> B[HooksRepository.Subscribe]
    B --> C[RefreshDataAsync]
    C --> D{データあり?}
    D -->|Yes| E[QuickGridで表示]
    D -->|No| F[メッセージなし表示]
    G[Webhook受信イベント] --> H[OnMessageReceivedAsync]
    H --> C
    I[コンポーネント破棄] --> J[Dispose]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-51-1 | リアルタイム更新 | 新規メッセージ受信時に自動的に画面を更新する | 常時 |
| BR-51-2 | ソート機能 | 各列（When, Data, Token）でソート可能 | 常時 |
| BR-51-3 | エラーハンドリング | 更新時のエラーはDispatchExceptionAsyncで処理 | エラー発生時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを直接操作しない。インメモリのConcurrentQueueからデータを取得する。

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし（インメモリストレージを使用）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Exception | OnMessageReceivedAsync内での例外 | DispatchExceptionAsyncで上位に伝搬 |

### リトライ仕様

特になし。

## トランザクション仕様

本機能はトランザクション管理を行わない（読み取り専用）。

## パフォーマンス要件

- 画面初期表示: 1秒以内
- リアルタイム更新: 新規メッセージ受信後0.5秒以内に画面反映

## セキュリティ考慮事項

- WebhookClientアプリケーションへのアクセスには認証が必要
- Webhookトークンの検証により、不正なWebhook送信を防止
- 受信データはサニタイズされて表示される

## 備考

- 本機能はBlazor Serverのリアルタイム通信（SignalR）を活用したリアクティブUIを実装
- データはインメモリで保持されるため、アプリケーション再起動時にクリアされる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Webhookメッセージを表すデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WebHookReceived.cs | `src/WebhookClient/Services/WebHookReceived.cs` | 受信Webhookメッセージのデータ構造（When, Data, Token） |

**読解のコツ**: シンプルなPOCOクラス。When（受信日時）、Data（ペイロード）、Token（検証トークン）の3プロパティで構成。

#### Step 2: データストレージを理解する

受信メッセージを保持するリポジトリの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HooksRepository.cs | `src/WebhookClient/Services/HooksRepository.cs` | インメモリキューとサブスクリプションパターンの実装 |

**主要処理フロー**:
- **7行目**: ConcurrentQueue<WebHookReceived>でスレッドセーフにメッセージを保持
- **10-28行目**: AddNewメソッドでメッセージ追加と購読者への通知
- **30-33行目**: GetAllメソッドで全メッセージを返却
- **35-39行目**: Subscribeメソッドでコールバック関数を登録

#### Step 3: 画面コンポーネントを理解する

Blazorコンポーネントの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ReceivedMessages.razor | `src/WebhookClient/Components/Pages/Home/ReceivedMessages.razor` | QuickGridによる表示とリアルタイム更新の実装 |

**主要処理フロー**:
- **1行目**: HooksRepositoryをDI注入
- **2行目**: IDisposable実装でサブスクリプション解除
- **10-14行目**: QuickGridでソート可能なテーブルを表示
- **28-32行目**: OnInitializedAsyncでサブスクリプション登録と初期データ取得
- **34-35行目**: RefreshDataAsyncでデータ取得
- **37-48行目**: OnMessageReceivedAsyncで新規メッセージ受信時の処理
- **50-53行目**: Disposeでサブスクリプション解除

#### Step 4: Webhookエンドポイントを理解する

Webhook受信のエントリーポイントを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | WebhookEndpoints.cs | `src/WebhookClient/Endpoints/WebhookEndpoints.cs` | /webhook-receivedエンドポイントの実装 |

**主要処理フロー**:
- **31-53行目**: /webhook-receivedでWebhookを受信しHooksRepositoryに追加

### プログラム呼び出し階層図

```
ReceivedMessages.razor（画面コンポーネント）
    │
    ├─ HooksRepository.Subscribe（初期化時）
    │      └─ OnChangeSubscriptionを登録
    │
    ├─ HooksRepository.GetAll（データ取得）
    │      └─ ConcurrentQueue<WebHookReceived>から全件取得
    │
    └─ OnMessageReceivedAsync（新規メッセージ時）
           └─ RefreshDataAsync → StateHasChanged

WebhookEndpoints.MapPost("/webhook-received")
    │
    └─ HooksRepository.AddNew
           └─ 購読者への通知 → OnMessageReceivedAsync
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Webhooks.APIからの通知 ───▶ WebhookEndpoints ───▶ HooksRepository
                           /webhook-received      ├─ AddNew（メッセージ追加）
                                                  └─ 購読者通知

HooksRepository ───▶ ReceivedMessages.razor ───▶ QuickGrid
GetAll()             データバインディング         画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ReceivedMessages.razor | `src/WebhookClient/Components/Pages/Home/ReceivedMessages.razor` | ソース | 受信メッセージ表示画面コンポーネント |
| HooksRepository.cs | `src/WebhookClient/Services/HooksRepository.cs` | ソース | インメモリリポジトリ・サブスクリプション管理 |
| WebHookReceived.cs | `src/WebhookClient/Services/WebHookReceived.cs` | ソース | 受信メッセージのデータモデル |
| WebhookEndpoints.cs | `src/WebhookClient/Endpoints/WebhookEndpoints.cs` | ソース | Webhook受信エンドポイント |
| Home.razor | `src/WebhookClient/Components/Pages/Home/Home.razor` | ソース | ReceivedMessagesを含むホーム画面 |
