# 機能設計書 52-登録済みWebhook表示

## 概要

本ドキュメントは、WebhookClientアプリケーションにおける「登録済みWebhook表示」機能の設計仕様を定義する。この機能は、ユーザーが登録したWebhookサブスクリプションの一覧を表示する画面コンポーネントである。

### 本機能の処理概要

本機能は、Webhooks.APIに登録されているWebhookサブスクリプションの一覧をWebhookClientアプリケーション上で表示するBlazor Server画面コンポーネントである。

**業務上の目的・背景**：eShopシステムでは、外部システムとの連携のためにWebhookを登録する機能を提供している。本機能は、ユーザーが自身で登録したWebhookの状態を確認し、管理するために必要である。どのURLに対してどのようなWebhookが登録されているかを一覧で把握できる。

**機能の利用シーン**：Webhookを登録した後、その登録内容を確認する場面で利用される。また、不要なWebhookの削除を検討する際に、現在の登録状況を確認するためにも使用される。

**主要な処理内容**：
1. WebhooksClient.LoadWebhooks()を呼び出してWebhooks.APIから登録済みWebhook一覧を取得
2. QuickGridコンポーネントを使用してソート可能なテーブル形式で表示
3. 登録日時、送信先URL、トークンを列として表示
4. 登録日時の降順でデフォルトソート

**関連システム・外部連携**：Webhooks.APIサービスのGET /api/webhooksエンドポイントからデータを取得する。

**権限による制御**：WebhookClientアプリケーションへのアクセスには認証が必要。認証済みユーザーは自身が登録したWebhookのみを閲覧できる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | ホーム画面 | 主画面 | WebhooksClientで登録済みWebhook一覧を表示 |

## 機能種別

データ表示

## 入力仕様

### 入力パラメータ

本コンポーネントは外部からのパラメータを受け取らない。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | - | - |

### 入力データソース

Webhooks.APIのGET /api/webhooksエンドポイントから取得。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Date | DateTime | Webhookの登録日時 |
| DestUrl | string | Webhook送信先URL |
| Token | string | 検証用トークン |

### 出力先

Blazor Server画面上のQuickGridコンポーネントに表示。

## 処理フロー

### 処理シーケンス

```
1. コンポーネント初期化（OnInitializedAsync）
   └─ WebhooksClient.LoadWebhooks()を呼び出し

2. API呼び出し
   └─ Webhooks.APIのGET /api/webhooksにリクエスト
   └─ 認証済みユーザーのWebhook一覧を取得

3. データバインディング
   └─ 取得結果をIQueryable<WebhookResponse>に変換
   └─ QuickGridにバインド

4. 画面表示
   └─ データがある場合：QuickGridでテーブル表示
   └─ データがない場合：「None registered」メッセージを表示
```

### フローチャート

```mermaid
flowchart TD
    A[コンポーネント初期化] --> B[WebhooksClient.LoadWebhooks]
    B --> C[Webhooks.API GET /api/webhooks]
    C --> D{データあり?}
    D -->|Yes| E[QuickGridで表示]
    D -->|No| F[登録なしメッセージ表示]
    E --> G[Date降順でソート]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-52-1 | デフォルトソート | 登録日時（Date）の降順でデフォルトソート | 常時 |
| BR-52-2 | ソート機能 | 各列（Date, Destination, Token）でソート可能 | 常時 |
| BR-52-3 | ユーザースコープ | 認証済みユーザーが登録したWebhookのみ表示 | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本コンポーネントはデータベースを直接操作しない。Webhooks.API経由でデータを取得する。

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | API経由でデータ取得 |

### テーブル別操作詳細

該当なし（API経由でのデータ取得）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 401 | 認証エラー | 未認証状態でアクセス | ログイン画面へリダイレクト |
| 500 | サーバーエラー | Webhooks.API障害 | エラー画面を表示 |

### リトライ仕様

特になし。

## トランザクション仕様

本機能はトランザクション管理を行わない（読み取り専用）。

## パフォーマンス要件

- 画面初期表示: 2秒以内
- API応答時間: 1秒以内

## セキュリティ考慮事項

- WebhookClientアプリケーションへのアクセスには認証が必要
- ユーザーは自身が登録したWebhookのみを閲覧可能
- トークン情報は画面上に表示されるため、機密性に注意

## 備考

- 本機能は静的な一覧表示であり、リアルタイム更新機能は持たない
- Webhook登録後に一覧を更新するには画面をリロードする必要がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Webhookレスポンスを表すデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WebhookResponse.cs | `src/WebhookClient/Services/WebhookResponse.cs` | APIレスポンスのデータ構造（Date, DestUrl, Token） |

**読解のコツ**: シンプルなDTOクラス。Date（登録日時）、DestUrl（送信先URL）、Token（検証トークン）の3プロパティで構成。

#### Step 2: APIクライアントを理解する

Webhooks.APIとの通信を行うクライアントを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WebhooksClient.cs | `src/WebhookClient/Services/WebhooksClient.cs` | HttpClientを使用したAPI呼び出し |

**主要処理フロー**:
- **3行目**: HttpClientをコンストラクタインジェクション
- **10-13行目**: LoadWebhooksメソッドでGET /api/webhooksを呼び出し

#### Step 3: 画面コンポーネントを理解する

Blazorコンポーネントの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RegisteredHooks.razor | `src/WebhookClient/Components/Pages/Home/RegisteredHooks.razor` | QuickGridによる表示実装 |

**主要処理フロー**:
- **1行目**: WebhooksClientをDI注入
- **9-13行目**: QuickGridでソート可能なテーブルを表示
- **10行目**: Date列をデフォルトソート列として設定（降順）
- **23-26行目**: OnInitializedAsyncでLoadWebhooksを呼び出し

### プログラム呼び出し階層図

```
RegisteredHooks.razor（画面コンポーネント）
    │
    └─ WebhooksClient.LoadWebhooks（初期化時）
           │
           └─ HttpClient.GetFromJsonAsync
                  │
                  └─ Webhooks.API GET /api/webhooks
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Webhooks.API ───▶ WebhooksClient ───▶ RegisteredHooks.razor
GET /api/webhooks   LoadWebhooks()      │
                                        └─ QuickGrid表示
                                           ├─ Date
                                           ├─ DestUrl
                                           └─ Token
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RegisteredHooks.razor | `src/WebhookClient/Components/Pages/Home/RegisteredHooks.razor` | ソース | 登録済みWebhook表示画面コンポーネント |
| WebhooksClient.cs | `src/WebhookClient/Services/WebhooksClient.cs` | ソース | Webhooks.API通信クライアント |
| WebhookResponse.cs | `src/WebhookClient/Services/WebhookResponse.cs` | ソース | Webhookレスポンスのデータモデル |
| Home.razor | `src/WebhookClient/Components/Pages/Home/Home.razor` | ソース | RegisteredHooksを含むホーム画面 |
