# 機能設計書 54-統合イベント購読

## 概要

本ドキュメントは、eShopシステムにおける「統合イベント購読」機能の設計仕様を定義する。この機能は、統合イベントを購読しハンドラを実行するための仕組みを提供する。

### 本機能の処理概要

本機能は、eShopのマイクロサービスアーキテクチャにおいて、他のサービスから発行されたIntegrationEventを受信し、対応するハンドラを実行する機能である。イベント駆動アーキテクチャの受信側を実現する。

**業務上の目的・背景**：マイクロサービス間で発生するイベント（価格変更、注文ステータス変更、在庫変動等）を各サービスが受信し、自身の業務ロジックを実行する必要がある。本機能は、イベントの購読登録とハンドラの実行を統一的な方法で提供する。

**機能の利用シーン**：
- カタログサービスの価格変更イベントをバスケットサービスが受信
- 注文サービスの在庫検証イベントを支払いサービスが受信
- 支払い完了イベントをWebhookサービスが受信して外部通知

**主要な処理内容**：
1. アプリケーション起動時にイベントタイプとハンドラの対応を登録
2. IEventBusBuilder.AddSubscription<T, TH>()でサブスクリプションを追加
3. RabbitMQキューからメッセージを受信
4. イベントタイプに対応する全ハンドラを順次実行

**関連システム・外部連携**：RabbitMQメッセージブローカーからメッセージを受信する。

**権限による制御**：サービス間の内部通信のため、特定の権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面との直接的な関連なし（バックエンド処理） |

## 機能種別

データ連携 / イベント購読

## 入力仕様

### 入力パラメータ

#### サブスクリプション登録

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| T | Type | Yes | 購読するイベントの型（IntegrationEvent派生） | IntegrationEvent派生型 |
| TH | Type | Yes | イベントハンドラの型 | IIntegrationEventHandler<T>実装 |

#### イベント受信

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| eventName | string | Yes | イベント型名（ルーティングキー） | 登録済みイベント型名 |
| message | string | Yes | JSONシリアライズされたイベントデータ | 有効なJSON |

### 入力データソース

RabbitMQキューからメッセージを受信。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| - | Task | ハンドラ実行完了（成功時） |

### 出力先

各イベントハンドラの実装に依存（DB更新、API呼び出し等）。

## 処理フロー

### 処理シーケンス

```
1. アプリケーション起動時（サブスクリプション登録）
   └─ AddSubscription<T, TH>()でイベント型とハンドラを登録
   └─ EventBusSubscriptionInfoにイベント型名と型の対応を保存
   └─ DIコンテナにハンドラをKeyedTransientとして登録

2. RabbitMQ接続開始（StartAsync）
   └─ コネクション取得
   └─ コンシューマーチャネル作成
   └─ キューを宣言（durable: true）
   └─ 登録済みイベント型でキューをExchangeにバインド
   └─ AsyncEventingBasicConsumerでメッセージ受信開始

3. メッセージ受信時（OnMessageReceived）
   └─ OpenTelemetryコンテキストを抽出
   └─ ルーティングキーからイベント型を特定
   └─ メッセージをデシリアライズ
   └─ 対応する全ハンドラを順次実行
   └─ BasicAckAsyncでメッセージを確認
```

### フローチャート

```mermaid
flowchart TD
    A[アプリ起動] --> B[AddSubscription登録]
    B --> C[StartAsync]
    C --> D[RabbitMQ接続]
    D --> E[キュー宣言]
    E --> F[キューバインド]
    F --> G[コンシューマー開始]

    H[メッセージ受信] --> I[OpenTelemetryコンテキスト抽出]
    I --> J[イベント型特定]
    J --> K{イベント型あり?}
    K -->|Yes| L[デシリアライズ]
    K -->|No| M[警告ログ]
    L --> N[ハンドラ取得]
    N --> O[全ハンドラ実行]
    O --> P[BasicAck]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-54-1 | Keyed Services | ハンドラはKeyed Servicesとして登録（同一イベントに複数ハンドラ可） | 常時 |
| BR-54-2 | 順次実行 | 同一イベントの複数ハンドラは順次実行 | 常時 |
| BR-54-3 | 自動Ack | 例外発生時もメッセージはAck（Dead Letter未実装） | 常時 |
| BR-54-4 | トレーシング | OpenTelemetryコンテキストを発行元から継承 | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能自体はデータベースを操作しない。各ハンドラの実装に依存。

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | ハンドラ実装に依存 |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | イベント型名が未登録 | ログ出力して処理スキップ |
| - | 警告 | ハンドラ実行時の例外 | ログ出力してAck |
| - | エラー | RabbitMQ接続エラー | ログ出力 |

### リトライ仕様

- メッセージ受信時のリトライは行わない
- 例外発生時もAckしてメッセージを削除（Dead Letter Exchange未実装）

## トランザクション仕様

本機能自体はトランザクション管理を行わない。各ハンドラの実装に依存。

## パフォーマンス要件

- メッセージ処理: 500ms以内
- 同時処理: シングルスレッド（コンシューマーごと）

## セキュリティ考慮事項

- RabbitMQへの接続は認証情報を使用
- メッセージ内容は信頼されたサービスからのみ受信する前提

## 備考

- Dead Letter Exchange（DLX）は未実装。本番運用時には実装を検討
- 並列処理はコメントで検討中と記載あり

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、イベントハンドラのインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IIntegrationEventHandler.cs | `src/EventBus/Abstractions/IIntegrationEventHandler.cs` | ハンドラインターフェースの定義 |

**読解のコツ**: ジェネリック版と非ジェネリック版の2つのインターフェース。ジェネリック版がHandle(TIntegrationEvent)を定義し、非ジェネリック版へ委譲。

**主要処理フロー**:
- **3-9行目**: IIntegrationEventHandler<T>がHandle(T @event)を定義
- **8行目**: 非ジェネリック版Handleへの委譲実装
- **11-14行目**: 非ジェネリック版IIntegrationEventHandler

#### Step 2: サブスクリプション登録を理解する

イベントとハンドラの登録方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventBusBuilderExtensions.cs | `src/EventBus/Extensions/EventBusBuilderExtensions.cs` | AddSubscriptionメソッドの実装 |
| 2-2 | EventBusSubscriptionInfo.cs | `src/EventBus/Abstractions/EventBusSubscriptionInfo.cs` | イベント型名とTypeの対応管理 |

**主要処理フロー（EventBusBuilderExtensions.cs）**:
- **20-38行目**: AddSubscription<T, TH>メソッド
- **27行目**: KeyedTransientでハンドラをDI登録（キーはイベント型）
- **35行目**: EventTypes辞書にイベント型名と型の対応を追加

#### Step 3: メッセージ受信処理を理解する

RabbitMQからのメッセージ受信とハンドラ実行を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RabbitMQEventBus.cs | `src/EventBusRabbitMQ/RabbitMQEventBus.cs` | OnMessageReceivedとProcessEvent |

**主要処理フロー**:
- **132-181行目**: OnMessageReceivedメソッド
- **145行目**: OpenTelemetryコンテキストを抽出
- **156-157行目**: ルーティングキーとメッセージ本文を取得
- **168行目**: ProcessEventを呼び出し
- **180行目**: BasicAckAsyncでメッセージ確認
- **183-208行目**: ProcessEventメソッド
- **192-196行目**: イベント型名からTypeを取得
- **199行目**: メッセージをデシリアライズ
- **204-207行目**: GetKeyedServicesで全ハンドラを取得して順次実行

#### Step 4: 起動処理を理解する

RabbitMQ接続とコンシューマー開始を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | RabbitMQEventBus.cs | `src/EventBusRabbitMQ/RabbitMQEventBus.cs` | StartAsyncメソッド |

**主要処理フロー**:
- **226-295行目**: StartAsyncメソッド
- **235行目**: IConnectionを取得
- **246行目**: コンシューマーチャネル作成
- **258-263行目**: キュー宣言（durable: true）
- **270-277行目**: AsyncEventingBasicConsumerでメッセージ受信
- **279-285行目**: 登録済みイベント型でキューをExchangeにバインド

### プログラム呼び出し階層図

```
アプリケーション起動
    │
    ├─ IEventBusBuilder.AddSubscription<T, TH>
    │      ├─ KeyedTransientでハンドラ登録
    │      └─ EventBusSubscriptionInfo.EventTypesに追加
    │
    └─ RabbitMQEventBus.StartAsync（IHostedService）
           │
           ├─ CreateChannelAsync
           │
           ├─ QueueDeclareAsync
           │
           ├─ QueueBindAsync（イベント型ごと）
           │
           └─ BasicConsumeAsync
                  │
                  └─ OnMessageReceived（イベント発生時）
                         │
                         ├─ Propagator.Extract（OpenTelemetry）
                         │
                         └─ ProcessEvent
                                │
                                ├─ DeserializeMessage
                                │
                                └─ GetKeyedServices → Handler.Handle
```

### データフロー図

```
[入力]                         [処理]                                [出力]

RabbitMQ Queue ───▶ AsyncEventingBasicConsumer ───▶ OnMessageReceived
                                                          │
                                                          ├─ OpenTelemetryコンテキスト抽出
                                                          │
                                                          └─ ProcessEvent
                                                                 │
                                                                 ├─ JSONデシリアライズ
                                                                 │
                                                                 └─ ハンドラ実行 ───▶ 業務処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IIntegrationEventHandler.cs | `src/EventBus/Abstractions/IIntegrationEventHandler.cs` | ソース | ハンドラインターフェース |
| EventBusBuilderExtensions.cs | `src/EventBus/Extensions/EventBusBuilderExtensions.cs` | ソース | サブスクリプション登録拡張メソッド |
| EventBusSubscriptionInfo.cs | `src/EventBus/Abstractions/EventBusSubscriptionInfo.cs` | ソース | イベント型マッピング管理 |
| RabbitMQEventBus.cs | `src/EventBusRabbitMQ/RabbitMQEventBus.cs` | ソース | RabbitMQ実装（受信処理） |
| IEventBusBuilder.cs | `src/EventBus/Abstractions/IEventBusBuilder.cs` | ソース | ビルダーインターフェース |
