# 機能設計書 9-商品タイプ一覧取得

## 概要

本ドキュメントは、eShopアプリケーションにおける商品タイプ一覧取得機能の設計仕様を定義する。カタログに登録されているすべての商品タイプ（カテゴリ）を取得するREST APIエンドポイントを提供する。

### 本機能の処理概要

**業務上の目的・背景**：ECサイトにおいて、商品のフィルタリングやナビゲーションに使用するタイプ（カテゴリ）一覧を提供する。ユーザーが商品を絞り込む際の選択肢として、また管理画面での商品登録時のタイプ選択に使用される。

**機能の利用シーン**：カタログ画面でのタイプフィルタドロップダウン、カテゴリナビゲーション、商品登録・編集画面でのタイプ選択など、タイプ一覧を表示する場面で利用される。

**主要な処理内容**：
1. CatalogTypesテーブルから全レコードを取得
2. タイプ名でソートしてリストとして返却

**関連システム・外部連携**：PostgreSQLデータベースからEntity Framework Coreを通じてデータを取得する。

**権限による制御**：本APIエンドポイントは認証不要で公開されており、誰でもアクセス可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | カタログ画面 | 参照画面 | CatalogSearchコンポーネントでタイプフィルタリング用一覧を取得 |
| 25 | カタログ画面（HybridApp） | 参照画面 | CatalogSearchでタイプフィルタリング用一覧を取得 |

## 機能種別

CRUD操作（Read）/ マスタデータ取得

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| (なし) | - | - | パラメータなし | - |

### 入力データソース

- HTTPリクエスト: `GET /api/catalog/catalogtypes`

## 出力仕様

### 出力データ

**正常時（200 OK）: List&lt;CatalogType&gt;**

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Id | int | タイプID |
| Type | string | タイプ名 |

### 出力先

- HTTP Response Body（JSON配列形式）
- Content-Type: application/json

## 処理フロー

### 処理シーケンス

```
1. HTTPリクエスト受信
   └─ パラメータなし

2. データベースクエリ実行
   ├─ CatalogTypesテーブルから全件取得
   └─ OrderBy(x => x.Type)でタイプ名順にソート

3. レスポンス生成
   └─ List<CatalogType>をJSONで返却
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B[CatalogTypesクエリ]
    B --> C[タイプ名でソート]
    C --> D[ToListAsync]
    D --> E[List返却]
    E --> F[200 OK]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 全件取得 | ページネーションなしで全タイプを取得 | 常時 |
| BR-002 | ソート順 | タイプ名（Type）の昇順でソート | 常時 |

### 計算ロジック

本機能に計算ロジックはない。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| タイプ一覧取得 | CatalogType | SELECT | 全タイプを取得 |

### テーブル別操作詳細

#### CatalogType

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | Id, Type | 全件取得、ORDER BY Type ASC | マスタデータ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | BadRequest | リクエスト形式が不正 | ProblemDetails形式でエラー詳細を返却 |
| 500 | InternalServerError | データベース接続エラー等 | サーバーエラーとして処理 |

### リトライ仕様

本機能では明示的なリトライ処理は実装されていない。

## トランザクション仕様

読み取り専用操作のため、明示的なトランザクション制御は行わない。

## パフォーマンス要件

- マスタデータのため、レコード数は限定的（通常数十件程度）
- 全件取得でもパフォーマンス影響は軽微

## セキュリティ考慮事項

- 認証不要のパブリックAPI
- マスタデータのため、機密情報は含まれない

## 備考

- V1/V2両方のAPIバージョンで共通のエンドポイント（apiグループ）
- タイプはシードデータとして事前登録されている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CatalogType.cs | `src/Catalog.API/Model/CatalogType.cs` | タイプエンティティの構造 |

**読解のコツ**: CatalogTypeは単純なエンティティで、Id（int）とType（string、[Required]）の2プロパティのみ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CatalogApi.cs | `src/Catalog.API/Apis/CatalogApi.cs` | インラインラムダでの実装 |

**主要処理フロー**:
1. **77-83行目**: `/catalogtypes` エンドポイント定義（インラインラムダ）
2. **79行目**: `context.CatalogTypes.OrderBy(x => x.Type).ToListAsync()`
3. ラムダ式内で直接クエリを実行し、結果を返却

#### Step 3: データアクセス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CatalogContext.cs | `src/Catalog.API/Infrastructure/CatalogContext.cs` | CatalogTypesのDbSet定義 |

**主要処理フロー**:
- **16行目**: `DbSet<CatalogType> CatalogTypes`

### プログラム呼び出し階層図

```
HTTP Request (GET /api/catalog/catalogtypes)
    │
    └─ インラインラムダ式
           │
           └─ CatalogContext.CatalogTypes
                  ├─ OrderBy(x => x.Type)
                  └─ ToListAsync()
                         │
                         └─ List<CatalogType>
```

### データフロー図

```
[入力]                [処理]                              [出力]

HTTPリクエスト         インラインラムダ                    HTTPレスポンス
  │                        │                                │
  └─ (パラメータなし) ────▶│                                │
                           │   PostgreSQL                   │
                           │   (CatalogType table)          │
                           │      │                         │
                           │      ▼                         │
                           └─▶ List<CatalogType> ──────────▶ JSON配列
                                 ├─ { Id: 1, Type: "..." }
                                 ├─ { Id: 2, Type: "..." }
                                 └─ ...
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CatalogApi.cs | `src/Catalog.API/Apis/CatalogApi.cs` | ソース | APIエンドポイント定義 |
| CatalogType.cs | `src/Catalog.API/Model/CatalogType.cs` | ソース | タイプエンティティモデル |
| CatalogContext.cs | `src/Catalog.API/Infrastructure/CatalogContext.cs` | ソース | DbContext・DbSet定義 |
| CatalogTypeEntityTypeConfiguration.cs | `src/Catalog.API/Infrastructure/EntityConfigurations/CatalogTypeEntityTypeConfiguration.cs` | ソース | エンティティ設定 |
