---
generated_at: 2026-01-14 21:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-注文作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Ordering.API/Apis/OrdersApi.cs` - 17行目: MapPost定義
- E-02: `src/Ordering.API/Apis/OrdersApi.cs` - 118-168行目: CreateOrderAsyncメソッド
- E-03: `src/Ordering.API/Apis/OrdersApi.cs` - 132-135行目: requestId検証
- E-04: `src/Ordering.API/Apis/OrdersApi.cs` - 140行目: カード番号マスク処理
- E-05: `src/Ordering.API/Apis/OrdersApi.cs` - 141-144行目: CreateOrderCommand生成
- E-06: `src/Ordering.API/Apis/OrdersApi.cs` - 146行目: IdentifiedCommand生成
- E-07: `src/Ordering.API/Apis/OrdersApi.cs` - 171-185行目: CreateOrderRequest定義
- E-08: `src/Ordering.API/Application/Commands/CreateOrderCommandHandler.cs` - 29-52行目: Handle実装
- E-09: `src/Ordering.API/Application/Commands/CreateOrderCommandHandler.cs` - 32-33行目: 統合イベント発行
- E-10: `src/Ordering.API/Application/Commands/CreateOrderCommandHandler.cs` - 39行目: Address生成
- E-11: `src/Ordering.API/Application/Commands/CreateOrderCommandHandler.cs` - 40行目: Order生成
- E-12: `src/Ordering.API/Application/Commands/CreateOrderCommandHandler.cs` - 42-45行目: AddOrderItem
- E-13: `src/Ordering.API/Application/Commands/CreateOrderCommandHandler.cs` - 49行目: Repository.Add
- E-14: `src/Ordering.API/Application/Commands/CreateOrderCommandHandler.cs` - 51行目: SaveEntitiesAsync
- E-15: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` - 52-65行目: コンストラクタ
- E-16: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` - 57行目: 初期ステータスSubmitted
- E-17: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` - 63-64行目: AddOrderStartedDomainEvent
- E-18: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` - 71-91行目: AddOrderItem実装
- E-19: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` - 73-84行目: 同一商品集約
- E-20: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` - 185行目: GetTotal計算
- E-21: `docs/code-to-docs/機能一覧/機能一覧.csv` - 18行目: 機能No.17定義
- E-22: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 18行目: 関連画面

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | POST /api/ordersで注文を作成する | E-01 | ○ |
| C-02 | CreateOrderAsyncが注文作成のエントリーポイント | E-02 | ○ |
| C-03 | x-requestidが空GUIDの場合BadRequestを返す | E-03 | ○ |
| C-04 | カード番号は末尾4桁以外をマスクする | E-04 | ○ |
| C-05 | CreateOrderCommandを生成してMediatRに送信 | E-05, E-06 | ○ |
| C-06 | CreateOrderRequestで入力を受け取る | E-07 | ○ |
| C-07 | CreateOrderCommandHandlerがコマンドを処理 | E-08 | ○ |
| C-08 | OrderStartedIntegrationEventを発行する | E-09 | ○ |
| C-09 | Addressバリューオブジェクトを生成する | E-10 | ○ |
| C-10 | Orderエンティティを生成する | E-11 | ○ |
| C-11 | AddOrderItemで注文明細を追加する | E-12 | ○ |
| C-12 | リポジトリに追加する | E-13 | ○ |
| C-13 | SaveEntitiesAsyncで永続化する | E-14 | ○ |
| C-14 | OrderコンストラクタでOrderStartedDomainEventを追加 | E-15, E-17 | ○ |
| C-15 | 初期ステータスはSubmittedである | E-16 | ○ |
| C-16 | AddOrderItemは同一商品を集約する | E-18, E-19 | ○ |
| C-17 | GetTotalで合計金額を計算する | E-20 | ○ |
| C-18 | 機能番号17は注文作成機能である | E-21 | ○ |
| C-19 | チェックアウト画面から利用される | E-22 | ○ |
| C-20 | IdentifiedCommandパターンで冪等性を保証 | E-06 | ○ |
| C-21 | DDDパターン（Aggregate Root）を採用 | E-15 (Order.cs構造) | ○ |
| C-22 | 重複リクエストはtrueを返して正常終了 | `CreateOrderIdentifiedCommandHandler.CreateResultForDuplicateRequest` | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張がソースコードに基づいている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] OrdersApi.cs 118-168行目のCreateOrderAsyncが設計書の処理フローと一致しているか
- [ ] CreateOrderCommandHandler.csのHandle処理が正しく記載されているか
- [ ] Order.csのドメインロジック（コンストラクタ、AddOrderItem）が正しく記載されているか
- [ ] DDDパターン、CQRSパターンの説明が適切か
