---
generated_at: 2026-01-14 21:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-注文下書き作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Ordering.API/Apis/OrdersApi.cs` - 16行目: MapPost("/draft")定義
- E-02: `src/Ordering.API/Apis/OrdersApi.cs` - 106-116行目: CreateOrderDraftAsyncメソッド
- E-03: `src/Ordering.API/Application/Commands/CreateOrderDraftCommand.cs` - 4行目: record定義
- E-04: `src/Ordering.API/Application/Commands/CreateOrderDraftCommandHandler.cs` - 10-19行目: Handle実装
- E-05: `src/Ordering.API/Application/Commands/CreateOrderDraftCommandHandler.cs` - 12行目: Order.NewDraft()
- E-06: `src/Ordering.API/Application/Commands/CreateOrderDraftCommandHandler.cs` - 13行目: ToOrderItemDTO
- E-07: `src/Ordering.API/Application/Commands/CreateOrderDraftCommandHandler.cs` - 14-17行目: AddOrderItem
- E-08: `src/Ordering.API/Application/Commands/CreateOrderDraftCommandHandler.cs` - 19行目: FromOrder
- E-09: `src/Ordering.API/Application/Commands/CreateOrderDraftCommandHandler.cs` - 23-43行目: OrderDraftDTO定義
- E-10: `src/Ordering.API/Application/Commands/CreateOrderDraftCommandHandler.cs` - 46-59行目: OrderItemDTO定義
- E-11: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` - 37-44行目: NewDraft実装
- E-12: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` - 41行目: _isDraft = true
- E-13: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs` - 185行目: GetTotal実装
- E-14: `docs/code-to-docs/機能一覧/機能一覧.csv` - 19行目: 機能No.18定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | POST /api/orders/draftで下書き注文を作成する | E-01 | ○ |
| C-02 | CreateOrderDraftAsyncがエントリーポイント | E-02 | ○ |
| C-03 | CreateOrderDraftCommandはrecord型で定義 | E-03 | ○ |
| C-04 | CreateOrderDraftCommandHandlerがコマンドを処理 | E-04 | ○ |
| C-05 | Order.NewDraft()でドラフト注文を生成 | E-05, E-11 | ○ |
| C-06 | ToOrderItemDTOでBasketItemを変換 | E-06 | ○ |
| C-07 | AddOrderItemで注文明細を追加 | E-07 | ○ |
| C-08 | OrderDraftDTO.FromOrderでDTO変換 | E-08 | ○ |
| C-09 | OrderDraftDTOにOrderItemsとTotalが含まれる | E-09 | ○ |
| C-10 | OrderItemDTOの構造が正しい | E-10 | ○ |
| C-11 | NewDraftは_isDraftをtrueに設定 | E-12 | ○ |
| C-12 | GetTotalで合計金額を計算 | E-13 | ○ |
| C-13 | 機能番号18は注文下書き作成機能である | E-14 | ○ |
| C-14 | データベース操作なし（メモリ内処理） | E-04 (DB呼び出しなし) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張がソースコードに基づいている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] OrdersApi.cs 106-116行目のCreateOrderDraftAsyncが設計書の処理フローと一致しているか
- [ ] CreateOrderDraftCommandHandler.csのHandle処理が正しく記載されているか
- [ ] OrderDraftDTO、OrderItemDTOの構造が正しく記載されているか
